/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui.datecombobox;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.DateComboBox;
import de.javasoft.syntheticaaddons.ui.datecombobox.DateComboBoxPopup;
import java.awt.Component;
import java.util.Date;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class DateComboBoxRenderer
extends BasicComboBoxRenderer {
    private static final long serialVersionUID = 5894523493751346368L;
    private JComboBox<?> comboBox;
    private DateComboBoxPopup popup;
    private Border comboLabelBorder;

    public DateComboBoxRenderer(JComboBox<?> comboBox, DateComboBoxPopup popup) {
        this.comboBox = comboBox;
        this.popup = popup;
        this.setName("ComboBox.renderer");
        String newRendererClassName = SyntheticaLookAndFeel.getString((String)"Synthetica.comboBox.defaultRenderer.className", null);
        if (newRendererClassName != null) {
            try {
                DefaultListCellRenderer r = (DefaultListCellRenderer)Class.forName(newRendererClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JComponent c = (JComponent)r.getListCellRendererComponent(popup.getList(), (Object)null, -1, false, false);
                this.comboLabelBorder = new EmptyBorder(c.getBorder().getBorderInsets(c));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (index != -1) {
            return this.popup.getMonthView();
        }
        JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        label.setOpaque(this.comboBox.isOpaque());
        if (value != null) {
            label.setText(((DateComboBox)this.comboBox).getDateFormats()[0].format((Date)value));
        }
        if (this.comboLabelBorder != null) {
            label.setBorder(this.comboLabelBorder);
        }
        return label;
    }
}

