/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Geometry3D;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFRotation;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.MFVec2f;
import org.web3d.x3d.jsail.fields.MFVec3f;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFRotation;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFVec2f;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;
import org.web3d.x3d.sai.X3DException;

public class Extrusion
extends X3DConcreteNode
implements org.web3d.x3d.sai.Geometry3D.Extrusion {
    private ArrayList<String> commentsList;
    private boolean beginCap;
    private boolean ccw;
    private boolean convex;
    private float creaseAngle;
    private float[] crossSection;
    private boolean endCap;
    private IS IS;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private float[] orientation;
    private float[] scale;
    private float[] spine;
    private boolean solid;
    public static final String NAME = "Extrusion";
    public static final String COMPONENT = "Geometry3D";
    public static final int LEVEL = 4;
    public static final boolean BEGINCAP_DEFAULT_VALUE = true;
    public static final boolean CCW_DEFAULT_VALUE = true;
    public static final boolean CONVEX_DEFAULT_VALUE = true;
    public static final float CREASEANGLE_DEFAULT_VALUE = 0.0f;
    public static final float[] CROSSSECTION_DEFAULT_VALUE = new float[]{1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    public static final boolean ENDCAP_DEFAULT_VALUE = true;
    public static final IS IS_DEFAULT_VALUE = null;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final float[] ORIENTATION_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    public static final float[] SCALE_DEFAULT_VALUE = new float[]{1.0f, 1.0f};
    public static final boolean SOLID_DEFAULT_VALUE = true;
    public static final float[] SPINE_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    public static final String containerField_DEFAULT_VALUE = "geometry";
    public static final String fromField_IS = "IS";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_ORIENTATION = "orientation";
    public static final String toField_ORIENTATION = "orientation";
    public static final String fromField_SCALE = "scale";
    public static final String toField_SCALE = "scale";
    public static final String toField_SET_CROSSSECTION = "set_crossSection";
    public static final String toField_SET_ORIENTATION = "set_orientation";
    public static final String toField_SET_SCALE = "set_scale";
    public static final String toField_SET_SPINE = "set_spine";

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 4;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "beginCap": {
                result = "SFBool";
                break;
            }
            case "ccw": {
                result = "SFBool";
                break;
            }
            case "convex": {
                result = "SFBool";
                break;
            }
            case "creaseAngle": {
                result = "SFFloat";
                break;
            }
            case "crossSection": {
                result = "MFVec2f";
                break;
            }
            case "endCap": {
                result = "SFBool";
                break;
            }
            case "IS": {
                result = "SFNode";
                break;
            }
            case "metadata": {
                result = "SFNode";
                break;
            }
            case "orientation": {
                result = "MFRotation";
                break;
            }
            case "scale": {
                result = "MFVec2f";
                break;
            }
            case "spine": {
                result = "MFVec3f";
                break;
            }
            case "solid": {
                result = "SFBool";
                break;
            }
            case "DEF": {
                result = "SFString";
                break;
            }
            case "USE": {
                result = "SFString";
                break;
            }
            case "class": {
                result = "SFString";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "beginCap": {
                result = "initializeOnly";
                break;
            }
            case "ccw": {
                result = "initializeOnly";
                break;
            }
            case "convex": {
                result = "initializeOnly";
                break;
            }
            case "creaseAngle": {
                result = "initializeOnly";
                break;
            }
            case "crossSection": {
                result = "initializeOnly";
                break;
            }
            case "endCap": {
                result = "initializeOnly";
                break;
            }
            case "IS": {
                result = "inputOutput";
                break;
            }
            case "metadata": {
                result = "inputOutput";
                break;
            }
            case "orientation": {
                result = "inputOutput";
                break;
            }
            case "scale": {
                result = "inputOutput";
                break;
            }
            case "set_crossSection": {
                result = "inputOnly";
                break;
            }
            case "set_orientation": {
                result = "inputOnly";
                break;
            }
            case "set_scale": {
                result = "inputOnly";
                break;
            }
            case "set_spine": {
                result = "inputOnly";
                break;
            }
            case "solid": {
                result = "initializeOnly";
                break;
            }
            case "spine": {
                result = "initializeOnly";
                break;
            }
            case "DEF": {
                result = "inputOutput";
                break;
            }
            case "USE": {
                result = "inputOutput";
                break;
            }
            case "class": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        return result;
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public Extrusion() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.beginCap = true;
        this.ccw = true;
        this.convex = true;
        this.creaseAngle = 0.0f;
        this.crossSection = CROSSSECTION_DEFAULT_VALUE;
        this.endCap = true;
        this.IS = null;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.orientation = ORIENTATION_DEFAULT_VALUE;
        this.scale = SCALE_DEFAULT_VALUE;
        this.solid = true;
        this.spine = SPINE_DEFAULT_VALUE;
        this.commentsList = new ArrayList();
    }

    @Override
    public boolean getBeginCap() {
        return this.beginCap;
    }

    @Override
    public Extrusion setBeginCap(boolean newValue) {
        this.beginCap = newValue;
        return this;
    }

    public Extrusion setBeginCap(SFBool newValue) {
        this.setBeginCap(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public boolean getCcw() {
        return this.ccw;
    }

    @Override
    public Extrusion setCcw(boolean newValue) {
        this.ccw = newValue;
        return this;
    }

    public Extrusion setCcw(SFBool newValue) {
        this.setCcw(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public boolean getConvex() {
        return this.convex;
    }

    @Override
    public Extrusion setConvex(boolean newValue) {
        this.convex = newValue;
        return this;
    }

    public Extrusion setConvex(SFBool newValue) {
        this.setConvex(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getCreaseAngle() {
        return this.creaseAngle;
    }

    @Override
    public Extrusion setCreaseAngle(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("Extrusion creaseAngle newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.creaseAngle = newValue;
        return this;
    }

    public Extrusion setCreaseAngle(SFFloat newValue) {
        this.setCreaseAngle(newValue.getPrimitiveValue());
        return this;
    }

    public Extrusion setCreaseAngle(double newValue) {
        return this.setCreaseAngle((float)newValue);
    }

    @Override
    public float[] getCrossSection() {
        return this.crossSection;
    }

    @Override
    public Extrusion setCrossSection(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length % 2 != 0) {
            throw new InvalidFieldValueException("Extrusion crossSection newValue=" + MFVec2f.toString(newValue) + " has length=" + newValue.length + ", must be a multiple of 2");
        }
        this.crossSection = newValue;
        return this;
    }

    public Extrusion setCrossSection(MFVec2f newValue) {
        this.setCrossSection(newValue.getPrimitiveValue());
        return this;
    }

    public Extrusion addCrossSection(SFVec2f newValue) {
        if (newValue == null) {
            return this;
        }
        float[] result = Arrays.copyOf(this.crossSection, this.crossSection.length + 2);
        System.arraycopy(newValue.getPrimitiveValue(), 0, result, this.crossSection.length, 2);
        this.crossSection = result;
        return this;
    }

    public Extrusion setCrossSection(double[] newArray) {
        return this.setCrossSection(new MFVec2f(newArray));
    }

    @Override
    public boolean getEndCap() {
        return this.endCap;
    }

    @Override
    public Extrusion setEndCap(boolean newValue) {
        this.endCap = newValue;
        return this;
    }

    public Extrusion setEndCap(SFBool newValue) {
        this.setEndCap(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public Extrusion setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public Extrusion clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public Extrusion setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public Extrusion clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public Extrusion setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public float[] getOrientation() {
        return this.orientation;
    }

    @Override
    public Extrusion setOrientation(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length % 4 != 0) {
            throw new InvalidFieldValueException("Extrusion orientation newValue=" + MFRotation.toString(newValue) + " has length=" + newValue.length + ", must be a multiple of 4");
        }
        this.orientation = newValue;
        return this;
    }

    public Extrusion setOrientation(MFRotation newValue) {
        this.setOrientation(newValue.getPrimitiveValue());
        return this;
    }

    public Extrusion addOrientation(SFRotation newValue) {
        if (newValue == null) {
            return this;
        }
        float[] result = Arrays.copyOf(this.orientation, this.orientation.length + 4);
        System.arraycopy(newValue.getPrimitiveValue(), 0, result, this.orientation.length, 4);
        this.orientation = result;
        return this;
    }

    @Override
    public float[] getScale() {
        return this.scale;
    }

    @Override
    public Extrusion setScale(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length % 2 != 0) {
            throw new InvalidFieldValueException("Extrusion scale newValue=" + MFVec2f.toString(newValue) + " has length=" + newValue.length + ", must be a multiple of 2");
        }
        this.scale = newValue;
        return this;
    }

    public Extrusion setScale(MFVec2f newValue) {
        this.setScale(newValue.getPrimitiveValue());
        return this;
    }

    public Extrusion addScale(SFVec2f newValue) {
        if (newValue == null) {
            return this;
        }
        float[] result = Arrays.copyOf(this.scale, this.scale.length + 2);
        System.arraycopy(newValue.getPrimitiveValue(), 0, result, this.scale.length, 2);
        this.scale = result;
        return this;
    }

    public Extrusion setScale(double[] newArray) {
        return this.setScale(new MFVec2f(newArray));
    }

    @Override
    public boolean getSolid() {
        return this.solid;
    }

    @Override
    public Extrusion setSolid(boolean newValue) {
        this.solid = newValue;
        return this;
    }

    public Extrusion setSolid(SFBool newValue) {
        this.setSolid(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float[] getSpine() {
        return this.spine;
    }

    @Override
    public Extrusion setSpine(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length % 3 != 0) {
            throw new InvalidFieldValueException("Extrusion spine newValue=" + MFVec3f.toString(newValue) + " has length=" + newValue.length + ", must be a multiple of 3");
        }
        this.spine = newValue;
        return this;
    }

    public Extrusion setSpine(MFVec3f newValue) {
        this.setSpine(newValue.getPrimitiveValue());
        return this;
    }

    public Extrusion addSpine(SFVec3f newValue) {
        if (newValue == null) {
            return this;
        }
        float[] result = Arrays.copyOf(this.spine, this.spine.length + 3);
        System.arraycopy(newValue.getPrimitiveValue(), 0, result, this.spine.length, 3);
        this.spine = result;
        return this;
    }

    public Extrusion setSpine(double[] newArray) {
        return this.setSpine(new MFVec3f(newArray));
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final Extrusion setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("Extrusion DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public Extrusion setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final Extrusion setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("Extrusion USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public Extrusion setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final Extrusion setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public Extrusion setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    public Extrusion setUSE(Extrusion DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on Extrusion that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public Extrusion(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public Extrusion addComments(String newComment) {
        if (this.isUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public Extrusion addComments(String[] newComments) {
        if (this.isUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public Extrusion addComments(CommentsBlock newCommentsBlock) {
        if (this.isUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<Extrusion");
        if (hasAttributes) {
            if (!this.getDEF().equals("") && !this.isUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals("")) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getBeginCap() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" beginCap='").append(SFBool.toString(this.getBeginCap())).append("'");
            }
            if (!(this.getCcw() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" ccw='").append(SFBool.toString(this.getCcw())).append("'");
            }
            if (!(this.getCssClass().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getConvex() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" convex='").append(SFBool.toString(this.getConvex())).append("'");
            }
            if (!(this.getCreaseAngle() == 0.0f && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" creaseAngle='").append(SFFloat.toString(this.getCreaseAngle())).append("'");
            }
            if (!(Arrays.equals(this.getCrossSection(), CROSSSECTION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" crossSection='").append(MFVec2f.toString(this.getCrossSection())).append("'");
            }
            if (!(this.getEndCap() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" endCap='").append(SFBool.toString(this.getEndCap())).append("'");
            }
            if (!(Arrays.equals(this.getOrientation(), ORIENTATION_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" orientation='").append(MFRotation.toString(this.getOrientation())).append("'");
            }
            if (!(Arrays.equals(this.getScale(), SCALE_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" scale='").append(MFVec2f.toString(this.getScale())).append("'");
            }
            if (!(this.getSolid() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" solid='").append(SFBool.toString(this.getSolid())).append("'");
            }
            if (!(Arrays.equals(this.getSpine(), SPINE_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" spine='").append(MFVec3f.toString(this.getSpine())).append("'");
            }
        }
        if (hasChild && !this.isUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</Extrusion>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals("")) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals("")) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("beginCap")) continue;
                        stringClassicVRML.append(indentCharacter).append("beginCap").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getBeginCap() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("beginCap ").append(SFBool.toString(this.getBeginCap())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("ccw")) continue;
                        stringClassicVRML.append(indentCharacter).append("ccw").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCcw() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("ccw ").append(SFBool.toString(this.getCcw())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("# class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("convex")) continue;
                        stringClassicVRML.append(indentCharacter).append("convex").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getConvex() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("convex ").append(SFBool.toString(this.getConvex())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("creaseAngle")) continue;
                        stringClassicVRML.append(indentCharacter).append("creaseAngle").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getCreaseAngle() != 0.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("creaseAngle ").append(SFFloat.toString(this.getCreaseAngle())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("crossSection")) continue;
                        stringClassicVRML.append(indentCharacter).append("crossSection").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getCrossSection(), CROSSSECTION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("crossSection ").append("[ ").append(MFVec2f.toString(this.getCrossSection())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("endCap")) continue;
                        stringClassicVRML.append(indentCharacter).append("endCap").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getEndCap() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("endCap ").append(SFBool.toString(this.getEndCap())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("orientation")) continue;
                        stringClassicVRML.append(indentCharacter).append("orientation").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getOrientation(), ORIENTATION_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("orientation ").append("[ ").append(MFRotation.toString(this.getOrientation())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("scale")) continue;
                        stringClassicVRML.append(indentCharacter).append("scale").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getScale(), SCALE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("scale ").append("[ ").append(MFVec2f.toString(this.getScale())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("solid")) continue;
                        stringClassicVRML.append(indentCharacter).append("solid").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getSolid() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("solid ").append(SFBool.toString(this.getSolid())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("spine")) continue;
                        stringClassicVRML.append(indentCharacter).append("spine").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getSpine(), SPINE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("spine ").append("[ ").append(MFVec3f.toString(this.getSpine())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setBeginCap(this.getBeginCap());
        this.setCcw(this.getCcw());
        this.setConvex(this.getConvex());
        this.setCreaseAngle(this.getCreaseAngle());
        this.setCrossSection(this.getCrossSection());
        this.setEndCap(this.getEndCap());
        this.setOrientation(this.getOrientation());
        this.setScale(this.getScale());
        this.setSolid(this.getSolid());
        this.setSpine(this.getSpine());
        if (!this.isUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.isUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.isUSE() && this.hasIS()) {
            String errorNotice = "Extrusion USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "Extrusion USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.isUSE() && this.hasMetadata()) {
            String errorNotice = "Extrusion USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "Extrusion USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean hasSatisfactorySupport = this.findAncestorX3D().supportsX3dComponent(COMPONENT, 4);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for parent X3D model containing 'Extrusion' node, add head statement <component name='Geometry3D' level='4'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Geometry3D\").setLevel(4);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }

    public boolean isCrossSectionClosed() {
        if (this.crossSection == null) {
            return false;
        }
        int crossSectionTupleLength = this.crossSection.length / 2;
        boolean isClosed = crossSectionTupleLength > 1 && this.crossSection[0] == this.crossSection[(crossSectionTupleLength - 1) * 2 + 0] && this.crossSection[1] == this.crossSection[(crossSectionTupleLength - 1) * 2 + 1];
        return isClosed;
    }

    public boolean isSpineClosed() {
        if (this.spine == null) {
            return false;
        }
        int spineTupleLength = this.spine.length / 3;
        boolean isClosed = spineTupleLength > 1 && this.spine[0] == this.spine[(spineTupleLength - 1) * 3 + 0] && this.spine[1] == this.spine[(spineTupleLength - 1) * 3 + 1] && this.spine[2] == this.spine[(spineTupleLength - 1) * 3 + 2];
        return isClosed;
    }

    public File toFileSvgCrossSection(String fileName) {
        if (!fileName.endsWith(".svg")) {
            throw new X3DException("fileName " + fileName + " does not end with expected extension \"" + ".svg" + "\"");
        }
        return this.findAncestorX3D().toFileStylesheetConversion("X3dExtrusionCrossSectionToSvg.xslt", fileName);
    }
}

