/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.ParticleSystems;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFFloat;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFInt32;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFVec2f;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.Core.X3DNode;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;
import org.web3d.x3d.sai.ParticleSystems.X3DParticleEmitterNode;
import org.web3d.x3d.sai.ParticleSystems.X3DParticlePhysicsModelNode;
import org.web3d.x3d.sai.Rendering.X3DColorNode;
import org.web3d.x3d.sai.Rendering.X3DGeometryNode;
import org.web3d.x3d.sai.Shape.X3DAppearanceNode;
import org.web3d.x3d.sai.Texturing.TextureCoordinate;

public class ParticleSystem
extends X3DConcreteNode
implements org.web3d.x3d.sai.ParticleSystems.ParticleSystem {
    private ArrayList<String> commentsList;
    private X3DAppearanceNode appearance;
    private ProtoInstance appearanceProtoInstance;
    private float[] bboxCenter;
    private boolean bboxDisplay;
    private float[] bboxSize;
    private ArrayList<Float> colorKey = new ArrayList();
    private X3DColorNode colorRamp;
    private ProtoInstance colorRampProtoInstance;
    private boolean createParticles;
    private X3DParticleEmitterNode emitter;
    private ProtoInstance emitterProtoInstance;
    private boolean enabled;
    private X3DGeometryNode geometry;
    private ProtoInstance geometryProtoInstance;
    private String geometryType;
    private IS IS;
    private boolean isActive;
    private float lifetimeVariation;
    private int maxParticles;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private float particleLifetime;
    private float[] particleSize;
    private ArrayList<X3DNode> physics = new ArrayList();
    private ArrayList<Float> texCoordKey = new ArrayList();
    private TextureCoordinate texCoordRamp;
    private ProtoInstance texCoordRampProtoInstance;
    private boolean visible;
    public static final String GEOMETRYTYPE_LINE = "LINE";
    public static final String GEOMETRYTYPE_POINT = "POINT";
    public static final String GEOMETRYTYPE_QUAD = "QUAD";
    public static final String GEOMETRYTYPE_SPRITE = "SPRITE";
    public static final String GEOMETRYTYPE_TRIANGLE = "TRIANGLE";
    public static final String GEOMETRYTYPE_GEOMETRY = "GEOMETRY";
    public static final String NAME = "ParticleSystem";
    public static final String COMPONENT = "ParticleSystems";
    public static final int LEVEL = 2;
    public static final X3DAppearanceNode APPEARANCE_DEFAULT_VALUE = null;
    public static final float[] BBOXCENTER_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f};
    public static final boolean BBOXDISPLAY_DEFAULT_VALUE = false;
    public static final float[] BBOXSIZE_DEFAULT_VALUE = new float[]{-1.0f, -1.0f, -1.0f};
    public static final ArrayList<Float> COLORKEY_DEFAULT_VALUE = new ArrayList<Float>(Arrays.asList(new Float[0]));
    public static final X3DColorNode COLORRAMP_DEFAULT_VALUE = null;
    public static final boolean CREATEPARTICLES_DEFAULT_VALUE = true;
    public static final X3DParticleEmitterNode EMITTER_DEFAULT_VALUE = null;
    public static final boolean ENABLED_DEFAULT_VALUE = true;
    public static final X3DGeometryNode GEOMETRY_DEFAULT_VALUE = null;
    public static final String GEOMETRYTYPE_DEFAULT_VALUE = "QUAD";
    public static final IS IS_DEFAULT_VALUE = null;
    public static final float LIFETIMEVARIATION_DEFAULT_VALUE = 0.25f;
    public static final int MAXPARTICLES_DEFAULT_VALUE = 200;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final float PARTICLELIFETIME_DEFAULT_VALUE = 5.0f;
    public static final float[] PARTICLESIZE_DEFAULT_VALUE = new float[]{0.02f, 0.02f};
    public static final ArrayList<Float> TEXCOORDKEY_DEFAULT_VALUE = new ArrayList<Float>(Arrays.asList(new Float[0]));
    public static final TextureCoordinate TEXCOORDRAMP_DEFAULT_VALUE = null;
    public static final boolean VISIBLE_DEFAULT_VALUE = true;
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_APPEARANCE = "appearance";
    public static final String toField_APPEARANCE = "appearance";
    public static final String fromField_BBOXDISPLAY = "bboxDisplay";
    public static final String toField_BBOXDISPLAY = "bboxDisplay";
    public static final String fromField_CREATEPARTICLES = "createParticles";
    public static final String toField_CREATEPARTICLES = "createParticles";
    public static final String fromField_ENABLED = "enabled";
    public static final String toField_ENABLED = "enabled";
    public static final String fromField_GEOMETRY = "geometry";
    public static final String toField_GEOMETRY = "geometry";
    public static final String fromField_IS = "IS";
    public static final String fromField_ISACTIVE = "isActive";
    public static final String fromField_LIFETIMEVARIATION = "lifetimeVariation";
    public static final String toField_LIFETIMEVARIATION = "lifetimeVariation";
    public static final String fromField_MAXPARTICLES = "maxParticles";
    public static final String toField_MAXPARTICLES = "maxParticles";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_PARTICLELIFETIME = "particleLifetime";
    public static final String toField_PARTICLELIFETIME = "particleLifetime";
    public static final String fromField_PARTICLESIZE = "particleSize";
    public static final String toField_PARTICLESIZE = "particleSize";
    public static final String fromField_VISIBLE = "visible";
    public static final String toField_VISIBLE = "visible";

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "appearance": {
                result = "SFNode";
                break;
            }
            case "bboxCenter": {
                result = "SFVec3f";
                break;
            }
            case "bboxDisplay": {
                result = "SFBool";
                break;
            }
            case "bboxSize": {
                result = "SFVec3f";
                break;
            }
            case "colorKey": {
                result = "MFFloat";
                break;
            }
            case "colorRamp": {
                result = "SFNode";
                break;
            }
            case "createParticles": {
                result = "SFBool";
                break;
            }
            case "emitter": {
                result = "SFNode";
                break;
            }
            case "enabled": {
                result = "SFBool";
                break;
            }
            case "geometry": {
                result = "SFNode";
                break;
            }
            case "geometryType": {
                result = "SFString";
                break;
            }
            case "IS": {
                result = "SFNode";
                break;
            }
            case "isActive": {
                result = "SFBool";
                break;
            }
            case "lifetimeVariation": {
                result = "SFFloat";
                break;
            }
            case "maxParticles": {
                result = "SFInt32";
                break;
            }
            case "metadata": {
                result = "SFNode";
                break;
            }
            case "particleLifetime": {
                result = "SFFloat";
                break;
            }
            case "particleSize": {
                result = "SFVec2f";
                break;
            }
            case "physics": {
                result = "MFNode";
                break;
            }
            case "texCoordKey": {
                result = "MFFloat";
                break;
            }
            case "texCoordRamp": {
                result = "SFNode";
                break;
            }
            case "visible": {
                result = "SFBool";
                break;
            }
            case "DEF": {
                result = "SFString";
                break;
            }
            case "USE": {
                result = "SFString";
                break;
            }
            case "class": {
                result = "SFString";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "appearance": {
                result = "inputOutput";
                break;
            }
            case "bboxCenter": {
                result = "initializeOnly";
                break;
            }
            case "bboxDisplay": {
                result = "inputOutput";
                break;
            }
            case "bboxSize": {
                result = "initializeOnly";
                break;
            }
            case "colorKey": {
                result = "initializeOnly";
                break;
            }
            case "colorRamp": {
                result = "initializeOnly";
                break;
            }
            case "createParticles": {
                result = "inputOutput";
                break;
            }
            case "emitter": {
                result = "initializeOnly";
                break;
            }
            case "enabled": {
                result = "inputOutput";
                break;
            }
            case "geometry": {
                result = "inputOutput";
                break;
            }
            case "geometryType": {
                result = "initializeOnly";
                break;
            }
            case "IS": {
                result = "inputOutput";
                break;
            }
            case "isActive": {
                result = "outputOnly";
                break;
            }
            case "lifetimeVariation": {
                result = "inputOutput";
                break;
            }
            case "maxParticles": {
                result = "inputOutput";
                break;
            }
            case "metadata": {
                result = "inputOutput";
                break;
            }
            case "particleLifetime": {
                result = "inputOutput";
                break;
            }
            case "particleSize": {
                result = "inputOutput";
                break;
            }
            case "physics": {
                result = "initializeOnly";
                break;
            }
            case "texCoordKey": {
                result = "initializeOnly";
                break;
            }
            case "texCoordRamp": {
                result = "initializeOnly";
                break;
            }
            case "visible": {
                result = "inputOutput";
                break;
            }
            case "DEF": {
                result = "inputOutput";
                break;
            }
            case "USE": {
                result = "inputOutput";
                break;
            }
            case "class": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        return result;
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public ParticleSystem() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.appearance = null;
        this.appearanceProtoInstance = null;
        this.bboxCenter = BBOXCENTER_DEFAULT_VALUE;
        this.bboxDisplay = false;
        this.bboxSize = BBOXSIZE_DEFAULT_VALUE;
        this.colorKey = new ArrayList();
        this.colorRamp = null;
        this.colorRampProtoInstance = null;
        this.createParticles = true;
        this.emitter = null;
        this.emitterProtoInstance = null;
        this.enabled = true;
        this.geometry = null;
        this.geometryProtoInstance = null;
        this.geometry = null;
        this.geometryProtoInstance = null;
        this.geometryType = "QUAD";
        this.IS = null;
        this.lifetimeVariation = 0.25f;
        this.maxParticles = 200;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.particleLifetime = 5.0f;
        this.particleSize = PARTICLESIZE_DEFAULT_VALUE;
        this.physics = new ArrayList();
        this.texCoordKey = new ArrayList();
        this.texCoordRamp = null;
        this.texCoordRampProtoInstance = null;
        this.visible = true;
        this.commentsList = new ArrayList();
    }

    @Override
    public X3DAppearanceNode getAppearance() {
        return this.appearance;
    }

    @Override
    public ParticleSystem setAppearance(X3DAppearanceNode newValue) {
        this.appearance = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.appearance)).setParent(this);
        }
        if (this.appearanceProtoInstance != null) {
            this.appearanceProtoInstance.setParent(null);
            this.appearanceProtoInstance = null;
        }
        return this;
    }

    public ParticleSystem clearAppearance() {
        ((X3DConcreteElement)((Object)this.appearance)).clearParent();
        this.appearance = null;
        return this;
    }

    public ParticleSystem setAppearance(ProtoInstance newValue) {
        if (this.appearanceProtoInstance != null) {
            this.appearanceProtoInstance.setParent(null);
        }
        this.appearanceProtoInstance = newValue;
        if (newValue != null) {
            this.appearanceProtoInstance.setParent(this);
            this.appearanceProtoInstance.setContainerField("appearance");
        }
        if (this.appearance != null) {
            ((X3DConcreteElement)((Object)this.appearance)).setParent(null);
            this.appearance = null;
        }
        return this;
    }

    private ProtoInstance getAppearanceProtoInstance() {
        return this.appearanceProtoInstance;
    }

    public boolean hasAppearance() {
        return this.appearance != null || this.appearanceProtoInstance != null;
    }

    @Override
    public float[] getBboxCenter() {
        return this.bboxCenter;
    }

    @Override
    public ParticleSystem setBboxCenter(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("ParticleSystem bboxCenter newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.bboxCenter = newValue;
        return this;
    }

    public ParticleSystem setBboxCenter(SFVec3f newValue) {
        this.setBboxCenter(newValue.getPrimitiveValue());
        return this;
    }

    public ParticleSystem setBboxCenter(float x, float y, float z) {
        this.setBboxCenter(new float[]{x, y, z});
        return this;
    }

    public ParticleSystem setBboxCenter(double x, double y, double z) {
        return this.setBboxCenter(new SFVec3f(x, y, z));
    }

    public ParticleSystem setBboxCenter(double[] newArray) {
        return this.setBboxCenter(new SFVec3f(newArray));
    }

    @Override
    public boolean getBboxDisplay() {
        return this.bboxDisplay;
    }

    @Override
    public ParticleSystem setBboxDisplay(boolean newValue) {
        this.bboxDisplay = newValue;
        return this;
    }

    public ParticleSystem setBboxDisplay(SFBool newValue) {
        this.setBboxDisplay(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float[] getBboxSize() {
        return this.bboxSize;
    }

    @Override
    public ParticleSystem setBboxSize(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("ParticleSystem bboxSize newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if ((newValue[0] < 0.0f || newValue[1] < 0.0f || newValue[2] < 0.0f) && (newValue[0] != -1.0f || newValue[1] != -1.0f || newValue[2] != -1.0f)) {
            throw new InvalidFieldValueException("ParticleSystem bboxSize newValue=" + SFVec3f.toString(newValue) + " has negative value but is not equal to sentinel {-1,-1,-1} value.");
        }
        this.bboxSize = newValue;
        return this;
    }

    public ParticleSystem setBboxSize(SFVec3f newValue) {
        this.setBboxSize(newValue.getPrimitiveValue());
        return this;
    }

    public ParticleSystem setBboxSize(float x, float y, float z) {
        this.setBboxSize(new float[]{x, y, z});
        return this;
    }

    public ParticleSystem setBboxSize(double x, double y, double z) {
        return this.setBboxSize(new SFVec3f(x, y, z));
    }

    public ParticleSystem setBboxSize(double[] newArray) {
        return this.setBboxSize(new SFVec3f(newArray));
    }

    @Override
    public float[] getColorKey() {
        float[] valuesArray = new float[this.colorKey.size()];
        int i = 0;
        for (Float arrayElement : this.colorKey) {
            valuesArray[i++] = arrayElement.floatValue();
        }
        return valuesArray;
    }

    public ArrayList<Float> getColorKeyList() {
        return this.colorKey;
    }

    public String getColorKeyString() {
        StringBuilder result = new StringBuilder();
        for (Float arrayElement : this.colorKey) {
            result.append(arrayElement.toString());
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public ParticleSystem setColorKey(float[] newValue) {
        if (newValue == null) {
            this.clearColorKey();
            return this;
        }
        this.clearColorKey();
        for (int i = 0; i < newValue.length; ++i) {
            this.colorKey.add(Float.valueOf(newValue[i]));
        }
        return this;
    }

    public ParticleSystem setColorKey(MFFloat newValue) {
        if (newValue == null) {
            this.clearColorKey();
            return this;
        }
        this.setColorKey(newValue.getPrimitiveValue());
        return this;
    }

    public ParticleSystem setColorKey(ArrayList<Float> newValue) {
        if (newValue == null) {
            this.clearColorKey();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearColorKey();
        } else {
            float[] newArray = new float[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i).floatValue();
            }
            this.setColorKey(newArray);
        }
        return this;
    }

    public ParticleSystem clearColorKey() {
        this.colorKey.clear();
        return this;
    }

    public ParticleSystem setColorKey(int[] newValue) {
        if (newValue == null) {
            this.clearColorKey();
            return this;
        }
        float[] holdArray = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            holdArray[i] = newValue[i];
        }
        this.setColorKey(holdArray);
        return this;
    }

    public ParticleSystem addColorKey(float newValue) {
        this.colorKey.add(Float.valueOf(newValue));
        return this;
    }

    public ParticleSystem addColorKey(SFFloat newValue) {
        if (newValue == null) {
            return this;
        }
        this.colorKey.add(Float.valueOf(newValue.getPrimitiveValue()));
        return this;
    }

    public ParticleSystem setColorKey(double[] newArray) {
        return this.setColorKey(new MFFloat(newArray));
    }

    @Override
    public X3DColorNode getColorRamp() {
        return this.colorRamp;
    }

    @Override
    public ParticleSystem setColorRamp(X3DColorNode newValue) {
        this.colorRamp = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.colorRamp)).setParent(this);
        }
        if (this.colorRampProtoInstance != null) {
            this.colorRampProtoInstance.setParent(null);
            this.colorRampProtoInstance = null;
        }
        return this;
    }

    public ParticleSystem clearColorRamp() {
        ((X3DConcreteElement)((Object)this.colorRamp)).clearParent();
        this.colorRamp = null;
        return this;
    }

    public ParticleSystem setColorRamp(ProtoInstance newValue) {
        if (this.colorRampProtoInstance != null) {
            this.colorRampProtoInstance.setParent(null);
        }
        this.colorRampProtoInstance = newValue;
        if (newValue != null) {
            this.colorRampProtoInstance.setParent(this);
            this.colorRampProtoInstance.setContainerField("colorRamp");
        }
        if (this.colorRamp != null) {
            ((X3DConcreteElement)((Object)this.colorRamp)).setParent(null);
            this.colorRamp = null;
        }
        return this;
    }

    private ProtoInstance getColorRampProtoInstance() {
        return this.colorRampProtoInstance;
    }

    public boolean hasColorRamp() {
        return this.colorRamp != null || this.colorRampProtoInstance != null;
    }

    @Override
    public boolean getCreateParticles() {
        return this.createParticles;
    }

    @Override
    public ParticleSystem setCreateParticles(boolean newValue) {
        this.createParticles = newValue;
        return this;
    }

    public ParticleSystem setCreateParticles(SFBool newValue) {
        this.setCreateParticles(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DParticleEmitterNode getEmitter() {
        return this.emitter;
    }

    @Override
    public ParticleSystem setEmitter(X3DParticleEmitterNode newValue) {
        this.emitter = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.emitter)).setParent(this);
        }
        if (this.emitterProtoInstance != null) {
            this.emitterProtoInstance.setParent(null);
            this.emitterProtoInstance = null;
        }
        return this;
    }

    public ParticleSystem clearEmitter() {
        ((X3DConcreteElement)((Object)this.emitter)).clearParent();
        this.emitter = null;
        return this;
    }

    public ParticleSystem setEmitter(ProtoInstance newValue) {
        if (this.emitterProtoInstance != null) {
            this.emitterProtoInstance.setParent(null);
        }
        this.emitterProtoInstance = newValue;
        if (newValue != null) {
            this.emitterProtoInstance.setParent(this);
            this.emitterProtoInstance.setContainerField("emitter");
        }
        if (this.emitter != null) {
            ((X3DConcreteElement)((Object)this.emitter)).setParent(null);
            this.emitter = null;
        }
        return this;
    }

    private ProtoInstance getEmitterProtoInstance() {
        return this.emitterProtoInstance;
    }

    public boolean hasEmitter() {
        return this.emitter != null || this.emitterProtoInstance != null;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public ParticleSystem setEnabled(boolean newValue) {
        this.enabled = newValue;
        return this;
    }

    public ParticleSystem setEnabled(SFBool newValue) {
        this.setEnabled(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DGeometryNode getGeometry() {
        return this.geometry;
    }

    @Override
    public ParticleSystem setGeometry(X3DGeometryNode newValue) {
        this.geometry = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.geometry)).setParent(this);
        }
        if (this.geometryProtoInstance != null) {
            this.geometryProtoInstance.setParent(null);
            this.geometryProtoInstance = null;
        }
        return this;
    }

    public ParticleSystem clearGeometry() {
        ((X3DConcreteElement)((Object)this.geometry)).clearParent();
        this.geometry = null;
        return this;
    }

    public ParticleSystem setGeometry(ProtoInstance newValue) {
        if (this.geometryProtoInstance != null) {
            this.geometryProtoInstance.setParent(null);
        }
        this.geometryProtoInstance = newValue;
        if (newValue != null) {
            this.geometryProtoInstance.setParent(this);
            this.geometryProtoInstance.setContainerField("geometry");
        }
        if (this.geometry != null) {
            ((X3DConcreteElement)((Object)this.geometry)).setParent(null);
            this.geometry = null;
        }
        return this;
    }

    private ProtoInstance getGeometryProtoInstance() {
        return this.geometryProtoInstance;
    }

    public boolean hasGeometry() {
        return this.geometry != null || this.geometryProtoInstance != null;
    }

    @Override
    public String getGeometryType() {
        return this.geometryType;
    }

    @Override
    public ParticleSystem setGeometryType(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)).isEmpty() || newValue.equals(GEOMETRYTYPE_LINE) || newValue.equals(GEOMETRYTYPE_POINT) || newValue.equals("QUAD") || newValue.equals(GEOMETRYTYPE_SPRITE) || newValue.equals(GEOMETRYTYPE_TRIANGLE) || newValue.equals(GEOMETRYTYPE_GEOMETRY))) {
            String warningMessage = "Warning: ParticleSystem geometryType newValue=\"" + newValue + "\" has an unrecognized value not matching any of the optional string tokens.";
            System.out.println(warningMessage);
        }
        if (newValue == null) {
            newValue = new String();
        }
        this.geometryType = newValue;
        return this;
    }

    public ParticleSystem setGeometryType(SFString newValue) {
        this.setGeometryType(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public ParticleSystem setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public ParticleSystem clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public boolean getIsActive() {
        return this.isActive;
    }

    @Override
    public float getLifetimeVariation() {
        return this.lifetimeVariation;
    }

    @Override
    public ParticleSystem setLifetimeVariation(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("ParticleSystem lifetimeVariation newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1.0f) {
            throw new InvalidFieldValueException("ParticleSystem lifetimeVariation newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.lifetimeVariation = newValue;
        return this;
    }

    public ParticleSystem setLifetimeVariation(SFFloat newValue) {
        this.setLifetimeVariation(newValue.getPrimitiveValue());
        return this;
    }

    public ParticleSystem setLifetimeVariation(double newValue) {
        return this.setLifetimeVariation((float)newValue);
    }

    @Override
    public int getMaxParticles() {
        return this.maxParticles;
    }

    @Override
    public ParticleSystem setMaxParticles(int newValue) {
        if (newValue < 0) {
            throw new InvalidFieldValueException("ParticleSystem maxParticles newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.maxParticles = newValue;
        return this;
    }

    public ParticleSystem setMaxParticles(SFInt32 newValue) {
        this.setMaxParticles(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public ParticleSystem setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public ParticleSystem clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public ParticleSystem setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public float getParticleLifetime() {
        return this.particleLifetime;
    }

    @Override
    public ParticleSystem setParticleLifetime(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("ParticleSystem particleLifetime newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.particleLifetime = newValue;
        return this;
    }

    public ParticleSystem setParticleLifetime(SFFloat newValue) {
        this.setParticleLifetime(newValue.getPrimitiveValue());
        return this;
    }

    public ParticleSystem setParticleLifetime(double newValue) {
        return this.setParticleLifetime((float)newValue);
    }

    @Override
    public float[] getParticleSize() {
        return this.particleSize;
    }

    @Override
    public ParticleSystem setParticleSize(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 2) {
            throw new InvalidFieldValueException("ParticleSystem particleSize newValue=" + SFVec2f.toString(newValue) + " has length=" + newValue.length + " instead of required length 2");
        }
        if (newValue[0] < 0.0f || newValue[1] < 0.0f) {
            throw new InvalidFieldValueException("ParticleSystem particleSize newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.particleSize = newValue;
        return this;
    }

    public ParticleSystem setParticleSize(SFVec2f newValue) {
        this.setParticleSize(newValue.getPrimitiveValue());
        return this;
    }

    public ParticleSystem setParticleSize(float x, float y) {
        this.setParticleSize(new float[]{x, y});
        return this;
    }

    public ParticleSystem setParticleSize(double x, double y) {
        return this.setParticleSize(new SFVec2f(x, y));
    }

    public ParticleSystem setParticleSize(double[] newArray) {
        return this.setParticleSize(new SFVec2f(newArray));
    }

    @Override
    public X3DNode[] getPhysics() {
        X3DNode[] valuesArray = new X3DNode[this.physics.size()];
        int i = 0;
        for (X3DNode arrayElement : this.physics) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<X3DNode> getPhysicsList() {
        return this.physics;
    }

    @Override
    public ParticleSystem setPhysics(X3DNode[] newValue) {
        if (newValue == null) {
            this.clearPhysics();
            return this;
        }
        this.clearPhysics();
        for (int i = 0; i < newValue.length; ++i) {
            if (!(newValue[i] instanceof X3DNode) && !(newValue[i] instanceof ProtoInstance)) {
                throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance array newValue=" + Arrays.toString(newValue));
            }
            this.physics.add(newValue[i]);
            ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
        }
        return this;
    }

    public ParticleSystem setPhysics(ArrayList<X3DParticlePhysicsModelNode> newValue) {
        if (newValue == null) {
            this.clearPhysics();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearPhysics();
        } else {
            X3DNode[] newArray = new X3DNode[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setPhysics(newArray);
        }
        for (X3DParticlePhysicsModelNode element : newValue) {
            this.physics.add(element);
            ((X3DConcreteElement)((Object)element)).setParent(this);
        }
        return this;
    }

    public ParticleSystem addPhysics(X3DNode newValue) {
        if (newValue == null) {
            return this;
        }
        this.physics.add(newValue);
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        return this;
    }

    public ParticleSystem addPhysics(ProtoInstance newValue) {
        if (newValue == null) {
            return this;
        }
        this.physics.add(newValue);
        newValue.setParent(this);
        return this;
    }

    @Override
    public void addPhysics(X3DNode[] newValue) {
        if (newValue == null) {
            return;
        }
        for (int i = 0; i < newValue.length; ++i) {
            if (newValue[i] instanceof X3DNode || newValue[i] instanceof ProtoInstance) {
                this.physics.add(newValue[i]);
                ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
                if (!(newValue[i] instanceof ProtoInstance)) continue;
                ((ProtoInstance)newValue[i]).setContainerField("physics");
                continue;
            }
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance, array newValue=" + Arrays.toString(newValue));
        }
    }

    @Override
    public void setPhysics(X3DNode newValue) {
        if (newValue == null) {
            this.clearPhysics();
            return;
        }
        if (newValue instanceof X3DNode) {
            for (X3DNode element : this.physics) {
                ((X3DConcreteElement)((Object)element)).clearParent();
            }
        } else {
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode newValue is not instanceof org.web3d.x3d.sai.Core.X3DNode; newValue=" + newValue);
        }
        this.clearPhysics();
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        this.physics.add(newValue);
    }

    public ParticleSystem clearPhysics() {
        for (X3DNode element : this.physics) {
            ((X3DConcreteElement)((Object)element)).clearParent();
        }
        this.physics.clear();
        return this;
    }

    public boolean hasPhysics() {
        return !this.physics.isEmpty();
    }

    @Override
    public float[] getTexCoordKey() {
        float[] valuesArray = new float[this.texCoordKey.size()];
        int i = 0;
        for (Float arrayElement : this.texCoordKey) {
            valuesArray[i++] = arrayElement.floatValue();
        }
        return valuesArray;
    }

    public ArrayList<Float> getTexCoordKeyList() {
        return this.texCoordKey;
    }

    public String getTexCoordKeyString() {
        StringBuilder result = new StringBuilder();
        for (Float arrayElement : this.texCoordKey) {
            result.append(arrayElement.toString());
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public ParticleSystem setTexCoordKey(float[] newValue) {
        if (newValue == null) {
            this.clearTexCoordKey();
            return this;
        }
        this.clearTexCoordKey();
        for (int i = 0; i < newValue.length; ++i) {
            this.texCoordKey.add(Float.valueOf(newValue[i]));
        }
        return this;
    }

    public ParticleSystem setTexCoordKey(MFFloat newValue) {
        if (newValue == null) {
            this.clearTexCoordKey();
            return this;
        }
        this.setTexCoordKey(newValue.getPrimitiveValue());
        return this;
    }

    public ParticleSystem setTexCoordKey(ArrayList<Float> newValue) {
        if (newValue == null) {
            this.clearTexCoordKey();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearTexCoordKey();
        } else {
            float[] newArray = new float[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i).floatValue();
            }
            this.setTexCoordKey(newArray);
        }
        return this;
    }

    public ParticleSystem clearTexCoordKey() {
        this.texCoordKey.clear();
        return this;
    }

    public ParticleSystem setTexCoordKey(int[] newValue) {
        if (newValue == null) {
            this.clearTexCoordKey();
            return this;
        }
        float[] holdArray = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            holdArray[i] = newValue[i];
        }
        this.setTexCoordKey(holdArray);
        return this;
    }

    public ParticleSystem addTexCoordKey(float newValue) {
        this.texCoordKey.add(Float.valueOf(newValue));
        return this;
    }

    public ParticleSystem addTexCoordKey(SFFloat newValue) {
        if (newValue == null) {
            return this;
        }
        this.texCoordKey.add(Float.valueOf(newValue.getPrimitiveValue()));
        return this;
    }

    public ParticleSystem setTexCoordKey(double[] newArray) {
        return this.setTexCoordKey(new MFFloat(newArray));
    }

    @Override
    public TextureCoordinate getTexCoordRamp() {
        return this.texCoordRamp;
    }

    @Override
    public ParticleSystem setTexCoordRamp(TextureCoordinate newValue) {
        this.texCoordRamp = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.texCoordRamp)).setParent(this);
        }
        if (this.texCoordRampProtoInstance != null) {
            this.texCoordRampProtoInstance.setParent(null);
            this.texCoordRampProtoInstance = null;
        }
        return this;
    }

    public ParticleSystem clearTexCoordRamp() {
        ((X3DConcreteElement)((Object)this.texCoordRamp)).clearParent();
        this.texCoordRamp = null;
        return this;
    }

    public ParticleSystem setTexCoordRamp(ProtoInstance newValue) {
        if (this.texCoordRampProtoInstance != null) {
            this.texCoordRampProtoInstance.setParent(null);
        }
        this.texCoordRampProtoInstance = newValue;
        if (newValue != null) {
            this.texCoordRampProtoInstance.setParent(this);
            this.texCoordRampProtoInstance.setContainerField("texCoordRamp");
        }
        if (this.texCoordRamp != null) {
            ((X3DConcreteElement)((Object)this.texCoordRamp)).setParent(null);
            this.texCoordRamp = null;
        }
        return this;
    }

    private ProtoInstance getTexCoordRampProtoInstance() {
        return this.texCoordRampProtoInstance;
    }

    public boolean hasTexCoordRamp() {
        return this.texCoordRamp != null || this.texCoordRampProtoInstance != null;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public ParticleSystem setVisible(boolean newValue) {
        this.visible = newValue;
        return this;
    }

    public ParticleSystem setVisible(SFBool newValue) {
        this.setVisible(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final ParticleSystem setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("ParticleSystem DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public ParticleSystem setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final ParticleSystem setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("ParticleSystem USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public ParticleSystem setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final ParticleSystem setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public ParticleSystem setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    public ParticleSystem setUSE(ParticleSystem DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on ParticleSystem that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public ParticleSystem(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public ParticleSystem addComments(String newComment) {
        if (this.isUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public ParticleSystem addComments(String[] newComments) {
        if (this.isUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public ParticleSystem addComments(CommentsBlock newCommentsBlock) {
        if (this.isUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.appearance != null || this.appearanceProtoInstance != null || this.colorRamp != null || this.colorRampProtoInstance != null || this.emitter != null || this.emitterProtoInstance != null || this.geometry != null || this.geometryProtoInstance != null || this.geometry != null || this.geometryProtoInstance != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.physics.isEmpty() || this.texCoordRamp != null || this.texCoordRampProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<ParticleSystem");
        if (hasAttributes) {
            if (!this.getDEF().equals("") && !this.isUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals("")) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(Arrays.equals(this.getBboxCenter(), BBOXCENTER_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" bboxCenter='").append(SFVec3f.toString(this.getBboxCenter())).append("'");
            }
            if (!(!this.getBboxDisplay() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" bboxDisplay='").append(SFBool.toString(this.getBboxDisplay())).append("'");
            }
            if (!(Arrays.equals(this.getBboxSize(), BBOXSIZE_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" bboxSize='").append(SFVec3f.toString(this.getBboxSize())).append("'");
            }
            if (!(this.getCssClass().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getColorKey().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" colorKey='").append(MFFloat.toString(this.getColorKey())).append("'");
            }
            if (!(this.getCreateParticles() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" createParticles='").append(SFBool.toString(this.getCreateParticles())).append("'");
            }
            if (!(this.getEnabled() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" enabled='").append(SFBool.toString(this.getEnabled())).append("'");
            }
            if (!(this.getGeometryType().equals("QUAD") && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" geometryType='").append(new SFString(this.getGeometryType()).toStringX3D()).append("'");
            }
            if (!(this.getLifetimeVariation() == 0.25f && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" lifetimeVariation='").append(SFFloat.toString(this.getLifetimeVariation())).append("'");
            }
            if (!(this.getMaxParticles() == 200 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" maxParticles='").append(SFInt32.toString(this.getMaxParticles())).append("'");
            }
            if (!(this.getParticleLifetime() == 5.0f && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" particleLifetime='").append(SFFloat.toString(this.getParticleLifetime())).append("'");
            }
            if (!(Arrays.equals(this.getParticleSize(), PARTICLESIZE_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" particleSize='").append(SFVec2f.toString(this.getParticleSize())).append("'");
            }
            if (!(this.getTexCoordKey().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" texCoordKey='").append(MFFloat.toString(this.getTexCoordKey())).append("'");
            }
            if (!(this.getVisible() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" visible='").append(SFBool.toString(this.getVisible())).append("'");
            }
        }
        if (hasChild && !this.isUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.appearance != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.appearance)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.appearanceProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.appearanceProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.colorRamp != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.colorRamp)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.colorRampProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.colorRampProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.emitter != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.emitter)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.emitterProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.emitterProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.geometry != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.geometry)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.geometryProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.geometryProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.geometry != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.geometry)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.geometryProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.geometryProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            for (X3DNode element : this.physics) {
                stringX3D.append(((X3DConcreteElement)((Object)element)).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.texCoordRamp != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.texCoordRamp)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.texCoordRampProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.texCoordRampProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</ParticleSystem>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.appearance != null || this.appearanceProtoInstance != null || this.colorRamp != null || this.colorRampProtoInstance != null || this.emitter != null || this.emitterProtoInstance != null || this.geometry != null || this.geometryProtoInstance != null || this.geometry != null || this.geometryProtoInstance != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.physics.isEmpty() || this.texCoordRamp != null || this.texCoordRampProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals("")) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals("")) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxCenter")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxCenter").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBboxCenter(), BBOXCENTER_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxCenter ").append(SFVec3f.toString(this.getBboxCenter())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxDisplay")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxDisplay").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getBboxDisplay() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxDisplay ").append(SFBool.toString(this.getBboxDisplay())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxSize")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxSize").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBboxSize(), BBOXSIZE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxSize ").append(SFVec3f.toString(this.getBboxSize())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("# class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("colorKey")) continue;
                        stringClassicVRML.append(indentCharacter).append("colorKey").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getColorKey().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("colorKey ").append("[ ").append(MFFloat.toString(this.getColorKey())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("createParticles")) continue;
                        stringClassicVRML.append(indentCharacter).append("createParticles").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCreateParticles() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("createParticles ").append(SFBool.toString(this.getCreateParticles())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("enabled")) continue;
                        stringClassicVRML.append(indentCharacter).append("enabled").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getEnabled() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("enabled ").append(SFBool.toString(this.getEnabled())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("geometryType")) continue;
                        stringClassicVRML.append(indentCharacter).append("geometryType").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getGeometryType().equals("QUAD") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("geometryType ").append("\"").append(SFString.toString(this.getGeometryType())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("lifetimeVariation")) continue;
                        stringClassicVRML.append(indentCharacter).append("lifetimeVariation").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getLifetimeVariation() != 0.25f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("lifetimeVariation ").append(SFFloat.toString(this.getLifetimeVariation())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("maxParticles")) continue;
                        stringClassicVRML.append(indentCharacter).append("maxParticles").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getMaxParticles() != 200 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("maxParticles ").append(SFInt32.toString(this.getMaxParticles())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("particleLifetime")) continue;
                        stringClassicVRML.append(indentCharacter).append("particleLifetime").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getParticleLifetime() != 5.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("particleLifetime ").append(SFFloat.toString(this.getParticleLifetime())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("particleSize")) continue;
                        stringClassicVRML.append(indentCharacter).append("particleSize").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getParticleSize(), PARTICLESIZE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("particleSize ").append(SFVec2f.toString(this.getParticleSize())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("texCoordKey")) continue;
                        stringClassicVRML.append(indentCharacter).append("texCoordKey").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getTexCoordKey().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("texCoordKey ").append("[ ").append(MFFloat.toString(this.getTexCoordKey())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("visible")) continue;
                        stringClassicVRML.append(indentCharacter).append("visible").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getVisible() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("visible ").append(SFBool.toString(this.getVisible())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.appearance != null) {
                stringClassicVRML.append(indentCharacter).append("appearance").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.appearance)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.appearanceProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("appearance").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.appearanceProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.colorRamp != null) {
                stringClassicVRML.append(indentCharacter).append("colorRamp").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.colorRamp)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.colorRampProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("colorRamp").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.colorRampProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.emitter != null) {
                stringClassicVRML.append(indentCharacter).append("emitter").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.emitter)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.emitterProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("emitter").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.emitterProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.geometry != null) {
                stringClassicVRML.append(indentCharacter).append("geometry").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.geometry)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.geometryProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("geometry").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.geometryProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.geometry != null) {
                stringClassicVRML.append(indentCharacter).append("geometry").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.geometry)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.geometryProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("geometry").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.geometryProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.physics.size() > 0) {
                stringClassicVRML.append(indentCharacter).append(indentCharacter).append("physics").append(" [").append("\n").append((CharSequence)indent).append(indentCharacter).append(indentCharacter);
                for (X3DNode element : this.physics) {
                    stringClassicVRML.append(((X3DConcreteElement)((Object)element)).toStringClassicVRML(indentLevel + indentIncrement + indentIncrement));
                }
                stringClassicVRML.append((CharSequence)indent).append(indentCharacter).append(indentCharacter).append("]").append("\n").append((CharSequence)indent);
            }
            if (this.texCoordRamp != null) {
                stringClassicVRML.append(indentCharacter).append("texCoordRamp").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.texCoordRamp)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.texCoordRampProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("texCoordRamp").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.texCoordRampProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.appearance != null && (referenceElement = ((X3DConcreteElement)((Object)this.appearance)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.appearanceProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.appearanceProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.colorRamp != null && (referenceElement = ((X3DConcreteElement)((Object)this.colorRamp)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.colorRampProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.colorRampProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.emitter != null && (referenceElement = ((X3DConcreteElement)((Object)this.emitter)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.emitterProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.emitterProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.geometry != null && (referenceElement = ((X3DConcreteElement)((Object)this.geometry)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.geometryProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.geometryProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.geometry != null && (referenceElement = ((X3DConcreteElement)((Object)this.geometry)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.geometryProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.geometryProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        for (X3DNode element : this.physics) {
            if (!(element instanceof X3DConcreteElement) || (referenceElement = ((X3DConcreteElement)((Object)element)).findElementByNameValue(nameValue, elementName)) == null) continue;
            return referenceElement;
        }
        if (this.texCoordRamp != null && (referenceElement = ((X3DConcreteElement)((Object)this.texCoordRamp)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.texCoordRampProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.texCoordRampProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.appearance != null && (referenceNode = ((X3DConcreteElement)((Object)this.appearance)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.appearanceProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.appearanceProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.colorRamp != null && (referenceNode = ((X3DConcreteElement)((Object)this.colorRamp)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.colorRampProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.colorRampProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.emitter != null && (referenceNode = ((X3DConcreteElement)((Object)this.emitter)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.emitterProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.emitterProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.geometry != null && (referenceNode = ((X3DConcreteElement)((Object)this.geometry)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.geometryProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.geometryProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.geometry != null && (referenceNode = ((X3DConcreteElement)((Object)this.geometry)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.geometryProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.geometryProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        for (X3DNode element : this.physics) {
            if (!(element instanceof X3DConcreteNode) || (referenceNode = ((X3DConcreteElement)((Object)element)).findNodeByDEF(DEFvalue)) == null) continue;
            return referenceNode;
        }
        if (this.texCoordRamp != null && (referenceNode = ((X3DConcreteElement)((Object)this.texCoordRamp)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.texCoordRampProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.texCoordRampProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        Object errorNotice21;
        this.validationResult = new StringBuilder();
        this.setBboxCenter(this.getBboxCenter());
        this.setBboxDisplay(this.getBboxDisplay());
        this.setBboxSize(this.getBboxSize());
        this.setColorKey(this.getColorKey());
        this.setCreateParticles(this.getCreateParticles());
        this.setEnabled(this.getEnabled());
        this.setGeometryType(this.getGeometryType());
        this.setLifetimeVariation(this.getLifetimeVariation());
        this.setMaxParticles(this.getMaxParticles());
        this.setParticleLifetime(this.getParticleLifetime());
        this.setParticleSize(this.getParticleSize());
        this.setTexCoordKey(this.getTexCoordKey());
        this.setVisible(this.getVisible());
        if (!this.isUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.isUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        if (this.appearance != null) {
            this.setAppearance(this.getAppearance());
            ((X3DConcreteElement)((Object)this.appearance)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.appearance)).getValidationResult());
        }
        if (this.appearanceProtoInstance != null) {
            this.setAppearance(this.getAppearanceProtoInstance());
            ((X3DConcreteElement)this.appearanceProtoInstance).validate();
            this.validationResult.append(this.appearanceProtoInstance.getValidationResult());
        }
        if (this.appearance != null && this.appearanceProtoInstance != null) {
            String errorNotice2 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both appearance and appearanceProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice2);
            throw new InvalidProtoException(errorNotice2);
        }
        if (this.isUSE() && this.hasAppearance()) {
            String errorNotice3 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained SFNode appearance";
            this.validationResult.append(errorNotice3);
            throw new InvalidFieldValueException(errorNotice3);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice4 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice4);
            throw new InvalidFieldValueException(errorNotice4);
        }
        if (this.colorRamp != null) {
            this.setColorRamp(this.getColorRamp());
            ((X3DConcreteElement)((Object)this.colorRamp)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.colorRamp)).getValidationResult());
        }
        if (this.colorRampProtoInstance != null) {
            this.setColorRamp(this.getColorRampProtoInstance());
            ((X3DConcreteElement)this.colorRampProtoInstance).validate();
            this.validationResult.append(this.colorRampProtoInstance.getValidationResult());
        }
        if (this.colorRamp != null && this.colorRampProtoInstance != null) {
            String errorNotice5 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both colorRamp and colorRampProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice5);
            throw new InvalidProtoException(errorNotice5);
        }
        if (this.isUSE() && this.hasColorRamp()) {
            String errorNotice6 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained SFNode colorRamp";
            this.validationResult.append(errorNotice6);
            throw new InvalidFieldValueException(errorNotice6);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice7 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice7);
            throw new InvalidFieldValueException(errorNotice7);
        }
        if (this.emitter != null) {
            this.setEmitter(this.getEmitter());
            ((X3DConcreteElement)((Object)this.emitter)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.emitter)).getValidationResult());
        }
        if (this.emitterProtoInstance != null) {
            this.setEmitter(this.getEmitterProtoInstance());
            ((X3DConcreteElement)this.emitterProtoInstance).validate();
            this.validationResult.append(this.emitterProtoInstance.getValidationResult());
        }
        if (this.emitter != null && this.emitterProtoInstance != null) {
            String errorNotice8 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both emitter and emitterProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice8);
            throw new InvalidProtoException(errorNotice8);
        }
        if (this.isUSE() && this.hasEmitter()) {
            String errorNotice9 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained SFNode emitter";
            this.validationResult.append(errorNotice9);
            throw new InvalidFieldValueException(errorNotice9);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice10 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice10);
            throw new InvalidFieldValueException(errorNotice10);
        }
        if (this.geometry != null) {
            this.setGeometry(this.getGeometry());
            ((X3DConcreteElement)((Object)this.geometry)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.geometry)).getValidationResult());
        }
        if (this.geometryProtoInstance != null) {
            this.setGeometry(this.getGeometryProtoInstance());
            ((X3DConcreteElement)this.geometryProtoInstance).validate();
            this.validationResult.append(this.geometryProtoInstance.getValidationResult());
        }
        if (this.geometry != null && this.geometryProtoInstance != null) {
            String errorNotice11 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both geometry and geometryProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice11);
            throw new InvalidProtoException(errorNotice11);
        }
        if (this.isUSE() && this.hasGeometry()) {
            String errorNotice12 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained SFNode geometry";
            this.validationResult.append(errorNotice12);
            throw new InvalidFieldValueException(errorNotice12);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice13 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice13);
            throw new InvalidFieldValueException(errorNotice13);
        }
        if (this.geometry != null) {
            this.setGeometry(this.getGeometry());
            ((X3DConcreteElement)((Object)this.geometry)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.geometry)).getValidationResult());
        }
        if (this.geometryProtoInstance != null) {
            this.setGeometry(this.getGeometryProtoInstance());
            ((X3DConcreteElement)this.geometryProtoInstance).validate();
            this.validationResult.append(this.geometryProtoInstance.getValidationResult());
        }
        if (this.geometry != null && this.geometryProtoInstance != null) {
            String errorNotice14 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both geometry and geometryProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice14);
            throw new InvalidProtoException(errorNotice14);
        }
        if (this.isUSE() && this.hasGeometry()) {
            String errorNotice15 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained SFNode geometry";
            this.validationResult.append(errorNotice15);
            throw new InvalidFieldValueException(errorNotice15);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice16 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice16);
            throw new InvalidFieldValueException(errorNotice16);
        }
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.isUSE() && this.hasIS()) {
            String errorNotice17 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice17);
            throw new InvalidFieldValueException(errorNotice17);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice18 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice18);
            throw new InvalidFieldValueException(errorNotice18);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice19 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice19);
            throw new InvalidProtoException(errorNotice19);
        }
        if (this.isUSE() && this.hasMetadata()) {
            String errorNotice20 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice20);
            throw new InvalidFieldValueException(errorNotice20);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice21 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice21);
            throw new InvalidFieldValueException(errorNotice21);
        }
        for (X3DNode element : this.physics) {
            ((X3DConcreteElement)((Object)element)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)element)).getValidationResult());
        }
        this.setPhysics(this.getPhysics());
        if (this.isUSE() && this.hasPhysics()) {
            errorNotice21 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained MFNode physics";
            this.validationResult.append((String)errorNotice21);
            throw new InvalidFieldValueException((String)errorNotice21);
        }
        if (this.texCoordRamp != null) {
            this.setTexCoordRamp(this.getTexCoordRamp());
            ((X3DConcreteElement)((Object)this.texCoordRamp)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.texCoordRamp)).getValidationResult());
        }
        if (this.texCoordRampProtoInstance != null) {
            this.setTexCoordRamp(this.getTexCoordRampProtoInstance());
            ((X3DConcreteElement)this.texCoordRampProtoInstance).validate();
            this.validationResult.append(this.texCoordRampProtoInstance.getValidationResult());
        }
        if (this.texCoordRamp != null && this.texCoordRampProtoInstance != null) {
            errorNotice21 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both texCoordRamp and texCoordRampProtoInstance are set simultaneously";
            this.validationResult.append((String)errorNotice21);
            throw new InvalidProtoException((String)errorNotice21);
        }
        if (this.isUSE() && this.hasTexCoordRamp()) {
            errorNotice21 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained SFNode texCoordRamp";
            this.validationResult.append((String)errorNotice21);
            throw new InvalidFieldValueException((String)errorNotice21);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            errorNotice21 = "ParticleSystem USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append((String)errorNotice21);
            throw new InvalidFieldValueException((String)errorNotice21);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            errorNotice21 = "IS statement present, but contains no connect statements";
            this.validationResult.append((String)errorNotice21).append("\n");
            throw new InvalidProtoException((String)errorNotice21);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            errorNotice21 = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append((String)errorNotice21).append("\n");
            throw new InvalidFieldException((String)errorNotice21);
        }
        if (this.findAncestorX3D() != null) {
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean hasSatisfactorySupport = this.findAncestorX3D().supportsX3dComponent(COMPONENT, 2);
            if (!hasSatisfactorySupport) {
                String errorNotice22 = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for parent X3D model containing 'ParticleSystem' node, add head statement <component name='ParticleSystems' level='2'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"ParticleSystems\").setLevel(2);";
                this.validationResult.append(errorNotice22).append("\n");
                throw new InvalidFieldException(errorNotice22);
            }
        }
        return this.validationResult.toString();
    }
}

