/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.web3d.x3d.jsail.CADGeometry.CADFace;
import org.web3d.x3d.jsail.CADGeometry.IndexedQuadSet;
import org.web3d.x3d.jsail.CADGeometry.QuadSet;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.ExternProtoDeclare;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoBody;
import org.web3d.x3d.jsail.Core.ProtoDeclare;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.ProtoInterface;
import org.web3d.x3d.jsail.Core.Scene;
import org.web3d.x3d.jsail.Core.X3D;
import org.web3d.x3d.jsail.Core.component;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.Core.field;
import org.web3d.x3d.jsail.Core.fieldValue;
import org.web3d.x3d.jsail.Core.head;
import org.web3d.x3d.jsail.Core.meta;
import org.web3d.x3d.jsail.Core.unit;
import org.web3d.x3d.jsail.CubeMapTexturing.ComposedCubeMapTexture;
import org.web3d.x3d.jsail.DIS.DISEntityManager;
import org.web3d.x3d.jsail.DIS.DISEntityTypeMapping;
import org.web3d.x3d.jsail.DIS.EspduTransform;
import org.web3d.x3d.jsail.EnvironmentalEffects.FogCoordinate;
import org.web3d.x3d.jsail.EnvironmentalEffects.TextureBackground;
import org.web3d.x3d.jsail.Geometry3D.ElevationGrid;
import org.web3d.x3d.jsail.Geometry3D.IndexedFaceSet;
import org.web3d.x3d.jsail.Geospatial.GeoCoordinate;
import org.web3d.x3d.jsail.Geospatial.GeoElevationGrid;
import org.web3d.x3d.jsail.Geospatial.GeoLOD;
import org.web3d.x3d.jsail.Geospatial.GeoLocation;
import org.web3d.x3d.jsail.Geospatial.GeoOrigin;
import org.web3d.x3d.jsail.Geospatial.GeoPositionInterpolator;
import org.web3d.x3d.jsail.Geospatial.GeoProximitySensor;
import org.web3d.x3d.jsail.Geospatial.GeoTouchSensor;
import org.web3d.x3d.jsail.Geospatial.GeoTransform;
import org.web3d.x3d.jsail.Geospatial.GeoViewpoint;
import org.web3d.x3d.jsail.Grouping.StaticGroup;
import org.web3d.x3d.jsail.HAnim.HAnimDisplacer;
import org.web3d.x3d.jsail.HAnim.HAnimHumanoid;
import org.web3d.x3d.jsail.HAnim.HAnimJoint;
import org.web3d.x3d.jsail.HAnim.HAnimSegment;
import org.web3d.x3d.jsail.HAnim.HAnimSite;
import org.web3d.x3d.jsail.Layering.LayerSet;
import org.web3d.x3d.jsail.NURBS.NurbsOrientationInterpolator;
import org.web3d.x3d.jsail.NURBS.NurbsPatchSurface;
import org.web3d.x3d.jsail.NURBS.NurbsPositionInterpolator;
import org.web3d.x3d.jsail.NURBS.NurbsSurfaceInterpolator;
import org.web3d.x3d.jsail.NURBS.NurbsTrimmedSurface;
import org.web3d.x3d.jsail.Navigation.Collision;
import org.web3d.x3d.jsail.Navigation.ViewpointGroup;
import org.web3d.x3d.jsail.Networking.LoadSensor;
import org.web3d.x3d.jsail.Rendering.IndexedLineSet;
import org.web3d.x3d.jsail.Rendering.IndexedTriangleFanSet;
import org.web3d.x3d.jsail.Rendering.IndexedTriangleSet;
import org.web3d.x3d.jsail.Rendering.IndexedTriangleStripSet;
import org.web3d.x3d.jsail.Rendering.LineSet;
import org.web3d.x3d.jsail.Rendering.Normal;
import org.web3d.x3d.jsail.Rendering.PointSet;
import org.web3d.x3d.jsail.Rendering.TriangleFanSet;
import org.web3d.x3d.jsail.Rendering.TriangleSet;
import org.web3d.x3d.jsail.Rendering.TriangleStripSet;
import org.web3d.x3d.jsail.Scripting.Script;
import org.web3d.x3d.jsail.Shaders.ComposedShader;
import org.web3d.x3d.jsail.Shaders.PackagedShader;
import org.web3d.x3d.jsail.Shaders.ProgramShader;
import org.web3d.x3d.jsail.Shaders.ShaderPart;
import org.web3d.x3d.jsail.Shaders.ShaderProgram;
import org.web3d.x3d.jsail.Shape.Appearance;
import org.web3d.x3d.jsail.Shape.FillProperties;
import org.web3d.x3d.jsail.Shape.LineProperties;
import org.web3d.x3d.jsail.Shape.Material;
import org.web3d.x3d.jsail.Shape.Shape;
import org.web3d.x3d.jsail.Shape.TwoSidedMaterial;
import org.web3d.x3d.jsail.Sound.Sound;
import org.web3d.x3d.jsail.Text.Text;
import org.web3d.x3d.jsail.Texturing.MultiTexture;
import org.web3d.x3d.jsail.Texturing.MultiTextureCoordinate;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.Core.X3DChildNode;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.Core.X3DNode;
import org.web3d.x3d.sai.Grouping.X3DGroupingNode;
import org.web3d.x3d.sai.InvalidDocumentException;
import org.web3d.x3d.sai.Rendering.X3DColorNode;
import org.web3d.x3d.sai.Rendering.X3DComposedGeometryNode;
import org.web3d.x3d.sai.Rendering.X3DCoordinateNode;
import org.web3d.x3d.sai.Rendering.X3DGeometryNode;
import org.web3d.x3d.sai.Rendering.X3DNormalNode;
import org.web3d.x3d.sai.Shaders.X3DShaderNode;
import org.web3d.x3d.sai.Shape.X3DAppearanceNode;
import org.web3d.x3d.sai.Sound.X3DSoundSourceNode;
import org.web3d.x3d.sai.Text.X3DFontStyleNode;
import org.web3d.x3d.sai.Texturing.X3DTexture2DNode;
import org.web3d.x3d.sai.Texturing.X3DTextureCoordinateNode;
import org.web3d.x3d.sai.Texturing.X3DTextureNode;
import org.web3d.x3d.sai.Texturing.X3DTextureTransformNode;
import org.web3d.x3d.sai.X3DException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class X3DLoaderDOM {
    private DocumentBuilderFactory documentBuilderFactory;
    private DocumentBuilder documentBuilder;
    private Document document;
    private boolean loadSuccess = false;
    private StringBuilder validationResult = new StringBuilder();
    public final boolean DEFAULT_DTD_VALIDATE = false;
    public final boolean DEFAULT_XSD_VALIDATE = false;
    private boolean dtdValidate = false;
    private boolean xsdValidate = false;
    protected String indentLevel = "  ";
    protected int lineBreakWidth = 100;
    private int lineLength = 0;
    private static X3D loadedX3dModelInstance;
    private X3DConcreteElement holdCopyElementObject;
    private String currentProtoDeclareNameValue = new String();
    private String currentExternProtoDeclareNameValue = new String();
    private boolean currentProtoNodeTypeFound = false;
    private Map<String, String> protoNameToNodeTypesHashMap = new HashMap<String, String>();
    private Map<String, String> protoDEFtoNodeTypesHashMap = new HashMap<String, String>();
    private Map<String, String> protoContainerFieldHashMap = new HashMap<String, String>();

    public X3DLoaderDOM() {
        this.initialize();
    }

    private void initialize() {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setValidating(this.dtdValidate || this.xsdValidate);
        this.loadSuccess = false;
    }

    public boolean loadModelFromFileX3D(String fileName) {
        return this.loadModelFromFileX3D("", fileName);
    }

    public boolean loadModelFromFileX3D(String path, String fileName) {
        if (!fileName.endsWith(".x3d") && !fileName.endsWith(".xml")) {
            throw new X3DException("fileName " + fileName + " does not end with extension \"" + ".x3d" + "\" or \"" + ".xml" + "\"");
        }
        File x3dFile = path == null || path.isEmpty() || path.equals(".") ? new File(fileName) : new File(path, fileName);
        if (!x3dFile.exists()) {
            throw new X3DException("path='" + path + "', fileName='" + fileName + "' does not exist and cannot be loaded, check path and filename.");
        }
        return this.loadModelFromFileX3D(x3dFile);
    }

    public boolean loadModelFromFileX3D(File x3dFile) {
        try {
            this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
            this.documentBuilder.setErrorHandler(new MyErrorHandler(new PrintWriter((Writer)errorWriter, true)));
            this.document = this.documentBuilder.parse(x3dFile);
            X3DConcreteElement concreteElement = this.toX3dModelInstance(this.document);
            if (!concreteElement.getElementName().equals("X3D")) {
                System.out.println("*** Warning, loadModelFromFileX3D(\"" + x3dFile.getPath() + "\") has root element=" + concreteElement.getElementName());
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger(X3DLoaderDOM.class.getName()).log(Level.SEVERE, null, parserConfigurationException);
            this.loadSuccess = false;
            return this.loadSuccess;
        }
        catch (SAXException saxException) {
            Logger.getLogger(X3DLoaderDOM.class.getName()).log(Level.SEVERE, null, saxException);
            this.loadSuccess = false;
            return this.loadSuccess;
        }
        catch (IOException ioException) {
            Logger.getLogger(X3DLoaderDOM.class.getName()).log(Level.SEVERE, null, ioException);
            this.loadSuccess = false;
            return this.loadSuccess;
        }
        this.loadSuccess = this.document != null;
        return this.loadSuccess;
    }

    public Document getDomDocument() {
        return this.document;
    }

    public String toStringX3D(Node node) {
        return this.toStringX3D(node, "");
    }

    private String toStringX3D(Node node, String indent) {
        boolean nodeChildFound = false;
        StringBuilder result = new StringBuilder();
        if (node == null) {
            String message = "*** Error invoking toStringX3D(node=" + node + ", indent=" + indent + ")";
            System.out.println(message);
            throw new InvalidDocumentException(message);
        }
        if (indent == null) {
            indent = "";
        }
        switch (node.getNodeType()) {
            case 9: {
                result.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\"?>").append("\n");
                NodeList childNodeList = node.getChildNodes();
                if (childNodeList == null) break;
                for (int i = 0; i < childNodeList.getLength(); ++i) {
                    result.append(this.toStringX3D(childNodeList.item(i), ""));
                }
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                result.append("<!DOCTYPE ").append(documentType.getName());
                if (documentType.getName().compareTo("X3D") == 0) {
                    result.append(" PUBLIC \"ISO//Web3D//DTD X3D 3.3//EN\"");
                    result.append(" \"http://www.web3d.org/specifications/x3d-3.3.dtd\"");
                } else if (documentType.getPublicId() != null && documentType.getSystemId() != null) {
                    result.append(" PUBLIC \"").append(documentType.getPublicId()).append("\"");
                    result.append("        \"").append(documentType.getSystemId());
                } else if (documentType.getPublicId() == null && documentType.getSystemId() != null) {
                    result.append(" SYSTEM \"").append(documentType.getSystemId());
                }
                NodeList childNodeList = node.getChildNodes();
                if (childNodeList != null) {
                    for (int i = 0; i < childNodeList.getLength(); ++i) {
                        result.append(this.toStringX3D(childNodeList.item(i), ""));
                    }
                }
                if (documentType.getPublicId() != null && documentType.getSystemId() != null) {
                    result.append(">").append("\n");
                    break;
                }
                if (documentType.getPublicId() == null && documentType.getSystemId() != null) {
                    result.append("\">").append("\n");
                    break;
                }
                result.append(">").append("\n");
                break;
            }
            case 1: {
                int i;
                String name = node.getNodeName();
                result.append(indent).append("<").append(name);
                this.lineLength = name.length() + 2;
                NamedNodeMap attributes = node.getAttributes();
                for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                    Node current = attributes.item(i2);
                    String attributeValue = new String();
                    if (current.getNodeValue() != null) {
                        attributeValue = current.getNodeValue();
                    }
                    result.append(" ").append(current.getNodeName()).append("='").append(attributeValue).append("'");
                }
                NodeList children = node.getChildNodes();
                for (i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() == 3) continue;
                    nodeChildFound = true;
                    break;
                }
                if (nodeChildFound) {
                    result.append(">").append("\n");
                    for (i = 0; i < children.getLength(); ++i) {
                        result.append(this.toStringX3D(children.item(i), indent + this.indentLevel));
                    }
                    result.append(indent).append("</").append(name).append(">").append("\n");
                    break;
                }
                result.append("/>").append("\n");
                break;
            }
            case 3: {
                result.append(node.getNodeValue().trim());
                break;
            }
            case 4: {
                result.append(indent).append("<![CDATA[").append(node.getNodeValue()).append("]]>").append("\n");
                break;
            }
            case 8: {
                result.append(indent).append("<!-- ").append(node.getNodeValue().trim()).append(" -->").append("\n");
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                result.append("&").append(node.getNodeName()).append(";");
            }
        }
        return result.toString();
    }

    public X3DConcreteElement toX3dModelInstance(Node node) {
        this.toX3dModelInstance(node, null);
        return loadedX3dModelInstance;
    }

    /*
     * Unable to fully structure code
     */
    public X3DConcreteElement toX3dModelInstance(Node node, X3DConcreteElement parentElement) {
        indent = "  ";
        nodeChildFound = false;
        elementObject = null;
        if (node == null) {
            message = "*** Error invoking toX3dModelInstance(node=" + node + ", parentElement=" + parentElement + ")";
            System.out.println(message);
            throw new InvalidDocumentException(message);
        }
        switch (node.getNodeType()) {
            case 9: {
                childNodeList = node.getChildNodes();
                if (childNodeList == null) break;
                for (i = 0; i < childNodeList.getLength(); ++i) {
                    this.toX3dModelInstance(childNodeList.item(i), elementObject);
                }
                break;
            }
            case 10: {
                childNodeList = node.getChildNodes();
                if (childNodeList == null) break;
                for (i = 0; i < childNodeList.getLength(); ++i) {
                    this.toX3dModelInstance(childNodeList.item(i), elementObject);
                }
                break;
            }
            case 1: {
                nodeName = node.getNodeName();
                elementName = node.getNodeName();
                packageName = X3DConcreteNode.getPackageName(elementName);
                try {
                    elementClass = Class.forName(packageName);
                    elementObject = (X3DConcreteElement)elementClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (elementObject instanceof X3D || X3DLoaderDOM.loadedX3dModelInstance == null && elementObject instanceof X3DConcreteNode) {
                        X3DLoaderDOM.loadedX3dModelInstance = (X3D)elementObject;
                        this.protoNameToNodeTypesHashMap.clear();
                        this.protoDEFtoNodeTypesHashMap.clear();
                        this.protoContainerFieldHashMap.clear();
                    } else if (elementObject instanceof ProtoDeclare) {
                        this.currentProtoDeclareNameValue = node.getAttributes().getNamedItem("name").getNodeValue();
                        this.currentProtoNodeTypeFound = false;
                    } else if (elementObject instanceof ExternProtoDeclare) {
                        this.currentExternProtoDeclareNameValue = node.getAttributes().getNamedItem("name").getNodeValue();
                        this.currentProtoNodeTypeFound = false;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    errorNotice = "*** [X3DLoaderDOM error] Fully qualified object packageName=" + packageName + " not found,\n   " + cnfe + " " + cnfe.getMessage();
                    if (cnfe.getCause() != null && !cnfe.getCause().getMessage().isEmpty()) {
                        errorNotice = errorNotice + "\n   " + cnfe.getCause();
                    }
                    this.validationResult.append(errorNotice).append("\n");
                    System.out.println(errorNotice);
                    cnfe.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException iae) {
                    errorNotice = "*** [X3DLoaderDOM error] Visibility of no-parameter constructor inaccessible for packageName=" + packageName + ",\n   " + iae + " " + iae.getMessage();
                    if (iae.getCause() != null && !iae.getCause().getMessage().isEmpty()) {
                        errorNotice = errorNotice + "\n   " + iae.getCause();
                    }
                    this.validationResult.append(errorNotice).append("\n");
                    System.out.println(errorNotice);
                    iae.printStackTrace();
                    return null;
                }
                catch (InstantiationException ie) {
                    errorNotice = "*** [X3DLoaderDOM error] Failure occurred inside constructor for packageName=" + packageName + ",\n   " + ie + " " + ie.getMessage();
                    if (ie.getCause() != null && !ie.getCause().getMessage().isEmpty()) {
                        errorNotice = errorNotice + "\n   " + ie.getCause();
                    }
                    this.validationResult.append(errorNotice).append("\n");
                    System.out.println(errorNotice);
                    ie.printStackTrace();
                    return null;
                }
                catch (Exception e) {
                    errorNotice = "*** [X3DLoaderDOM error] Exception occurred inside constructor for packageName=" + packageName + ",\n   " + e + " " + e.getMessage();
                    if (e.getCause() != null && !e.getCause().getMessage().isEmpty()) {
                        errorNotice = errorNotice + "\n   " + e.getCause();
                    }
                    this.validationResult.append(errorNotice).append("\n");
                    System.out.println(errorNotice);
                    e.printStackTrace();
                    return null;
                }
                children = node.getChildNodes();
                for (i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() == 3) continue;
                    nodeChildFound = true;
                    break;
                }
                if (!nodeChildFound) ** GOTO lbl1090
                for (i = 0; i < children.getLength(); ++i) {
                    if (children.item(i) == null || elementObject == null || children.item(i).getNodeType() == 3 || (childX3dElement = this.toX3dModelInstance(children.item(i), elementObject)) == null || childX3dElement.getElementName() == null) continue;
                    childElementName = childX3dElement.getElementName();
                    childProtoInstanceName = new String();
                    childProtoInstanceUSE = new String();
                    containerField = new String();
                    if (children.item(i).getAttributes().getNamedItem("containerField") != null) {
                        containerField = children.item(i).getAttributes().getNamedItem("containerField").getNodeValue();
                        if (childX3dElement instanceof X3DConcreteNode && containerField != null && !containerField.isEmpty()) {
                            ((X3DConcreteNode)childX3dElement).setContainerFieldOverride(containerField);
                        }
                    }
                    protoInstanceNodeType = new String();
                    DEF = new String();
                    try {
                        if (!nodeName.equals("ProtoBody")) ** GOTO lbl110
                        if (this.currentProtoNodeTypeFound) ** GOTO lbl161
                        this.currentProtoNodeTypeFound = true;
                        this.protoNameToNodeTypesHashMap.put(this.currentProtoDeclareNameValue, childElementName);
                        if (!ConfigurationProperties.isDebugModeActive()) ** GOTO lbl161
                        System.out.println("[X3DLoaderDOM] ProtoBody/ProtoDeclare name='" + this.currentProtoDeclareNameValue + "' childElementName='" + childElementName + "' protoNameToNodeTypesHashMap.keySet()=" + this.protoNameToNodeTypesHashMap.keySet() + "' protoNameToNodeTypesHashMap.values()=" + this.protoNameToNodeTypesHashMap.values());
                        ** GOTO lbl161
lbl110:
                        // 1 sources

                        if (!nodeName.equals("ExternProtoDeclare")) ** GOTO lbl118
                        if (this.currentProtoNodeTypeFound) ** GOTO lbl161
                        this.currentProtoNodeTypeFound = true;
                        this.protoNameToNodeTypesHashMap.put(this.currentExternProtoDeclareNameValue, "ExternProtoDeclare");
                        if (!ConfigurationProperties.isDebugModeActive()) ** GOTO lbl161
                        System.out.println("[X3DLoaderDOM] ExternProtoDeclare name='" + this.currentExternProtoDeclareNameValue + "' protoNameToNodeTypesHashMap.keySet()=" + this.protoNameToNodeTypesHashMap.keySet() + "' protoNameToNodeTypesHashMap.values()=" + this.protoNameToNodeTypesHashMap.values());
                        ** GOTO lbl161
lbl118:
                        // 1 sources

                        if (childElementName.equals("ProtoInstance")) {
                            if (children.item(i).getAttributes().getNamedItem("name") != null) {
                                childProtoInstanceName = children.item(i).getAttributes().getNamedItem("name").getNodeValue();
                            }
                            protoInstanceNodeType = this.protoNameToNodeTypesHashMap.get(childProtoInstanceName);
                            if (ConfigurationProperties.isDebugModeActive()) {
                                System.out.println("[X3DLoaderDOM] ProtoInstance name='" + childProtoInstanceName + "' protoInstanceNodeType='" + protoInstanceNodeType + "' protoNameToNodeTypesHashMap.keySet()=" + this.protoNameToNodeTypesHashMap.keySet() + "' protoNameToNodeTypesHashMap.values()=" + this.protoNameToNodeTypesHashMap.values());
                            }
                            if (children.item(i).getAttributes().getNamedItem("DEF") != null) {
                                childProtoInstanceDEF = children.item(i).getAttributes().getNamedItem("DEF").getNodeValue();
                                this.protoDEFtoNodeTypesHashMap.put(childProtoInstanceDEF, protoInstanceNodeType);
                                this.protoContainerFieldHashMap.put(childProtoInstanceDEF, containerField);
                            } else if (children.item(i).getAttributes().getNamedItem("USE") != null) {
                                childProtoInstanceUSE = children.item(i).getAttributes().getNamedItem("USE").getNodeValue();
                                protoInstanceNodeType = this.protoDEFtoNodeTypesHashMap.get(childProtoInstanceUSE);
                                containerField = this.protoContainerFieldHashMap.get(childProtoInstanceUSE);
                            }
                            if (!containerField.equals("children")) {
                                ((ProtoInstance)childX3dElement).setContainerField(containerField);
                            }
                            if (childProtoInstanceUSE != null && !childProtoInstanceUSE.isEmpty() && (protoInstanceNodeType == null || protoInstanceNodeType.isEmpty())) {
                                errorNotice = "*** [X3DLoaderDOM error] ProtoInstance " + childProtoInstanceName + " found with USE " + childProtoInstanceUSE + " but unable to find original ProtoInstance DEF node type, thus unable to add to scene graph";
                                this.validationResult.append(errorNotice).append("\n");
                                System.out.println(errorNotice);
                                continue;
                            }
                            if ((protoInstanceNodeType == null || protoInstanceNodeType.isEmpty()) && (containerField == null || containerField.isEmpty())) {
                                errorNotice = "***[X3DLoaderDOM warning] ProtoInstance " + childProtoInstanceName + " found but node type is unknown and containerField is missing, assuming default value 'children'";
                                containerField = "children";
                            } else {
                                if (protoInstanceNodeType == null || protoInstanceNodeType.isEmpty()) {
                                    errorNotice = "*** [X3DLoaderDOM error] ProtoInstance " + childProtoInstanceName + " found but node type is unknown and containerField is " + containerField + ", unable to add to scene graph";
                                    this.validationResult.append(errorNotice).append("\n");
                                    System.out.println(errorNotice);
                                    continue;
                                }
                                if (containerField == null || containerField.isEmpty()) {
                                    errorNotice = "***[X3DLoaderDOM warning] ProtoInstance " + childProtoInstanceName + " found and node type is " + protoInstanceNodeType + " but containerField is missing, assuming default value 'children'";
                                    containerField = "children";
                                    this.validationResult.append(errorNotice).append("\n");
                                    System.out.println(errorNotice);
                                    continue;
                                }
                            }
                        }
lbl161:
                        // 11 sources

                        if (childElementName.equals("head")) {
                            ((X3D)elementObject).setHead((head)childX3dElement);
                            continue;
                        }
                        if (childElementName.equals("component")) {
                            ((head)elementObject).addComponent((component)childX3dElement);
                            continue;
                        }
                        if (childElementName.equals("meta")) {
                            ((head)elementObject).addMeta((meta)childX3dElement);
                            metaName = new String();
                            metaContent = new String();
                            if (children.item(i).getAttributes().getNamedItem("name") != null) {
                                metaName = children.item(i).getAttributes().getNamedItem("name").getNodeValue();
                            }
                            if (children.item(i).getAttributes().getNamedItem("content") != null) {
                                metaContent = children.item(i).getAttributes().getNamedItem("content").getNodeValue();
                            }
                            if (!metaName.equalsIgnoreCase("error") && !metaName.equalsIgnoreCase("warning") && !metaName.equalsIgnoreCase("hint") && !metaName.equalsIgnoreCase("info")) continue;
                            System.out.println("[X3DLoaderDOM] <meta name='" + metaName + "' content='" + metaContent + "'/>");
                            continue;
                        }
                        if (childElementName.equals("unit")) {
                            ((head)elementObject).addUnit((unit)childX3dElement);
                            continue;
                        }
                        if (childElementName.equals("Scene")) {
                            ((X3D)elementObject).setScene((Scene)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Scene") && childElementName.startsWith("Metadata")) {
                            ((Scene)elementObject).addMetadata((X3DMetadataObject)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Scene") && childElementName.equals("LayerSet")) {
                            ((Scene)elementObject).addLayerSet((LayerSet)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Scene")) {
                            ((Scene)elementObject).addChild((X3DChildNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ProtoDeclare") && childElementName.equals("ProtoInterface")) {
                            ((ProtoDeclare)elementObject).setProtoInterface((ProtoInterface)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Script") && childElementName.equals("field")) {
                            ((Script)elementObject).addField((field)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ProtoInterface") && childElementName.equals("field")) {
                            ((ProtoInterface)elementObject).addField((field)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ExternProtoDeclare") && childElementName.equals("field")) {
                            ((ExternProtoDeclare)elementObject).addField((field)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedShader") && childElementName.equals("field")) {
                            ((ComposedShader)elementObject).addField((field)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ProtoBody")) {
                            ((ProtoBody)elementObject).addChild((X3DNode)childX3dElement);
                            continue;
                        }
                        if (childElementName.equals("ProtoBody")) {
                            ((ProtoDeclare)elementObject).setProtoBody((ProtoBody)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("field")) {
                            ((field)elementObject).addChild((X3DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("fieldValue")) {
                            ((fieldValue)elementObject).addChild((X3DNode)childX3dElement);
                            continue;
                        }
                        if (childElementName.equals("fieldValue")) {
                            ((ProtoInstance)elementObject).setFieldValue((fieldValue)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ShaderProgram") && childElementName.equals("field")) {
                            ((ShaderProgram)elementObject).addField((field)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedShader") && childElementName.equals("field")) {
                            ((ComposedShader)elementObject).addField((field)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("PackagedShader") && childElementName.equals("field")) {
                            ((PackagedShader)elementObject).addField((field)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Collision") && containerField.equals("proxy")) {
                            ((Collision)elementObject).setProxy((X3DChildNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Collision") && childElementName.equals("ProtoInstance") && containerField.equals("proxy")) {
                            ((Collision)elementObject).setProxy((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("MetadataSet") && childElementName.startsWith("Metadata") && !containerField.equals("metadata")) {
                            ((MetadataSet)elementObject).addValue((X3DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("MetadataSet") && childElementName.equals("ProtoInstance") && !containerField.equals("metadata")) {
                            ((MetadataSet)elementObject).addValue((X3DNode)childX3dElement);
                            continue;
                        }
                        if (childElementName.startsWith("Metadata")) {
                            ((X3DConcreteNode)elementObject).setMetadata((X3DMetadataObject)childX3dElement);
                            continue;
                        }
                        if ((protoInstanceNodeType.equals("Metadata") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("metadata") || containerField.isEmpty())) {
                            ((X3DConcreteNode)elementObject).setMetadata((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (childElementName.equals("Appearance")) {
                            ((Shape)elementObject).setAppearance((X3DAppearanceNode)childX3dElement);
                            continue;
                        }
                        if ((protoInstanceNodeType.equals("Appearance") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("appearance") || containerField.isEmpty())) {
                            ((Shape)elementObject).setAppearance((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (childElementName.equals("Material")) {
                            ((Appearance)elementObject).setMaterial((Material)childX3dElement);
                            continue;
                        }
                        if ((protoInstanceNodeType.equals("Material") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("material")) {
                            ((Appearance)elementObject).setMaterial((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (childElementName.equals("TwoSidedMaterial")) {
                            ((Appearance)elementObject).setMaterial((TwoSidedMaterial)childX3dElement);
                            continue;
                        }
                        if ((protoInstanceNodeType.equals("TwoSidedMaterial") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("material")) {
                            ((Appearance)elementObject).setMaterial((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Appearance") && childElementName.equals("LineProperties") && (containerField.equals("lineProperties") || containerField.isEmpty())) {
                            ((Appearance)elementObject).setLineProperties((LineProperties)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Appearance") && (protoInstanceNodeType.equals("LineProperties") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("lineProperties") || containerField.isEmpty())) {
                            ((Appearance)elementObject).setLineProperties((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Appearance") && childElementName.equals("FillProperties")) {
                            ((Appearance)elementObject).setFillProperties((FillProperties)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Appearance") && (protoInstanceNodeType.equals("FillProperties") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("fillProperties") || containerField.isEmpty())) {
                            ((Appearance)elementObject).setFillProperties((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TextureBackground") && childElementName.endsWith("Texture") && containerField.equals("backTexture")) {
                            ((TextureBackground)elementObject).setBackTexture((X3DTexture2DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TextureBackground") && (protoInstanceNodeType.endsWith("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("backTexture") || containerField.isEmpty())) {
                            ((TextureBackground)elementObject).setBackTexture((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TextureBackground") && childElementName.endsWith("Texture") && containerField.equals("bottomTexture")) {
                            ((TextureBackground)elementObject).setBottomTexture((X3DTexture2DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TextureBackground") && (protoInstanceNodeType.endsWith("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("bottomTexture") || containerField.isEmpty())) {
                            ((TextureBackground)elementObject).setBottomTexture((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TextureBackground") && childElementName.endsWith("Texture") && containerField.equals("frontTexture")) {
                            ((TextureBackground)elementObject).setFrontTexture((X3DTexture2DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TextureBackground") && (protoInstanceNodeType.endsWith("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("frontTexture") || containerField.isEmpty())) {
                            ((TextureBackground)elementObject).setFrontTexture((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TextureBackground") && childElementName.endsWith("Texture") && containerField.equals("leftTexture")) {
                            ((TextureBackground)elementObject).setLeftTexture((X3DTexture2DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TextureBackground") && (protoInstanceNodeType.endsWith("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("leftTexture") || containerField.isEmpty())) {
                            ((TextureBackground)elementObject).setLeftTexture((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TextureBackground") && childElementName.endsWith("Texture") && containerField.equals("rightTexture")) {
                            ((TextureBackground)elementObject).setRightTexture((X3DTexture2DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TextureBackground") && (protoInstanceNodeType.endsWith("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("rightTexture") || containerField.isEmpty())) {
                            ((TextureBackground)elementObject).setRightTexture((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TextureBackground") && childElementName.endsWith("Texture") && containerField.equals("topTexture")) {
                            ((TextureBackground)elementObject).setTopTexture((X3DTexture2DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TextureBackground") && (protoInstanceNodeType.endsWith("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("topTexture") || containerField.isEmpty())) {
                            ((TextureBackground)elementObject).setTopTexture((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Sound") && (childElementName.equals("AudioClip") || childElementName.equals("MovieTexture"))) {
                            ((Sound)elementObject).setSource((X3DSoundSourceNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Sound") && (protoInstanceNodeType.equals("AudioClip") || protoInstanceNodeType.equals("MovieTexture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("source") || containerField.isEmpty())) {
                            ((Sound)elementObject).setSource((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && childElementName.endsWith("Texture") && (containerField.equals("front") || containerField.isEmpty())) {
                            ((ComposedCubeMapTexture)elementObject).setFront((X3DTexture2DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && (protoInstanceNodeType.equals("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("front") || containerField.isEmpty())) {
                            ((ComposedCubeMapTexture)elementObject).setFront((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && childElementName.endsWith("Texture") && (containerField.equals("back") || containerField.isEmpty())) {
                            ((ComposedCubeMapTexture)elementObject).setBack((X3DTexture2DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && (protoInstanceNodeType.equals("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("back") || containerField.isEmpty())) {
                            ((ComposedCubeMapTexture)elementObject).setBack((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && childElementName.endsWith("Texture") && (containerField.equals("left") || containerField.isEmpty() || containerField.isEmpty())) {
                            ((ComposedCubeMapTexture)elementObject).setLeft((X3DTexture2DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && (protoInstanceNodeType.equals("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("left") || containerField.isEmpty())) {
                            ((ComposedCubeMapTexture)elementObject).setLeft((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && childElementName.endsWith("Texture") && (containerField.equals("right") || containerField.isEmpty() || containerField.isEmpty())) {
                            ((ComposedCubeMapTexture)elementObject).setRight((X3DTexture2DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && (protoInstanceNodeType.equals("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("right") || containerField.isEmpty())) {
                            ((ComposedCubeMapTexture)elementObject).setRight((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && childElementName.endsWith("Texture") && (containerField.equals("top") || containerField.isEmpty())) {
                            ((ComposedCubeMapTexture)elementObject).setTop((X3DTexture2DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && (protoInstanceNodeType.equals("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("top") || containerField.isEmpty())) {
                            ((ComposedCubeMapTexture)elementObject).setTop((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && childElementName.endsWith("Texture") && (containerField.equals("bottom") || containerField.isEmpty())) {
                            ((ComposedCubeMapTexture)elementObject).setBottom((X3DTexture2DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && (protoInstanceNodeType.equals("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("bottom") || containerField.isEmpty())) {
                            ((ComposedCubeMapTexture)elementObject).setBottom((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && childElementName.endsWith("Texture")) {
                            errorNotice = "*** [X3DLoaderDOM error] parent " + nodeName + " has child " + childElementName + " with invalid containerField='" + containerField + "' (must have value of front, back, left, right, top or bottom)";
                            this.validationResult.append(errorNotice).append("\n");
                            continue;
                        }
                        if (nodeName.equals("ComposedCubeMapTexture") && protoInstanceNodeType.equals("Texture")) {
                            errorNotice = "*** [X3DLoaderDOM error] parent " + nodeName + " has child ProtoInstance with invalid containerField='" + containerField + "' (must have value of front, back, left, right, top or bottom)";
                            this.validationResult.append(errorNotice).append("\n");
                            continue;
                        }
                        if (nodeName.equals("Appearance") && childElementName.endsWith("Texture") && (containerField.equals("texture") || containerField.isEmpty())) {
                            ((Appearance)elementObject).setTexture((X3DTextureNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Appearance") && (protoInstanceNodeType.endsWith("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("texture") || containerField.isEmpty())) {
                            ((Appearance)elementObject).setTexture((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Appearance") && childElementName.contains("TextureTransform") && (containerField.equals("textureTransform") || containerField.isEmpty())) {
                            ((Appearance)elementObject).setTextureTransform((X3DTextureTransformNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Appearance") && (protoInstanceNodeType.contains("TextureTransform") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("textureTransform") || containerField.isEmpty())) {
                            ((Appearance)elementObject).setTextureTransform((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Appearance") && (childElementName.equals("ComposedShader") || childElementName.equals("PackagedShader") || childElementName.equals("ProgramShader")) && (containerField.equals("shaders") || containerField.isEmpty())) {
                            ((Appearance)elementObject).addShaders((X3DShaderNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Appearance") && (protoInstanceNodeType.contains("Shader") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("shaders") || containerField.isEmpty())) {
                            ((Appearance)elementObject).addShaders((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedShader") && childElementName.equals("ShaderPart") && (containerField.equals("parts") || containerField.isEmpty())) {
                            ((ComposedShader)elementObject).addParts((ShaderPart)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ComposedShader") && (protoInstanceNodeType.equals("ShaderPart") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("parts") || containerField.isEmpty())) {
                            ((ComposedShader)elementObject).addParts((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ProgramShader") && childElementName.equals("ShaderProgram") && (containerField.equals("programs") || containerField.isEmpty())) {
                            ((ProgramShader)elementObject).addPrograms((ShaderProgram)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ProgramShader") && (protoInstanceNodeType.equals("ShaderProgram") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("programs") || containerField.isEmpty())) {
                            ((ProgramShader)elementObject).addPrograms((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if ((childElementName.equals("Box") || childElementName.equals("Cone") || childElementName.equals("Cylinder") || childElementName.equals("Sphere") || childElementName.equals("Text") || childElementName.equals("IndexedFaceSet") || childElementName.equals("Arc2d") || childElementName.equals("ArcClose2d") || childElementName.equals("Circle2D") || childElementName.equals("Disk2D") || childElementName.equals("Polyline2D") || childElementName.equals("Polypoint2D") || childElementName.equals("Rectangle2D") || childElementName.equals("TriangleSet2D") || childElementName.equals("ElevationGrid") || childElementName.equals("Extrusion") || childElementName.equals("GeoElevationGrid") || childElementName.equals("IndexedLineSet") || childElementName.equals("IndexedPointSet") || childElementName.equals("IndexedQuadSet") || childElementName.equals("LineSet") || childElementName.equals("PointSet") || childElementName.equals("QuadSet") || childElementName.equals("IndexedTriangleFanSet") || childElementName.equals("IndexedTriangleSet") || childElementName.equals("IndexedTriangleStripSet") || childElementName.equals("TriangleFanSet") || childElementName.equals("TriangleSet") || childElementName.equals("TriangleStripSet") || childElementName.equals("NurbsCurve") || childElementName.equals("NurbsSweptSurface") || childElementName.equals("NurbsSwungSurface")) && containerField.equals("geometry")) {
                            ((Shape)elementObject).setGeometry((X3DGeometryNode)childX3dElement);
                            continue;
                        }
                        if ((protoInstanceNodeType.equals("Box") || protoInstanceNodeType.equals("Cone") || protoInstanceNodeType.equals("Cylinder") || protoInstanceNodeType.equals("Sphere") || protoInstanceNodeType.equals("Text") || protoInstanceNodeType.equals("IndexedFaceSet") || protoInstanceNodeType.equals("Arc2d") || protoInstanceNodeType.equals("ArcClose2d") || protoInstanceNodeType.equals("Circle2D") || protoInstanceNodeType.equals("Disk2D") || protoInstanceNodeType.equals("Polyline2D") || protoInstanceNodeType.equals("Polypoint2D") || protoInstanceNodeType.equals("Rectangle2D ") || protoInstanceNodeType.equals("TriangleSet2D") || protoInstanceNodeType.equals("ElevationGrid") || protoInstanceNodeType.equals("Extrusion") || protoInstanceNodeType.equals("GeoElevationGrid") || protoInstanceNodeType.equals("IndexedLineSet") || protoInstanceNodeType.equals("IndexedPointSet") || protoInstanceNodeType.equals("IndexedQuadSet") || protoInstanceNodeType.equals("LineSet") || protoInstanceNodeType.equals("PointSet") || protoInstanceNodeType.equals("QuadSet") || protoInstanceNodeType.equals("IndexedTriangleFanSet") || protoInstanceNodeType.equals("IndexedTriangleSet") || protoInstanceNodeType.equals("IndexedTriangleStripSet") || protoInstanceNodeType.equals("TriangleFanSet") || protoInstanceNodeType.equals("TriangleSet") || protoInstanceNodeType.equals("TriangleStripSet") || protoInstanceNodeType.equals("NurbsCurve") || protoInstanceNodeType.equals("NurbsSweptSurface") || protoInstanceNodeType.equals("NurbsSwungSurface") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("geometry")) {
                            ((Shape)elementObject).setGeometry((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ElevationGrid") && (childElementName.equals("Color") || childElementName.equals("ColorRGBA")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((ElevationGrid)elementObject).setColor((X3DColorNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ElevationGrid") && (protoInstanceNodeType.equals("Color") || protoInstanceNodeType.equals("ColorRGBA") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("color")) {
                            ((ElevationGrid)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoElevationGrid") && (childElementName.equals("Color") || childElementName.equals("ColorRGBA")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((GeoElevationGrid)elementObject).setColor((X3DColorNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoElevationGrid") && (protoInstanceNodeType.equals("Color") || protoInstanceNodeType.equals("ColorRGBA") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("color")) {
                            ((GeoElevationGrid)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ElevationGrid") && childElementName.equals("Normal") && (containerField.equals("normal") || containerField.isEmpty())) {
                            ((ElevationGrid)elementObject).setNormal((Normal)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ElevationGrid") && (protoInstanceNodeType.equals("Normal") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("normal")) {
                            ((ElevationGrid)elementObject).setNormal((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoElevationGrid") && childElementName.equals("Normal") && (containerField.equals("normal") || containerField.isEmpty())) {
                            ((GeoElevationGrid)elementObject).setNormal((Normal)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoElevationGrid") && (protoInstanceNodeType.equals("Normal") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("normal")) {
                            ((GeoElevationGrid)elementObject).setNormal((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ElevationGrid") && childElementName.contains("TextureCoordinate") && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((ElevationGrid)elementObject).setTexCoord((X3DTextureCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ElevationGrid") && (protoInstanceNodeType.contains("TextureCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("texcoord")) {
                            ((ElevationGrid)elementObject).setTexCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoElevationGrid") && childElementName.contains("TextureCoordinate") && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((GeoElevationGrid)elementObject).setTexCoord((X3DTextureCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoElevationGrid") && (protoInstanceNodeType.contains("TextureCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("texcoord")) {
                            ((GeoElevationGrid)elementObject).setTexCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("LoadSensor") && (childElementName.equals("Anchor") || childElementName.equals("AudioClip") || childElementName.equals("DISEntityTypeMapping") || childElementName.equals("GeoMetadata") || childElementName.equals("ImageCubeMapTexture") || childElementName.equals("ImageTexture3D") || childElementName.equals("ImageTexture") || childElementName.equals("Inline") || childElementName.equals("MovieTexture") || childElementName.equals("PackagedShader") || childElementName.equals("Script") || childElementName.equals("ShaderPart") || childElementName.equals("ShaderProgramObject")) && (containerField.equals("watchList") || containerField.equals("texture") || containerField.equals("programs") || containerField.equals("parts") || containerField.equals("children"))) {
                            ((LoadSensor)elementObject).addWatchList((X3DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("LoadSensor") && (protoInstanceNodeType.equals("Anchor") || protoInstanceNodeType.equals("AudioClip") || protoInstanceNodeType.equals("DISEntityTypeMapping") || protoInstanceNodeType.equals("GeoMetadata") || protoInstanceNodeType.equals("ImageCubeMapTexture") || protoInstanceNodeType.equals("ImageTexture3D") || protoInstanceNodeType.equals("ImageTexture") || protoInstanceNodeType.equals("Inline") || protoInstanceNodeType.equals("MovieTexture") || protoInstanceNodeType.equals("PackagedShader") || protoInstanceNodeType.equals("Script") || protoInstanceNodeType.equals("ShaderPart") || protoInstanceNodeType.equals("ShaderProgramObject")) && (containerField.equals("watchList") || containerField.equals("texture") || containerField.equals("programs") || containerField.equals("parts") || containerField.equals("children"))) {
                            ((CADFace)elementObject).setShape((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("CADFace") && (childElementName.equals("Shape") || childElementName.equals("LOD") || childElementName.equals("Transform")) && containerField.equals("shape")) {
                            ((CADFace)elementObject).setShape((X3DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("CADFace") && (protoInstanceNodeType.equals("Shape") || protoInstanceNodeType.equals("LOD") || protoInstanceNodeType.equals("Transform") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("shape")) {
                            ((CADFace)elementObject).setShape((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Scene") && (childElementName.equals("EspduTransform") || childElementName.equals("ReceiverPdu") || childElementName.equals("SignalPdu") || childElementName.equals("TransmitterPdu") || childElementName.equals("DISEntityManager")) && containerField.equals("children")) {
                            ((Scene)elementObject).addChild((EspduTransform)childX3dElement);
                            continue;
                        }
                        if (childElementName.equals("EspduTransform") && containerField.equals("children")) {
                            ((X3DGroupingNode)elementObject).addChildren(new X3DNode[]{(X3DNode)childX3dElement});
                            continue;
                        }
                        if (nodeName.equals("DISEntityManager") && childElementName.equals("DISEntityTypeMapping") && containerField.equals("mapping")) {
                            ((DISEntityManager)elementObject).addMapping((DISEntityTypeMapping)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("DISEntityManager") && protoInstanceNodeType.equals("DISEntityTypeMapping")) {
                            ((DISEntityManager)elementObject).addMapping((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoCoordinate") && childElementName.equals("GeoOrigin")) {
                            ((GeoCoordinate)elementObject).setGeoOrigin((GeoOrigin)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoElevationGrid") && childElementName.equals("GeoOrigin")) {
                            ((GeoElevationGrid)elementObject).setGeoOrigin((GeoOrigin)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoLocation") && childElementName.equals("GeoOrigin")) {
                            ((GeoLocation)elementObject).setGeoOrigin((GeoOrigin)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoLOD") && childElementName.equals("GeoOrigin")) {
                            ((GeoLOD)elementObject).setGeoOrigin((GeoOrigin)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoPositionInterpolator") && childElementName.equals("GeoOrigin")) {
                            ((GeoPositionInterpolator)elementObject).setGeoOrigin((GeoOrigin)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoProximitySensor") && childElementName.equals("GeoOrigin")) {
                            ((GeoProximitySensor)elementObject).setGeoOrigin((GeoOrigin)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoTouchSensor") && childElementName.equals("GeoOrigin")) {
                            ((GeoTouchSensor)elementObject).setGeoOrigin((GeoOrigin)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoTransform") && childElementName.equals("GeoOrigin")) {
                            ((GeoTransform)elementObject).setGeoOrigin((GeoOrigin)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoViewpoint") && childElementName.equals("GeoOrigin")) {
                            ((GeoViewpoint)elementObject).setGeoOrigin((GeoOrigin)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoCoordinate") && protoInstanceNodeType.equals("GeoOrigin")) {
                            ((GeoCoordinate)elementObject).setGeoOrigin((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoElevationGrid") && protoInstanceNodeType.equals("GeoOrigin")) {
                            ((GeoElevationGrid)elementObject).setGeoOrigin((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoLocation") && protoInstanceNodeType.equals("GeoOrigin")) {
                            ((GeoLocation)elementObject).setGeoOrigin((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoLOD") && protoInstanceNodeType.equals("GeoOrigin")) {
                            ((GeoLOD)elementObject).setGeoOrigin((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoPositionInterpolator") && protoInstanceNodeType.equals("GeoOrigin")) {
                            ((GeoPositionInterpolator)elementObject).setGeoOrigin((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoProximitySensor") && protoInstanceNodeType.equals("GeoOrigin")) {
                            ((GeoProximitySensor)elementObject).setGeoOrigin((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoTouchSensor") && protoInstanceNodeType.equals("GeoOrigin")) {
                            ((GeoTouchSensor)elementObject).setGeoOrigin((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoTransform") && protoInstanceNodeType.equals("GeoOrigin")) {
                            ((GeoTransform)elementObject).setGeoOrigin((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoViewpoint") && protoInstanceNodeType.equals("GeoOrigin")) {
                            ((GeoViewpoint)elementObject).setGeoOrigin((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoLOD") && !protoInstanceNodeType.isEmpty()) {
                            ((GeoLOD)elementObject).addRootNode((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("GeoLOD")) {
                            ((GeoLOD)elementObject).addRootNode((X3DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Scene") && childElementName.equals("HAnimHumanoid") && containerField.equals("children")) {
                            ((Scene)elementObject).addChild((HAnimHumanoid)childX3dElement);
                            continue;
                        }
                        if (childElementName.equals("HAnimHumanoid") && containerField.equals("children")) {
                            ((X3DGroupingNode)elementObject).addChildren(new X3DNode[]{(X3DNode)childX3dElement});
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && (childElementName.equals("HAnimJoint") || childElementName.equals("HAnimSite")) && containerField.equals("skeleton")) {
                            ((HAnimHumanoid)elementObject).addSkeleton((X3DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && (protoInstanceNodeType.equals("HAnimJoint") || protoInstanceNodeType.equals("HAnimSite") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("skeleton")) {
                            ((HAnimHumanoid)elementObject).addSkeleton((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && containerField.equals("skin")) {
                            ((HAnimHumanoid)elementObject).addSkin((X3DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && childElementName.equals("HAnimJoint") && containerField.equals("joints")) {
                            ((HAnimHumanoid)elementObject).addJoints((HAnimJoint)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && (protoInstanceNodeType.equals("HAnimJoint") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("joints")) {
                            ((HAnimHumanoid)elementObject).addJoints((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && childElementName.equals("HAnimSegment") && containerField.equals("segments")) {
                            ((HAnimHumanoid)elementObject).addSegments((HAnimSegment)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && (protoInstanceNodeType.equals("HAnimSegment") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("segments")) {
                            ((HAnimHumanoid)elementObject).addSegments((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && childElementName.equals("HAnimSite") && containerField.equals("sites")) {
                            ((HAnimHumanoid)elementObject).addSites((HAnimSite)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && (protoInstanceNodeType.equals("HAnimSite") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("sites")) {
                            ((HAnimHumanoid)elementObject).addSites((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && childElementName.equals("HAnimSite") && containerField.equals("viewpoints")) {
                            ((HAnimHumanoid)elementObject).addViewpoints((HAnimSite)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && (protoInstanceNodeType.equals("HAnimSite") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("viewpoints")) {
                            ((HAnimHumanoid)elementObject).addViewpoints((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && (childElementName.equals("Coordinate") || childElementName.equals("CoordinateDouble")) && containerField.equals("skinCoord")) {
                            ((HAnimHumanoid)elementObject).setSkinCoord((X3DCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("skinCoord")) {
                            ((HAnimHumanoid)elementObject).setSkinCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && childElementName.equals("Normal") && containerField.equals("skinNormal")) {
                            ((HAnimHumanoid)elementObject).setSkinNormal((X3DNormalNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimHumanoid") && (protoInstanceNodeType.equals("Normal") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("skinNormal")) {
                            ((HAnimHumanoid)elementObject).setSkinNormal((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimJoint") && (childElementName.equals("HAnimJoint") || childElementName.equals("HAnimSegment") || childElementName.equals("HAnimSite")) && containerField.equals("children")) {
                            ((HAnimJoint)elementObject).addChild((X3DChildNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimJoint") && (protoInstanceNodeType.equals("HAnimDisplacer") || protoInstanceNodeType.equals("HAnimSegment") || protoInstanceNodeType.equals("HAnimSite") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("children")) {
                            ((HAnimJoint)elementObject).addChild((X3DChildNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimJoint") && childElementName.equals("HAnimDisplacer") && (containerField.equals("displacers") || containerField.isEmpty())) {
                            ((HAnimJoint)elementObject).addDisplacers((HAnimDisplacer)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimJoint") && (protoInstanceNodeType.equals("HAnimDisplacer") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("displacers") || containerField.isEmpty())) {
                            ((HAnimJoint)elementObject).addDisplacers((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimSegment") && childElementName.equals("HAnimDisplacer") && (containerField.equals("displacers") || containerField.isEmpty())) {
                            ((HAnimSegment)elementObject).addDisplacers((HAnimDisplacer)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimSegment") && (protoInstanceNodeType.equals("HAnimDisplacer") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("displacers") || containerField.isEmpty())) {
                            ((HAnimSegment)elementObject).addDisplacers((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimSegment") && (childElementName.equals("Coordinate") || childElementName.equals("CoordinateDouble")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((HAnimSegment)elementObject).setCoord((X3DCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("HAnimSegment") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((HAnimSegment)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedLineSet") && (childElementName.equals("Coordinate") || childElementName.equals("CoordinateDouble") || childElementName.equals("GeoCoordinate")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((IndexedLineSet)elementObject).setCoord((X3DCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedLineSet") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("GeoCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((IndexedLineSet)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("LineSet") && (childElementName.equals("Coordinate") || childElementName.equals("CoordinateDouble") || childElementName.equals("GeoCoordinate")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((LineSet)elementObject).setCoord((X3DCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("LineSet") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("GeoCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((LineSet)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("PointSet") && (childElementName.equals("Coordinate") || childElementName.equals("CoordinateDouble") || childElementName.equals("GeoCoordinate")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((PointSet)elementObject).setCoord((X3DCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("PointSet") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("GeoCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((PointSet)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("NurbsPositionInterpolator") && (childElementName.equals("Coordinate") || childElementName.equals("CoordinateDouble")) && containerField.equals("controlPoint")) {
                            ((NurbsPositionInterpolator)elementObject).setControlPoint((X3DCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("NurbsPositionInterpolator") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("controlPoint")) {
                            ((NurbsPositionInterpolator)elementObject).setControlPoint((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("NurbsOrientationInterpolator") && (childElementName.equals("Coordinate") || childElementName.equals("CoordinateDouble")) && containerField.equals("controlPoint")) {
                            ((NurbsOrientationInterpolator)elementObject).setControlPoint((X3DCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("NurbsOrientationInterpolator") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("controlPoint")) {
                            ((NurbsOrientationInterpolator)elementObject).setControlPoint((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("NurbsSurfaceInterpolator") && (childElementName.equals("Coordinate") || childElementName.equals("CoordinateDouble")) && containerField.equals("controlPoint")) {
                            ((NurbsSurfaceInterpolator)elementObject).setControlPoint((X3DCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("NurbsSurfaceInterpolator") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("controlPoint")) {
                            ((NurbsSurfaceInterpolator)elementObject).setControlPoint((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("NurbsPatchSurface") && (childElementName.equals("Coordinate") || childElementName.equals("CoordinateDouble")) && containerField.equals("controlPoint")) {
                            ((NurbsPatchSurface)elementObject).setControlPoint((X3DCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("NurbsPatchSurface") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("controlPoint")) {
                            ((NurbsPatchSurface)elementObject).setControlPoint((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("NurbsTrimmedSurface") && (childElementName.equals("Coordinate") || childElementName.equals("CoordinateDouble")) && containerField.equals("controlPoint")) {
                            ((NurbsTrimmedSurface)elementObject).setControlPoint((X3DCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("NurbsTrimmedSurface") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("ExternProtoDeclare")) && containerField.equals("controlPoint")) {
                            ((NurbsTrimmedSurface)elementObject).setControlPoint((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedLineSet") && childElementName.startsWith("Color") && (containerField.equals("color") || containerField.isEmpty())) {
                            ((IndexedLineSet)elementObject).setColor((X3DColorNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedLineSet") && (protoInstanceNodeType.startsWith("Color") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((IndexedLineSet)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("LineSet") && childElementName.startsWith("Color") && (containerField.equals("color") || containerField.isEmpty())) {
                            ((LineSet)elementObject).setColor((X3DColorNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("LineSet") && (protoInstanceNodeType.startsWith("Color") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((LineSet)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("PointSet") && childElementName.startsWith("Color") && (containerField.equals("color") || containerField.isEmpty())) {
                            ((PointSet)elementObject).setColor((X3DColorNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("PointSet") && (protoInstanceNodeType.startsWith("Color") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((PointSet)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("MultiTextureCoordinate") && childElementName.contains("TextureCoordinate") && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((MultiTextureCoordinate)elementObject).addTexCoord((X3DTextureCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("MultiTextureCoordinate") && (protoInstanceNodeType.contains("TextureCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((MultiTextureCoordinate)elementObject).addTexCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.endsWith("Set") && childElementName.contains("FogCoordinate") && (containerField.equals("fogCoord") || containerField.isEmpty())) {
                            ((X3DComposedGeometryNode)elementObject).setFogCoord((FogCoordinate)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedFaceSet") && (protoInstanceNodeType.contains("FogCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("fogCoord") || containerField.isEmpty())) {
                            ((IndexedFaceSet)elementObject).setFogCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedQuadSet") && (protoInstanceNodeType.contains("FogCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("fogCoord") || containerField.isEmpty())) {
                            ((IndexedQuadSet)elementObject).setFogCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleSet") && (protoInstanceNodeType.contains("FogCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("fogCoord") || containerField.isEmpty())) {
                            ((IndexedTriangleSet)elementObject).setFogCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleFanSet") && (protoInstanceNodeType.contains("FogCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("fogCoord") || containerField.isEmpty())) {
                            ((IndexedTriangleFanSet)elementObject).setFogCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleStripSet") && (protoInstanceNodeType.contains("FogCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("fogCoord") || containerField.isEmpty())) {
                            ((IndexedTriangleStripSet)elementObject).setFogCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("QuadSet") && (protoInstanceNodeType.contains("FogCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("fogCoord") || containerField.isEmpty())) {
                            ((QuadSet)elementObject).setFogCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleSet") && (protoInstanceNodeType.contains("FogCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("fogCoord") || containerField.isEmpty())) {
                            ((TriangleSet)elementObject).setFogCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleFanSet") && (protoInstanceNodeType.contains("FogCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("fogCoord") || containerField.isEmpty())) {
                            ((TriangleFanSet)elementObject).setFogCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleStripSet") && (protoInstanceNodeType.contains("FogCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("fogCoord") || containerField.isEmpty())) {
                            ((TriangleStripSet)elementObject).setFogCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if ((nodeName.endsWith("Set") || nodeName.endsWith("Surface")) && childElementName.contains("TextureCoordinate") && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((X3DComposedGeometryNode)elementObject).setTexCoord((X3DTextureCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedFaceSet") && (protoInstanceNodeType.contains("TextureCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((IndexedFaceSet)elementObject).setTexCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedQuadSet") && (protoInstanceNodeType.contains("TextureCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((IndexedQuadSet)elementObject).setTexCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleSet") && (protoInstanceNodeType.contains("TextureCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((IndexedTriangleSet)elementObject).setTexCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleFanSet") && (protoInstanceNodeType.contains("TextureCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((IndexedTriangleFanSet)elementObject).setTexCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleStripSet") && (protoInstanceNodeType.contains("TextureCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((IndexedTriangleStripSet)elementObject).setTexCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("QuadSet") && (protoInstanceNodeType.contains("TextureCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((QuadSet)elementObject).setTexCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleSet") && (protoInstanceNodeType.contains("TextureCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((TriangleSet)elementObject).setTexCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleFanSet") && (protoInstanceNodeType.contains("TextureCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((TriangleFanSet)elementObject).setTexCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleStripSet") && (protoInstanceNodeType.contains("TextureCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("texCoord") || containerField.isEmpty())) {
                            ((TriangleStripSet)elementObject).setTexCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.endsWith("Set") && childElementName.startsWith("Color") && (containerField.equals("color") || containerField.isEmpty())) {
                            ((X3DComposedGeometryNode)elementObject).setColor((X3DColorNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedFaceSet") && (protoInstanceNodeType.startsWith("Color") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((IndexedFaceSet)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedQuadSet") && (protoInstanceNodeType.startsWith("Color") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((IndexedQuadSet)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleSet") && (protoInstanceNodeType.startsWith("Color") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((IndexedTriangleSet)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleFanSet") && (protoInstanceNodeType.startsWith("Color") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((IndexedTriangleFanSet)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleStripSet") && (protoInstanceNodeType.startsWith("Color") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((IndexedTriangleStripSet)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("QuadSet") && (protoInstanceNodeType.startsWith("Color") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((QuadSet)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleSet") && (protoInstanceNodeType.startsWith("Color") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((TriangleSet)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleFanSet") && (protoInstanceNodeType.startsWith("Color") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((TriangleFanSet)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleStripSet") && (protoInstanceNodeType.startsWith("Color") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("color") || containerField.isEmpty())) {
                            ((TriangleStripSet)elementObject).setColor((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.endsWith("Set") && (childElementName.equals("Coordinate") || childElementName.equals("CoordinateDouble") || childElementName.equals("GeoCoordinate")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((X3DComposedGeometryNode)elementObject).setCoord((X3DCoordinateNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedFaceSet") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("GeoCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((IndexedFaceSet)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedQuadSet") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("GeoCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((IndexedQuadSet)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleSet") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("GeoCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((IndexedTriangleSet)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleFanSet") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("GeoCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((IndexedTriangleFanSet)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleStripSet") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("GeoCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((IndexedTriangleStripSet)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("QuadSet") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("GeoCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((QuadSet)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleSet") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("GeoCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((TriangleSet)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleFanSet") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("GeoCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((TriangleFanSet)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleStripSet") && (protoInstanceNodeType.equals("Coordinate") || protoInstanceNodeType.equals("CoordinateDouble") || protoInstanceNodeType.equals("GeoCoordinate") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("coord") || containerField.isEmpty())) {
                            ((TriangleStripSet)elementObject).setCoord((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.endsWith("Set") && childElementName.equals("Normal") && containerField.equals("normal")) {
                            ((X3DComposedGeometryNode)elementObject).setNormal((Normal)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedFaceSet") && (protoInstanceNodeType.contains("Normal") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("normal") || containerField.isEmpty())) {
                            ((IndexedFaceSet)elementObject).setNormal((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedQuadSet") && (protoInstanceNodeType.contains("Normal") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("normal") || containerField.isEmpty())) {
                            ((IndexedQuadSet)elementObject).setNormal((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleSet") && (protoInstanceNodeType.contains("Normal") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("normal") || containerField.isEmpty())) {
                            ((IndexedTriangleSet)elementObject).setNormal((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleFanSet") && (protoInstanceNodeType.contains("Normal") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("normal") || containerField.isEmpty())) {
                            ((IndexedTriangleFanSet)elementObject).setNormal((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IndexedTriangleStripSet") && (protoInstanceNodeType.contains("Normal") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("normal") || containerField.isEmpty())) {
                            ((IndexedTriangleStripSet)elementObject).setNormal((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("QuadSet") && (protoInstanceNodeType.contains("Normal") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("normal") || containerField.isEmpty())) {
                            ((QuadSet)elementObject).setNormal((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleSet") && (protoInstanceNodeType.contains("Normal") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("normal") || containerField.isEmpty())) {
                            ((TriangleSet)elementObject).setNormal((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleFanSet") && (protoInstanceNodeType.contains("Normal") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("normal") || containerField.isEmpty())) {
                            ((TriangleFanSet)elementObject).setNormal((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("TriangleStripSet") && (protoInstanceNodeType.contains("Normal") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("normal") || containerField.isEmpty() || containerField.isEmpty())) {
                            ((TriangleStripSet)elementObject).setNormal((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("StaticGroup") && (containerField.equals("children") || containerField.isEmpty())) {
                            ((StaticGroup)elementObject).addChild((X3DChildNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("StaticGroup") && (containerField.equals("children") || containerField.isEmpty())) {
                            ((StaticGroup)elementObject).addChild((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ViewpointGroup") && childElementName.contains("Viewpoint") && (containerField.equals("children") || containerField.isEmpty())) {
                            ((ViewpointGroup)elementObject).addChild((X3DNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("ViewpointGroup") && (protoInstanceNodeType.equals("Viewpoint") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("children") || containerField.isEmpty())) {
                            ((ViewpointGroup)elementObject).addChild((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Text") && childElementName.equals("FontStyle") && (containerField.equals("fontStyle") || containerField.isEmpty())) {
                            ((Text)elementObject).setFontStyle((X3DFontStyleNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("Text") && (protoInstanceNodeType.equals("FontStyle") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("fontStyle") || containerField.isEmpty())) {
                            ((Text)elementObject).setFontStyle((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("MultiTexture") && childElementName.contains("Texture") && (containerField.equals("texture") || containerField.isEmpty())) {
                            ((MultiTexture)elementObject).addTexture((X3DTextureNode)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("MultiTexture") && (protoInstanceNodeType.contains("Texture") || protoInstanceNodeType.equals("ExternProtoDeclare")) && (containerField.equals("texture") || containerField.isEmpty())) {
                            ((MultiTexture)elementObject).addTexture((ProtoInstance)childX3dElement);
                            continue;
                        }
                        if (childElementName.equals("IS")) {
                            ((X3DConcreteNode)elementObject).setIS((IS)childX3dElement);
                            continue;
                        }
                        if (nodeName.equals("IS") && childElementName.equals("connect")) {
                            ((IS)elementObject).addConnect((connect)childX3dElement);
                            continue;
                        }
                        if (!(elementObject instanceof X3DGroupingNode)) {
                            errorNotice = "*** [X3DLoaderDOM error] Parent-child node relationship not found! Please report this problem to brutzman@nps.edu";
                            this.validationResult.append(errorNotice);
                            System.out.println(errorNotice);
                        }
                        ((X3DGroupingNode)elementObject).addChildren(new X3DNode[]{(X3DNode)childX3dElement});
                        continue;
                    }
                    catch (ClassCastException | DOMException ex) {
                        errorNotice = "*** [X3DLoaderDOM error] Incorrectly handled X3DJSAIL object construction, current elementObject=" + nodeName + " (" + elementObject.getElementName() + "), child=\"" + childElementName + "\", containerField=\"" + containerField + "\", " + ex + "\n";
                        errorNotice = errorNotice + "    This error can be caused by incorrect parent-child node relationships or incorrect containerField values.\n";
                        errorNotice = errorNotice + "    X3D node typing is strict, check or validate your scene graph!\n";
                        errorNotice = errorNotice + "    This error can also be caused by X3DLoaderDOM DOM omissions in X3DJSAIL. Please report mysterious problems, thank you.\n";
                        this.validationResult.append(errorNotice);
                        System.out.println(errorNotice);
                        ex.printStackTrace();
                    }
                }
lbl1090:
                // 2 sources

                if (nodeName.equals("Script") && !node.getTextContent().trim().isEmpty()) {
                    ((Script)elementObject).setSourceCode(node.getTextContent().trim());
                } else if (nodeName.equals("ShaderProgram") && !node.getTextContent().trim().isEmpty()) {
                    ((ShaderProgram)elementObject).setSourceCode(node.getTextContent().trim());
                } else if (nodeName.equals("ShaderPart") && !node.getTextContent().trim().isEmpty()) {
                    ((ShaderPart)elementObject).setSourceCode(node.getTextContent().trim());
                }
                attributes = node.getAttributes();
                for (i = 0; i < attributes.getLength(); ++i) {
                    fieldName = "[uninitializedFieldName]";
                    fieldSetMethodName = "setValueByString";
                    currentAttributeNode = attributes.item(i);
                    attributeName = currentAttributeNode.getNodeName();
                    attributeValue = currentAttributeNode.getNodeValue();
                    errorNotice = "*** [X3DLoaderDOM error] <" + nodeName + " " + attributeName + "='" + attributeValue + "'/> exception: ";
                    if (attributeName.equals("containerField") || attributeName.startsWith("xmlns:") || attributeName.startsWith("xsd:") || attributeName.contains(":")) continue;
                    attributeType = elementObject.getFieldType(attributeName);
                    elementSetMethodName = "set";
                    if (attributeName.equals("class")) {
                        elementSetMethodName = elementSetMethodName + "Css";
                    }
                    elementSetMethodName = elementSetMethodName + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
                    unescapedAttributeValue = attributeValue.replace("\\\\\"", "\\\"");
                    if (!unescapedAttributeValue.equals(attributeValue)) {
                        System.out.println("*trace of X3DLoaderDOM DOM import: attributeValue='" + attributeValue + "', unescapedAttributeValue='" + unescapedAttributeValue + "', attributeName='" + attributeName + "', attributeType='" + attributeType + "'");
                        attributeValue = unescapedAttributeValue;
                    }
                    try {
                        if (attributeType.equals("SFString")) {
                            elementSetMethod = elementClass.getMethod(elementSetMethodName, new Class[]{String.class});
                            elementSetMethod.invoke((Object)elementObject, new Object[]{attributeValue});
                            continue;
                        }
                        if (attributeType.equals("SFNode") || attributeType.equals("MFNode")) {
                            errorNotice = "*** [X3DLoaderDOM error] Reflection parsing unexpectedly encountered " + attributeType + " type when parsing attribute" + attributeName + ".";
                            this.validationResult.append(errorNotice).append("\n");
                            System.out.println(errorNotice);
                            continue;
                        }
                        fieldTypePrefix = "org.web3d.x3d.jsail.fields.";
                        fieldName = fieldTypePrefix + attributeType;
                        fieldClass = Class.forName(fieldName);
                        field = (X3DConcreteField)fieldClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        field.initialize();
                        fieldSetMethod = fieldClass.getDeclaredMethod(fieldSetMethodName, new Class[]{String.class});
                        if (!Modifier.isPublic(fieldSetMethod.getModifiers())) {
                            fieldSetMethod.setAccessible(true);
                        }
                        try {
                            fieldSetMethod.invoke((Object)field, new Object[]{attributeValue});
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            insertionValue = attributeValue.length() < 1000 ? "\"" + attributeValue + "\"" : "\"" + attributeValue.substring(0, 40) + "\" ... [attributeValue length=" + attributeValue.length() + " characters]";
                            errorNotice = "*** [X3DLoaderDOM error] Java reflection invocation problem for fieldName=" + fieldName + "." + fieldSetMethodName + "(" + insertionValue + ") method throws exception";
                            if (e.getMessage() != null) {
                                errorNotice = errorNotice + " " + e.getMessage();
                            }
                            if (e.getCause() != null) {
                                errorNotice = errorNotice + " caused by: " + e.getCause().toString();
                            }
                            errorNotice = errorNotice + ", continuing...";
                            this.validationResult.append(errorNotice).append("\n");
                            if (errorNotice.contains(".setValueByString") || errorNotice.contains("StackOverflowError")) ** GOTO lbl1157
                            System.out.println(errorNotice);
                            if (e.getMessage() != null || e.getCause() != null) ** GOTO lbl1157
                            e.printStackTrace();
                        }
lbl1157:
                        // 4 sources

                        elementSetMethod = elementClass.getMethod(elementSetMethodName, new Class[]{fieldClass});
                        elementSetMethod.invoke((Object)elementObject, new Object[]{field});
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        errorNotice = "*** [X3DLoaderDOM error] Reflection invocation: fully qualified object package not found for fieldName=" + fieldName + ",\n   " + cnfe + " " + cnfe.getMessage();
                        if (cnfe.getCause() != null && !cnfe.getCause().getMessage().isEmpty()) {
                            errorNotice = errorNotice + "\n   " + cnfe.getCause();
                        }
                        this.validationResult.append(errorNotice).append("\n");
                        System.out.println(errorNotice);
                        cnfe.printStackTrace();
                        return null;
                    }
                    catch (IllegalAccessException iae) {
                        errorNotice = "*** [X3DLoaderDOM error] Reflection invocation visibility of no-parameter constructor inaccessible for fieldName=" + fieldName + ",\n   " + iae + " " + iae.getMessage();
                        if (iae.getCause() != null && !iae.getCause().getMessage().isEmpty()) {
                            errorNotice = errorNotice + "\n   " + iae.getCause();
                        }
                        this.validationResult.append(errorNotice).append("\n");
                        System.out.println(errorNotice);
                        iae.printStackTrace();
                        return null;
                    }
                    catch (InstantiationException ie) {
                        errorNotice = "*** [X3DLoaderDOM error] Reflection invocation failure occurred inside constructor for fieldName=" + fieldName + ",\n   " + ie + " " + ie.getMessage();
                        if (ie.getCause() != null && !ie.getCause().getMessage().isEmpty()) {
                            errorNotice = errorNotice + "\n   " + ie.getCause();
                        }
                        this.validationResult.append(errorNotice).append("\n");
                        System.out.println(errorNotice);
                        ie.printStackTrace();
                        return null;
                    }
                    catch (InvocationTargetException ite) {
                        errorNotice = "*** [X3DLoaderDOM error] Reflection invocation of " + nodeName + "." + elementSetMethodName + "(" + fieldName + "()." + fieldSetMethodName + "(\"" + attributeValue + "\")) failed (likely due to illegal value),\n   " + ite + " " + ite.getMessage();
                        if (ite.getCause() != null) {
                            errorNotice = errorNotice + "\n   getCause()=" + ite.getCause();
                            if (ite.getCause().toString().contains("java.lang.StackOverflowError")) continue;
                        }
                        if (ite.getMessage().contains("java.lang.StackOverflowError")) continue;
                        this.validationResult.append(errorNotice).append("\n");
                        System.out.println(errorNotice + "\n");
                        ite.printStackTrace();
                        return null;
                    }
                    catch (NoSuchMethodException nsme) {
                        errorNotice = "*** [X3DLoaderDOM error] Reflection invocation incorrectly constructed set method name for fieldName=" + fieldName + ",\n   " + nsme + " " + nsme.getMessage();
                        if (nsme.getCause() != null && !nsme.getCause().getMessage().isEmpty()) {
                            errorNotice = errorNotice + "\n   " + nsme.getCause();
                        }
                        this.validationResult.append(errorNotice).append("\n");
                        System.out.println(errorNotice);
                        nsme.printStackTrace();
                        return null;
                    }
                    catch (Exception e) {
                        errorNotice = "*** [X3DLoaderDOM error] Reflection invocation incorrectly constructed set method name for fieldName=" + fieldName + ",\n   " + e + " " + e.getMessage();
                        if (e.getCause() != null && !e.getCause().getMessage().isEmpty()) {
                            errorNotice = errorNotice + "\n   " + e.getCause();
                        }
                        this.validationResult.append(errorNotice).append("\n");
                        System.out.println(errorNotice);
                        e.printStackTrace();
                        return null;
                    }
                }
                break;
            }
            case 3: {
                if (!node.getNodeValue().trim().isEmpty()) break;
                errorNotice = "*** [X3DLoaderDOM error] Unexpected plain text found: " + node.getNodeValue().trim();
                this.validationResult.append(errorNotice).append("\n");
                System.out.println(errorNotice);
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                commentsBlock = new CommentsBlock(node.getNodeValue());
                if (parentElement == null) {
                    errorNotice = "*** [X3DLoaderDOM error] CommentsBlock found without prior parent being saved; ignored.";
                    errorNotice = errorNotice + "<!-- " + node.getNodeValue() + " -->";
                    this.validationResult.append(errorNotice).append("\n");
                    System.out.println(errorNotice);
                    break;
                }
                parentElement.addComments(commentsBlock);
                break;
            }
            case 7: {
                break;
            }
        }
        return elementObject;
    }

    public boolean isDtdValidationPerformed() {
        return this.dtdValidate;
    }

    public void setDtdValidationPerformed(boolean newDtdValidationValue) {
        this.dtdValidate = newDtdValidationValue;
        this.documentBuilderFactory.setValidating(this.dtdValidate || this.xsdValidate);
    }

    public boolean isXmlSchemaValidationPerformed() {
        return this.xsdValidate;
    }

    public void setXmlSchemaValidation(boolean newXmlSchemaValidationValue) {
        this.xsdValidate = newXmlSchemaValidationValue;
        this.documentBuilderFactory.setValidating(this.dtdValidate || this.xsdValidate);
    }

    public X3DConcreteElement getX3dObjectTree() {
        return loadedX3dModelInstance;
    }

    public boolean isLoadSuccessful() {
        return this.loadSuccess && loadedX3dModelInstance != null;
    }

    public String getValidationResult() {
        return this.validationResult.toString();
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private final PrintWriter out;

        MyErrorHandler(PrintWriter out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            String message = "Warning: " + this.getParseExceptionInfo(spe);
            this.out.println(message);
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

