/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFDouble
extends X3DConcreteField
implements org.web3d.x3d.sai.SFDouble {
    public static final String NAME = "SFDouble";
    public static final double DEFAULT_VALUE = 0.0;
    public static final String DEFAULT_VALUE_STRING = "0.0";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "(\\s)*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)(\\s)*";
    public static final Pattern PATTERN = Pattern.compile("(\\s)*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)(\\s)*");
    private static boolean priorRegexStackOverflowFound = false;
    private double SFDouble = 0.0;

    public static final boolean isArray() {
        return false;
    }

    public SFDouble() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFDouble = 0.0;
    }

    public boolean equals(SFDouble comparisonSFDouble) {
        return this.getPrimitiveValue() == comparisonSFDouble.getPrimitiveValue();
    }

    public final String validate() {
        SFDouble tempHold = new SFDouble(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFDouble validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** Regular expression (regex) failure, new SFDouble PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFDouble";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFDouble";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFDouble setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFDouble.matches(newValue)) {
            String errorNotice = "*** Regular expression (regex) failure, new SFDouble(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFDouble = 0.0;
            return this;
        }
        try {
            this.SFDouble = Double.parseDouble(newValue);
        }
        catch (NumberFormatException e) {
            String errorNotice = "new SFDouble(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFDouble(SFDouble newValue) {
        if (newValue == null) {
            this.SFDouble = 0.0;
            return;
        }
        this.SFDouble = newValue.getPrimitiveValue();
    }

    public SFDouble(double newValue) {
        this.SFDouble = newValue;
    }

    public SFDouble(float newValue) {
        this.SFDouble = newValue;
    }

    public SFDouble(int newValue) {
        this.SFDouble = newValue;
    }

    public static String toString(double value) {
        return String.valueOf(value);
    }

    @Override
    public double getValue() {
        return this.SFDouble;
    }

    public double getPrimitiveValue() {
        return this.SFDouble;
    }

    public String toString() {
        return String.valueOf(this.SFDouble);
    }

    @Override
    public void setValue(double newValue) {
        this.SFDouble = newValue;
    }

    public SFDouble setValue(float newValue) {
        this.SFDouble = newValue;
        return this;
    }

    public SFDouble setValue(int newValue) {
        this.SFDouble = newValue;
        return this;
    }

    public String stripTrailingZeroes() {
        return org.web3d.x3d.jsail.fields.SFDouble.stripTrailingZeroes(this.getValue());
    }

    public static String stripTrailingZeroes(double value) {
        String stringValue = String.valueOf(value);
        if (stringValue.contains(".") && !stringValue.contains("E") && !stringValue.contains("e")) {
            return stringValue.replaceAll("[0]*$", "").replaceAll("\\.$", "");
        }
        return stringValue;
    }

    public SFDouble setValue(SFDouble newValue) {
        if (newValue == null) {
            this.SFDouble = 0.0;
            return this;
        }
        this.SFDouble = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return this.SFDouble == 0.0;
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFDouble(0.0).matches()) {
                System.out.println("SFDouble.initialize() problem: failed to match DEFAULT_VALUE=0.0");
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFDouble initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"(\\s)*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)(\\s)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

