/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import java.io.IOException;
import java.util.LinkedList;
import org.lbzip2.AbstractDataSource;
import org.lbzip2.DataSource;

class CompoundDataSource
extends AbstractDataSource {
    private final LinkedList<DataSource> sources = new LinkedList();

    CompoundDataSource() {
    }

    protected final void addSource(DataSource source) {
        this.sources.add(source);
    }

    public final boolean isEmpty() throws IOException {
        return this.sources.isEmpty();
    }

    public final int read(byte[] buf, int off, int len) throws IOException {
        int avail;
        int read;
        for (avail = len; avail > 0 && !this.isEmpty(); avail -= read) {
            DataSource source = this.sources.peek();
            read = source.read(buf, off, avail);
            off += read;
            if (!source.isEmpty()) continue;
            this.sources.poll();
        }
        return len - avail;
    }
}

