/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import java.util.Arrays;
import org.lbzip2.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EntropyCoder {
    private final Logger logger = LoggerFactory.getLogger(EntropyCoder.class);
    private final int cluster_factor;
    int num_selectors;
    int num_trees;
    final byte[][] length = new byte[6][259];
    final int[][] code = new int[6][259];
    final byte[] selector = new byte[18002];
    final int[] tmap_new2old = new int[6];
    final int[] tmap_old2new = new int[6];

    public EntropyCoder(int cluster_factor) {
        this.cluster_factor = cluster_factor;
    }

    private long weight_add(long w1, long w2) {
        return (w1 + w2 & 0xFFFFFFFF00000000L) + Math.max(w1 & 0xFF000000L, w2 & 0xFF000000L) + 0x1000000L;
    }

    private void build_tree(int[] tree, long[] weight, int as) {
        int t;
        int r = as;
        int s = as;
        for (t = as - 1; t > 0; --t) {
            long w2;
            long w1;
            if (s < 1 || r > t + 2 && weight[r - 2] < weight[s - 1]) {
                tree[r - 1] = t;
                tree[r - 2] = t;
                w1 = weight[r - 1];
                w2 = weight[r - 2];
                r -= 2;
            } else if (r < t + 2 || s > 1 && weight[s - 2] <= weight[r - 1]) {
                w1 = weight[s - 1];
                w2 = weight[s - 2];
                s -= 2;
            } else {
                tree[r - 1] = t;
                w1 = weight[r - 1];
                w2 = weight[s - 1];
                --s;
                --r;
            }
            weight[t] = (weight[t] & 0xFFFFL) + (w1 + w2 & 0xFFFFFFFF00FF0000L) + Math.max(w1 & 0xFF000000L, w2 & 0xFF000000L) + 0x1000000L;
        }
        assert (r == 2);
        assert (s == 0);
        assert (t == 0);
    }

    private void compute_depths(int[] count, int[] tree, int as) {
        tree[1] = 0;
        count[0] = 0;
        int node = 2;
        int avail = 2;
        for (int depth = 1; depth <= 30; ++depth) {
            int used = 0;
            while (node < as && tree[tree[node]] + 1 == depth) {
                assert (avail > used);
                ++used;
                tree[node++] = depth;
            }
            count[depth] = avail - used;
            avail = used << 1;
        }
        assert (avail == 0);
    }

    private void package_merge(short[][] tree, int[] count, long[] leaf_weight, int as) {
        int depth;
        long[] pkg_weight = new long[21];
        long[] prev_weight = new long[21];
        long[] curr_weight = new long[21];
        pkg_weight[0] = Long.MAX_VALUE;
        for (depth = 1; depth <= 20; ++depth) {
            tree[depth][0] = 2;
            pkg_weight[depth] = this.weight_add(leaf_weight[as], leaf_weight[as - 1]);
            prev_weight[depth] = leaf_weight[as - 1];
            curr_weight[depth] = leaf_weight[as - 2];
        }
        block1: for (int width = 2; width < as; ++width) {
            count[0] = 20;
            depth = 20;
            int next_depth = 1;
            while (true) {
                if (pkg_weight[depth - 1] <= curr_weight[depth]) {
                    if (depth != 1) {
                        System.arraycopy(tree[depth - 1], 0, tree[depth], 1, 20);
                        pkg_weight[depth] = this.weight_add(prev_weight[depth], pkg_weight[depth - 1]);
                        prev_weight[depth] = pkg_weight[depth - 1];
                        count[next_depth++] = --depth;
                        continue;
                    }
                } else {
                    short[] sArray = tree[depth];
                    sArray[0] = (short)(sArray[0] + 1);
                    pkg_weight[depth] = this.weight_add(prev_weight[depth], curr_weight[depth]);
                    prev_weight[depth] = curr_weight[depth];
                    curr_weight[depth] = leaf_weight[as - tree[depth][0]];
                }
                if (next_depth == 0) continue block1;
                depth = count[--next_depth];
            }
        }
    }

    private void make_code_lengths(byte[] length, int[] frequency, int as) {
        int i;
        long[] weight = new long[258];
        int[] V = new int[258];
        int[] count = new int[32];
        assert (as >= 3);
        assert (as <= 258);
        for (i = 0; i < as; ++i) {
            weight[i] = Math.max((long)frequency[i], 1L) << 32 | 0x10000L | (long)(258 - i);
        }
        Utils.insertion_sort(weight, 0, as);
        this.build_tree(V, weight, as);
        this.compute_depths(count, V, as);
        i = 0;
        int c = 0;
        for (int d = 0; d <= 30; ++d) {
            int k;
            c = c + k << 1;
            for (k = count[d]; k != 0; --k) {
                assert (i < as);
                length[(int)(258L - (weight[i] & 0xFFFFL))] = (byte)d;
                ++i;
            }
        }
        assert (c == Integer.MIN_VALUE);
        assert (i == as);
    }

    private void generate_initial_trees(int nm, int nt) {
        int freq;
        int t;
        for (t = 0; t < nt; ++t) {
            Arrays.fill(this.length[t], (byte)1);
        }
        int as = 0;
        int a = 0;
        int cum = 0;
        while (cum < nm) {
            freq = this.code[0][a];
            cum += freq;
            as += Math.min(freq, 1);
            ++a;
        }
        assert (cum == nm);
        a = 0;
        t = 0;
        for (nt = Math.min(nt, as); nt > 0; --nt) {
            assert (nm > 0);
            assert (as >= nt);
            cum = freq = this.code[0][a];
            as -= Math.min(freq, 1);
            int b = a + 1;
            while (as > nt - 1 && cum * nt < nm) {
                freq = this.code[0][b];
                cum += freq;
                as -= Math.min(freq, 1);
                ++b;
            }
            if (cum > freq && (2 * cum - freq) * nt > 2 * nm) {
                cum -= freq;
                as += Math.min(freq, 1);
                --b;
            }
            assert (a < b);
            assert (cum > 0);
            assert (cum <= nm);
            assert (as >= nt - 1);
            this.logger.trace("Initial tree {}: EC=[{},{}), |EC|={}, cum={}", new Object[]{t, a, b, b - a, cum});
            while (a < b) {
                this.length[t][a++] = 0;
            }
            nm -= cum;
            ++t;
        }
        assert (as == 0);
        assert (nm == 0);
    }

    private int find_best_tree(short[] mtfv, int gs, int nt, long[] len_pack) {
        long cp = 0L;
        for (int i = 0; i < 50; ++i) {
            cp += len_pack[mtfv[gs++]];
        }
        long bc = cp & 0x3FFL;
        int bt = 0;
        for (int t = 1; t < nt; ++t) {
            long c = (cp >>= 10) & 0x3FFL;
            if (c >= bc) continue;
            bc = c;
            bt = t;
        }
        return bt;
    }

    private int assign_codes(int[] code, byte[] length, int[] frequency, int as) {
        int symbol;
        int avail;
        int depth;
        int leaf;
        long[] leaf_weight = new long[259];
        int[] count = new int[32];
        int[] base_code = new int[21];
        short[][] tree = new short[21][21];
        for (leaf = 0; leaf < as; ++leaf) {
            leaf_weight[leaf + 1] = (long)frequency[leaf] << 32 | 0x10000L | (long)(258 - leaf);
        }
        Utils.insertion_sort(leaf_weight, 1, as + 1);
        leaf_weight[0] = Long.MAX_VALUE;
        for (int i = 0; i <= 20; ++i) {
            Arrays.fill(tree[i], (short)0);
        }
        this.package_merge(tree, count, leaf_weight, as);
        int best_cost = Integer.MAX_VALUE;
        int best_height = 20;
        for (int height = 2; height <= 20; ++height) {
            if (1L << height < (long)as) continue;
            if (tree[height][height - 1] == 0) {
                this.logger.trace("      (for heights >{} costs is the same as for height={})", (Object)(height - 1), (Object)(height - 1));
                break;
            }
            int cost = 0;
            leaf = 0;
            for (depth = 1; depth <= height; ++depth) {
                for (avail = tree[height][depth - 1] - tree[height][depth]; avail > 0; --avail) {
                    assert (leaf < as);
                    symbol = (int)(258L - (leaf_weight[leaf + 1] & 0xFFFFL));
                    length[symbol] = (byte)depth;
                    cost += (int)(leaf_weight[leaf + 1] >> 32) * depth;
                    ++leaf;
                }
            }
            for (symbol = 1; symbol < as; ++symbol) {
                cost += 2 * Math.abs(length[symbol - 1] - length[symbol]);
            }
            this.logger.trace("    for height={} transmission cost is {}", (Object)height, (Object)(cost += 5 + as));
            if (cost >= best_cost) continue;
            best_cost = cost;
            best_height = height;
        }
        this.logger.trace("  best tree height is {}", (Object)best_height);
        leaf = 0;
        int next_code = 0;
        for (depth = 1; depth <= best_height; ++depth) {
            base_code[depth] = next_code;
            next_code = next_code + avail << 1;
            for (avail = tree[best_height][depth - 1] - tree[best_height][depth]; avail > 0; --avail) {
                assert (leaf < as);
                symbol = (int)(258L - (leaf_weight[leaf + 1] & 0xFFFFL));
                length[symbol] = (byte)depth;
                ++leaf;
            }
        }
        assert (next_code == 1 << best_height + 1);
        assert (leaf == as);
        for (symbol = 0; symbol < as; ++symbol) {
            byte by = length[symbol];
            base_code[by] = base_code[by] + 1;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("  Prefix code dump:");
            for (symbol = 0; symbol < as; ++symbol) {
                StringBuilder buffer = new StringBuilder(32);
                int len = length[symbol];
                while (len-- > 0) {
                    buffer.append(((long)code[symbol] & 1L << len) != 0L ? (char)'1' : '0');
                }
                this.logger.trace("    symbol {} has code {}", (Object)symbol, (Object)buffer);
            }
        }
        return best_cost;
    }

    int generate_prefix_code(short[] mtfv, int nm) {
        int t;
        int i;
        int[][] frequency = new int[6][259];
        int as = mtfv[nm - 1] + 1;
        this.num_selectors = (nm + 50 - 1) / 50;
        assert (nm >= 2);
        int nt = Math.min(Utils.ilog2((nm - 1) / 150) + 2, 6);
        for (i = nm; i < this.num_selectors * 50; ++i) {
            mtfv[i] = (short)as;
        }
        this.generate_initial_trees(nm, nt);
        int iter = this.cluster_factor;
        while (iter-- > 0) {
            int t2;
            long[] len_pack = new long[259];
            for (int v = 0; v < as; ++v) {
                len_pack[v] = (long)this.length[0][v] + ((long)this.length[1][v] << 10) + ((long)this.length[2][v] << 20) + ((long)this.length[3][v] << 30) + ((long)this.length[4][v] << 40) + ((long)this.length[5][v] << 50);
            }
            len_pack[as] = 0L;
            int sp_off = 0;
            for (t2 = 0; t2 < nt; ++t2) {
                Arrays.fill(frequency[t2], 0);
            }
            for (int gs = 0; gs < nm; gs += 50) {
                t2 = this.find_best_tree(mtfv, gs, nt, len_pack);
                assert (t2 < nt);
                this.selector[sp_off++] = (byte)t2;
                for (i = 0; i < 50; ++i) {
                    int[] nArray = frequency[t2];
                    short s = mtfv[gs + i];
                    nArray[s] = nArray[s] + 1;
                }
            }
            assert (sp_off == this.num_selectors);
            this.selector[sp_off] = 6;
            for (t2 = 0; t2 < nt; ++t2) {
                this.make_code_lengths(this.length[t2], frequency[t2], as);
            }
        }
        int cost = 0;
        int not_seen = (1 << nt) - 1;
        int sp = 0;
        nt = 0;
        while (not_seen > 0 && (t = this.selector[sp++]) < 6) {
            if ((not_seen & 1 << t) == 0) continue;
            this.logger.trace("Final tree {}:", (Object)nt);
            not_seen -= 1 << t;
            this.tmap_old2new[t] = nt;
            this.tmap_new2old[nt] = t;
            ++nt;
            cost += this.assign_codes(this.code[t], this.length[t], frequency[t], as);
            this.code[t][as] = 0;
            this.length[t][as] = 0;
        }
        assert (nt >= 1);
        if (nt == 1) {
            nt = 2;
            t = this.tmap_new2old[0] ^ 1;
            this.tmap_old2new[t] = 1;
            this.tmap_new2old[1] = t;
            for (int v = 0; v < 258; ++v) {
                this.length[t][v] = 20;
            }
            cost += as + 5;
        }
        this.num_trees = nt;
        return cost;
    }
}

