/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.lbzip2.StreamComposer;
import org.lbzip2.UncompressedBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LBzip2OutputStream
extends OutputStream {
    private final Logger logger = LoggerFactory.getLogger(LBzip2OutputStream.class);
    private final OutputStream os;
    private final StreamComposer composer;
    private final UncompressedBlock block;
    private final byte[] buf1 = new byte[1];
    private final byte[] buf = new byte[4096];

    public LBzip2OutputStream(OutputStream os, int maxBlockSize) throws IOException {
        this.os = os;
        this.composer = new StreamComposer(maxBlockSize);
        this.block = new UncompressedBlock(maxBlockSize);
    }

    public void write(int b) throws IOException {
        this.buf1[0] = (byte)b;
        this.write(this.buf1, 0, 1);
    }

    public void write(byte[] buf, int off, int avail) throws IOException {
        while (avail > 0) {
            int written = this.block.write(buf, off, avail);
            off += written;
            avail -= written;
            if (!this.block.isFull()) continue;
            this.logger.trace("Block full, forcing transmission");
            this.transmit();
        }
    }

    private void transmit() throws IOException {
        if (!this.block.isEmpty()) {
            this.logger.trace("Adding block");
            this.composer.addBlock(this.block.compress());
        }
        while (!this.composer.isEmpty()) {
            this.logger.trace("Emptying composer");
            this.os.write(this.buf, 0, this.composer.read(this.buf));
        }
    }

    public void flush() throws IOException {
        this.transmit();
        this.os.flush();
    }

    public void finish() throws IOException {
        this.logger.trace("Closing stream");
        this.transmit();
        this.composer.finish();
        this.transmit();
    }

    public void close() throws IOException {
        this.finish();
        this.os.close();
    }

    public static void main(String[] args) {
        try {
            int n;
            InputStream is = System.in;
            LBzip2OutputStream os = new LBzip2OutputStream(System.out, 900000);
            byte[] buf = new byte[4096];
            while ((n = is.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, n);
            }
            is.close();
            ((OutputStream)os).close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

