/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing;

import com.macrofocus.docking.Dockable;
import com.macrofocus.docking.DockingAnchor;
import com.macrofocus.docking.DockingBar;
import com.macrofocus.docking.DockingState;
import com.macrofocus.docking.DockingType;
import com.macrofocus.docking.swing.DockingButton;
import com.macrofocus.docking.swing.DockingContainer;
import com.macrofocus.docking.swing.IconDockable;
import com.macrofocus.helper.ComponentCleaner;
import com.macrofocus.helper.Disposable;
import com.macrofocus.helper.WeakActionListeners;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SwingDockingBar
extends JPanel
implements DockingBar<JComponent>,
Disposable {
    private final List<Dockable<JComponent>> dockables;
    private final Map<Dockable, DockingButton> dockingButtons;
    private final Map<Dockable, DockingState> dockingStates;
    private final DockingAnchor orientation;
    private final DockingContainer container;
    private Timer enterTimer;
    private InsideTimerAction insideTimerAction;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public SwingDockingBar(DockingContainer container, DockingAnchor orientation) {
        this.container = container;
        this.orientation = orientation;
        this.dockables = new ArrayList<Dockable<JComponent>>();
        this.dockingButtons = new HashMap<Dockable, DockingButton>();
        this.dockingStates = new HashMap<Dockable, DockingState>();
        this.insideTimerAction = new InsideTimerAction();
        this.enterTimer = new Timer(750, this.insideTimerAction);
        this.enterTimer.setRepeats(false);
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
    }

    public void attach(final Dockable dockable) {
        dockable.setDockingBar((DockingBar)this);
        boolean first = this.dockables.isEmpty();
        this.dockables.add((Dockable<JComponent>)dockable);
        final DockingButton button = new DockingButton(this.orientation);
        button.setText(dockable.getShortTitle());
        if (dockable instanceof IconDockable) {
            button.setIcon(((IconDockable)dockable).getIcon());
        }
        button.setToolTipText(dockable.getDescription());
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new AbstractAction("Float"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingDockingBar.this.setFloating((Dockable<JComponent>)dockable, true);
            }
        }));
        button.setComponentPopupMenu(popupMenu);
        this.dockingButtons.put(dockable, button);
        DockingState state = new DockingState();
        this.dockingStates.put(dockable, state);
        button.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingDockingBar.this.setActive((Dockable<JComponent>)dockable, button.isSelected());
            }
        }, (Object)button));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SwingDockingBar.this.insideTimerAction.setDockable(dockable);
                SwingDockingBar.this.enterTimer.start();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SwingDockingBar.this.enterTimer.stop();
            }
        });
        this.container.setLayout(new OverlayLayout(this.container));
        if (first) {
            this.setActive((Dockable<JComponent>)dockable, true);
        }
        this.update();
    }

    public void detach(Dockable dockable) {
        this.setActive((Dockable<JComponent>)dockable, false);
        this.dockables.remove(dockable);
        this.dockingButtons.remove(dockable);
        this.dockingStates.remove(dockable);
        this.update();
    }

    @Override
    public void removeAll() {
        for (Dockable<JComponent> dockable : this.dockables) {
            this.setActive(dockable, false);
            this.dockingButtons.remove(dockable);
            this.dockingStates.remove(dockable);
        }
        this.dockables.clear();
        this.update();
    }

    public boolean isActive(Dockable dockable) {
        DockingState state = this.dockingStates.get(dockable);
        return state.isActive();
    }

    public void setActive(Dockable<JComponent> dockable, boolean active) {
        DockingState state = this.dockingStates.get(dockable);
        if (!state.isFloating()) {
            for (Dockable<JComponent> d : this.dockables) {
                DockingState s = this.dockingStates.get(d);
                if (!s.isActive()) continue;
                s.setActive(d == dockable && active);
                DockingButton button = this.dockingButtons.get(d);
                button.setSelected(d == dockable && active);
                this.container.remove((Component)d.getComponent());
            }
            if (active) {
                state.setActive(true);
                this.container.add((Component)dockable.getComponent());
                this.container.validate();
                this.container.setVisible(true);
                DockingButton button = this.dockingButtons.get(dockable);
                button.setSelected(true);
                this.container.repaint();
            } else {
                this.container.setVisible(false);
                this.container.revalidate();
                this.container.repaint();
            }
        } else {
            SwingUtilities.windowForComponent((Component)dockable.getContainer()).toFront();
            DockingButton button = this.dockingButtons.get(dockable);
            button.setSelected(false);
        }
    }

    public void setFloating(final Dockable<JComponent> dockable, boolean floating) {
        DockingState state = this.dockingStates.get(dockable);
        if (floating) {
            if (!state.isFloating()) {
                Container component = (Container)dockable.getComponent();
                Point p = component.isShowing() ? component.getLocationOnScreen() : null;
                Dimension size = component.getSize();
                this.setActive(dockable, false);
                JFrame frame = new JFrame();
                frame.setAlwaysOnTop(true);
                if (p != null) {
                    frame.setLocation(p);
                } else {
                    frame.setLocationRelativeTo(this);
                }
                frame.setSize(size);
                String title = dockable.getTitle();
                frame.setTitle(title);
                Container container = (Container)dockable.detachContainer();
                frame.getContentPane().add(container);
                frame.validate();
                frame.setVisible(true);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        SwingDockingBar.this.setFloating((Dockable<JComponent>)dockable, false);
                    }
                });
                state.setType(DockingType.FLOATING);
            }
        } else if (state.isFloating()) {
            Container component = (Container)dockable.getContainer();
            component.getParent().remove(component);
            dockable.attachContainer();
            state.setType(DockingType.DOCKED);
            this.setActive(dockable, true);
        }
    }

    public void setSliding(Dockable<JComponent> dockable, boolean sliding) {
        DockingState state = this.dockingStates.get(dockable);
        if (sliding) {
            if (!state.isSliding()) {
                JComponent component = (JComponent)dockable.getComponent();
                JFrame frame = new JFrame();
                frame.setSize(50, 50);
                frame.setUndecorated(true);
                String title = dockable.getTitle();
                frame.setTitle(title);
                JComponent container = (JComponent)dockable.detachContainer();
                frame.getContentPane().add(container);
                frame.validate();
                frame.setVisible(true);
                state.setType(DockingType.SLIDING);
            }
        } else if (state.isSliding()) {
            JComponent component = (JComponent)dockable.getContainer();
            component.getParent().remove(component);
            dockable.attachContainer();
            state.setType(DockingType.DOCKED);
        }
    }

    public List<Dockable<JComponent>> getDockables() {
        return this.dockables;
    }

    private void update() {
        super.removeAll();
        if (this.orientation == DockingAnchor.TOP || this.orientation == DockingAnchor.BOTTOM) {
            int i = 1;
            for (Dockable<JComponent> dockable : this.dockables) {
                DockingButton dockingButton = this.dockingButtons.get(dockable);
                this.add((Component)dockingButton, new GridBagConstraints(i, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
                ++i;
            }
            this.add(Box.createGlue(), new GridBagConstraints(i, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else if (this.orientation == DockingAnchor.LEFT || this.orientation == DockingAnchor.RIGHT) {
            int i = 0;
            for (Dockable<JComponent> dockable : this.dockables) {
                DockingButton dockingButton = this.dockingButtons.get(dockable);
                this.add((Component)dockingButton, new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                ++i;
            }
            GridBagConstraints gridbagconstraints = new GridBagConstraints();
            gridbagconstraints.gridy = this.dockables.size();
            gridbagconstraints.weighty = 1.0;
            gridbagconstraints.anchor = 11;
            this.add(Box.createGlue(), gridbagconstraints);
        } else {
            throw new UnknownError();
        }
    }

    public void dispose() {
        if (this.enterTimer != null) {
            this.enterTimer.stop();
            this.enterTimer = null;
        }
        this.insideTimerAction = null;
        this.dockables.clear();
        for (DockingButton dockingButton : this.dockingButtons.values()) {
            ComponentCleaner.cleanComponent((Component)dockingButton);
        }
        this.dockingButtons.clear();
        this.dockingStates.clear();
        ComponentCleaner.cleanComponent((Component)this.container);
    }

    public JComponent getNativeComponent() {
        return this;
    }

    private static class InsideTimerAction
    implements ActionListener {
        public void setDockable(Dockable dockable) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

