/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing.splitter;

import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.docking.splitter.ThreeComponentsSplitter;
import com.macrofocus.helper.Disposable;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SwingThreeComponentsSplitter
extends JPanel
implements ThreeComponentsSplitter<JComponent>,
Disposable {
    private int myDividerWidth;
    private boolean myVerticalSplit;
    private boolean myHonorMinimumSize = false;
    private Divider myFirstDivider;
    private Divider myLastDivider;
    private JComponent myFirstComponent;
    private JComponent myInnerComponent;
    private JComponent myLastComponent;
    private double myFirstSize = 350.0;
    private double myLastSize = 10.0;
    private boolean myShowDividerControls;
    private boolean relativeResize = true;

    public SwingThreeComponentsSplitter() {
        this(false);
    }

    public SwingThreeComponentsSplitter(boolean vertical) {
        this.myVerticalSplit = vertical;
        this.myShowDividerControls = false;
        this.myFirstDivider = new Divider(true);
        this.myLastDivider = new Divider(false);
        this.myDividerWidth = 8;
        this.setOpaque(false);
        super.add((Component)((Object)this.myFirstDivider));
        super.add((Component)((Object)this.myLastDivider));
    }

    public void setShowDividerControls(boolean showDividerControls) {
        this.myShowDividerControls = showDividerControls;
        this.setOrientation(this.myVerticalSplit);
    }

    public boolean isHonorMinimumSize() {
        return this.myHonorMinimumSize;
    }

    public void setHonorComponentsMinimumSize(boolean honorMinimumSize) {
        this.myHonorMinimumSize = honorMinimumSize;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && (this.firstVisible() || this.innerVisible() || this.lastVisible());
    }

    private boolean lastVisible() {
        return this.myLastComponent != null && this.myLastComponent.isVisible();
    }

    private boolean innerVisible() {
        return this.myInnerComponent != null && this.myInnerComponent.isVisible();
    }

    private boolean firstVisible() {
        return this.myFirstComponent != null && this.myFirstComponent.isVisible();
    }

    private int visibleDividersCount() {
        int count = 0;
        if (this.firstDividerVisible()) {
            ++count;
        }
        if (this.lastDividerVisible()) {
            ++count;
        }
        return count;
    }

    private boolean firstDividerVisible() {
        return this.firstVisible() && this.innerVisible() || this.firstVisible() && this.lastVisible() && !this.innerVisible();
    }

    private boolean lastDividerVisible() {
        return this.innerVisible() && this.lastVisible();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isHonorMinimumSize()) {
            Dimension innerSize;
            int dividerWidth = this.getDividerWidth();
            Dimension firstSize = this.myFirstComponent == null ? new Dimension(0, 0) : this.myFirstComponent.getMinimumSize();
            Dimension lastSize = this.myLastComponent == null ? new Dimension(0, 0) : this.myLastComponent.getMinimumSize();
            Dimension dimension = innerSize = this.myInnerComponent == null ? new Dimension(0, 0) : this.myInnerComponent.getMinimumSize();
            if (this.getOrientation()) {
                int width = Math.max(firstSize.width, Math.max(lastSize.width, innerSize.width));
                int height = this.visibleDividersCount() * dividerWidth;
                height += firstSize.height;
                height += lastSize.height;
                return new Dimension(width, height += innerSize.height);
            }
            int heigth = Math.max(firstSize.height, Math.max(lastSize.height, innerSize.height));
            int width = this.visibleDividersCount() * dividerWidth;
            width += firstSize.width;
            width += lastSize.width;
            return new Dimension(width += innerSize.width, heigth);
        }
        return super.getMinimumSize();
    }

    @Override
    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 0 && height > 0) {
            int space;
            double innerComponentSize;
            double lastComponentSize;
            double firstCompontSize;
            Rectangle firstRect = new Rectangle();
            Rectangle firstDividerRect = new Rectangle();
            Rectangle lastDividerRect = new Rectangle();
            Rectangle lastRect = new Rectangle();
            Rectangle innerRect = new Rectangle();
            int componentSize = this.getOrientation() ? height : width;
            int dividerWidth = this.getDividerWidth();
            int dividersCount = this.visibleDividersCount();
            if (componentSize <= dividersCount * dividerWidth) {
                firstCompontSize = 0.0;
                lastComponentSize = 0.0;
                innerComponentSize = 0.0;
                dividerWidth = componentSize;
            } else {
                firstCompontSize = this.getFirstSizeIfVisible();
                int sizeLack = (int)(firstCompontSize + (lastComponentSize = this.getLastSizeIfVisible())) - (componentSize - dividersCount * dividerWidth);
                if (sizeLack > 0) {
                    firstCompontSize -= (double)sizeLack;
                    innerComponentSize = 0.0;
                } else {
                    innerComponentSize = (double)(componentSize - dividersCount * dividerWidth) - this.getFirstSizeIfVisible() - this.getLastSizeIfVisible();
                }
                if (!this.innerVisible()) {
                    if (this.lastVisible()) {
                        lastComponentSize += innerComponentSize;
                    } else {
                        firstCompontSize += innerComponentSize;
                    }
                    innerComponentSize = 0.0;
                }
            }
            if (this.getOrientation()) {
                space = (int)firstCompontSize;
                firstRect.setBounds(0, 0, width, (int)firstCompontSize);
                if (this.firstDividerVisible()) {
                    firstDividerRect.setBounds(0, space, width, dividerWidth);
                    space += dividerWidth;
                }
                if (this.innerVisible()) {
                    innerRect.setBounds(0, space, width, (int)innerComponentSize);
                    space = (int)((double)space + innerComponentSize);
                }
                if (this.lastDividerVisible()) {
                    lastDividerRect.setBounds(0, space, width, dividerWidth);
                    space += dividerWidth;
                }
                lastRect.setBounds(0, space, width, (int)lastComponentSize);
            } else {
                space = (int)firstCompontSize;
                firstRect.setBounds(0, 0, (int)firstCompontSize, height);
                if (this.firstDividerVisible()) {
                    firstDividerRect.setBounds(space, 0, dividerWidth, height);
                    space += dividerWidth;
                }
                if (this.innerVisible()) {
                    innerRect.setBounds(space, 0, (int)innerComponentSize, height);
                    space = (int)((double)space + innerComponentSize);
                }
                if (this.lastDividerVisible()) {
                    lastDividerRect.setBounds(space, 0, dividerWidth, height);
                    space += dividerWidth;
                }
                lastRect.setBounds(space, 0, (int)lastComponentSize, height);
            }
            this.myFirstDivider.setVisible(this.firstDividerVisible());
            this.myFirstDivider.setBounds(firstDividerRect);
            this.myFirstDivider.doLayout();
            this.myLastDivider.setVisible(this.lastDividerVisible());
            this.myLastDivider.setBounds(lastDividerRect);
            this.myLastDivider.doLayout();
            if (this.myFirstComponent != null) {
                this.myFirstComponent.setBounds(firstRect);
                this.myFirstComponent.revalidate();
            }
            if (this.myInnerComponent != null) {
                this.myInnerComponent.setBounds(innerRect);
                this.myInnerComponent.revalidate();
            }
            if (this.myLastComponent != null) {
                this.myLastComponent.setBounds(lastRect);
                this.myLastComponent.revalidate();
            }
        }
    }

    public int getDividerWidth() {
        return this.myDividerWidth;
    }

    public void setDividerWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Wrong divider width: " + width);
        }
        if (this.myDividerWidth != width) {
            this.myDividerWidth = width;
            this.doLayout();
            this.repaint();
        }
    }

    public boolean getOrientation() {
        return this.myVerticalSplit;
    }

    public void setOrientation(boolean verticalSplit) {
        this.myVerticalSplit = verticalSplit;
        this.myFirstDivider.setOrientation(verticalSplit);
        this.myLastDivider.setOrientation(verticalSplit);
        this.doLayout();
        this.repaint();
    }

    public void setComponents(JComponent first, JComponent inner, JComponent last) {
        this.setFirstComponent(first);
        this.setInnerComponent(inner);
        this.setLastComponent(last);
    }

    public JComponent getFirstComponent() {
        return this.myFirstComponent;
    }

    public void setFirstComponent(JComponent component) {
        if (this.myFirstComponent != component) {
            if (this.myFirstComponent != null) {
                this.remove(this.myFirstComponent);
            }
            this.myFirstComponent = component;
            if (this.myFirstComponent != null) {
                super.add(this.myFirstComponent);
                this.myFirstComponent.invalidate();
            }
        }
    }

    public JComponent getLastComponent() {
        return this.myLastComponent;
    }

    public void setLastComponent(JComponent component) {
        if (this.myLastComponent != component) {
            if (this.myLastComponent != null) {
                this.remove(this.myLastComponent);
            }
            this.myLastComponent = component;
            if (this.myLastComponent != null) {
                super.add(this.myLastComponent);
                this.myLastComponent.invalidate();
            }
        }
    }

    public JComponent getInnerComponent() {
        return this.myInnerComponent;
    }

    public void setInnerComponent(JComponent component) {
        if (this.myInnerComponent != component) {
            if (this.myInnerComponent != null) {
                this.remove(this.myInnerComponent);
            }
            this.myInnerComponent = component;
            if (this.myInnerComponent != null) {
                super.add(this.myInnerComponent);
                this.myInnerComponent.invalidate();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SwingThreeComponentsSplitter.this.myInnerComponent != null) {
                        SwingUtilities.updateComponentTreeUI(SwingThreeComponentsSplitter.this.myInnerComponent);
                    }
                    SwingThreeComponentsSplitter.this.revalidate();
                    SwingThreeComponentsSplitter.this.repaint();
                }
            });
        }
    }

    public void setFirstSize(double size) {
        if (this.myFirstSize != size) {
            this.myFirstSize = size;
            this.doLayout();
            this.repaint();
        }
    }

    public void setLastSize(double size) {
        if (this.myLastSize != size) {
            this.myLastSize = size;
            this.doLayout();
            this.repaint();
        }
    }

    public double getFirstSize() {
        return this.myFirstSize;
    }

    public double getLastSize() {
        return this.myLastSize;
    }

    public double getFirstSizeIfVisible() {
        return this.firstVisible() ? this.myFirstSize : 0.0;
    }

    public double getLastSizeIfVisible() {
        return this.lastVisible() ? this.myLastSize : 0.0;
    }

    public boolean isRelativeResize() {
        return this.relativeResize;
    }

    public void setRelativeResize(boolean relativeResize) {
        this.relativeResize = relativeResize;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.relativeResize) {
            int currentHeight = this.getHeight();
            int currentWidth = this.getWidth();
            int firstSize = (int)this.myFirstSize;
            if (currentWidth > 0 && currentHeight > 0) {
                firstSize = this.myVerticalSplit ? firstSize * height / currentHeight : firstSize * width / currentWidth;
            }
            int lastSize = (int)this.myLastSize;
            if (currentWidth > 0 && currentHeight > 0) {
                lastSize = this.myVerticalSplit ? lastSize * height / currentHeight : lastSize * width / currentWidth;
            }
            super.setBounds(x, y, width, height);
            this.setFirstSize(firstSize);
            this.setLastSize(lastSize);
        } else {
            super.setBounds(x, y, width, height);
        }
    }

    public JComponent getNativeComponent() {
        return this;
    }

    public void dispose() {
        this.myFirstDivider = null;
        this.myLastDivider = null;
        this.myFirstComponent = null;
        this.myInnerComponent = null;
        this.myLastComponent = null;
    }

    public void setWidgetHidden(JComponent widget, boolean hidden) {
    }

    protected class Divider
    extends MJPanel {
        protected boolean myDragging;
        protected Point myPoint;
        private boolean myIsFirst;

        private void setOrientation(boolean isVerticalSplit) {
            this.removeAll();
            if (!SwingThreeComponentsSplitter.this.myShowDividerControls) {
                return;
            }
            int xMask = isVerticalSplit ? 1 : 0;
            int yMask = isVerticalSplit ? 0 : 1;
            URL splitGlue = SwingThreeComponentsSplitter.class.getResource(isVerticalSplit ? "splitGlueV.png" : "splitGlueH.png");
            if (splitGlue == null) {
                System.err.println(isVerticalSplit ? "splitGlueV.png" : "splitGlueH.png couldn't be found");
                return;
            }
            ImageIcon glueIcon = new ImageIcon(splitGlue);
            int glueFill = isVerticalSplit ? 3 : 2;
            this.add(new JLabel(glueIcon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, isVerticalSplit ? 13 : 11, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            URL split = SwingThreeComponentsSplitter.class.getResource(isVerticalSplit ? "splitDown.png" : "splitRight.png");
            if (split == null) {
                System.err.println(isVerticalSplit ? "splitDown.png" : "splitRight.png couldn't be found");
                return;
            }
            JLabel splitDownlabel = new JLabel(new ImageIcon(split));
            splitDownlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitDownlabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingThreeComponentsSplitter.this.myInnerComponent != null) {
                        if (SwingThreeComponentsSplitter.this.myFirstComponent != null && SwingThreeComponentsSplitter.this.myFirstComponent.isVisible()) {
                            int income;
                            int n = income = SwingThreeComponentsSplitter.this.myVerticalSplit ? SwingThreeComponentsSplitter.this.myInnerComponent.getHeight() : SwingThreeComponentsSplitter.this.myInnerComponent.getWidth();
                            if (Divider.this.myIsFirst) {
                                SwingThreeComponentsSplitter.this.setFirstSize(SwingThreeComponentsSplitter.this.myFirstSize + (double)income);
                            } else {
                                SwingThreeComponentsSplitter.this.setLastSize(SwingThreeComponentsSplitter.this.myLastSize + (double)income);
                            }
                        } else if (Divider.this.myIsFirst) {
                            SwingThreeComponentsSplitter.this.setFirstSize(Divider.this.getMinSize(SwingThreeComponentsSplitter.this.myFirstComponent));
                        } else {
                            SwingThreeComponentsSplitter.this.setLastSize(Divider.this.getMinSize(SwingThreeComponentsSplitter.this.myLastComponent));
                        }
                    } else {
                        int income;
                        int n = income = SwingThreeComponentsSplitter.this.myVerticalSplit ? SwingThreeComponentsSplitter.this.myLastComponent.getHeight() : SwingThreeComponentsSplitter.this.myLastComponent.getWidth();
                        if (Divider.this.myIsFirst) {
                            SwingThreeComponentsSplitter.this.setFirstSize(SwingThreeComponentsSplitter.this.myFirstSize + (double)income);
                        }
                    }
                }
            });
            this.add(splitDownlabel, new GridBagConstraints(isVerticalSplit ? 1 : 0, isVerticalSplit ? 0 : 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(new JLabel(glueIcon), new GridBagConstraints(2 * xMask, 2 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitCenterlabel = new JLabel(new ImageIcon(SwingThreeComponentsSplitter.class.getResource(isVerticalSplit ? "splitCenterV.png" : "splitCenterH.png")));
            splitCenterlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitCenterlabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Divider.this.center();
                }
            });
            this.add(splitCenterlabel, new GridBagConstraints(3 * xMask, 3 * yMask, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(new JLabel(glueIcon), new GridBagConstraints(4 * xMask, 4 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitUpLabel = new JLabel(new ImageIcon(SwingThreeComponentsSplitter.class.getResource(isVerticalSplit ? "splitUp.png" : "splitLeft.png")));
            splitUpLabel.setCursor(Cursor.getPredefinedCursor(12));
            splitUpLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingThreeComponentsSplitter.this.myInnerComponent != null) {
                        if (SwingThreeComponentsSplitter.this.myFirstComponent != null && SwingThreeComponentsSplitter.this.myFirstComponent.isVisible()) {
                            if (Divider.this.myIsFirst) {
                                SwingThreeComponentsSplitter.this.setFirstSize(Divider.this.getMinSize(SwingThreeComponentsSplitter.this.myFirstComponent));
                            } else {
                                SwingThreeComponentsSplitter.this.setLastSize(Divider.this.getMinSize(SwingThreeComponentsSplitter.this.myLastComponent));
                            }
                        } else {
                            int income;
                            int n = income = SwingThreeComponentsSplitter.this.myVerticalSplit ? SwingThreeComponentsSplitter.this.myInnerComponent.getHeight() : SwingThreeComponentsSplitter.this.myInnerComponent.getWidth();
                            if (Divider.this.myIsFirst) {
                                SwingThreeComponentsSplitter.this.setFirstSize(SwingThreeComponentsSplitter.this.myFirstSize + (double)income);
                            } else {
                                SwingThreeComponentsSplitter.this.setLastSize(SwingThreeComponentsSplitter.this.myLastSize + (double)income);
                            }
                        }
                    } else if (Divider.this.myIsFirst) {
                        SwingThreeComponentsSplitter.this.setFirstSize(Divider.this.getMinSize(SwingThreeComponentsSplitter.this.myFirstComponent));
                    }
                }
            });
            this.add(splitUpLabel, new GridBagConstraints(isVerticalSplit ? 5 : 0, isVerticalSplit ? 0 : 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(new JLabel(glueIcon), new GridBagConstraints(6 * xMask, 6 * yMask, 1, 1, 0.0, 0.0, isVerticalSplit ? 17 : 15, glueFill, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void center() {
            if (SwingThreeComponentsSplitter.this.myInnerComponent != null) {
                if (SwingThreeComponentsSplitter.this.myFirstComponent != null && SwingThreeComponentsSplitter.this.myFirstComponent.isVisible()) {
                    int total = (int)SwingThreeComponentsSplitter.this.myFirstSize + (SwingThreeComponentsSplitter.this.myVerticalSplit ? SwingThreeComponentsSplitter.this.myInnerComponent.getHeight() : SwingThreeComponentsSplitter.this.myInnerComponent.getWidth());
                    if (this.myIsFirst) {
                        SwingThreeComponentsSplitter.this.setFirstSize(total / 2);
                    } else {
                        SwingThreeComponentsSplitter.this.setLastSize(total / 2);
                    }
                } else {
                    int total = (int)SwingThreeComponentsSplitter.this.myLastSize + (SwingThreeComponentsSplitter.this.myVerticalSplit ? SwingThreeComponentsSplitter.this.myInnerComponent.getHeight() : SwingThreeComponentsSplitter.this.myInnerComponent.getWidth());
                    if (this.myIsFirst) {
                        SwingThreeComponentsSplitter.this.setFirstSize(total / 2);
                    } else {
                        SwingThreeComponentsSplitter.this.setLastSize(total / 2);
                    }
                }
            } else {
                int total = (int)SwingThreeComponentsSplitter.this.myFirstSize + (SwingThreeComponentsSplitter.this.myVerticalSplit ? SwingThreeComponentsSplitter.this.myLastComponent.getHeight() : SwingThreeComponentsSplitter.this.myLastComponent.getWidth());
                if (this.myIsFirst) {
                    SwingThreeComponentsSplitter.this.setFirstSize(total / 2);
                }
            }
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (506 == e.getID()) {
                this.myDragging = true;
                this.setCursor(SwingThreeComponentsSplitter.this.getOrientation() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                this.myPoint = SwingUtilities.convertPoint((Component)((Object)this), e.getPoint(), SwingThreeComponentsSplitter.this);
                if (SwingThreeComponentsSplitter.this.getOrientation()) {
                    if (this.getHeight() > 0) {
                        if (this.myIsFirst) {
                            SwingThreeComponentsSplitter.this.setFirstSize(Math.max(this.getMinSize(SwingThreeComponentsSplitter.this.myFirstComponent), this.myPoint.y));
                        } else {
                            SwingThreeComponentsSplitter.this.setLastSize(Math.max(this.getMinSize(SwingThreeComponentsSplitter.this.myLastComponent), SwingThreeComponentsSplitter.this.getHeight() - this.myPoint.y - SwingThreeComponentsSplitter.this.getDividerWidth()));
                        }
                    }
                } else if (this.getWidth() > 0) {
                    if (this.myIsFirst) {
                        SwingThreeComponentsSplitter.this.setFirstSize(Math.max(this.getMinSize(SwingThreeComponentsSplitter.this.myFirstComponent), this.myPoint.x));
                    } else {
                        SwingThreeComponentsSplitter.this.setLastSize(Math.max(this.getMinSize(SwingThreeComponentsSplitter.this.myLastComponent), SwingThreeComponentsSplitter.this.getWidth() - this.myPoint.x - SwingThreeComponentsSplitter.this.getDividerWidth()));
                    }
                }
                this.doLayout();
            }
        }

        private int getMinSize(JComponent component) {
            if (SwingThreeComponentsSplitter.this.isHonorMinimumSize() && component != null && SwingThreeComponentsSplitter.this.myFirstComponent != null && SwingThreeComponentsSplitter.this.myFirstComponent.isVisible() && SwingThreeComponentsSplitter.this.myLastComponent != null && SwingThreeComponentsSplitter.this.myLastComponent.isVisible()) {
                if (SwingThreeComponentsSplitter.this.getOrientation()) {
                    return component.getMinimumSize().height;
                }
                return component.getMinimumSize().width;
            }
            return 0;
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            switch (e.getID()) {
                default: {
                    break;
                }
                case 504: {
                    this.setCursor(SwingThreeComponentsSplitter.this.getOrientation() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                    break;
                }
                case 505: {
                    if (this.myDragging) break;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 501: {
                    this.setCursor(SwingThreeComponentsSplitter.this.getOrientation() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                    break;
                }
                case 502: {
                    this.myDragging = false;
                    this.myPoint = null;
                    break;
                }
                case 500: {
                    if (e.getClickCount() != 2) break;
                    this.center();
                }
            }
        }

        public Divider(boolean isFirst) {
            super((LayoutManager)new GridBagLayout());
            this.setFocusable(false);
            this.enableEvents(48L);
            this.myIsFirst = isFirst;
            this.setOrientation(SwingThreeComponentsSplitter.this.myVerticalSplit);
            this.setOpaque(false);
        }
    }
}

