/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartogram;

import com.macrofocus.color.ColormapModel;
import com.macrofocus.colormap.ColorMap;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.data.table.Column;
import com.macrofocus.data.table.Row;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.geo.model.GeoListener;
import com.macrofocus.geo.model.GeoModel;
import com.macrofocus.util.range.MBoundedRangeModel;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import javax.swing.table.TableModel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class InputLayerModel
implements GeoModel {
    double PADDING = 1.5;
    double MAXNSQLOG = 18.0;
    private final LinkedList<Geometry> polygons;
    private Rectangle2D.Double bounds;
    private GeoModel layer;
    private final int lx;
    private final int ly;
    private final double xstepsize;
    private final double ystepsize;
    private final double maxx;
    private final double maxy;
    private final double minx;
    private final double miny;

    public InputLayerModel(GeoModel geoModel) {
        this.layer = geoModel;
        this.polygons = new LinkedList();
        this.bounds = null;
        double polymaxx = geoModel.getBounds().getMaxX();
        double polymaxy = geoModel.getBounds().getMaxY();
        double polyminx = geoModel.getBounds().getMinX();
        double polyminy = geoModel.getBounds().getMinY();
        double ratiolog = Math.ceil(Math.log((polymaxx - polyminx) / (polymaxy - polyminy)) / Math.log(2.0)) + Math.floor(Math.log((polymaxx - polyminx) / (polymaxy - polyminy)) / Math.log(2.0)) > 2.0 * Math.log((polymaxx - polyminx) / (polymaxy - polyminy)) / Math.log(2.0) ? (double)((int)Math.floor(Math.log((polymaxx - polyminx) / (polymaxy - polyminy)) / Math.log(2.0))) : (double)((int)Math.ceil(Math.log((polymaxx - polyminx) / (polymaxy - polyminy)) / Math.log(2.0)));
        this.lx = (int)Math.pow(2.0, (int)(0.5 * (ratiolog + this.MAXNSQLOG)));
        this.ly = (int)Math.pow(2.0, (int)(0.5 * (this.MAXNSQLOG - ratiolog)));
        if ((polymaxx - polyminx) / (double)this.lx > (polymaxy - polyminy) / (double)this.ly) {
            this.maxx = 0.5 * ((1.0 + this.PADDING) * polymaxx + (1.0 - this.PADDING) * polyminx);
            this.minx = 0.5 * ((1.0 - this.PADDING) * polymaxx + (1.0 + this.PADDING) * polyminx);
            this.maxy = 0.5 * (polymaxy + polyminy + (this.maxx - this.minx) * (double)this.ly / (double)this.lx);
            this.miny = 0.5 * (polymaxy + polyminy - (this.maxx - this.minx) * (double)this.ly / (double)this.lx);
        } else {
            this.maxy = 0.5 * ((1.0 + this.PADDING) * polymaxy + (1.0 - this.PADDING) * polyminy);
            this.miny = 0.5 * ((1.0 - this.PADDING) * polymaxy + (1.0 + this.PADDING) * polyminy);
            this.maxx = 0.5 * (polymaxx + polyminx + (this.maxy - this.miny) * (double)this.lx / (double)this.ly);
            this.minx = 0.5 * (polymaxx + polyminx - (this.maxy - this.miny) * (double)this.lx / (double)this.ly);
        }
        this.xstepsize = (this.maxx - this.minx) / (double)this.lx;
        this.ystepsize = (this.maxy - this.miny) / (double)this.ly;
        if (Math.abs(this.xstepsize / this.ystepsize - 1.0) > 0.001) {
            System.err.println("WARNING: Area elements are not square: " + this.xstepsize + " : " + this.ystepsize);
        }
        for (int row = 0; row < geoModel.getRowCount(); ++row) {
            Geometry copy;
            Geometry po = geoModel.getGeometry(row);
            if (po instanceof MultiPolygon) {
                copy = (Geometry)po.clone();
                copy.apply(new CoordinateFilter(){

                    public void filter(Coordinate coordinate) {
                        coordinate.x = (coordinate.x - InputLayerModel.this.minx) / InputLayerModel.this.xstepsize;
                        coordinate.y = (coordinate.y - InputLayerModel.this.miny) / InputLayerModel.this.ystepsize;
                    }
                });
                copy.geometryChanged();
                this.addPolygon((MultiPolygon)copy);
                continue;
            }
            if (po instanceof MultiPolygon || po instanceof Polygon) {
                copy = (Geometry)po.clone();
                copy.apply(new CoordinateFilter(){

                    public void filter(Coordinate coordinate) {
                        coordinate.x = (coordinate.x - InputLayerModel.this.minx) / InputLayerModel.this.xstepsize;
                        coordinate.y = (coordinate.y - InputLayerModel.this.miny) / InputLayerModel.this.ystepsize;
                    }
                });
                copy.geometryChanged();
                this.addPolygon((Polygon)copy);
                continue;
            }
            if (po != null) {
                System.err.println("Unsupported geometry for " + po.getClass());
            }
            this.addPolygon((Polygon)null);
        }
        this.updateBounds();
    }

    public String getName() {
        return "Input";
    }

    public void addPolygon(Polygon polygon) {
        if (polygon != null) {
            Envelope e = polygon.getEnvelopeInternal();
            if (this.bounds != null) {
                this.bounds.add(e.getMinX(), e.getMinY());
                this.bounds.add(e.getMaxX(), e.getMaxY());
            } else {
                this.bounds = new Rectangle2D.Double(e.getMinX(), e.getMinY(), e.getWidth(), e.getHeight());
            }
        }
        this.polygons.add((Geometry)polygon);
    }

    public void addPolygon(MultiPolygon polygon) {
        if (polygon != null) {
            Envelope e = polygon.getEnvelopeInternal();
            if (this.bounds != null) {
                this.bounds.add(e.getMinX(), e.getMinY());
                this.bounds.add(e.getMaxX(), e.getMaxY());
            } else {
                this.bounds = new Rectangle2D.Double(e.getMinX(), e.getMinY(), e.getWidth(), e.getHeight());
            }
        }
        this.polygons.add((Geometry)polygon);
    }

    private void updateBounds() {
        this.bounds = null;
        for (int r = 0; r < this.getRowCount(); ++r) {
            Geometry g = this.getGeometry(r);
            if (g == null) continue;
            Envelope e = g.getEnvelopeInternal();
            if (this.bounds != null) {
                this.bounds.add(e.getMinX(), e.getMinY());
                this.bounds.add(e.getMaxX(), e.getMaxY());
                continue;
            }
            this.bounds = new Rectangle2D.Double(e.getMinX(), e.getMinY(), e.getWidth(), e.getHeight());
        }
    }

    public Rectangle2D.Double getBounds() {
        return this.bounds;
    }

    public Geometry getGeometry(int index) {
        return this.polygons.get(index);
    }

    public Image getImage(int row) {
        return null;
    }

    public MutableSingleSelection<Column> getImageColumn() {
        return null;
    }

    public int getRowCount() {
        return this.polygons.size();
    }

    public TableModel getTableModel() {
        return this.layer.getTableModel();
    }

    public int getLX() {
        return this.lx;
    }

    public int getLY() {
        return this.ly;
    }

    public double getMaxx() {
        return this.maxx;
    }

    public double getMaxy() {
        return this.maxy;
    }

    public double getMinx() {
        return this.minx;
    }

    public double getMiny() {
        return this.miny;
    }

    public double getXstepsize() {
        return this.xstepsize;
    }

    public double getYstepsize() {
        return this.ystepsize;
    }

    public void setGeometryColumn(int geometryColumn) {
    }

    public int getColumnCount() {
        return this.layer.getColumnCount();
    }

    public Row getRow(int row) {
        return this.layer.getRow(row);
    }

    public Column findColumn(String name) {
        throw new UnsupportedOperationException();
    }

    public Column getColumn(int column) {
        return this.layer.getColumn(column);
    }

    public MutableSingleSelection<Column> getColorColumn() {
        return this.layer.getColorColumn();
    }

    public MutableSingleSelection<Column> getLabelColumn() {
        return null;
    }

    public MBoundedRangeModel getColorRangeModel(Column column) {
        return this.layer.getColorRangeModel(column);
    }

    public ColorMap getColormap(Column column) {
        return null;
    }

    public void setColormap(Column column, ColorMap colormap) {
    }

    public MutableSingleSelection<ColormapModel> getColormap() {
        return this.layer.getColormap();
    }

    public MutableSingleSelection<Row> getProbing() {
        return this.layer.getProbing();
    }

    public MutableSelection<Row> getSelection() {
        return this.layer.getSelection();
    }

    public MutableFilter<Row> getFilter() {
        return this.layer.getFilter();
    }

    public void apply(int column, CoordinateFilter coordinateFilter) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            ((Geometry)this.getTableModel().getValueAt(row, column)).apply(coordinateFilter);
        }
        this.updateBounds();
    }

    public void apply(CoordinateFilter coordinateFilter) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.getGeometry(row).apply(coordinateFilter);
        }
        this.updateBounds();
    }

    public void addListener(GeoListener treeMapListener) {
    }

    public void removeListener(GeoListener treeMapListener) {
    }
}

