/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartogram.math;

public final class Tensor {
    private final double[][][] t;
    private final int rows;
    private final int columns;
    private final int deps;

    public Tensor(int rows, int columns, int deps) {
        this.rows = rows;
        this.columns = columns;
        this.deps = deps;
        assert (rows > 0);
        assert (columns > 0);
        assert (deps > 0);
        this.t = new double[rows][columns][deps];
    }

    public final double getValue(int row, int column, int dep) {
        return this.t[row - 1][column - 1][dep - 1];
    }

    public final void setValue(int row, int column, int dep, double value) {
        this.t[row - 1][column - 1][dep - 1] = value;
    }

    public final double getValue(int index) {
        int i = index - 1;
        int columnSize = this.columns * this.deps;
        int row = i / columnSize;
        int column = (i - row) / this.deps;
        return this.t[row][column][i % this.deps];
    }

    public final void setValue(int index, double value) {
        int i = index - 1;
        int columnSize = this.columns * this.deps;
        int row = i / columnSize;
        int column = (i - row) / this.deps;
        this.t[row][column][i % this.deps] = value;
    }
}

