/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.FundOScope.vector;

import com.macrofocus.FundOScope.vector.IntegerVectorModel;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SimpleIntegerVectorModel
implements IntegerVectorModel,
Serializable {
    static final long serialVersionUID = 7401449300510395665L;
    private Vector vector;

    public SimpleIntegerVectorModel() {
        this.vector = new Vector();
    }

    public SimpleIntegerVectorModel(String value) {
        StringTokenizer st = new StringTokenizer(value, ",");
        int count = st.countTokens();
        this.vector = new Vector(count);
        for (int index = 0; index < count; ++index) {
            this.vector.addElement(Integer.valueOf(st.nextToken().trim()));
        }
    }

    public SimpleIntegerVectorModel(int[] values) {
        this.vector = new Vector(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.vector.addElement(values[i]);
        }
    }

    @Override
    public int getInteger(int index) {
        return (Integer)this.getObject(index);
    }

    @Override
    public void addInteger(Object source, int value) {
        this.addObject(source, value);
    }

    @Override
    public void removeInteger(Object source, int value) {
        this.removeObject(source, value);
    }

    @Override
    public Object getObject(int index) {
        return this.vector.elementAt(index);
    }

    @Override
    public void addObject(Object source, Object value) {
        this.vector.addElement(value);
    }

    private void removeObject(Object source, Object value) {
        this.vector.removeElement(value);
    }

    @Override
    public int getObjectCount() {
        return this.vector.size();
    }

    public String toString() {
        String string = "";
        for (int index = 0; index < this.getObjectCount(); ++index) {
            string = string + this.getObject(index).toString();
            if (index + 1 >= this.getObjectCount()) continue;
            string = string + ",";
        }
        return string;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(10000);
        out.writeObject(this.vector);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 10000) {
            this.vector = (Vector)in.readObject();
        }
    }
}

