/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.color;

import com.macrofocus.color.ColorModel;
import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.StringTokenizer;

public class RGBAColorModel
implements ColorModel,
Externalizable {
    static final long serialVersionUID = -4699260146629055095L;
    private Color color;
    private int rgba;
    private int rgb;
    private int red;
    private int green;
    private int blue;
    private int alpha;

    public RGBAColorModel() {
    }

    public RGBAColorModel(String colorName) {
        StringTokenizer st = new StringTokenizer(colorName, ",");
        this.red = Integer.valueOf(st.nextToken().trim());
        this.green = Integer.valueOf(st.nextToken().trim());
        this.blue = Integer.valueOf(st.nextToken().trim());
        int alpha = 255;
        if (st.hasMoreTokens()) {
            alpha = Integer.valueOf(st.nextToken().trim());
        }
        this.alpha = alpha;
        this.color = new Color(this.red, this.green, this.blue, alpha);
        this.rgba = (alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
        this.rgb = this.rgba & 0xFFFFFF | 0xFF000000;
    }

    public RGBAColorModel(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.color = new Color(this.red, this.green, this.blue, this.alpha);
        this.rgba = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        this.rgb = this.rgba & 0xFFFFFF | 0xFF000000;
    }

    public RGBAColorModel(byte red, byte green, byte blue) {
        this(red + 128, green + 128, blue + 128, 255);
    }

    public RGBAColorModel(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public RGBAColorModel(Color color) {
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        this.alpha = color.getAlpha();
        this.color = color;
        this.rgba = (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
        this.rgb = this.rgba & 0xFFFFFF | 0xFF000000;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public int getRGBA() {
        return this.rgba;
    }

    @Override
    public int getRGB() {
        return this.rgb;
    }

    @Override
    public int getRed() {
        return this.red;
    }

    @Override
    public int getGreen() {
        return this.green;
    }

    @Override
    public int getBlue() {
        return this.blue;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public ColorModel createBrighter(int increment) {
        return new RGBAColorModel(Math.min(this.red + increment, 255), Math.min(this.green + increment, 255), Math.min(this.blue + increment, 255));
    }

    @Override
    public ColorModel createDarker(int increment) {
        return new RGBAColorModel(Math.max(this.red - increment, 0), Math.max(this.green - increment, 0), Math.max(this.blue - increment, 0));
    }

    @Override
    public ColorModel createBrighter() {
        int increment = 100;
        return new RGBAColorModel(Math.min(this.red + increment, 255), Math.min(this.green + increment, 255), Math.min(this.blue + increment, 255));
    }

    @Override
    public ColorModel createDarker() {
        int increment = 100;
        return new RGBAColorModel(Math.max(this.red - increment, 0), Math.max(this.green - increment, 0), Math.max(this.blue - increment, 0));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(10000);
        out.writeObject(this.color);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 10000) {
            this.color = (Color)in.readObject();
            this.red = this.color.getRed();
            this.green = this.color.getGreen();
            this.blue = this.color.getBlue();
            this.alpha = this.color.getAlpha();
            this.rgba = (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
            this.rgb = this.rgba & 0xFFFFFF | 0xFF000000;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + this.red + ", g=" + this.green + ", b=" + this.blue + ", a=" + this.alpha + "]";
    }
}

