/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.color;

import com.macrofocus.color.ColorModel;
import com.macrofocus.helper.ColorHelper;
import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.StringTokenizer;

public class RGBColorModel
implements ColorModel,
Externalizable {
    static final long serialVersionUID = -4699260146629055095L;
    private Color color;
    private int rgba;
    private int rgb;
    private int red;
    private int green;
    private int blue;
    private int alpha;

    public RGBColorModel() {
    }

    public RGBColorModel(String colorName) {
        StringTokenizer st = new StringTokenizer(colorName, ",");
        int red = Integer.valueOf(st.nextToken().trim());
        int green = Integer.valueOf(st.nextToken().trim());
        int blue = Integer.valueOf(st.nextToken().trim());
        int alpha = 255;
        if (st.hasMoreTokens()) {
            alpha = Integer.valueOf(st.nextToken().trim());
        }
        this.alpha = alpha;
        this.red = ColorHelper.intMult((int)alpha, (int)red);
        this.green = ColorHelper.intMult((int)alpha, (int)green);
        this.blue = ColorHelper.intMult((int)alpha, (int)blue);
        this.color = new Color(red, green, blue);
        this.rgba = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        this.rgb = this.rgba & 0xFFFFFF | 0xFF000000;
    }

    public RGBColorModel(int red, int green, int blue, int alpha) {
        this.red = ColorHelper.intMult((int)alpha, (int)red);
        this.green = ColorHelper.intMult((int)alpha, (int)green);
        this.blue = ColorHelper.intMult((int)alpha, (int)blue);
        this.alpha = alpha;
        this.color = new Color(this.red, this.green, this.blue);
        this.rgba = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        this.rgb = this.rgba & 0xFFFFFF | 0xFF000000;
    }

    public RGBColorModel(byte red, byte green, byte blue) {
        this(red + 128, green + 128, blue + 128, 255);
    }

    public RGBColorModel(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public RGBColorModel(Color color) {
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        this.alpha = 255;
        this.color = color;
        this.rgba = (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
        this.rgb = this.rgba & 0xFFFFFF | 0xFF000000;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public int getRGBA() {
        return this.rgba;
    }

    @Override
    public int getRGB() {
        return this.rgb;
    }

    @Override
    public int getRed() {
        return this.red;
    }

    @Override
    public int getGreen() {
        return this.green;
    }

    @Override
    public int getBlue() {
        return this.blue;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public ColorModel createBrighter(int increment) {
        return new RGBColorModel(Math.min(this.red + increment, 255), Math.min(this.green + increment, 255), Math.min(this.blue + increment, 255));
    }

    @Override
    public ColorModel createDarker(int increment) {
        return new RGBColorModel(Math.max(this.red - increment, 0), Math.max(this.green - increment, 0), Math.max(this.blue - increment, 0));
    }

    @Override
    public ColorModel createBrighter() {
        int increment = 100;
        return new RGBColorModel(Math.min(this.red + increment, 255), Math.min(this.green + increment, 255), Math.min(this.blue + increment, 255));
    }

    @Override
    public ColorModel createDarker() {
        int increment = 100;
        return new RGBColorModel(Math.max(this.red - increment, 0), Math.max(this.green - increment, 0), Math.max(this.blue - increment, 0));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(10000);
        out.writeObject(this.color);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 10000) {
            this.color = (Color)in.readObject();
            this.red = this.color.getRed();
            this.green = this.color.getGreen();
            this.blue = this.color.getBlue();
            this.alpha = this.color.getAlpha();
            this.rgba = (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
            this.rgb = this.rgba & 0xFFFFFF | 0xFF000000;
        }
    }

    public String toString() {
        return this.red + "," + this.green + "," + this.blue;
    }
}

