/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.data.DataModel;
import com.macrofocus.data.column.ColumnModel;
import com.macrofocus.data.column.DataModelColumnModel;
import com.macrofocus.data.row.DataModelRowModel;
import com.macrofocus.data.row.RowModel;
import com.macrofocus.resources.LocaleHelper;
import java.util.Enumeration;
import java.util.Locale;

public abstract class AbstractDataModel
implements DataModel {
    @Override
    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            Object columnName = this.getColumnName(i);
            if (columnName == null) continue;
            if (columnName instanceof String && name instanceof String) {
                if (!((String)columnName).trim().equals(((String)name).trim())) continue;
                index = i;
                break;
            }
            if (!columnName.equals(name)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public int getLocalizedColumnIndex(Object name, Locale locale) {
        Enumeration enumeration = LocaleHelper.getCandidates((Locale)locale);
        while (enumeration.hasMoreElements()) {
            String s2 = (String)enumeration.nextElement();
            String localizedName = name + s2;
            int index = this.getColumnIndex(localizedName);
            if (index < 0) continue;
            return index;
        }
        return -1;
    }

    @Override
    public RowModel getRowModel(int row) {
        return new DataModelRowModel(this, row);
    }

    @Override
    public ColumnModel getColumnModel(int column) {
        if (column >= 0) {
            return new DataModelColumnModel(this, column);
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[columnCount=" + this.getColumnCount() + ",rowCount=" + this.getRowCount() + "]";
    }
}

