/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.data.AbstractDataModel;
import com.macrofocus.data.MutableDataEvent;
import com.macrofocus.data.MutableDataListener;
import com.macrofocus.data.MutableDataModel;
import java.io.BufferedWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AbstractMutableDataModel
extends AbstractDataModel
implements MutableDataModel {
    private final Vector mutableDataListeners = new Vector();

    @Override
    public void addMutableDataListener(MutableDataListener mutableDataListener) {
        this.mutableDataListeners.addElement(mutableDataListener);
    }

    @Override
    public void removeMutableDataListener(MutableDataListener mutableDataListener) {
        this.mutableDataListeners.removeElement(mutableDataListener);
    }

    protected void notifyMutableDataChanged(MutableDataEvent event) {
        Enumeration enumeration = this.mutableDataListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MutableDataListener)enumeration.nextElement()).mutableDataChanged(event);
        }
    }

    protected void notifyMutableDataChangedAll(MutableDataEvent event) {
        Enumeration enumeration = this.mutableDataListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MutableDataListener)enumeration.nextElement()).mutableDataChangedAll(event);
        }
    }

    public void save(Writer writer) throws Exception {
        int column;
        BufferedWriter out = new BufferedWriter(writer);
        for (column = 0; column < this.getColumnCount(); ++column) {
            out.write(this.getColumnName(column).toString());
            if (column >= this.getColumnCount() - 1) continue;
            out.write(9);
        }
        out.newLine();
        for (column = 0; column < this.getColumnCount(); ++column) {
            out.write(this.getColumnClass(column).getName());
            if (column >= this.getColumnCount() - 1) continue;
            out.write(9);
        }
        out.newLine();
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column2 = 0; column2 < this.getColumnCount(); ++column2) {
                if (this.isAvailable(row, column2)) {
                    out.write(this.getValueAt(row, column2).toString());
                } else {
                    out.write("n.a.");
                }
                if (column2 >= this.getColumnCount() - 1) continue;
                out.write(9);
            }
            if (row >= this.getRowCount() - 1) continue;
            out.newLine();
        }
        writer.flush();
        writer.close();
    }
}

