/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.AbstractDataModel;
import com.macrofocus.data.DataModel;

public class AutoTypeDataModel
extends AbstractDataModel {
    private final DataModel dataModel;
    private final Class[] cl;

    public AutoTypeDataModel(DataModel dataModel, Class[] cl) {
        this.dataModel = dataModel;
        this.cl = cl;
    }

    public AutoTypeDataModel(DataModel dataModel) {
        int c;
        this.dataModel = dataModel;
        this.cl = new Class[dataModel.getColumnCount()];
        for (c = 0; c < dataModel.getColumnCount(); ++c) {
            this.cl[c] = Double.class;
        }
        for (c = 0; c < dataModel.getColumnCount(); ++c) {
            String s;
            Object v;
            int r;
            for (r = 0; r < dataModel.getRowCount() && this.cl[c] == Double.class; ++r) {
                if (!dataModel.isAvailable(r, c) || (v = dataModel.getValueAt(r, c)) == null) continue;
                if (v instanceof String) {
                    s = (String)v;
                    if (s.trim().equals("")) continue;
                    try {
                        Double.valueOf(s);
                    }
                    catch (NumberFormatException e) {
                        this.cl[c] = String.class;
                    }
                    continue;
                }
                if (v instanceof Double || v instanceof Integer) continue;
                this.cl[c] = String.class;
            }
            if (this.cl[c] != Double.class) continue;
            this.cl[c] = Integer.class;
            for (r = 0; r < dataModel.getRowCount() && this.cl[c] == Integer.class; ++r) {
                if (!dataModel.isAvailable(r, c) || (v = dataModel.getValueAt(r, c)) == null) continue;
                if (v instanceof String) {
                    s = (String)v;
                    if (s.trim().equals("")) continue;
                    try {
                        Integer.valueOf(s);
                    }
                    catch (NumberFormatException e) {
                        this.cl[c] = Double.class;
                    }
                    continue;
                }
                if (v instanceof Integer) continue;
                this.cl[c] = Double.class;
            }
        }
    }

    @Override
    public Class getColumnClass(int column) {
        return this.cl[column];
    }

    @Override
    public int getColumnCount() {
        return this.dataModel.getColumnCount();
    }

    @Override
    public Object getColumnName(int column) {
        return this.dataModel.getColumnName(column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object v = this.dataModel.getValueAt(row, column);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            String s = (String)v;
            if (this.cl[column] == Double.class) {
                if (!s.trim().equals("")) {
                    try {
                        return Double.valueOf((String)v);
                    }
                    catch (NumberFormatException e) {
                        Logging.getInstance().process((Throwable)e);
                        return null;
                    }
                }
                return null;
            }
            if (this.cl[column] == Long.class) {
                if (!s.trim().equals("")) {
                    try {
                        return Long.valueOf((String)v);
                    }
                    catch (NumberFormatException e) {
                        Logging.getInstance().process((Throwable)e);
                        return null;
                    }
                }
                return null;
            }
            if (this.cl[column] == Float.class) {
                if (!s.trim().equals("")) {
                    try {
                        return Float.valueOf((String)v);
                    }
                    catch (NumberFormatException e) {
                        Logging.getInstance().process((Throwable)e);
                        return null;
                    }
                }
                return null;
            }
            if (this.cl[column] == Integer.class) {
                if (!s.trim().equals("")) {
                    try {
                        return Integer.valueOf((String)v);
                    }
                    catch (NumberFormatException e) {
                        Logging.getInstance().process((Throwable)e);
                        return null;
                    }
                }
                return null;
            }
            return v;
        }
        if (this.cl[column] == v.getClass()) {
            return v;
        }
        if (this.cl[column] == String.class) {
            return v.toString();
        }
        throw new UnsupportedOperationException("Unsuported type " + this.cl[column]);
    }

    @Override
    public int getRowCount() {
        return this.dataModel.getRowCount();
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return this.dataModel.isAvailable(row, column);
    }
}

