/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.data.DataModel;
import com.macrofocus.molap.dataframe.AbstractDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.IntegerRangeUniqueIndex;
import com.macrofocus.molap.index.MultiKey;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.series.AbstractSeries;
import com.macrofocus.molap.series.Series;

public class DataModelDataFrame
extends AbstractDataFrame<Integer, String, Object>
implements MutableDataFrame<Integer, String, Object> {
    private final DataModel tableModel;
    private UniqueIndex<Integer> rowIndex = null;
    private UniqueIndex<String> columnIndex = null;

    public DataModelDataFrame(DataModel tableModel) {
        this.tableModel = tableModel;
    }

    public Class getRowClass(Integer row) {
        return Object.class;
    }

    public Class getColumnClass(String column) {
        return this.tableModel.getColumnClass(this.getColumnIndex().getAddress((Object)column));
    }

    public Object getValueAt(Integer row, String column) {
        return this.tableModel.getValueAt(row, this.getColumnIndex().getAddress((Object)column));
    }

    public void setValueAt(Integer row, String column, Object value) {
    }

    public Series<String, ?> getRow(Integer row) {
        return null;
    }

    public Series<Integer, Object> getColumn(String column) {
        return new ColumnSeries(column);
    }

    public Iterable<Integer> rows() {
        return this.getRowIndex().keys();
    }

    public Iterable<String> columns() {
        return this.getColumnIndex().keys();
    }

    public Integer getRowKey(int index) {
        return (Integer)this.getRowIndex().getKey(index);
    }

    public String getColumnKey(int index) {
        return (String)this.getColumnIndex().getKey(index);
    }

    public int getRowAddress(Integer row) {
        return this.getRowIndex().getAddress((Object)row);
    }

    public int getColumnAddress(String column) {
        return this.getColumnIndex().getAddress((Object)column);
    }

    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    public MutableDataFrame<MultiKey, String, Object> reindexRowsUsingColumns(String ... rows) {
        return null;
    }

    public DataFrame join(Series series, String[] columns) {
        return null;
    }

    public UniqueIndex<Integer> getRowIndex() {
        if (this.rowIndex == null) {
            this.rowIndex = new IntegerRangeUniqueIndex(0, this.tableModel.getRowCount() - 1);
        }
        return this.rowIndex;
    }

    public UniqueIndex<String> getColumnIndex() {
        if (this.columnIndex == null) {
            Object[] names = new String[this.tableModel.getColumnCount()];
            for (int c = 0; c < this.tableModel.getColumnCount(); ++c) {
                names[c] = this.tableModel.getColumnName(c).toString();
            }
            this.columnIndex = new DefaultUniqueIndex(names);
        }
        return this.columnIndex;
    }

    private class ColumnSeries
    extends AbstractSeries<Integer, Object> {
        private final String column;

        private ColumnSeries(String column) {
            assert (column != null);
            this.column = column;
        }

        public Object getName() {
            return this.column;
        }

        public Class getType() {
            return DataModelDataFrame.this.getColumnClass(this.column);
        }

        public Object get(Integer key) {
            return DataModelDataFrame.this.getValueAt(key, this.column);
        }

        public Integer getKey(int i) {
            return DataModelDataFrame.this.getRowKey(i);
        }

        public int size() {
            return DataModelDataFrame.this.getRowCount();
        }

        public int getAddress(Integer key) {
            return DataModelDataFrame.this.getRowAddress(key);
        }

        public Iterable<Integer> keys() {
            return DataModelDataFrame.this.rows();
        }

        public <L> Series<L, Object> reindex(L ... keys) {
            return null;
        }

        public Series<Integer, Object> head(int count) {
            return null;
        }

        public Series<Integer, Object> tail(int count) {
            return null;
        }
    }
}

