/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.AbstractDataModel;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.reader.DataReader;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;

public final class SimpleDataModel
extends AbstractDataModel
implements Externalizable {
    static final long serialVersionUID = -3175316423606085277L;
    private Object[][] objects;
    private Object[] columnNames;
    private Class[] classes;

    public SimpleDataModel() {
    }

    public SimpleDataModel(DataModel dataModel) {
        this.columnNames = new Object[dataModel.getColumnCount()];
        this.classes = new Class[dataModel.getColumnCount()];
        this.objects = new Object[dataModel.getRowCount()][dataModel.getColumnCount()];
        for (int column = 0; column < dataModel.getColumnCount(); ++column) {
            this.columnNames[column] = dataModel.getColumnName(column);
            this.classes[column] = dataModel.getColumnClass(column);
            for (int row = 0; row < dataModel.getRowCount(); ++row) {
                this.objects[row][column] = dataModel.isAvailable(row, column) ? dataModel.getValueAt(row, column) : null;
            }
        }
    }

    public SimpleDataModel(Reader reader) {
        int dimCount = 0;
        String token = "";
        LineNumberReader lnr = new LineNumberReader(reader);
        Vector array = new Vector();
        try {
            String s;
            StringTokenizer header1 = new StringTokenizer(lnr.readLine(), "\t");
            StringTokenizer header2 = new StringTokenizer(lnr.readLine(), "\t");
            dimCount = header2.countTokens();
            this.columnNames = new Object[dimCount];
            this.classes = new Class[dimCount];
            Constructor[] constructors = new Constructor[dimCount];
            Class[] cl = new Class[]{String.class};
            for (int i = 0; i < dimCount; ++i) {
                this.columnNames[i] = header1.nextToken();
                String c = header2.nextToken();
                try {
                    this.classes[i] = Class.forName(c);
                }
                catch (ClassNotFoundException e) {
                    this.classes[i] = Class.forName("java.lang." + c);
                }
                if (this.classes[i] == null) {
                    throw new ClassNotFoundException(c);
                }
                constructors[i] = this.classes[i].getConstructor(cl);
                if (constructors[i] != null) continue;
                throw new ClassNotFoundException(cl.toString());
            }
            while (lnr.ready() && (s = lnr.readLine()) != null) {
                Vector vector = new Vector(dimCount);
                StringTokenizer st = new StringTokenizer(s, "\t");
                for (int i = 0; i < dimCount; ++i) {
                    token = st.hasMoreTokens() ? st.nextToken().trim() : null;
                    if (token == null || token.equals("") || token.equals("n.a.") || token.equals("N/A") || token.equals("x") || token.equals("NaN") || token.equals("---") || token.equals("Infinity") || token.equals("-Infinity")) {
                        vector.addElement(null);
                        continue;
                    }
                    Object[] initargs = new Object[]{token};
                    try {
                        Object feature = constructors[i].newInstance(initargs);
                        if (feature == null) {
                            System.err.println("Instantiation failed for " + token + " as " + constructors[i] + " at line " + lnr.getLineNumber());
                            throw new NoSuchFieldException("Instantiation failed for " + token + ",constructor=" + constructors[i]);
                        }
                        vector.addElement(feature);
                        continue;
                    }
                    catch (Exception e) {
                        Logging.getInstance().process((Throwable)e);
                        System.err.println("Instantiation failed for " + token + " as " + constructors[i] + " at line " + lnr.getLineNumber());
                    }
                }
                array.addElement(vector);
            }
            this.objects = new Object[array.size()][dimCount];
            for (int j = 0; j < dimCount; ++j) {
                for (int i = 0; i < array.size(); ++i) {
                    Object value = ((Vector)array.elementAt(i)).elementAt(j);
                    this.objects[i][j] = value;
                }
            }
        }
        catch (Exception e) {
            Logging.getInstance().process((Throwable)e);
            System.out.println("Error in reading line number " + lnr.getLineNumber() + ". Token is " + token);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public SimpleDataModel(DataReader reader) {
        try {
            this.columnNames = new Object[reader.getColumnCount()];
            this.classes = new Class[reader.getColumnCount()];
            for (int i = 0; i < reader.getColumnCount(); ++i) {
                this.columnNames[i] = reader.getColumnName(i);
                this.classes[i] = reader.getClass(i);
            }
            Object[] previousVector = null;
            if (reader.getRowCount() == -1) {
                ArrayList<Object[]> array = new ArrayList<Object[]>();
                while (reader.hasMoreRow()) {
                    reader.nextRow();
                    if (!reader.hasMoreColumn()) continue;
                    Object[] vector = new Object[reader.getColumnCount()];
                    boolean dataFound = false;
                    for (int i = 0; i < reader.getColumnCount(); ++i) {
                        if (reader.hasMoreColumn()) {
                            Object feature = reader.nextColumn();
                            if (feature == null) continue;
                            vector[i] = feature;
                            if (previousVector != null && previousVector[i] != null && previousVector[i].equals(vector[i])) {
                                vector[i] = previousVector[i];
                            }
                            dataFound = true;
                            continue;
                        }
                        vector[i] = null;
                    }
                    if (!dataFound) continue;
                    array.add(vector);
                    previousVector = vector;
                }
                this.objects = new Object[array.size()][];
                for (int row = 0; row < array.size(); ++row) {
                    this.objects[row] = (Object[])array.get(row);
                }
            } else {
                this.objects = new Object[reader.getRowCount()][reader.getColumnCount()];
                for (int row = 0; row < reader.getRowCount(); ++row) {
                    for (int column = 0; column < reader.getColumnCount(); ++column) {
                        Object o = reader.nextColumn();
                        if (row > 0 && this.objects[row - 1][column] != null && this.objects[row - 1][column].equals(o)) {
                            o = this.objects[row - 1][column];
                        }
                        this.objects[row][column] = o;
                    }
                    reader.nextRow();
                }
            }
        }
        catch (Exception e) {
            Logging.getInstance().process((Throwable)e);
            System.out.println("Error in reading line number " + reader.getLineNumber());
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.objects[row][column];
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return this.objects[row][column] != null;
    }

    @Override
    public Object getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class getColumnClass(int column) {
        return this.classes[column];
    }

    @Override
    public int getRowCount() {
        return this.objects.length;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int column;
        out.writeInt(10000);
        out.writeInt(this.getRowCount());
        out.writeInt(this.getColumnCount());
        for (column = 0; column < this.getColumnCount(); ++column) {
            out.writeObject(this.columnNames[column]);
        }
        for (column = 0; column < this.getColumnCount(); ++column) {
            out.writeObject(this.classes[column]);
        }
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column2 = 0; column2 < this.getColumnCount(); ++column2) {
                out.writeBoolean(this.isAvailable(row, column2));
            }
        }
        for (column = 0; column < this.getColumnCount(); ++column) {
            int row;
            Class cl = this.getColumnClass(column);
            if (cl == Double.class) {
                for (row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    if (this.objects[row][column] instanceof Number) {
                        out.writeDouble(((Number)this.objects[row][column]).doubleValue());
                        continue;
                    }
                    Logging.getInstance().process((Throwable)new ClassCastException("Row " + row + ", column " + column + ": " + this.objects[row][column].getClass().getSimpleName() + " (" + this.objects[row][column] + ") cannot be cast to Number"));
                }
                continue;
            }
            if (cl == Float.class) {
                for (row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    if (this.objects[row][column] instanceof Float) {
                        out.writeFloat(((Float)this.objects[row][column]).floatValue());
                        continue;
                    }
                    Logging.getInstance().process((Throwable)new ClassCastException("Row " + row + ", column " + column + ": " + this.objects[row][column].getClass().getSimpleName() + " (" + this.objects[row][column] + ") cannot be cast to Float"));
                }
                continue;
            }
            if (cl == Long.class) {
                for (row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    if (this.objects[row][column] instanceof Long) {
                        out.writeLong((Long)this.objects[row][column]);
                        continue;
                    }
                    Logging.getInstance().process((Throwable)new ClassCastException("Row " + row + ", column " + column + ": " + this.objects[row][column].getClass().getSimpleName() + " (" + this.objects[row][column] + ") cannot be cast to Long"));
                }
                continue;
            }
            if (cl == Integer.class) {
                for (row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    if (this.objects[row][column] instanceof Integer) {
                        out.writeInt((Integer)this.objects[row][column]);
                        continue;
                    }
                    Logging.getInstance().process((Throwable)new ClassCastException("Row " + row + ", column " + column + ": " + this.objects[row][column].getClass().getSimpleName() + " (" + this.objects[row][column] + ") cannot be cast to Integer"));
                }
                continue;
            }
            if (cl == Short.class) {
                for (row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    if (this.objects[row][column] instanceof Short) {
                        out.writeShort(((Short)this.objects[row][column]).shortValue());
                        continue;
                    }
                    Logging.getInstance().process((Throwable)new ClassCastException("Row " + row + ", column " + column + ": " + this.objects[row][column].getClass().getSimpleName() + " (" + this.objects[row][column] + ") cannot be cast to Short"));
                }
                continue;
            }
            if (cl == Byte.class) {
                for (row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    if (this.objects[row][column] instanceof Byte) {
                        out.writeByte(((Byte)this.objects[row][column]).byteValue());
                        continue;
                    }
                    Logging.getInstance().process((Throwable)new ClassCastException("Row " + row + ", column " + column + ": " + this.objects[row][column].getClass().getSimpleName() + " (" + this.objects[row][column] + ") cannot be cast to Byte"));
                }
                continue;
            }
            if (cl == Boolean.class) {
                for (row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    if (this.objects[row][column] instanceof Boolean) {
                        out.writeBoolean((Boolean)this.objects[row][column]);
                        continue;
                    }
                    Logging.getInstance().process((Throwable)new ClassCastException("Row " + row + ", column " + column + ": " + this.objects[row][column].getClass().getSimpleName() + " (" + this.objects[row][column] + ") cannot be cast to Boolean"));
                }
                continue;
            }
            if (cl == BufferedImage.class) {
                for (row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    if (this.objects[row][column] instanceof BufferedImage) {
                        boolean useCache = ImageIO.getUseCache();
                        ImageIO.setUseCache(false);
                        ByteArrayOutputStream bao = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)((BufferedImage)this.objects[row][column]), "png", bao);
                        byte[] ba = bao.toByteArray();
                        out.writeObject(ba);
                        ImageIO.setUseCache(useCache);
                        continue;
                    }
                    Logging.getInstance().process((Throwable)new ClassCastException("Row " + row + ", column " + column + ": " + this.objects[row][column].getClass().getSimpleName() + "(" + this.objects[row][column] + ") cannot be cast to BufferedImage"));
                }
                continue;
            }
            for (row = 0; row < this.getRowCount(); ++row) {
                if (!this.isAvailable(row, column)) continue;
                out.writeObject(this.objects[row][column]);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version > 0) {
            int column;
            int rowCount = in.readInt();
            int columnCount = in.readInt();
            this.columnNames = new Object[columnCount];
            this.classes = new Class[columnCount];
            this.objects = new Object[rowCount][columnCount];
            for (column = 0; column < columnCount; ++column) {
                this.columnNames[column] = in.readObject();
            }
            for (column = 0; column < columnCount; ++column) {
                this.classes[column] = (Class)in.readObject();
            }
            boolean[][] isAvailable = new boolean[rowCount][columnCount];
            for (int row = 0; row < this.getRowCount(); ++row) {
                for (int column2 = 0; column2 < this.getColumnCount(); ++column2) {
                    isAvailable[row][column2] = in.readBoolean();
                }
            }
            for (int column3 = 0; column3 < this.getColumnCount(); ++column3) {
                int row;
                Class cl = this.getColumnClass(column3);
                if (cl == Double.class) {
                    for (row = 0; row < this.getRowCount(); ++row) {
                        if (isAvailable[row][column3]) {
                            Object o = in.readDouble();
                            if (row > 0 && o.equals(this.objects[row - 1][column3])) {
                                o = this.objects[row - 1][column3];
                            }
                            this.objects[row][column3] = o;
                            continue;
                        }
                        this.objects[row][column3] = null;
                    }
                    continue;
                }
                if (cl == Float.class) {
                    for (row = 0; row < this.getRowCount(); ++row) {
                        if (isAvailable[row][column3]) {
                            Object o = Float.valueOf(in.readFloat());
                            if (row > 0 && o.equals(this.objects[row - 1][column3])) {
                                o = this.objects[row - 1][column3];
                            }
                            this.objects[row][column3] = o;
                            continue;
                        }
                        this.objects[row][column3] = null;
                    }
                    continue;
                }
                if (cl == Long.class) {
                    for (row = 0; row < this.getRowCount(); ++row) {
                        if (isAvailable[row][column3]) {
                            Object o = in.readLong();
                            if (row > 0 && o.equals(this.objects[row - 1][column3])) {
                                o = this.objects[row - 1][column3];
                            }
                            this.objects[row][column3] = o;
                            continue;
                        }
                        this.objects[row][column3] = null;
                    }
                    continue;
                }
                if (cl == Integer.class) {
                    for (row = 0; row < this.getRowCount(); ++row) {
                        if (isAvailable[row][column3]) {
                            Object o = in.readInt();
                            if (row > 0 && o.equals(this.objects[row - 1][column3])) {
                                o = this.objects[row - 1][column3];
                            }
                            this.objects[row][column3] = o;
                            continue;
                        }
                        this.objects[row][column3] = null;
                    }
                    continue;
                }
                if (cl == Short.class) {
                    for (row = 0; row < this.getRowCount(); ++row) {
                        if (isAvailable[row][column3]) {
                            Object o = in.readShort();
                            if (row > 0 && o.equals(this.objects[row - 1][column3])) {
                                o = this.objects[row - 1][column3];
                            }
                            this.objects[row][column3] = o;
                            continue;
                        }
                        this.objects[row][column3] = null;
                    }
                    continue;
                }
                if (cl == Byte.class) {
                    for (row = 0; row < this.getRowCount(); ++row) {
                        if (isAvailable[row][column3]) {
                            Object o = new Byte(in.readByte());
                            if (row > 0 && o.equals(this.objects[row - 1][column3])) {
                                o = this.objects[row - 1][column3];
                            }
                            this.objects[row][column3] = o;
                            continue;
                        }
                        this.objects[row][column3] = null;
                    }
                    continue;
                }
                if (cl == Boolean.class) {
                    for (row = 0; row < this.getRowCount(); ++row) {
                        if (isAvailable[row][column3]) {
                            Object o = new Boolean(in.readBoolean());
                            if (row > 0 && o.equals(this.objects[row - 1][column3])) {
                                o = this.objects[row - 1][column3];
                            }
                            this.objects[row][column3] = o;
                            continue;
                        }
                        this.objects[row][column3] = null;
                    }
                    continue;
                }
                if (cl == BufferedImage.class) {
                    for (row = 0; row < this.getRowCount(); ++row) {
                        if (isAvailable[row][column3]) {
                            boolean useCache = ImageIO.getUseCache();
                            ImageIO.setUseCache(false);
                            byte[] array = (byte[])in.readObject();
                            ByteArrayInputStream bai = new ByteArrayInputStream(array);
                            Object o = ImageIO.read(bai);
                            ImageIO.setUseCache(useCache);
                            if (row > 0 && o.equals(this.objects[row - 1][column3])) {
                                o = this.objects[row - 1][column3];
                            }
                            this.objects[row][column3] = o;
                            continue;
                        }
                        this.objects[row][column3] = null;
                    }
                    continue;
                }
                if (this.getColumnClass(column3) != URL.class) {
                    for (row = 0; row < this.getRowCount(); ++row) {
                        if (isAvailable[row][column3]) {
                            Object o = in.readObject();
                            if (row > 0 && o.equals(this.objects[row - 1][column3])) {
                                o = this.objects[row - 1][column3];
                            }
                            this.objects[row][column3] = o;
                            continue;
                        }
                        this.objects[row][column3] = null;
                    }
                    continue;
                }
                for (row = 0; row < this.getRowCount(); ++row) {
                    Object o;
                    this.objects[row][column3] = isAvailable[row][column3] ? (o = in.readObject()) : null;
                }
            }
        }
    }
}

