/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.cleaning;

import com.macrofocus.data.AbstractDataModel;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.cleaning.CleaningModel;
import java.util.Vector;

public class DirtyDataModel
extends AbstractDataModel {
    private DataModel dataModel;
    private CleaningModel cleaningModel;
    private Vector rows;

    public DirtyDataModel(DataModel dataModel, CleaningModel cleaningModel) {
        this.dataModel = dataModel;
        this.rows = new Vector();
        cleaningModel.init();
        for (int row = 0; row < dataModel.getRowCount(); ++row) {
            boolean exclude = false;
            int i = 0;
            while (i < cleaningModel.getRowExcluderCount() & !exclude) {
                exclude |= cleaningModel.getRowExcluder(i).exclude(row);
                ++i;
            }
            if (!exclude) continue;
            this.rows.addElement(row);
        }
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return this.dataModel.isAvailable((Integer)this.rows.elementAt(row), column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.dataModel.getValueAt((Integer)this.rows.elementAt(row), column);
    }

    @Override
    public Object getColumnName(int column) {
        return this.dataModel.getColumnName(column);
    }

    @Override
    public Class getColumnClass(int column) {
        return this.dataModel.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.dataModel.getColumnCount();
    }
}

