/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.column;

import com.macrofocus.data.column.AbstractColumnModel;
import com.macrofocus.data.column.ColumnModel;

public class CacheColumnModel
extends AbstractColumnModel {
    private final Object[] objects;
    private final Class membership;
    private final Object name;
    private final boolean isEditable;

    public CacheColumnModel(ColumnModel columnModel, boolean isEditable) {
        this.name = columnModel.getName();
        this.membership = columnModel.getMembership();
        this.objects = new Object[columnModel.getRowCount()];
        for (int i = 0; i < columnModel.getRowCount(); ++i) {
            this.objects[i] = columnModel.getObject(i);
        }
        this.isEditable = isEditable;
    }

    @Override
    public boolean isAvailable(int index) {
        return this.objects[index] != null;
    }

    @Override
    public Object getObject(int index) {
        return this.objects[index];
    }

    @Override
    public Object getName() {
        return this.name;
    }

    @Override
    public Class getMembership() {
        return this.membership;
    }

    @Override
    public int getRowCount() {
        return this.objects.length;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public void setObject(int index, Object value) {
        if (this.isEditable) {
            this.objects[index] = value;
        } else {
            super.setObject(index, value);
        }
    }
}

