/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.dataframe;

import com.macrofocus.common.convert.ToBooleanTypeConverter;
import com.macrofocus.common.convert.ToCommonTypeConverter;
import com.macrofocus.common.convert.ToIntegerTypeConverter;
import com.macrofocus.common.convert.TypeConverter;
import com.macrofocus.data.type.convert.ToByteArrayTypeConverter;
import com.macrofocus.data.type.convert.ToColorTypeConverter;
import com.macrofocus.data.type.convert.ToDateTypeConverter;
import com.macrofocus.data.type.convert.ToDoubleFormatTypeConverter;
import com.macrofocus.data.type.convert.ToGeometryTypeConverter;
import com.macrofocus.data.type.convert.ToURLTypeConverter;
import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.molap.aggregates.cuboid.Cuboid;
import com.macrofocus.molap.colection.Sets;
import com.macrofocus.molap.dataframe.AbstractDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.ReIndexRecipe;
import com.macrofocus.molap.dataframe.ReIndexedDataFrame;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.IntegerRangeUniqueIndex;
import com.macrofocus.molap.index.MultiKey;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.series.AbstractSeries;
import com.macrofocus.molap.series.DoubleSeries;
import com.macrofocus.molap.series.IntegerSeries;
import com.macrofocus.molap.series.MutableSeries;
import com.macrofocus.molap.series.Series;
import com.macrofocus.molap.series.SeriesFactory;
import gnu.trove.set.hash.THashSet;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.table.TableModel;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class DefaultDataFrame<V>
extends AbstractDataFrame<Integer, String, V>
implements MutableDataFrame<Integer, String, V>,
Externalizable {
    private static final boolean MULTITHREADED = true;
    private static final int nAvailableProcessors = Math.max(Runtime.getRuntime().availableProcessors(), 1);
    private MutableSeries<Integer, V>[] series;
    private DefaultUniqueIndex<String> columnIndex;
    private UniqueIndex<Integer> rowIndex;
    private static final int MAGIC = 43610693;
    private static final int VERSION = 1;

    public DefaultDataFrame() {
    }

    @Deprecated
    public DefaultDataFrame(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream compressed = new BufferedInputStream(new GZIPInputStream((InputStream)new BufferedInputStream(fis, 65536), 65536), 65536);
        DataInputStream input = new DataInputStream(compressed);
        int magic = input.readInt();
        int version = input.readInt();
        int rowCount = input.readInt();
        int columnCount = input.readInt();
        this.series = new MutableSeries[columnCount];
        this.rowIndex = new IntegerRangeUniqueIndex(0, rowCount - 1);
        Object[] columns = new String[columnCount];
        for (int column = 0; column < columnCount; ++column) {
            int p;
            int i;
            int i2;
            TypemapModel.Builder builder;
            columns[column] = input.readUTF();
            String type = input.readUTF();
            try {
                builder = DefaultTypemapModel.getInstance().getBuilder(type);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (builder.getType() == Integer.class) {
                int[] values = new int[rowCount];
                boolean[] available = new boolean[rowCount];
                for (i2 = 0; i2 < rowCount; ++i2) {
                    values[i2] = input.readInt();
                    available[i2] = true;
                }
                this.series[column] = SeriesFactory.createInteger((int[])values, (boolean[])available);
                continue;
            }
            if (builder.getType() == Double.class || builder.getType() != String.class) continue;
            int size = input.readInt();
            String[] dictionary = new String[size];
            for (i2 = 0; i2 < size; ++i2) {
                dictionary[i2] = input.readUTF();
            }
            Object[] values = new String[rowCount];
            if (size < 127) {
                for (i = 0; i < rowCount; ++i) {
                    p = input.readByte();
                    values[i] = p >= 0 ? dictionary[p] : null;
                }
            } else if (size < Short.MAX_VALUE) {
                for (i = 0; i < rowCount; ++i) {
                    p = input.readShort();
                    values[i] = p >= 0 ? dictionary[p] : null;
                }
            } else {
                for (i = 0; i < rowCount; ++i) {
                    p = input.readInt();
                    values[i] = p >= 0 ? dictionary[p] : null;
                }
            }
            this.series[column] = SeriesFactory.create((Object[])values);
        }
        this.columnIndex = new DefaultUniqueIndex(columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultDataFrame(final TableModel tableModel, final boolean autoConvert) {
        this.series = new MutableSeries[tableModel.getColumnCount()];
        ArrayList<1> todo = new ArrayList<1>();
        int column = 0;
        while (column < tableModel.getColumnCount()) {
            final int c = column++;
            todo.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (!autoConvert) {
                        Class<?> columnClass = tableModel.getColumnClass(c);
                        DefaultDataFrame.this.createSeries(columnClass, tableModel, c);
                    } else {
                        TypeConverter.Input input = new TypeConverter.Input(){

                            public Class getType() {
                                return tableModel.getColumnClass(c);
                            }

                            public Object get(int index) {
                                return tableModel.getValueAt(index, c);
                            }

                            public int size() {
                                return tableModel.getRowCount();
                            }
                        };
                        ToCommonTypeConverter toCommonTypeConverter = new ToCommonTypeConverter();
                        ToDoubleFormatTypeConverter toDoubleTypeConverter = new ToDoubleFormatTypeConverter();
                        ToIntegerTypeConverter toIntegerTypeConverter = new ToIntegerTypeConverter();
                        ToDateTypeConverter toDateTypeConverter = new ToDateTypeConverter();
                        ToBooleanTypeConverter toBooleanTypeConverter = new ToBooleanTypeConverter();
                        ToURLTypeConverter toURLTypeConverter = new ToURLTypeConverter();
                        ToGeometryTypeConverter toGeometryTypeConverter = new ToGeometryTypeConverter();
                        ToByteArrayTypeConverter toByteArrayTypeConverter = new ToByteArrayTypeConverter();
                        ToColorTypeConverter toColorTypeConverter = new ToColorTypeConverter();
                        if (toDoubleTypeConverter.isConvertable(input)) {
                            if (toIntegerTypeConverter.isConvertable(input)) {
                                final int[] values = new int[input.size()];
                                final boolean[] available = new boolean[input.size()];
                                TypeConverter.Output output = new TypeConverter.Output(){

                                    public void setType(Class type) {
                                    }

                                    public void set(int index, Object value) {
                                        if (value != null) {
                                            values[index] = ((Number)value).intValue();
                                            available[index] = true;
                                        } else {
                                            available[index] = false;
                                        }
                                    }
                                };
                                output.setType(toIntegerTypeConverter.convert(input, output));
                                ((DefaultDataFrame)DefaultDataFrame.this).series[c] = SeriesFactory.createInteger((int[])values, (boolean[])available);
                            } else {
                                final double[] values = new double[input.size()];
                                final boolean[] available = new boolean[input.size()];
                                TypeConverter.Output output = new TypeConverter.Output(){

                                    public void setType(Class type) {
                                    }

                                    public void set(int index, Object value) {
                                        if (value != null) {
                                            values[index] = value instanceof Double ? ((Double)value).doubleValue() : ((Number)value).doubleValue();
                                            available[index] = true;
                                        } else {
                                            values[index] = Double.NaN;
                                            available[index] = false;
                                        }
                                    }
                                };
                                output.setType(toDoubleTypeConverter.convert(input, output));
                                ((DefaultDataFrame)DefaultDataFrame.this).series[c] = SeriesFactory.createDouble((double[])values, (boolean[])available);
                            }
                        } else {
                            Object typeConverter;
                            if (toBooleanTypeConverter.isConvertable(input)) {
                                typeConverter = toBooleanTypeConverter;
                            } else if (toDateTypeConverter.isConvertable(input)) {
                                typeConverter = toDateTypeConverter;
                            } else if (toURLTypeConverter.isConvertable(input)) {
                                typeConverter = toURLTypeConverter;
                            } else if (toGeometryTypeConverter.isConvertable(input)) {
                                typeConverter = toGeometryTypeConverter;
                            } else if (toByteArrayTypeConverter.isConvertable(input)) {
                                typeConverter = toByteArrayTypeConverter;
                            } else if (toColorTypeConverter.isConvertable(input)) {
                                typeConverter = toColorTypeConverter;
                            } else {
                                toCommonTypeConverter.isConvertable(input);
                                typeConverter = toCommonTypeConverter;
                            }
                            final Object[] values = (Object[])Array.newInstance(typeConverter.getType(), tableModel.getRowCount());
                            TypeConverter.Output output = new TypeConverter.Output(){

                                public void setType(Class type) {
                                }

                                public void set(int index, Object value) {
                                    values[index] = value;
                                }
                            };
                            output.setType(typeConverter.convert(input, output));
                            ((DefaultDataFrame)DefaultDataFrame.this).series[c] = SeriesFactory.create((Object[])values);
                        }
                    }
                    return null;
                }
            });
        }
        ExecutorService executor = Executors.newFixedThreadPool(nAvailableProcessors);
        try {
            List answers = executor.invokeAll(todo);
            for (Future answer : answers) {
                try {
                    answer.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.getCause().printStackTrace();
                }
            }
        }
        catch (InterruptedException answers) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            executor.shutdown();
        }
        Object[] columns = new String[tableModel.getColumnCount()];
        HashSet<String> unique = new HashSet<String>();
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            if (tableModel.getColumnName(i) != null) {
                String header = tableModel.getColumnName(i).intern();
                int c = 0;
                String uniqueHeader = header;
                while (unique.contains(uniqueHeader)) {
                    uniqueHeader = header + "-" + c;
                    ++c;
                }
                columns[i] = uniqueHeader;
                unique.add(uniqueHeader);
                continue;
            }
            columns[i] = Integer.toString(i);
        }
        this.columnIndex = new DefaultUniqueIndex(columns);
        this.rowIndex = new IntegerRangeUniqueIndex(0, tableModel.getRowCount() - 1);
    }

    public DefaultDataFrame(DataFrame<Integer, String, V> dataFrame, boolean autoConvert) {
        MutableSeries<Integer, V>[] series = this.autoConvert(dataFrame, autoConvert);
        this.series = series;
        Object[] columns = new String[dataFrame.getColumnCount()];
        HashSet<String> unique = new HashSet<String>();
        for (int column = 0; column < dataFrame.getColumnCount(); ++column) {
            String columnKey = (String)dataFrame.getColumnKey(column);
            if (dataFrame.getColumnName((Object)columnKey) != null) {
                String header = dataFrame.getColumnName((Object)columnKey).intern();
                int c = 0;
                while (unique.contains(header)) {
                    header = header + "-" + c;
                }
                columns[column] = header;
                unique.add(header);
                continue;
            }
            columns[column] = Integer.toString(column);
        }
        this.columnIndex = new DefaultUniqueIndex(columns);
        this.rowIndex = new IntegerRangeUniqueIndex(0, dataFrame.getRowCount() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutableSeries<Integer, V>[] autoConvert(final DataFrame<Integer, String, V> dataFrame, final boolean autoConvert) {
        final MutableSeries[] series = new MutableSeries[dataFrame.getColumnCount()];
        ArrayList<2> todo = new ArrayList<2>();
        int column = 0;
        while (column < dataFrame.getColumnCount()) {
            final String c = (String)dataFrame.getColumnKey(column);
            final int columnIndex = column++;
            todo.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (!autoConvert) {
                        DefaultDataFrame.this.createSeries(dataFrame, c, series, columnIndex);
                    } else {
                        TypeConverter.Input input = new TypeConverter.Input(){

                            public Class getType() {
                                return dataFrame.getColumnClass((Object)c);
                            }

                            public Object get(int index) {
                                return dataFrame.getValueAt((Object)((Integer)dataFrame.getRowKey(index)), (Object)c);
                            }

                            public int size() {
                                return dataFrame.getRowCount();
                            }
                        };
                        ToCommonTypeConverter toCommonTypeConverter = new ToCommonTypeConverter();
                        ToDoubleFormatTypeConverter toDoubleTypeConverter = new ToDoubleFormatTypeConverter();
                        ToIntegerTypeConverter toIntegerTypeConverter = new ToIntegerTypeConverter();
                        ToDateTypeConverter toDateTypeConverter = new ToDateTypeConverter();
                        ToBooleanTypeConverter toBooleanTypeConverter = new ToBooleanTypeConverter();
                        ToURLTypeConverter toURLTypeConverter = new ToURLTypeConverter();
                        ToGeometryTypeConverter toGeometryTypeConverter = new ToGeometryTypeConverter();
                        ToByteArrayTypeConverter toByteArrayTypeConverter = new ToByteArrayTypeConverter();
                        ToColorTypeConverter toColorTypeConverter = new ToColorTypeConverter();
                        if (toDoubleTypeConverter.isConvertable(input)) {
                            if (toIntegerTypeConverter.isConvertable(input)) {
                                final int[] values = new int[input.size()];
                                final boolean[] available = new boolean[input.size()];
                                TypeConverter.Output output = new TypeConverter.Output(){

                                    public void setType(Class type) {
                                    }

                                    public void set(int index, Object value) {
                                        if (value != null) {
                                            values[index] = ((Number)value).intValue();
                                            available[index] = true;
                                        } else {
                                            available[index] = false;
                                        }
                                    }
                                };
                                output.setType(toIntegerTypeConverter.convert(input, output));
                                series[columnIndex] = SeriesFactory.createInteger((int[])values, (boolean[])available);
                            } else {
                                final double[] values = new double[input.size()];
                                final boolean[] available = new boolean[input.size()];
                                TypeConverter.Output output = new TypeConverter.Output(){

                                    public void setType(Class type) {
                                    }

                                    public void set(int index, Object value) {
                                        if (value != null) {
                                            if (value instanceof Double) {
                                                values[index] = (Double)value;
                                                available[index] = true;
                                            } else if (value instanceof Number) {
                                                values[index] = ((Number)value).doubleValue();
                                                available[index] = true;
                                            } else {
                                                values[index] = Double.NaN;
                                                available[index] = false;
                                            }
                                        } else {
                                            values[index] = Double.NaN;
                                            available[index] = false;
                                        }
                                    }
                                };
                                output.setType(toDoubleTypeConverter.convert(input, output));
                                series[columnIndex] = SeriesFactory.createDouble((double[])values, (boolean[])available);
                            }
                        } else {
                            Object typeConverter;
                            if (toBooleanTypeConverter.isConvertable(input)) {
                                typeConverter = toBooleanTypeConverter;
                            } else if (toDateTypeConverter.isConvertable(input)) {
                                typeConverter = toDateTypeConverter;
                            } else if (toURLTypeConverter.isConvertable(input)) {
                                typeConverter = toURLTypeConverter;
                            } else if (toGeometryTypeConverter.isConvertable(input)) {
                                typeConverter = toGeometryTypeConverter;
                            } else if (toByteArrayTypeConverter.isConvertable(input)) {
                                typeConverter = toByteArrayTypeConverter;
                            } else if (toColorTypeConverter.isConvertable(input)) {
                                typeConverter = toColorTypeConverter;
                            } else {
                                toCommonTypeConverter.isConvertable(input);
                                typeConverter = toCommonTypeConverter;
                            }
                            final Object[] values = (Object[])Array.newInstance(typeConverter.getType(), dataFrame.getRowCount());
                            TypeConverter.Output output = new TypeConverter.Output(){

                                public void setType(Class type) {
                                }

                                public void set(int index, Object value) {
                                    values[index] = value;
                                }
                            };
                            output.setType(typeConverter.convert(input, output));
                            series[columnIndex] = SeriesFactory.create((Object[])values);
                        }
                    }
                    return null;
                }
            });
        }
        ExecutorService executor = Executors.newFixedThreadPool(nAvailableProcessors);
        try {
            List answers = executor.invokeAll(todo);
            for (Future answer : answers) {
                try {
                    answer.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.getCause().printStackTrace();
                }
            }
        }
        catch (InterruptedException answers) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            executor.shutdown();
        }
        return series;
    }

    public DefaultDataFrame(TableModel tableModel) {
        this(tableModel, false);
    }

    public DefaultDataFrame(String[] names, Class[] classes, V[][] data) {
        this.series = new MutableSeries[names.length];
        int rowCount = data.length;
        for (int c = 0; c < names.length; ++c) {
            Object[] values = (Object[])Array.newInstance(classes[c], rowCount);
            for (int r = 0; r < rowCount; ++r) {
                values[r] = data[r][c];
            }
            this.series[c] = SeriesFactory.create((Object)names[c].intern(), (Object[])values);
        }
        Object[] columns = new String[names.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = names[i].intern();
        }
        System.arraycopy(names, 0, columns, 0, names.length);
        this.columnIndex = new DefaultUniqueIndex(columns);
        this.rowIndex = new IntegerRangeUniqueIndex(0, rowCount - 1);
    }

    public DefaultDataFrame(DataFrame dataFrame) {
        this(dataFrame, UniqueIndex.Duplicate.UseFirstWarn);
    }

    public DefaultDataFrame(DataFrame dataFrame, UniqueIndex.Duplicate duplicate) {
        this.series = new MutableSeries[dataFrame.getColumnCount()];
        int c = 0;
        for (Object column : dataFrame.columns()) {
            this.createSeries(dataFrame, column, this.series, c);
            ++c;
        }
        Object[] columns = new String[dataFrame.getColumnCount()];
        for (int i = 0; i < dataFrame.getColumnCount(); ++i) {
            columns[i] = dataFrame.getColumnKey(i).toString().intern();
        }
        this.columnIndex = new DefaultUniqueIndex(duplicate, columns);
        this.rowIndex = new IntegerRangeUniqueIndex(0, dataFrame.getRowCount() - 1);
    }

    public DefaultDataFrame(UniqueIndex<Integer> rowIndex, DefaultUniqueIndex<String> columnIndex, MutableSeries<Integer, V>[] series) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.series = series;
    }

    private void createSeries(Class<?> columnClass, TableModel tableModel, int c) {
        if (columnClass == Integer.TYPE || columnClass == Integer.class) {
            int[] values = new int[tableModel.getRowCount()];
            boolean[] available = new boolean[tableModel.getRowCount()];
            for (int r = 0; r < tableModel.getRowCount(); ++r) {
                Integer valueAt = (Integer)tableModel.getValueAt(r, c);
                if (valueAt != null) {
                    available[r] = true;
                    values[r] = valueAt;
                    continue;
                }
                available[r] = false;
            }
            this.series[c] = SeriesFactory.createInteger((int[])values, (boolean[])available);
        } else if (columnClass == Long.TYPE || columnClass == Long.class) {
            long[] values = new long[tableModel.getRowCount()];
            boolean[] available = new boolean[tableModel.getRowCount()];
            for (int r = 0; r < tableModel.getRowCount(); ++r) {
                Long valueAt = (Long)tableModel.getValueAt(r, c);
                if (valueAt != null) {
                    available[r] = true;
                    values[r] = valueAt;
                    continue;
                }
                available[r] = false;
            }
            this.series[c] = SeriesFactory.createLong((long[])values, (boolean[])available);
        } else if (columnClass == Float.TYPE || columnClass == Float.class) {
            float[] values = new float[tableModel.getRowCount()];
            boolean[] available = new boolean[tableModel.getRowCount()];
            for (int r = 0; r < tableModel.getRowCount(); ++r) {
                Float valueAt = (Float)tableModel.getValueAt(r, c);
                if (valueAt != null) {
                    available[r] = true;
                    values[r] = valueAt.floatValue();
                    continue;
                }
                available[r] = false;
            }
            this.series[c] = SeriesFactory.createFloat((float[])values, (boolean[])available);
        } else if (columnClass == Double.TYPE || columnClass == Double.class) {
            double[] values = new double[tableModel.getRowCount()];
            boolean[] available = new boolean[tableModel.getRowCount()];
            for (int r = 0; r < tableModel.getRowCount(); ++r) {
                Double valueAt = (Double)tableModel.getValueAt(r, c);
                if (valueAt != null) {
                    available[r] = true;
                    values[r] = valueAt;
                    continue;
                }
                available[r] = false;
            }
            this.series[c] = SeriesFactory.createDouble((double[])values, (boolean[])available);
        } else {
            Object[] values = (Object[])Array.newInstance(columnClass, tableModel.getRowCount());
            for (int r = 0; r < tableModel.getRowCount(); ++r) {
                Object valueAt = tableModel.getValueAt(r, c);
                try {
                    if (valueAt != Cuboid.ALL) {
                        try {
                            values[r] = valueAt;
                        }
                        catch (ArrayStoreException e) {
                            System.err.println("Cannot store " + valueAt.getClass() + " into " + values.getClass());
                        }
                        continue;
                    }
                    values[r] = null;
                    continue;
                }
                catch (ArrayStoreException e) {
                    System.err.println(valueAt + ", " + valueAt.getClass() + ": " + columnClass);
                    e.printStackTrace();
                }
            }
            this.series[c] = SeriesFactory.create((Object[])values);
        }
    }

    private void createSeries(DataFrame dataFrame, Object c, MutableSeries<Integer, V>[] series, int columnIndex) {
        Class columnClass = dataFrame.getColumnClass(c);
        if (columnClass == Integer.TYPE || columnClass == Integer.class) {
            int[] values = new int[dataFrame.getRowCount()];
            boolean[] available = new boolean[dataFrame.getRowCount()];
            for (int r = 0; r < dataFrame.getRowCount(); ++r) {
                Integer valueAt = (Integer)dataFrame.getValueAt(dataFrame.getRowKey(r), c);
                if (valueAt != null) {
                    available[r] = true;
                    values[r] = valueAt;
                    continue;
                }
                available[r] = false;
            }
            series[columnIndex] = SeriesFactory.createInteger((int[])values, (boolean[])available);
        } else if (columnClass == Long.TYPE || columnClass == Long.class) {
            long[] values = new long[dataFrame.getRowCount()];
            boolean[] available = new boolean[dataFrame.getRowCount()];
            for (int r = 0; r < dataFrame.getRowCount(); ++r) {
                Long valueAt = (Long)dataFrame.getValueAt(dataFrame.getRowKey(r), c);
                if (valueAt != null) {
                    available[r] = true;
                    values[r] = valueAt;
                    continue;
                }
                available[r] = false;
            }
            series[columnIndex] = SeriesFactory.createLong((long[])values, (boolean[])available);
        } else if (columnClass == Float.TYPE || columnClass == Float.class) {
            float[] values = new float[dataFrame.getRowCount()];
            boolean[] available = new boolean[dataFrame.getRowCount()];
            for (int r = 0; r < dataFrame.getRowCount(); ++r) {
                Float valueAt = (Float)dataFrame.getValueAt(dataFrame.getRowKey(r), c);
                if (valueAt != null) {
                    available[r] = true;
                    values[r] = valueAt.floatValue();
                    continue;
                }
                available[r] = false;
            }
            series[columnIndex] = SeriesFactory.createFloat((float[])values, (boolean[])available);
        } else if (columnClass == Double.TYPE || columnClass == Double.class) {
            double[] values = new double[dataFrame.getRowCount()];
            boolean[] available = new boolean[dataFrame.getRowCount()];
            for (int r = 0; r < dataFrame.getRowCount(); ++r) {
                Double valueAt = (Double)dataFrame.getValueAt(dataFrame.getRowKey(r), c);
                if (valueAt != null) {
                    available[r] = true;
                    values[r] = valueAt;
                    continue;
                }
                available[r] = false;
            }
            series[columnIndex] = SeriesFactory.createDouble((double[])values, (boolean[])available);
        } else {
            Object[] values = (Object[])Array.newInstance(columnClass, dataFrame.getRowCount());
            for (int r = 0; r < dataFrame.getRowCount(); ++r) {
                Object valueAt = dataFrame.getValueAt(dataFrame.getRowKey(r), c);
                try {
                    if (valueAt != Cuboid.ALL) {
                        try {
                            values[r] = valueAt;
                        }
                        catch (ArrayStoreException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    values[r] = null;
                    continue;
                }
                catch (ArrayStoreException e) {
                    System.err.println(valueAt + ", " + valueAt.getClass() + ": " + columnClass);
                    e.printStackTrace();
                }
            }
            series[columnIndex] = SeriesFactory.create((Object[])values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeze(File file) throws IOException {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream buffer = new BufferedOutputStream(fos);
            GZIPOutputStream compressed = new GZIPOutputStream(buffer);
            try {
                this.freeze(compressed);
            }
            finally {
                compressed.finish();
                compressed.flush();
                ((OutputStream)fos).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version > 0) {
            int column;
            int rowCount = in.readInt();
            int columnCount = in.readInt();
            this.series = new MutableSeries[columnCount];
            this.rowIndex = new IntegerRangeUniqueIndex(0, rowCount - 1);
            Object[] names = new String[columnCount];
            Class[] classes = new Class[columnCount];
            for (column = 0; column < columnCount; ++column) {
                names[column] = in.readUTF();
            }
            for (column = 0; column < columnCount; ++column) {
                classes[column] = (Class)in.readObject();
            }
            this.columnIndex = new DefaultUniqueIndex(names);
            boolean[][] isAvailable = new boolean[columnCount][rowCount];
            for (int row = 0; row < rowCount; ++row) {
                for (int column2 = 0; column2 < columnCount; ++column2) {
                    isAvailable[column2][row] = in.readBoolean();
                }
            }
            for (int column3 = 0; column3 < columnCount; ++column3) {
                Object name = names[column3];
                Class cl = classes[column3];
                boolean[] cIsAvailable = isAvailable[column3];
                if (cl == Double.class) {
                    double[] c = new double[rowCount];
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = in.readDouble();
                    }
                    this.series[column3] = SeriesFactory.createDouble((double[])c, (boolean[])cIsAvailable);
                    continue;
                }
                if (cl == Float.class) {
                    Object[] c = new Float[rowCount];
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = Float.valueOf(in.readFloat());
                    }
                    this.series[column3] = SeriesFactory.create((Object[])c);
                    continue;
                }
                if (cl == Long.class) {
                    Object[] c = new Long[rowCount];
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = in.readLong();
                    }
                    this.series[column3] = SeriesFactory.create((Object[])c);
                    continue;
                }
                if (cl == Integer.class) {
                    int[] c = new int[rowCount];
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = in.readInt();
                    }
                    this.series[column3] = SeriesFactory.createInteger((int[])c, (boolean[])cIsAvailable);
                    continue;
                }
                if (cl == Short.class) {
                    Object[] c = new Short[rowCount];
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = in.readShort();
                    }
                    this.series[column3] = SeriesFactory.create((Object[])c);
                    continue;
                }
                if (cl == Byte.class) {
                    Object[] c = new Byte[rowCount];
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = in.readByte();
                    }
                    this.series[column3] = SeriesFactory.create((Object[])c);
                    continue;
                }
                if (cl == Boolean.class) {
                    Object[] c = new Boolean[rowCount];
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = in.readBoolean();
                    }
                    this.series[column3] = SeriesFactory.create((Object[])c);
                    continue;
                }
                if (cl == BufferedImage.class) {
                    Object[] c = new BufferedImage[rowCount];
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        boolean useCache = ImageIO.getUseCache();
                        ImageIO.setUseCache(false);
                        byte[] array = (byte[])in.readObject();
                        ByteArrayInputStream bai = new ByteArrayInputStream(array);
                        BufferedImage o = ImageIO.read(bai);
                        ImageIO.setUseCache(useCache);
                        c[row] = o;
                    }
                    this.series[column3] = SeriesFactory.create((Object[])c);
                    continue;
                }
                if (Geometry.class.isAssignableFrom(cl)) {
                    Object[] c = new Geometry[rowCount];
                    WKBReader reader = new WKBReader();
                    for (int row = 0; row < rowCount; ++row) {
                        if (cIsAvailable[row]) {
                            byte[] array = (byte[])in.readObject();
                            try {
                                c[row] = reader.read(array);
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                        }
                        this.series[column3] = SeriesFactory.create((Object[])c);
                    }
                    continue;
                }
                if (cl == String.class) {
                    boolean useDictionary = true;
                    THashSet set = Sets.createTHashSet();
                    Object[] c = new String[rowCount];
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        String s = (String)in.readObject();
                        c[row] = s;
                        if (set.size() >= Short.MAX_VALUE) continue;
                        set.add((Object)s);
                    }
                    if (set.size() < Short.MAX_VALUE) {
                        Object s;
                        int i;
                        Object[] pointers;
                        Object[] dictionary;
                        if (set.size() < 127) {
                            DefaultUniqueIndex index = new DefaultUniqueIndex((Iterable)set, false);
                            dictionary = new String[index.getSize()];
                            for (int i2 = 0; i2 < dictionary.length; ++i2) {
                                dictionary[i2] = (String)index.getKey(i2);
                            }
                            pointers = new byte[rowCount];
                            for (i = 0; i < c.length; ++i) {
                                s = c[i];
                                pointers[i] = s != null ? (int)index.getAddress(s) : -1;
                            }
                            this.series[column3] = (MutableSeries)SeriesFactory.create((Object)name, (Object[])dictionary, (byte[])pointers);
                            continue;
                        }
                        DefaultUniqueIndex index = new DefaultUniqueIndex((Iterable)set, false);
                        dictionary = new String[index.getSize()];
                        for (int i3 = 0; i3 < dictionary.length; ++i3) {
                            dictionary[i3] = (String)index.getKey(i3);
                        }
                        pointers = new short[rowCount];
                        for (i = 0; i < c.length; ++i) {
                            s = c[i];
                            pointers[i] = s != null ? (int)index.getAddress(s) : -1;
                        }
                        this.series[column3] = (MutableSeries)SeriesFactory.create((Object)name, (Object[])dictionary, (short[])pointers);
                        continue;
                    }
                    this.series[column3] = SeriesFactory.create((Object[])c);
                    continue;
                }
                Object[] c = new Object[rowCount];
                for (int row = 0; row < rowCount; ++row) {
                    if (!cIsAvailable[row]) continue;
                    c[row] = in.readObject();
                }
                this.series[column3] = SeriesFactory.create((Object[])c);
            }
        }
    }

    @Deprecated
    public void freeze(OutputStream os) throws IOException {
        DataOutputStream output = new DataOutputStream(os);
        output.writeInt(43610693);
        output.writeInt(1);
        output.writeInt(this.getRowCount());
        output.writeInt(this.getColumnCount());
        for (String column : this.columns()) {
            Class type = this.getColumnClass(column);
            output.writeUTF(column);
            output.writeUTF(DefaultTypemapModel.getInstance().getType(type));
            final MutableSeries<Integer, V> s = this.series[this.getColumnAddress(column)];
            if (type == Integer.class && s instanceof IntegerSeries) {
                System.out.println("Writing " + column + " as array of int");
                IntegerSeries is = (IntegerSeries)s;
                for (Integer row : this.rows()) {
                    int value = is.getInt(row);
                    output.writeInt(value);
                }
                continue;
            }
            if (type == Double.class && s instanceof DoubleSeries) {
                DoubleSeries ds = (DoubleSeries)s;
                for (Integer row : this.rows()) {
                    double value = ds.getDouble(row);
                    output.writeDouble(value);
                }
                continue;
            }
            if (type == String.class) {
                String value;
                DefaultUniqueIndex index = new DefaultUniqueIndex((Iterable)new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        final Iterator<Integer> rows = DefaultDataFrame.this.rows().iterator();
                        return new Iterator<String>(){

                            @Override
                            public boolean hasNext() {
                                return rows.hasNext();
                            }

                            @Override
                            public String next() {
                                return (String)s.get((Object)((Integer)rows.next()));
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                }, false);
                int size = index.getSize();
                output.writeInt(index.contains(null) ? size - 1 : size);
                for (String value2 : index.keys()) {
                    if (value2 == null) continue;
                    output.writeUTF(value2);
                }
                if (size < 127) {
                    System.out.println("Writing " + column + " with dictionary of bytes");
                    for (Integer row : this.rows()) {
                        value = (String)s.get((Object)row);
                        if (value != null) {
                            output.writeByte(index.getAddress((Object)value));
                            continue;
                        }
                        output.writeByte(-1);
                    }
                    continue;
                }
                if (size < Short.MAX_VALUE) {
                    System.out.println("Writing " + column + " with dictionary of shorts");
                    for (Integer row : this.rows()) {
                        value = (String)s.get((Object)row);
                        if (value != null) {
                            output.writeShort(index.getAddress((Object)value));
                            continue;
                        }
                        output.writeShort(-1);
                    }
                    continue;
                }
                System.out.println("Writing " + column + " with dictionary of int");
                for (Integer row : this.rows()) {
                    value = (String)s.get((Object)row);
                    if (value != null) {
                        output.writeInt(index.getAddress((Object)value));
                        continue;
                    }
                    output.writeInt(-1);
                }
                continue;
            }
            for (Integer row : this.rows()) {
                Iterator<Object> iterator = s.get((Object)row);
            }
        }
        output.flush();
        output.close();
    }

    public DefaultUniqueIndex<String> getColumnIndex() {
        return this.columnIndex;
    }

    public UniqueIndex<Integer> getRowIndex() {
        return this.rowIndex;
    }

    public Iterable<String> columns() {
        return this.columnIndex.keys();
    }

    public Class getRowClass(Integer row) {
        return Object.class;
    }

    public Class getColumnClass(String column) {
        int index = this.columnIndex.getAddress((Object)column);
        assert (index >= 0) : "Could not find column named " + column;
        MutableSeries<Integer, V> series = this.series[index];
        if (series != null) {
            return series.getType();
        }
        return null;
    }

    public Series<String, ?> getRow(Integer row) {
        return null;
    }

    public Series<Integer, V> getColumn(String column) {
        return new ColumnSeries2(column);
    }

    public V getValueAt(Integer row, String column) {
        int c = this.columnIndex.getAddress((Object)column);
        int r = this.rowIndex.getAddress((Object)row);
        if (r >= 0 && c >= 0) {
            return (V)this.series[c].get((Object)r);
        }
        return null;
    }

    public void setValueAt(Integer row, String column, V value) {
        this.series[this.columnIndex.getAddress((Object)column)].set((Object)row, value);
    }

    public Iterable<Integer> rows() {
        return this.rowIndex.keys();
    }

    public Integer getRowKey(int index) {
        return (Integer)this.rowIndex.getKey(index);
    }

    public String getColumnKey(int index) {
        return (String)this.columnIndex.getKey(index);
    }

    public int getRowAddress(Integer row) {
        return this.rowIndex.getAddress((Object)row);
    }

    public int getColumnAddress(String column) {
        return this.columnIndex.getAddress((Object)column);
    }

    public int getRowCount() {
        return this.rowIndex.getSize();
    }

    public int getColumnCount() {
        return this.columnIndex.getSize();
    }

    public MutableDataFrame<MultiKey, String, V> reindexRowsUsingColumns(final String ... rows) {
        return new ReIndexedDataFrame((DataFrame)this, (ReIndexRecipe)new ReIndexRecipe<MultiKey, String>(){

            public UniqueIndex<MultiKey> buildRowIndex() {
                int r = 0;
                Object[] keys = new MultiKey[DefaultDataFrame.this.getRowCount()];
                for (Integer row : DefaultDataFrame.this.rows()) {
                    Object[] values = new Object[rows.length];
                    int c = 0;
                    for (String column : rows) {
                        values[c++] = DefaultDataFrame.this.getValueAt(row, column);
                    }
                    MultiKey key = new MultiKey(values);
                    keys[r++] = key;
                }
                DefaultUniqueIndex index = new DefaultUniqueIndex(keys);
                return index;
            }

            public UniqueIndex<String> buildColumnIndex() {
                return DefaultDataFrame.this.columnIndex;
            }
        });
    }

    public DataFrame join(Series series, String[] columns) {
        MutableSeries[] array = new MutableSeries[this.getColumnCount() + 1];
        Object[] columnLabels = new Object[this.getColumnCount() + 1];
        int c = 0;
        for (String column : this.columns()) {
            columnLabels[c] = column;
            array[c++] = this.series[this.columnIndex.getAddress((Object)column)];
        }
        columnLabels[c] = series.getName();
        array[c++] = new MultiKeyJoinSeries(series, columns);
        return new DefaultDataFrame<V>(this.rowIndex, (DefaultUniqueIndex<String>)new DefaultUniqueIndex(columnLabels), array);
    }

    public DefaultDataFrame<V> leftSemiJoin(DataFrame<Object, String, V> dataFrame, String c) {
        MutableSeries[] array = new MutableSeries[this.getColumnCount() + dataFrame.getColumnCount()];
        Object[] columnLabels = new Object[this.getColumnCount() + dataFrame.getColumnCount()];
        int i = 0;
        for (String column : this.columns()) {
            columnLabels[i] = column;
            array[i++] = this.series[this.columnIndex.getAddress((Object)column)];
        }
        for (String column : dataFrame.columns()) {
            columnLabels[i] = column;
            array[i++] = new JoinSeries(dataFrame.getColumn((Object)column), c);
        }
        return new DefaultDataFrame<V>(this.rowIndex, (DefaultUniqueIndex<String>)new DefaultUniqueIndex(columnLabels), array);
    }

    public DataFrame<Integer, String, V> leftSemiJoin(DataFrame<MultiKey, String, V> dataFrame, String[] cs) {
        return this.leftSemiJoin(UniqueIndex.Duplicate.UseFirstWarn, dataFrame, cs);
    }

    public DataFrame<Integer, String, V> leftSemiJoin(UniqueIndex.Duplicate duplicate, DataFrame<MultiKey, String, V> dataFrame, String[] cs) {
        MutableSeries[] array = new MutableSeries[this.getColumnCount() + dataFrame.getColumnCount()];
        Object[] columnLabels = new Object[this.getColumnCount() + dataFrame.getColumnCount()];
        int c = 0;
        for (String column : this.columns()) {
            columnLabels[c] = column;
            array[c++] = this.series[this.columnIndex.getAddress((Object)column)];
        }
        for (String column : dataFrame.columns()) {
            columnLabels[c] = column;
            array[c++] = new MultiKeyJoinSeries(dataFrame.getColumn((Object)column), cs);
        }
        return new DefaultDataFrame<V>(this.rowIndex, (DefaultUniqueIndex<String>)new DefaultUniqueIndex(duplicate, columnLabels), array);
    }

    public DefaultDataFrame<V> removeColumns(String ... columns) {
        return new DefaultDataFrame<V>(this.rowIndex, (DefaultUniqueIndex<String>)this.columnIndex.remove((Object[])columns), this.series);
    }

    private class ColumnSeries2
    extends AbstractSeries<Integer, V> {
        private final String column;
        private final Series<Integer, V> s;

        private ColumnSeries2(String column) {
            assert (column != null);
            this.column = column;
            int address = DefaultDataFrame.this.columnIndex.getAddress((Object)column);
            this.s = address >= 0 ? DefaultDataFrame.this.series[address] : null;
        }

        public Object getName() {
            return this.column;
        }

        public Class getType() {
            return this.s != null ? this.s.getType() : null;
        }

        public V get(Integer key) {
            return this.s != null ? this.s.get((Object)key) : null;
        }

        public Integer getKey(int i) {
            return this.s != null ? (Integer)this.s.getKey(i) : null;
        }

        public int size() {
            return this.s != null ? this.s.size() : 0;
        }

        public int getAddress(Integer key) {
            return this.s.getAddress((Object)key);
        }

        public Iterable<Integer> keys() {
            return DefaultDataFrame.this.rows();
        }

        public <L> Series<L, V> reindex(L ... keys) {
            return null;
        }

        public Series<Integer, V> head(int count) {
            return null;
        }

        public Series<Integer, V> tail(int count) {
            return null;
        }
    }

    private class ColumnSeries
    extends AbstractSeries<Integer, V> {
        private String column;
        private UniqueIndex index;

        private ColumnSeries(String column, UniqueIndex index) {
            assert (column != null);
            this.column = column;
            this.index = index;
        }

        public Object getName() {
            return this.column;
        }

        public Class getType() {
            return DefaultDataFrame.this.getColumnClass(this.column);
        }

        public V get(Integer key) {
            return DefaultDataFrame.this.getValueAt((Integer)DefaultDataFrame.this.rowIndex.getKey(this.index.getAddress((Object)key)), this.column);
        }

        public Integer getKey(int i) {
            return (Integer)DefaultDataFrame.this.rowIndex.getKey(i);
        }

        public int size() {
            return DefaultDataFrame.this.rowIndex.getSize();
        }

        public int getAddress(Integer key) {
            return DefaultDataFrame.this.rowIndex.getAddress((Object)key);
        }

        public Iterable<Integer> keys() {
            return this.index.keys();
        }

        public <L> Series<L, V> reindex(L ... keys) {
            return null;
        }

        public Series<Integer, V> head(int count) {
            return null;
        }

        public Series<Integer, V> tail(int count) {
            return null;
        }
    }

    private class MultiKeyJoinSeries
    extends AbstractSeries<Integer, V>
    implements MutableSeries<Integer, V> {
        private Series<MultiKey, V> series;
        private String[] columns;

        private MultiKeyJoinSeries(Series<MultiKey, V> series, String[] columns) {
            assert (series != null);
            this.series = series;
            this.columns = columns;
        }

        public Object getName() {
            return this.series.getName();
        }

        public Class getType() {
            return this.series.getType();
        }

        public V get(Integer key) {
            Object[] values = new Object[this.columns.length];
            int c = 0;
            for (String column : this.columns) {
                values[c++] = DefaultDataFrame.this.getValueAt(key, column);
            }
            MultiKey multiKey = new MultiKey(values);
            return this.series.get((Object)multiKey);
        }

        public int getAddress(Integer key) {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Integer getKey(int i) {
            return null;
        }

        public int size() {
            return DefaultDataFrame.this.getRowCount();
        }

        public void set(Integer key, V value) {
        }

        public Iterable<Integer> keys() {
            return DefaultDataFrame.this.rows();
        }

        public <L> Series<L, V> reindex(L ... keys) {
            return null;
        }

        public Series<Integer, V> head(int count) {
            return null;
        }

        public Series<Integer, V> tail(int count) {
            return null;
        }
    }

    private class JoinSeries
    extends AbstractSeries<Integer, V>
    implements MutableSeries<Integer, V> {
        private Series<Object, V> series;
        private String column;

        private JoinSeries(Series<Object, V> series, String column) {
            assert (series != null);
            this.series = series;
            this.column = column;
        }

        public Object getName() {
            return this.series.getName();
        }

        public Class getType() {
            return this.series.getType();
        }

        public V get(Integer key) {
            Object value = DefaultDataFrame.this.getValueAt(key, this.column);
            return this.series.get(value);
        }

        public int getAddress(Integer key) {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Integer getKey(int i) {
            return null;
        }

        public int size() {
            return DefaultDataFrame.this.getRowCount();
        }

        public void set(Integer key, V value) {
        }

        public Iterable<Integer> keys() {
            return DefaultDataFrame.this.rows();
        }

        public <L> Series<L, V> reindex(L ... keys) {
            return null;
        }

        public Series<Integer, V> head(int count) {
            return null;
        }

        public Series<Integer, V> tail(int count) {
            return null;
        }
    }
}

