/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.db;

import com.macrofocus.data.db.JDBCDatabaseDriver;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.swing.table.TableModel;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class H2DatabaseDriver
extends JDBCDatabaseDriver {
    private static final String className = "org.h2.Driver";

    @Override
    public Class getColumnType(ResultSetMetaData metaData, int column) throws SQLException {
        if ("VARBINARY".equals(metaData.getColumnTypeName(column))) {
            return Geometry.class;
        }
        return super.getColumnType(metaData, column);
    }

    @Override
    public Object getColumnValue(ResultSet rs, Class columnType, int column) throws SQLException {
        if (columnType == Geometry.class) {
            try {
                byte[] bytes = rs.getBytes(column);
                if (bytes != null) {
                    return new WKBReader().read(bytes);
                }
                return null;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return super.getColumnValue(rs, columnType, column);
    }

    @Override
    public String getURL(String host, String schema, String username, String password) {
        String url = "jdbc:" + this.getPrefix() + ":";
        if (schema != null) {
            url = url + schema;
        }
        return url;
    }

    @Override
    public String createTable(String table, TableModel tableModel, ResultSetMetaData md, ResultSet primary) throws SQLException {
        StringBuffer result = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        result.append("CREATE TABLE ");
        result.append(table);
        result.append(" ( ");
        for (int column = 0; column < tableModel.getColumnCount(); ++column) {
            String columnName;
            int i = column + 1;
            if (i != 1) {
                result.append(',');
            }
            if ((columnName = md.getColumnName(i)).equalsIgnoreCase("location") || columnName.equalsIgnoreCase("case") || columnName.equalsIgnoreCase("group") || columnName.equalsIgnoreCase("check") || columnName.equalsIgnoreCase("comment")) {
                result.append("\"" + columnName.replace('.', '_') + "\"");
            } else {
                result.append(columnName.replace('.', '_'));
            }
            result.append(' ');
            String type = this.getColumnType(tableModel.getColumnClass(column), md.getPrecision(i));
            result.append(type);
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public void dropTable(Connection connection, String table) throws SQLException {
        super.dropTable(connection, table.toUpperCase());
    }

    public static boolean exist() {
        return H2DatabaseDriver.exist(className);
    }

    @Override
    public String getClassName() {
        return className;
    }

    @Override
    public String getPrefix() {
        return "h2";
    }

    public String toString() {
        return "H2";
    }
}

