/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.db;

import com.macrofocus.data.db.JDBCDatabaseDriver;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class HSQLDBDatabaseDriver
extends JDBCDatabaseDriver {
    private static final String className = "org.hsqldb.jdbc.JDBCDriver";

    @Override
    public Class getColumnType(ResultSetMetaData metaData, int column) throws SQLException {
        if ("VARBINARY".equals(metaData.getColumnTypeName(column))) {
            return Geometry.class;
        }
        return super.getColumnType(metaData, column);
    }

    @Override
    public Object getColumnValue(ResultSet rs, Class columnType, int column) throws SQLException {
        if (columnType == Geometry.class) {
            try {
                byte[] bytes = rs.getBytes(column);
                if (bytes != null) {
                    return new WKBReader().read(bytes);
                }
                return null;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return super.getColumnValue(rs, columnType, column);
    }

    @Override
    public String getURL(String host, String schema, String username, String password) {
        String url = "jdbc:" + this.getPrefix() + ":";
        if (schema != null) {
            url = url + schema;
        }
        return url;
    }

    @Override
    public void dropTable(Connection connection, String table) throws SQLException {
        super.dropTable(connection, table.toUpperCase());
    }

    public static boolean exist() {
        return HSQLDBDatabaseDriver.exist(className);
    }

    @Override
    public String getClassName() {
        return className;
    }

    @Override
    public String getPrefix() {
        return "hsqldb";
    }

    public String toString() {
        return "HSQLDB";
    }
}

