/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.db;

import com.macrofocus.data.db.JDBCDatabaseDriver;
import com.macrofocus.data.db.MyWKBReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;

public class MariaDBDatabaseDriver
extends JDBCDatabaseDriver {
    private static final String className = "org.mariadb.jdbc.Driver";

    public static boolean exist() {
        return MariaDBDatabaseDriver.exist(className);
    }

    @Override
    public String getClassName() {
        return className;
    }

    @Override
    public Class getColumnType(ResultSetMetaData metaData, int column) throws SQLException {
        if ("UNKNOWN".equals(metaData.getColumnTypeName(column)) || "GEOMETRY".equals(metaData.getColumnTypeName(column))) {
            return Geometry.class;
        }
        return super.getColumnType(metaData, column);
    }

    @Override
    public String getColumnType(Class type, int precision) {
        if (Geometry.class.isAssignableFrom(type)) {
            return "geometry";
        }
        return super.getColumnType(type, precision);
    }

    @Override
    public Object getColumnValue(ResultSet rs, Class columnType, int column) throws SQLException {
        if (columnType == Geometry.class) {
            Object o = rs.getObject(column);
            return this.convert2JTS(o);
        }
        return super.getColumnValue(rs, columnType, column);
    }

    @Override
    public Connection getConnection(String url, String username, String password) throws SQLException {
        Connection connection = null;
        Properties info = new Properties();
        if (username != null) {
            info.put("user", username);
        }
        if (password != null) {
            info.put("password", password);
        }
        info.setProperty("cacheResultSetMetaData", "true");
        info.setProperty("autoReconnect", "true");
        if (username != null) {
            try {
                connection = DriverManager.getConnection(url, info);
            }
            catch (SQLException e) {
                try {
                    connection = DriverManager.getConnection(url);
                }
                catch (SQLException e1) {
                    throw e;
                }
            }
        } else {
            connection = DriverManager.getConnection(url);
        }
        return connection;
    }

    @Override
    public Iterable<String> getDatabases(String host, String username, String password) throws SQLException {
        Properties info = new Properties();
        if (username != null) {
            info.put("user", username);
        }
        if (password != null) {
            info.put("password", password);
        }
        info.setProperty("useInformationSchema", "true");
        Connection conn = this.getConnection(this.getURL(host, null, username, password), info);
        ArrayList<String> databases = new ArrayList<String>();
        if (conn != null) {
            ResultSet schemas = conn.getMetaData().getCatalogs();
            while (schemas.next()) {
                databases.add(schemas.getString(1));
            }
        }
        return databases;
    }

    @Override
    public String getPrefix() {
        return "mariadb";
    }

    public String toString() {
        return "MariaDB";
    }

    public Geometry convert2JTS(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] wkb = (byte[])object;
            try {
                Geometry geometry = new MyWKBReader().read(wkb);
                return geometry;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

