/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.db;

import com.macrofocus.data.db.JDBCDatabaseDriver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ODBCDatabaseDriver
extends JDBCDatabaseDriver {
    private static final String className = "sun.jdbc.odbc.JdbcOdbcDriver";
    private PrintWriter nullWriter = new PrintWriter(new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    });

    public static boolean exist() {
        return ODBCDatabaseDriver.exist(className);
    }

    @Override
    public String getClassName() {
        return className;
    }

    @Override
    public String getPrefix() {
        return "odbc";
    }

    public String toString() {
        return "ODBC";
    }

    @Override
    public String getURL(String host, String schema, String username, String password) {
        String url = "jdbc:" + this.getPrefix() + ":";
        if (schema != null) {
            url = url + schema;
        }
        return url;
    }

    @Override
    public Connection getConnection(String url, String username, String password) throws SQLException {
        PrintWriter writer = DriverManager.getLogWriter();
        DriverManager.setLogWriter(this.nullWriter);
        Connection connection = super.getConnection(url, username, password);
        DriverManager.setLogWriter(writer);
        return connection;
    }

    @Override
    public Connection getConnection(String url, Properties info) throws SQLException {
        PrintWriter writer = DriverManager.getLogWriter();
        DriverManager.setLogWriter(this.nullWriter);
        Connection connection = super.getConnection(url, info);
        DriverManager.setLogWriter(writer);
        return connection;
    }

    @Override
    public Iterable<String> getDatabases(String host, String username, String password) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getDatabases("HKEY_CURRENT_USER\\SOFTWARE\\ODBC\\ODBC.INI"));
        list.addAll(this.getDatabases("HKEY_LOCAL_MACHINE\\SOFTWARE\\ODBC\\ODBC.INI"));
        return list;
    }

    private List<String> getDatabases(String registryKey) {
        String[] command = new String[]{"reg", "query", registryKey};
        ArrayList<String> dsnList = new ArrayList<String>();
        try {
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader stream = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String dsn = "";
            while ((dsn = stream.readLine()) != null) {
                String dsnName;
                if (dsn.indexOf(registryKey + "\\") == -1 || "ODBC Data Sources".equals(dsnName = dsn.substring(dsn.lastIndexOf("\\") + 1))) continue;
                dsnList.add(dsnName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dsnList;
    }

    @Override
    public Iterable<String> getTables(String url, String database, String username, String password) throws SQLException {
        PrintWriter writer = DriverManager.getLogWriter();
        DriverManager.setLogWriter(this.nullWriter);
        Iterable<String> tables = super.getTables(url, database, username, password);
        DriverManager.setLogWriter(writer);
        return tables;
    }

    @Override
    public boolean isNetworkEnabled() {
        return false;
    }
}

