/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.db;

import com.macrofocus.data.db.JDBCDatabaseDriver;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class PostgreSQLDatabaseDriver
extends JDBCDatabaseDriver {
    private static final String className = "org.postgresql.Driver";

    public static boolean exist() {
        return PostgreSQLDatabaseDriver.exist(className);
    }

    @Override
    public String getClassName() {
        return className;
    }

    @Override
    public String getPrefix() {
        return "postgresql";
    }

    public String toString() {
        return "PostgreSQL";
    }

    @Override
    public Iterable<String> getDatabases(String host, String username, String password) throws SQLException {
        Connection conn = DriverManager.getConnection(this.getURL(host, "postgres", username, password), username, password);
        ArrayList<String> databases = new ArrayList<String>();
        String query = "select datname from pg_catalog.pg_database where not datistemplate";
        PreparedStatement pst = conn.prepareStatement("select datname from pg_catalog.pg_database where not datistemplate");
        ResultSet schemas = pst.executeQuery();
        while (schemas.next()) {
            databases.add(schemas.getString(1));
        }
        return databases;
    }

    @Override
    public String generateParseDate(String date) {
        return "to_date('" + date + "', 'YYYY-MM-DD')";
    }
}

