/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.format;

import com.macrofocus.data.format.AbstractFileURLDataFormat;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.JarDataSource;
import com.macrofocus.data.source.ZipDataSource;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.file.filter.JarFileFilter;
import java.io.File;
import java.net.URL;

public class JarDataFormat
extends AbstractFileURLDataFormat {
    static final String type = "Jar";
    private static final AbstractFileFilter fileFilter = new JarFileFilter();

    @Override
    public String getType() {
        return type;
    }

    @Override
    public AbstractFileFilter getFileFilter() {
        return fileFilter;
    }

    @Override
    public DataSource getDataSource(File file) {
        try {
            return new JarDataSource(file);
        }
        catch (NoClassDefFoundError e) {
            return new ZipDataSource(file);
        }
    }

    @Override
    public DataSource getDataSource(URL url) {
        return new ZipDataSource(url);
    }
}

