/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.stat;

import com.macrofocus.data.matrix.AbstractMatrixModel;
import com.macrofocus.data.matrix.MatrixModel;

public final class MinMaxMatrixModel
extends AbstractMatrixModel {
    private double[] _min;
    private double[] _max;
    private MatrixModel _dataset;

    public MinMaxMatrixModel(MatrixModel dataset) {
        this._dataset = dataset;
        this._min = new double[dataset.getColumnCount()];
        this._max = new double[dataset.getColumnCount()];
        for (int j = 0; j < dataset.getColumnCount(); ++j) {
            this._min[j] = Double.MAX_VALUE;
            this._max[j] = -1.7976931348623157E308;
        }
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            for (int j = 0; j < dataset.getColumnCount(); ++j) {
                if (!dataset.isAvailable(i, j)) continue;
                double value = this._dataset.getDouble(i, j);
                if (this._min[j] > value) {
                    this._min[j] = value;
                }
                if (!(this._max[j] < value)) continue;
                this._max[j] = value;
            }
        }
    }

    public MinMaxMatrixModel(MatrixModel dataset, double min, double max) {
        this._dataset = dataset;
        this._min = new double[dataset.getColumnCount()];
        this._max = new double[dataset.getColumnCount()];
        for (int j = 0; j < dataset.getColumnCount(); ++j) {
            this._min[j] = min;
            this._max[j] = max;
        }
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return true;
    }

    @Override
    public int getRowCount() {
        return 2;
    }

    @Override
    public int getColumnCount() {
        return this._dataset.getColumnCount();
    }

    @Override
    public double getDouble(int row, int column) {
        if (row == 0) {
            return this.getMax(column);
        }
        return this.getMin(column);
    }

    public double getMin(int column) {
        return this._min[column];
    }

    public double getMax(int column) {
        return this._max[column];
    }

    public void setMin(int column, double min) {
        this._min[column] = min;
    }

    public void setMax(int column, double max) {
        this._max[column] = max;
    }

    public double getRange(int column) {
        return this._max[column] - this._min[column];
    }

    @Override
    public Object getColumnName(int column) {
        return this._dataset.getColumnName(column);
    }

    @Override
    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(name)) continue;
            index = i;
        }
        return index;
    }
}

