/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.vector;

import com.macrofocus.data.matrix.vector.AbstractVectorModel;
import com.macrofocus.data.matrix.vector.VectorHelper;
import com.macrofocus.data.matrix.vector.VectorModel;

public class NormalizedVectorModel
extends AbstractVectorModel {
    private final VectorModel vectorModel;
    private final double norm;

    public NormalizedVectorModel(VectorModel vectorModel) {
        this.vectorModel = vectorModel;
        this.norm = VectorHelper.getEuclideanNorm(vectorModel);
    }

    @Override
    public boolean isAvailable(int index) {
        return this.vectorModel.isAvailable(index);
    }

    @Override
    public double getDouble(int index) {
        return this.vectorModel.getDouble(index) / this.norm;
    }

    @Override
    public Object getName() {
        return this.vectorModel.getName();
    }

    @Override
    public int getRowCount() {
        return this.vectorModel.getRowCount();
    }
}

