/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.vector;

import com.macrofocus.data.matrix.vector.AbstractVectorModel;
import com.macrofocus.data.matrix.vector.VectorHelper;
import com.macrofocus.data.matrix.vector.VectorModel;

public class ScaledVectorModel
extends AbstractVectorModel {
    private final VectorModel vectorModel;
    private final double factor;
    private final double substract;
    private final double add;

    public ScaledVectorModel(VectorModel vectorModel, double factor) {
        this(vectorModel, 0.0, factor);
    }

    public ScaledVectorModel(VectorModel vectorModel, double substract, double factor) {
        this.vectorModel = vectorModel;
        this.substract = substract;
        this.factor = factor;
        this.add = 0.0;
    }

    public ScaledVectorModel(VectorModel vectorModel) {
        this.vectorModel = vectorModel;
        double min = VectorHelper.getMimimum(vectorModel);
        double max = VectorHelper.getMaximum(vectorModel);
        this.substract = min;
        this.factor = 1.0 / (max - min);
        this.add = 0.0;
    }

    public ScaledVectorModel(VectorModel vectorModel, double min, double max, double targetMin, double targetMax) {
        this.vectorModel = vectorModel;
        this.substract = min;
        this.factor = (targetMax - targetMin) / (max - min);
        this.add = targetMin;
    }

    @Override
    public boolean isAvailable(int index) {
        return this.vectorModel.isAvailable(index);
    }

    @Override
    public double getDouble(int index) {
        return (this.vectorModel.getDouble(index) - this.substract) * this.factor + this.add;
    }

    @Override
    public Object getName() {
        return this.vectorModel.getName();
    }

    @Override
    public int getRowCount() {
        return this.vectorModel.getRowCount();
    }
}

