/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.metaphone;

import com.macrofocus.data.metaphone.MetaphoneModel;
import com.macrofocus.util.math.MathHelper;

public class DoubleMetaphoneModel
implements MetaphoneModel {
    private final String string;
    private String primary;
    private String secondary;
    private boolean alternate;
    private int length;
    private int last;

    public DoubleMetaphoneModel(String word) {
        this.string = word.toUpperCase() + "     ";
        this.primary = "";
        this.secondary = "";
        int current = 0;
        this.length = this.string.length();
        if (this.length < 1) {
            return;
        }
        this.last = this.length - 1;
        this.alternate = false;
        if (this.stringAt(0, 2, new String[]{"GN", "KN", "PN", "WR", "PS"})) {
            ++current;
        }
        if (this.stringAt(0, 1, new String[]{"X"})) {
            this.add("S");
            ++current;
        }
        block23: while (current < this.length) {
            char c = this.string.charAt(current);
            switch (c) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    if (current == 0) {
                        this.add("A");
                    }
                    ++current;
                    continue block23;
                }
                case 'B': {
                    this.add("P");
                    if (this.charAt(current + 1) == 'B') {
                        current += 2;
                        continue block23;
                    }
                    ++current;
                    continue block23;
                }
                case 'C': {
                    if (current > 1 && !this.isVowel(current - 2) && this.stringAt(current - 1, 3, new String[]{"ACH", ""}) && this.charAt(current + 2) != 'I' && (this.charAt(current + 2) != 'E' || this.stringAt(current - 2, 6, new String[]{"BACHER", "MACHER", ""}))) {
                        this.add("K");
                        current += 2;
                        continue block23;
                    }
                    if (current == 0 && this.stringAt(current, 6, new String[]{"CAESAR", ""})) {
                        this.add("S");
                        current += 2;
                        continue block23;
                    }
                    if (this.stringAt(current, 4, new String[]{"CHIA", ""})) {
                        this.add("K");
                        current += 2;
                        continue block23;
                    }
                    if (this.stringAt(current, 2, new String[]{"CH", ""})) {
                        if (current > 0 && this.stringAt(current, 4, new String[]{"CHAE", ""})) {
                            this.add("K", "X");
                            current += 2;
                            continue block23;
                        }
                        if (current == 0 && (this.stringAt(current + 1, 5, new String[]{"HARAC", "HARIS", ""}) || this.stringAt(current + 1, 3, new String[]{"HOR", "HYM", "HIA", "HEM", ""})) && !this.stringAt(0, 5, new String[]{"CHORE", ""})) {
                            this.add("K");
                            current += 2;
                            continue block23;
                        }
                        if (this.stringAt(0, 4, new String[]{"VAN ", "VON ", ""}) || this.stringAt(0, 3, new String[]{"SCH", ""}) || this.stringAt(current - 2, 6, new String[]{"ORCHES", "ARCHIT", "ORCHID", ""}) || this.stringAt(current + 2, 1, new String[]{"T", "S", ""}) || (this.stringAt(current - 1, 1, new String[]{"A", "O", "U", "E", ""}) || current == 0) && this.stringAt(current + 2, 1, new String[]{"L", "R", "N", "M", "B", "H", "F", "V", "W", " ", ""})) {
                            this.add("K");
                        } else if (current > 0) {
                            if (this.stringAt(0, 2, new String[]{"MC", ""})) {
                                this.add("K");
                            } else {
                                this.add("X", "K");
                            }
                        } else {
                            this.add("X");
                        }
                        current += 2;
                        continue block23;
                    }
                    if (this.stringAt(current, 2, new String[]{"CZ", ""}) && !this.stringAt(current - 2, 4, new String[]{"WICZ", ""})) {
                        this.add("S", "X");
                        current += 2;
                        continue block23;
                    }
                    if (this.stringAt(current + 1, 3, new String[]{"CIA", ""})) {
                        this.add("X");
                        current += 3;
                        continue block23;
                    }
                    if (this.stringAt(current, 2, new String[]{"CC", ""}) && (current != 1 || this.charAt(0) != 'M')) {
                        if (this.stringAt(current + 2, 1, new String[]{"I", "E", "H", ""}) && !this.stringAt(current + 2, 2, new String[]{"HU", ""})) {
                            if (current == 1 && this.charAt(current - 1) == 'A' || this.stringAt(current - 1, 5, new String[]{"UCCEE", "UCCES", ""})) {
                                this.add("KS");
                            } else {
                                this.add("X");
                            }
                            current += 3;
                            continue block23;
                        }
                        this.add("K");
                        current += 2;
                        continue block23;
                    }
                    if (this.stringAt(current, 2, new String[]{"CK", "CG", "CQ", ""})) {
                        this.add("K");
                        current += 2;
                        continue block23;
                    }
                    if (this.stringAt(current, 2, new String[]{"CI", "CE", "CY", ""})) {
                        if (this.stringAt(current, 3, new String[]{"CIO", "CIE", "CIA", ""})) {
                            this.add("S", "X");
                        } else {
                            this.add("S");
                        }
                        current += 2;
                        continue block23;
                    }
                    this.add("K");
                    if (this.stringAt(current + 1, 2, new String[]{" C", " Q", " G", ""})) {
                        current += 3;
                        continue block23;
                    }
                    if (this.stringAt(current + 1, 1, new String[]{"C", "K", "Q", ""}) && !this.stringAt(current + 1, 2, new String[]{"CE", "CI", ""})) {
                        current += 2;
                        continue block23;
                    }
                    ++current;
                    continue block23;
                }
                case 'D': {
                    if (this.stringAt(current, 2, new String[]{"DG", ""})) {
                        if (this.stringAt(current + 2, 1, new String[]{"I", "E", "Y", ""})) {
                            this.add("J");
                            current += 3;
                            continue block23;
                        }
                        this.add("TK");
                        current += 2;
                        continue block23;
                    }
                    if (this.stringAt(current, 2, new String[]{"DT", "DD", ""})) {
                        this.add("T");
                        current += 2;
                        continue block23;
                    }
                    this.add("T");
                    ++current;
                    continue block23;
                }
                case 'F': {
                    current = this.charAt(current + 1) == 'F' ? (current += 2) : ++current;
                    this.add("F");
                    continue block23;
                }
                case 'G': {
                    if (this.charAt(current + 1) == 'H') {
                        if (current > 0 && !this.isVowel(current - 1)) {
                            this.add("K");
                            current += 2;
                            continue block23;
                        }
                        if (current < 3 && current == 0) {
                            if (this.charAt(current + 2) == 'I') {
                                this.add("J");
                            } else {
                                this.add("K");
                            }
                            current += 2;
                            continue block23;
                        }
                        if (current > 1 && this.stringAt(current - 2, 1, new String[]{"B", "H", "D", ""}) || current > 2 && this.stringAt(current - 3, 1, new String[]{"B", "H", "D", ""}) || current > 3 && this.stringAt(current - 4, 1, new String[]{"B", "H", ""})) {
                            current += 2;
                            continue block23;
                        }
                        if (current > 2 && this.charAt(current - 1) == 'U' && this.stringAt(current - 3, 1, new String[]{"C", "G", "L", "R", "T", ""})) {
                            this.add("F");
                        } else if (current > 0 && this.charAt(current - 1) != 'I') {
                            this.add("K");
                        }
                        current += 2;
                        continue block23;
                    }
                    if (this.charAt(current + 1) == 'N') {
                        if (current == 1 && this.isVowel(0) && !this.isSlavoGermanic()) {
                            this.add("KN", "N");
                        } else if (!this.stringAt(current + 2, 2, new String[]{"EY", ""}) && this.charAt(current + 1) != 'Y' && !this.isSlavoGermanic()) {
                            this.add("N", "KN");
                        } else {
                            this.add("KN");
                        }
                        current += 2;
                        continue block23;
                    }
                    if (this.stringAt(current + 1, 2, new String[]{"LI", ""}) && !this.isSlavoGermanic()) {
                        this.add("KL", "L");
                        current += 2;
                        continue block23;
                    }
                    if (current == 0 && (this.charAt(current + 1) == 'Y' || this.stringAt(current + 1, 2, new String[]{"ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER", ""}))) {
                        this.add("K", "J");
                        current += 2;
                        continue block23;
                    }
                    if (!(!this.stringAt(current + 1, 2, new String[]{"ER", ""}) && this.charAt(current + 1) != 'Y' || this.stringAt(0, 6, new String[]{"DANGER", "RANGER", "MANGER", ""}) || this.stringAt(current - 1, 1, new String[]{"E", "I", ""}) || this.stringAt(current - 1, 3, new String[]{"RGY", "OGY", ""}))) {
                        this.add("K", "J");
                        current += 2;
                        continue block23;
                    }
                    if (this.stringAt(current + 1, 1, new String[]{"E", "I", "Y", ""}) || this.stringAt(current - 1, 4, new String[]{"AGGI", "OGGI", ""})) {
                        if (this.stringAt(0, 4, new String[]{"VAN ", "VON ", ""}) || this.stringAt(0, 3, new String[]{"SCH", ""}) || this.stringAt(current + 1, 2, new String[]{"ET", ""})) {
                            this.add("K");
                        } else if (this.stringAt(current + 1, 4, new String[]{"IER ", ""})) {
                            this.add("J");
                        } else {
                            this.add("J", "K");
                        }
                        current += 2;
                        continue block23;
                    }
                    current = this.charAt(current + 1) == 'G' ? (current += 2) : ++current;
                    this.add("K");
                    continue block23;
                }
                case 'H': {
                    if ((current == 0 || this.isVowel(current - 1)) && this.isVowel(current + 1)) {
                        this.add("H");
                        current += 2;
                        continue block23;
                    }
                    ++current;
                    continue block23;
                }
                case 'J': {
                    if (this.stringAt(current, 4, new String[]{"JOSE", ""}) || this.stringAt(0, 4, new String[]{"SAN ", ""})) {
                        if (current == 0 && this.charAt(current + 4) == ' ' || this.stringAt(0, 4, new String[]{"SAN ", ""})) {
                            this.add("H");
                        } else {
                            this.add("J", "H");
                        }
                        ++current;
                        continue block23;
                    }
                    if (current == 0 && !this.stringAt(current, 4, new String[]{"JOSE", ""})) {
                        this.add("J", "A");
                    } else if (this.isVowel(current - 1) && !this.isSlavoGermanic() && (this.charAt(current + 1) == 'A' || this.charAt(current + 1) == 'O')) {
                        this.add("J", "H");
                    } else if (current == this.last) {
                        this.add("J", " ");
                    } else if (!this.stringAt(current + 1, 1, new String[]{"L", "T", "K", "S", "N", "M", "B", "Z", ""}) && !this.stringAt(current - 1, 1, new String[]{"S", "K", "L", ""})) {
                        this.add("J");
                    }
                    if (this.charAt(current + 1) == 'J') {
                        current += 2;
                        continue block23;
                    }
                    ++current;
                    continue block23;
                }
                case 'K': {
                    current = this.charAt(current + 1) == 'K' ? (current += 2) : ++current;
                    this.add("K");
                    continue block23;
                }
                case 'L': {
                    if (this.charAt(current + 1) == 'L') {
                        if (current == this.length - 3 && this.stringAt(current - 1, 4, new String[]{"ILLO", "ILLA", "ALLE", ""}) || (this.stringAt(this.last - 1, 2, new String[]{"AS", "OS", ""}) || this.stringAt(this.last, 1, new String[]{"A", "O", ""})) && this.stringAt(current - 1, 4, new String[]{"ALLE", ""})) {
                            this.add("L", " ");
                            current += 2;
                            continue block23;
                        }
                        current += 2;
                    } else {
                        ++current;
                    }
                    this.add("L");
                    continue block23;
                }
                case 'M': {
                    current = this.stringAt(current - 1, 3, new String[]{"UMB", ""}) && (current + 1 == this.last || this.stringAt(current + 2, 2, new String[]{"ER", ""})) || this.charAt(current + 1) == 'M' ? (current += 2) : ++current;
                    this.add("M");
                    continue block23;
                }
                case 'N': {
                    current = this.charAt(current + 1) == 'N' ? (current += 2) : ++current;
                    this.add("N");
                    continue block23;
                }
                case 'P': {
                    if (this.charAt(current + 1) == 'H') {
                        this.add("F");
                        current += 2;
                        continue block23;
                    }
                    current = this.stringAt(current + 1, 1, new String[]{"P", "B", ""}) ? (current += 2) : ++current;
                    this.add("P");
                    continue block23;
                }
                case 'Q': {
                    current = this.charAt(current + 1) == 'Q' ? (current += 2) : ++current;
                    this.add("K");
                    continue block23;
                }
                case 'R': {
                    if (current == this.last && !this.isSlavoGermanic() && this.stringAt(current - 2, 2, new String[]{"IE", ""}) && !this.stringAt(current - 4, 2, new String[]{"ME", "MA", ""})) {
                        this.add("", "R");
                    } else {
                        this.add("R");
                    }
                    if (this.charAt(current + 1) == 'R') {
                        current += 2;
                        continue block23;
                    }
                    ++current;
                    continue block23;
                }
                case 'S': {
                    if (this.stringAt(current - 1, 3, new String[]{"ISL", "YSL", ""})) {
                        ++current;
                        continue block23;
                    }
                    if (current == 0 && this.stringAt(current, 5, new String[]{"SUGAR", ""})) {
                        this.add("X", "S");
                        ++current;
                        continue block23;
                    }
                    if (this.stringAt(current, 2, new String[]{"SH", ""})) {
                        if (this.stringAt(current + 1, 4, new String[]{"HEIM", "HOEK", "HOLM", "HOLZ", ""})) {
                            this.add("S");
                        } else {
                            this.add("X");
                        }
                        current += 2;
                        continue block23;
                    }
                    if (this.stringAt(current, 3, new String[]{"SIO", "SIA", ""}) || this.stringAt(current, 4, new String[]{"SIAN", ""})) {
                        if (!this.isSlavoGermanic()) {
                            this.add("S", "X");
                        } else {
                            this.add("S");
                        }
                        current += 3;
                        continue block23;
                    }
                    if (current == 0 && this.stringAt(current + 1, 1, new String[]{"M", "N", "L", "W", ""}) || this.stringAt(current + 1, 1, new String[]{"Z", ""})) {
                        this.add("S", "X");
                        if (this.stringAt(current + 1, 1, new String[]{"Z", ""})) {
                            current += 2;
                            continue block23;
                        }
                        ++current;
                        continue block23;
                    }
                    if (this.stringAt(current, 2, new String[]{"SC", ""})) {
                        if (this.charAt(current + 2) == 'H') {
                            if (this.stringAt(current + 3, 2, new String[]{"OO", "ER", "EN", "UY", "ED", "EM", ""})) {
                                if (this.stringAt(current + 3, 2, new String[]{"ER", "EN", ""})) {
                                    this.add("X", "SK");
                                } else {
                                    this.add("SK");
                                }
                                current += 3;
                                continue block23;
                            }
                            if (current == 0 && !this.isVowel(3) && this.charAt(3) != 'W') {
                                this.add("X", "S");
                            } else {
                                this.add("X");
                            }
                            current += 3;
                            continue block23;
                        }
                        if (this.stringAt(current + 2, 1, new String[]{"I", "E", "Y", ""})) {
                            this.add("S");
                            current += 3;
                            continue block23;
                        }
                        this.add("SK");
                        current += 3;
                        continue block23;
                    }
                    if (current == this.last && this.stringAt(current - 2, 2, new String[]{"AI", "OI", ""})) {
                        this.add("", "S");
                    } else {
                        this.add("S");
                    }
                    if (this.stringAt(current + 1, 1, new String[]{"S", "Z", ""})) {
                        current += 2;
                        continue block23;
                    }
                    ++current;
                    continue block23;
                }
                case 'T': {
                    if (this.stringAt(current, 4, new String[]{"TION", ""})) {
                        this.add("X");
                        current += 3;
                        continue block23;
                    }
                    if (this.stringAt(current, 3, new String[]{"TIA", "TCH", ""})) {
                        this.add("X");
                        current += 3;
                        continue block23;
                    }
                    if (this.stringAt(current, 2, new String[]{"TH", ""}) || this.stringAt(current, 3, new String[]{"TTH", ""})) {
                        if (this.stringAt(current + 2, 2, new String[]{"OM", "AM", ""}) || this.stringAt(0, 4, new String[]{"VAN ", "VON ", ""}) || this.stringAt(0, 3, new String[]{"SCH", ""})) {
                            this.add("T");
                        } else {
                            this.add("0", "T");
                        }
                        current += 2;
                        continue block23;
                    }
                    current = this.stringAt(current + 1, 1, new String[]{"T", "D", ""}) ? (current += 2) : ++current;
                    this.add("T");
                    continue block23;
                }
                case 'V': {
                    current = this.charAt(current + 1) == 'V' ? (current += 2) : ++current;
                    this.add("F");
                    continue block23;
                }
                case 'W': {
                    if (this.stringAt(current, 2, new String[]{"WR", ""})) {
                        this.add("R");
                        current += 2;
                        continue block23;
                    }
                    if (current == 0 && (this.isVowel(current + 1) || this.stringAt(current, 2, new String[]{"WH", ""}))) {
                        if (this.isVowel(current + 1)) {
                            this.add("A", "F");
                        } else {
                            this.add("A");
                        }
                    }
                    if (current == this.last && this.isVowel(current - 1) || this.stringAt(current - 1, 5, new String[]{"EWSKI", "EWSKY", "OWSKI", "OWSKY", ""}) || this.stringAt(0, 3, new String[]{"SCH", ""})) {
                        this.add("", "F");
                        ++current;
                        continue block23;
                    }
                    if (this.stringAt(current, 4, new String[]{"WICZ", "WITZ", ""})) {
                        this.add("TS", "FX");
                        current += 4;
                        continue block23;
                    }
                    ++current;
                    continue block23;
                }
                case 'X': {
                    if (current != this.last || !this.stringAt(current - 3, 3, new String[]{"IAU", "EAU", ""}) && !this.stringAt(current - 2, 2, new String[]{"AU", "OU", ""})) {
                        this.add("KS");
                    }
                    if (this.stringAt(current + 1, 1, new String[]{"C", "X", ""})) {
                        current += 2;
                        continue block23;
                    }
                    ++current;
                    continue block23;
                }
                case 'Z': {
                    if (this.charAt(current + 1) == 'H') {
                        this.add("J");
                        current += 2;
                        continue block23;
                    }
                    if (this.stringAt(current + 1, 2, new String[]{"ZO", "ZI", "ZA", ""}) || this.isSlavoGermanic() && current > 0 && this.charAt(current - 1) != 'T') {
                        this.add("S", "TS");
                    } else {
                        this.add("S");
                    }
                    if (this.charAt(current + 1) == 'Z') {
                        current += 2;
                        continue block23;
                    }
                    ++current;
                    continue block23;
                }
            }
            ++current;
        }
    }

    @Override
    public double distance(MetaphoneModel metaphoneModel) {
        double l;
        String t;
        String s = this.getPrimary();
        double distance = MathHelper.levenshtein((String)s, (String)(t = metaphoneModel.getPrimary()));
        if (distance >= (l = (double)Math.min(s.length(), t.length()))) {
            distance = 10.0;
        }
        if (this.getWord().equals(metaphoneModel.getWord())) {
            return 0.0;
        }
        return 1.0 + distance / l;
    }

    @Override
    public String getPrimary() {
        return this.primary;
    }

    @Override
    public String getSecondary() {
        return this.secondary;
    }

    @Override
    public String getWord() {
        return this.string;
    }

    private void add(String primary) {
        this.primary = this.primary + primary;
        this.secondary = this.secondary + primary;
    }

    private void add(String primary, String secondary) {
        this.primary = this.primary + primary;
        if (!secondary.substring(0, 1).equals(" ")) {
            this.alternate = false;
            this.secondary = this.secondary + primary;
        }
    }

    private boolean stringAt(int start, int end, String[] strings) {
        boolean found = false;
        if (start < 0 || start >= this.length || start + end < 0 || start + end >= this.length) {
            return false;
        }
        String sub = this.string.substring(start, start + end);
        for (int i = 0; i < strings.length; ++i) {
            found = found || sub.equals(strings[i]);
        }
        return found;
    }

    private char charAt(int index) {
        return this.string.charAt(index);
    }

    private boolean isSlavoGermanic() {
        return this.string.indexOf(87) > -1 || this.string.indexOf(75) > -1 || this.string.indexOf("CZ") > -1 || this.string.indexOf("WITZ") > -1;
    }

    private boolean isVowel(int index) {
        if (index < 0 || index >= this.length) {
            return false;
        }
        char it = this.string.charAt(index);
        return it == 'A' || it == 'E' || it == 'I' || it == 'O' || it == 'U' || it == 'Y';
    }

    public String toString() {
        return this.getClass().getName() + "[string=" + this.string.trim() + ",primary=" + this.primary + ",secondary=" + this.secondary + "]";
    }
}

