/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.properties;

import com.macrofocus.color.RGBColorModel;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.RowMajorDataModel;
import com.macrofocus.data.row.SimpleRowModel;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;

public class PropertiesHelper {
    public static DataModel convertToDataModel(PropertiesModel propertiesModel) {
        if (propertiesModel != null) {
            Class[] classes = new Class[]{String.class, String.class, String.class};
            Object[] names = new String[]{"Key", "Class", "Value"};
            RowMajorDataModel dataModel = new RowMajorDataModel(names, classes);
            Map map = propertiesModel.getMap();
            for (Map.Entry entry : map.entrySet()) {
                String value;
                Class<?> cl = entry.getValue().getClass();
                if (Color.class.equals(cl)) {
                    Color color = (Color)entry.getValue();
                    value = color.getRed() + "," + color.getGreen() + "," + color.getBlue();
                } else {
                    value = entry.getValue().toString();
                }
                Object[] values = new Object[]{entry.getKey(), cl.getName(), value};
                dataModel.addRowModel(new SimpleRowModel(values, classes, names));
            }
            return dataModel;
        }
        return null;
    }

    public static void load(PropertiesModel propertiesModel, DataModel dataModel) {
        if (dataModel != null) {
            Hashtable<String, Color> hashtable = new Hashtable<String, Color>();
            for (int row = 0; row < dataModel.getRowCount(); ++row) {
                try {
                    Object value;
                    Class valueClass;
                    String key = (String)dataModel.getValueAt(row, 0);
                    String c = dataModel.getValueAt(row, 1).toString();
                    if (c.equals("Double")) {
                        valueClass = Double.class;
                    } else if (c.equals("Float")) {
                        valueClass = Float.class;
                    } else if (c.equals("Long")) {
                        valueClass = Long.class;
                    } else if (c.equals("Integer")) {
                        valueClass = Integer.class;
                    } else if (c.equals("Short")) {
                        valueClass = Short.class;
                    } else if (c.equals("Byte")) {
                        valueClass = Byte.class;
                    } else if (c.equals("Boolean")) {
                        valueClass = Boolean.class;
                    } else if (c.equals("String")) {
                        valueClass = String.class;
                    } else if (c.equals("StringBuffer")) {
                        valueClass = StringBuffer.class;
                    } else if (c.equals("Color")) {
                        valueClass = Color.class;
                    } else {
                        try {
                            valueClass = Class.forName(c);
                        }
                        catch (ClassNotFoundException e) {
                            valueClass = Class.forName("java.lang." + c);
                        }
                    }
                    String valueString = ((String)dataModel.getValueAt(row, 2)).trim();
                    if (valueClass == Color.class) {
                        value = new RGBColorModel(valueString).getColor();
                    } else {
                        Class[] cl = new Class[]{String.class};
                        Constructor constructor = valueClass.getConstructor(cl);
                        try {
                            Field field = valueClass.getField(valueString);
                            value = field.get(null);
                        }
                        catch (NoSuchFieldException e) {
                            try {
                                Object[] initargs = new Object[]{valueString};
                                value = constructor.newInstance(initargs);
                            }
                            catch (InvocationTargetException ite) {
                                value = null;
                                System.err.println("Invalid value for " + valueClass.getName() + ":" + valueString);
                                e.printStackTrace();
                            }
                        }
                    }
                    if (key == null || value == null) continue;
                    hashtable.put(key, (Color)value);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Error in row " + row);
                }
            }
            propertiesModel.setValues(hashtable);
        }
    }
}

