/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.properties;

import com.macrofocus.data.DataHelper;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.properties.PropertiesHelper;
import com.macrofocus.resources.properties.AbstractPropertyPropertiesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;

public class SimplePropertiesModel
extends AbstractPropertyPropertiesModel
implements Externalizable {
    static final long serialVersionUID = 2877230954486493251L;
    private Hashtable hashtable;
    private URL url = null;

    public SimplePropertiesModel(ResourceBundle resourceBundle) {
        Enumeration<String> elements = resourceBundle.getKeys();
        this.hashtable = new Hashtable();
        while (elements.hasMoreElements()) {
            String key = elements.nextElement();
            Object value = resourceBundle.getObject(key);
            this.hashtable.put(key, value);
        }
    }

    public SimplePropertiesModel(URL url) {
        this.hashtable = new Hashtable();
        this.url = url;
        PropertiesHelper.load((PropertiesModel)this, DataHelper.loadTxt(url, "UTF-8"));
    }

    public SimplePropertiesModel(DataModel dataModel) {
        this.hashtable = new Hashtable();
        if (dataModel != null) {
            PropertiesHelper.load((PropertiesModel)this, dataModel);
        }
    }

    public SimplePropertiesModel(String[] keys, Object[] values) {
        this.hashtable = new Hashtable();
        int count = Math.min(keys.length, values.length);
        for (int i = 0; i < count; ++i) {
            this.hashtable.put(keys[i], values[i]);
        }
    }

    public SimplePropertiesModel() {
        this.hashtable = new Hashtable();
    }

    public void reload() {
        PropertiesHelper.load((PropertiesModel)this, DataHelper.loadTxt(this.url));
        this.notifyPropertiesChanged(new PropertiesEvent((PropertiesModel)this));
    }

    public boolean isAvailable(String key) {
        return this.hashtable.get(key) != null;
    }

    public boolean isAvailable(Class cl, String name, String property) {
        return name != null && this.hashtable.get(cl.getName() + "." + name + "." + property) != null || this.hashtable.get(cl.getName() + "." + property) != null;
    }

    public Object getValue(String key) {
        Object value = this.hashtable.get(key);
        return value;
    }

    public Object getValue(String key, Object defaultValue) {
        if (this.hashtable.containsKey(key)) {
            Object value = this.hashtable.get(key);
            if (value == null) {
                throw new RuntimeException("Cannot find value for " + key);
            }
            return value;
        }
        return defaultValue;
    }

    public Color getColor(String key) {
        return (Color)this.getValue(key);
    }

    public Object getValue(Class cl, String name, String property) {
        Object value = null;
        if (name != null && this.hashtable.get(cl.getName() + "." + name + "." + property) != null) {
            value = this.hashtable.get(cl.getName() + "." + name + "." + property);
        } else if (this.hashtable.get(cl.getName() + "." + property) != null) {
            value = this.hashtable.get(cl.getName() + "." + property);
        }
        if (value == null) {
            throw new RuntimeException("Cannot find value for " + cl.getName() + "." + name + "." + property);
        }
        return value;
    }

    public Object getValue(Class cl, String property) {
        Object value = this.hashtable.get(cl.getName() + "." + property);
        if (value == null) {
            throw new RuntimeException("Cannot find value for " + cl.getName() + "." + property);
        }
        return value;
    }

    public void setValue(Class cl, String name, String property, Object value) {
        String key = cl.getName() + "." + name + "." + property;
        if (this.hashtable.containsKey(key)) {
            Object oldValue = this.hashtable.get(key);
            if (!value.equals(oldValue)) {
                this.hashtable.put(key, value);
                this.notifyPropertiesChanged(new PropertiesEvent((PropertiesModel)this, key, value, oldValue));
            }
        } else {
            this.hashtable.put(key, value);
            this.notifyPropertiesChanged(new PropertiesEvent((PropertiesModel)this, key, value, null));
        }
    }

    public void setValue(Class cl, String name, Object value) {
        String key = cl.getName() + "." + name;
        if (this.hashtable.containsKey(key)) {
            Object oldValue = this.hashtable.get(key);
            if (!value.equals(oldValue)) {
                this.hashtable.put(key, value);
                this.notifyPropertiesChanged(new PropertiesEvent((PropertiesModel)this, key, value, oldValue));
            }
        } else {
            this.hashtable.put(key, value);
            this.notifyPropertiesChanged(new PropertiesEvent((PropertiesModel)this, key, value, null));
        }
    }

    public void setValue(String key, Object value) {
        if (this.hashtable.containsKey(key)) {
            Object oldValue = this.hashtable.get(key);
            if (value != null || oldValue != null || !value.equals(oldValue)) {
                if (value == null) {
                    this.hashtable.remove(key);
                } else {
                    this.hashtable.put(key, value);
                }
                this.notifyPropertiesChanged(new PropertiesEvent((PropertiesModel)this, key, value, oldValue));
            }
        } else {
            if (value != null) {
                this.hashtable.put(key, value);
            }
            this.notifyPropertiesChanged(new PropertiesEvent((PropertiesModel)this, key, value, null));
        }
        this.notifyPropertiesChanged(new PropertiesEvent((PropertiesModel)this));
    }

    public void setValues(PropertiesModel propertiesModel) {
        this.hashtable.putAll(propertiesModel.getMap());
        this.notifyPropertiesChanged(new PropertiesEvent((PropertiesModel)this));
    }

    public void setValues(Hashtable hashtable) {
        this.hashtable.putAll(hashtable);
        this.notifyPropertiesChanged(new PropertiesEvent((PropertiesModel)this));
    }

    public void resetValues(PropertiesModel propertiesModel) {
        Hashtable hashtable = new Hashtable();
        hashtable.putAll(propertiesModel.getMap());
        this.hashtable = hashtable;
        this.notifyPropertiesChanged(new PropertiesEvent((PropertiesModel)this));
    }

    public Map getMap() {
        return this.hashtable;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(10000);
        out.writeObject(this.hashtable);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version > 0) {
            this.hashtable = (Hashtable)in.readObject();
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hashtable=" + this.hashtable + "]";
    }
}

