/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.reader;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.reader.DataReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class BinaryDataReader
implements DataReader {
    private String[] labels;
    private Class[] classes;
    private Constructor[] constructors;
    private int rowCount;
    private int columnCount;
    private int row;
    private int column;
    private final DataInputStream stream;
    private static final int MAGIC = 299792;

    public BinaryDataReader(DataInputStream stream) {
        this.stream = stream;
        try {
            int i;
            int magic = stream.readInt();
            this.rowCount = stream.readInt();
            this.columnCount = stream.readInt();
            this.labels = new String[this.getColumnCount()];
            this.classes = new Class[this.getColumnCount()];
            this.constructors = new Constructor[this.getColumnCount()];
            for (i = 0; i < this.getColumnCount(); ++i) {
                this.labels[i] = stream.readUTF();
            }
            for (i = 0; i < this.getColumnCount(); ++i) {
                String c = stream.readUTF();
                if (c.equals("byte")) {
                    this.classes[i] = Byte.class;
                } else if (c.equals("char")) {
                    this.classes[i] = Character.class;
                } else if (c.equals("double")) {
                    this.classes[i] = Double.class;
                } else if (c.equals("float")) {
                    this.classes[i] = Float.class;
                } else if (c.equals("int")) {
                    this.classes[i] = Integer.class;
                } else if (c.equals("long")) {
                    this.classes[i] = Long.class;
                } else if (c.equals("short")) {
                    this.classes[i] = Short.class;
                } else if (c.equals("boolean")) {
                    this.classes[i] = Boolean.class;
                } else {
                    try {
                        Class<?> cl;
                        try {
                            cl = Class.forName(c);
                        }
                        catch (ClassNotFoundException e) {
                            cl = Class.forName("java.lang." + c);
                        }
                        this.classes[i] = cl;
                    }
                    catch (ClassNotFoundException e) {
                        Logging.getInstance().process((Throwable)e);
                    }
                }
                try {
                    Class[] arg = new Class[]{String.class};
                    this.constructors[i] = this.classes[i].getConstructor(arg);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    Logging.getInstance().process((Throwable)e);
                }
            }
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
            this.columnCount = 0;
            this.labels = new String[0];
            this.classes = new Class[0];
        }
        this.row = -1;
        this.column = -1;
    }

    @Override
    public Object getColumnName(int column) {
        return this.labels[column];
    }

    @Override
    public Class getClass(int column) {
        return this.classes[column];
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void nextRow() {
        ++this.row;
        this.column = -1;
    }

    @Override
    public Object nextColumn() {
        Comparable<Byte> value;
        block14: {
            ++this.column;
            value = null;
            try {
                if (this.classes[this.column] == Byte.class) {
                    value = this.stream.readByte();
                    break block14;
                }
                if (this.classes[this.column] == Character.class) {
                    value = Character.valueOf(this.stream.readChar());
                    break block14;
                }
                if (this.classes[this.column] == Double.class) {
                    value = this.stream.readDouble();
                    break block14;
                }
                if (this.classes[this.column] == Float.class) {
                    value = Float.valueOf(this.stream.readFloat());
                    break block14;
                }
                if (this.classes[this.column] == Integer.class) {
                    value = this.stream.readInt();
                    break block14;
                }
                if (this.classes[this.column] == Long.class) {
                    value = this.stream.readLong();
                    break block14;
                }
                if (this.classes[this.column] == Short.class) {
                    value = this.stream.readShort();
                    break block14;
                }
                if (this.classes[this.column] == Boolean.class) {
                    value = this.stream.readBoolean();
                    break block14;
                }
                String token = this.stream.readUTF();
                Object[] initargs = new Object[]{token};
                if (!(token == null || token.equals("") || token.equals("n.a.") || token.equals("N/A") || token.equals("x") || token.equals("NaN") || token.equals("---"))) {
                    try {
                        value = this.constructors[this.column].newInstance(initargs);
                        if (value == null) {
                            System.err.println("Instantiation failed for " + token + " as " + this.constructors[this.column]);
                            throw new NoSuchFieldException("Instantiation failed for " + token + ",constructor=" + this.constructors[this.column]);
                        }
                        break block14;
                    }
                    catch (Exception e) {
                        Logging.getInstance().process((Throwable)e);
                        System.err.println("Instantiation failed for " + token + " as " + this.constructors[this.column]);
                    }
                    break block14;
                }
                value = null;
            }
            catch (IOException e) {
                Logging.getInstance().process((Throwable)e);
            }
        }
        return value;
    }

    @Override
    public boolean hasMoreRow() {
        return this.row < this.getRowCount() - 1;
    }

    @Override
    public boolean hasMoreColumn() {
        return this.column < this.getColumnCount() - 1;
    }

    @Override
    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public boolean isHasClassHeader() {
        return true;
    }
}

