/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.reader;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.header.MultilineHeaderModel;
import com.macrofocus.data.reader.DataReader;
import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.util.tokenizer.CharTokenizerModel;
import com.macrofocus.util.tokenizer.TokenizerModel;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.Constructor;

public class GenericDataReader
implements DataReader {
    private Object[] labels;
    private Class[] classes;
    private Constructor[] constructors;
    private static final int rowCount = -1;
    private int columnCount;
    private int row;
    private int column;
    private final LineNumberReader lnr;
    private TokenizerModel current;
    private TokenizerModel first;
    private final char delim;
    private String token;
    private final int endLineNumber;

    public GenericDataReader(Reader reader, char delim) {
        this(reader, delim, true, true, "String", 0, Integer.MAX_VALUE);
    }

    public GenericDataReader(Reader reader, char delim, boolean hasColumnHeader, boolean hasClassHeader) {
        this(reader, delim, hasColumnHeader, hasClassHeader, "String", 0, Integer.MAX_VALUE);
    }

    public GenericDataReader(Reader reader, char delim, boolean hasColumnHeader, boolean hasClassHeader, String className) {
        this(reader, delim, hasColumnHeader, hasClassHeader, className, 0, Integer.MAX_VALUE);
    }

    public GenericDataReader(Reader reader, char delim, boolean hasColumnHeader, boolean hasClassHeader, String className, int startLineNumber, int endLineNumber) {
        this(reader, delim, hasColumnHeader, hasClassHeader, className, startLineNumber, endLineNumber, 1, new DefaultTypemapModel());
    }

    public GenericDataReader(Reader reader, char delim, boolean hasColumnHeader, boolean hasClassHeader, String className, int startLineNumber, int endLineNumber, int columnHeaderLines, TypemapModel typemapModel) {
        this.delim = delim;
        this.endLineNumber = endLineNumber;
        this.lnr = new LineNumberReader(reader);
        try {
            int l;
            while (this.getLineNumber() < startLineNumber) {
                this.lnr.readLine();
            }
            TokenizerModel[] columnHeader = new TokenizerModel[columnHeaderLines];
            CharTokenizerModel classHeader = null;
            if (hasColumnHeader) {
                for (l = 0; l < columnHeaderLines; ++l) {
                    columnHeader[l] = new CharTokenizerModel(this.lnr.readLine(), delim);
                }
            }
            if (hasClassHeader) {
                classHeader = new CharTokenizerModel(this.lnr.readLine(), delim);
            }
            this.first = null;
            if (hasColumnHeader && hasClassHeader) {
                for (l = 0; l < columnHeaderLines; ++l) {
                    this.columnCount = Math.min(columnHeader[l].countTokens(), classHeader.countTokens());
                }
            } else if (hasColumnHeader) {
                this.columnCount = Integer.MAX_VALUE;
                for (l = 0; l < columnHeaderLines; ++l) {
                    this.columnCount = Math.min(columnHeader[l].countTokens(), this.columnCount);
                }
            } else if (hasClassHeader) {
                this.columnCount = classHeader.countTokens();
            } else {
                this.first = new CharTokenizerModel(this.lnr.readLine(), delim);
                this.columnCount = this.first.countTokens();
            }
            this.labels = new Object[this.getColumnCount()];
            this.classes = new Class[this.getColumnCount()];
            this.constructors = new Constructor[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (hasColumnHeader) {
                    if (columnHeaderLines == 1) {
                        String token = columnHeader[0].nextToken();
                        if (token.startsWith("\"") && token.endsWith("\"")) {
                            token = token.substring(1, token.length() - 1);
                        }
                        this.labels[i] = token;
                    } else {
                        String[] s = new String[columnHeaderLines];
                        for (int l2 = 0; l2 < columnHeaderLines; ++l2) {
                            String token = columnHeader[l2].nextToken();
                            if (token.startsWith("\"") && token.endsWith("\"")) {
                                token = token.substring(1, token.length() - 1);
                            }
                            s[l2] = token;
                        }
                        this.labels[i] = new MultilineHeaderModel(s);
                    }
                } else {
                    this.labels[i] = "Column " + i;
                }
                String c = hasClassHeader ? classHeader.nextToken() : className;
                try {
                    Class cl;
                    this.classes[i] = cl = typemapModel.getClass(c);
                }
                catch (Exception e) {
                    Logging.getInstance().process((Throwable)e);
                }
                try {
                    Class[] arg = new Class[]{String.class};
                    this.constructors[i] = this.classes[i].getConstructor(arg);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    Logging.getInstance().process((Throwable)e);
                }
            }
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
            this.columnCount = 0;
            this.labels = new String[0];
            this.classes = new Class[0];
        }
        this.row = -1;
        this.column = -1;
    }

    @Override
    public Object getColumnName(int column) {
        return this.labels[column];
    }

    @Override
    public Class getClass(int column) {
        return this.classes[column];
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return -1;
    }

    @Override
    public void nextRow() {
        try {
            if (this.first == null) {
                String line = this.lnr.readLine();
                this.current = line != null ? new CharTokenizerModel(line, this.delim) : null;
            } else {
                this.current = this.first;
                this.first = null;
            }
            ++this.row;
            this.column = -1;
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public Object nextColumn() {
        ++this.column;
        this.token = this.current.nextToken();
        Object value = null;
        if (!(this.token == null || this.token.equals("") || this.token.equals("n.a.") || this.token.equals("N/A") || this.token.equals("x") || this.token.equals("NaN") || this.token.equals("---") || this.token.equals("Infinity") || this.token.equals("-Infinity") || this.token.equals("NULL") || this.token.equals("#VALUE!"))) {
            if (this.token.startsWith("\"") && this.token.endsWith("\"")) {
                this.token = this.token.substring(1, this.token.length() - 1);
            }
            try {
                if (this.classes[this.column] == String.class) {
                    value = this.token;
                } else if (this.classes[this.column] == Byte.class) {
                    value = Byte.parseByte(this.token);
                } else if (this.classes[this.column] == Double.class) {
                    value = Double.parseDouble(this.token);
                } else if (this.classes[this.column] == Float.class) {
                    value = Float.valueOf(Float.parseFloat(this.token));
                } else if (this.classes[this.column] == Integer.class) {
                    value = Integer.parseInt(this.token);
                } else if (this.classes[this.column] == Long.class) {
                    value = Long.parseLong(this.token);
                } else if (this.classes[this.column] == Short.class) {
                    value = Short.parseShort(this.token);
                } else {
                    Object[] initargs = new Object[]{this.token};
                    value = this.constructors[this.column].newInstance(initargs);
                }
                if (value == null) {
                    Logging.getInstance().process((Throwable)new NoSuchFieldException("Instantiation failed for " + this.token + " as " + this.constructors[this.column] + " at line " + this.lnr.getLineNumber()));
                }
            }
            catch (Exception e) {
                Logging.getInstance().process((Throwable)new Exception("Instantiation failed for column " + this.getColumnName(this.column) + " of " + this.token + " as " + this.constructors[this.column] + " at line " + this.lnr.getLineNumber(), e));
            }
        } else {
            value = null;
        }
        return value;
    }

    @Override
    public boolean hasMoreRow() {
        try {
            return this.lnr.ready() && this.getLineNumber() <= this.endLineNumber;
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean hasMoreColumn() {
        try {
            return this.current != null && this.current.hasMoreTokens();
        }
        catch (StringIndexOutOfBoundsException e) {
            Logging.getInstance().process((Throwable)new Exception("Row:" + this.row + ", column:" + this.column, e));
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.lnr.close();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getLineNumber() {
        return this.lnr.getLineNumber();
    }

    public void setClasses(Class[] classes) {
        this.classes = classes;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            try {
                Class[] arg = new Class[]{String.class};
                this.constructors[i] = classes[i].getConstructor(arg);
                continue;
            }
            catch (NoSuchMethodException e) {
                Logging.getInstance().process((Throwable)e);
            }
        }
    }

    @Override
    public boolean isHasClassHeader() {
        return true;
    }
}

