/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.reader;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.header.MultilineHeaderModel;
import com.macrofocus.data.reader.DataReader;
import com.macrofocus.data.reader.FileLoader;
import com.macrofocus.data.reader.Tokenizer;
import com.macrofocus.data.reader.TokenizerFactory;
import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.InvalidValueException;
import com.macrofocus.data.typemap.TypemapModel;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class PerfectDataReader
implements DataReader {
    private Object[] labels;
    private Class[] classes;
    private TypemapModel.Builder[] builders;
    private final int rowCount = -1;
    private int columnCount;
    private int row;
    private int column;
    private final LineNumberReader lnr;
    private Tokenizer current;
    private Iterator<String> currentIterator;
    private Tokenizer first;
    private Tokenizer second;
    private Tokenizer next;
    private final TokenizerFactory tokenizerFactory;
    private String token;
    private final int startLineNumber;
    private final int endLineNumber;
    private boolean hasClassHeader;
    private FileLoader fileLoader;
    private boolean exceptionThrown = false;
    private HashSet<String> nullStrings = new HashSet<String>(Arrays.asList("", "n.a.", "N/A", "x", "NaN", "---", "Infinity", "-Infinity", "NULL", "#VALUE!", "#N/A"));

    public PerfectDataReader(Reader reader, TokenizerFactory tokenizerFactory) {
        this(reader, tokenizerFactory, true, true, "String", 0, Integer.MAX_VALUE);
    }

    public PerfectDataReader(Reader reader, TokenizerFactory tokenizerFactory, boolean hasColumnHeader, boolean hasClassHeader) {
        this(reader, tokenizerFactory, hasColumnHeader, hasClassHeader, "String", 0, Integer.MAX_VALUE);
    }

    public PerfectDataReader(Reader reader, TokenizerFactory tokenizerFactory, boolean hasColumnHeader, boolean hasClassHeader, String className) {
        this(reader, tokenizerFactory, hasColumnHeader, hasClassHeader, className, 0, Integer.MAX_VALUE);
    }

    public PerfectDataReader(Reader reader, TokenizerFactory tokenizerFactory, boolean hasColumnHeader, boolean hasClassHeader, String className, int startLineNumber, int endLineNumber) {
        this(reader, tokenizerFactory, hasColumnHeader, hasClassHeader, className, startLineNumber, endLineNumber, 1, new DefaultTypemapModel(), new TypemapModel.Builder[0]);
    }

    public PerfectDataReader(Reader reader, TokenizerFactory tokenizerFactory, boolean hasColumnHeader, boolean hasClassHeader, String className, int startLineNumber, int endLineNumber, int columnHeaderLines, TypemapModel typemapModel, TypemapModel.Builder ... builders) {
        this.tokenizerFactory = tokenizerFactory;
        this.startLineNumber = startLineNumber;
        this.endLineNumber = endLineNumber;
        this.lnr = new LineNumberReader(reader, 1);
        try {
            int l;
            while (this.getLineNumber() < startLineNumber) {
                this.lnr.readLine();
            }
            Tokenizer[] columnHeader = new Tokenizer[columnHeaderLines];
            Tokenizer classHeader = null;
            Tokenizer firstLine = null;
            if (hasColumnHeader) {
                for (int l2 = 0; l2 < columnHeaderLines; ++l2) {
                    columnHeader[l2] = firstLine == null ? (firstLine = tokenizerFactory.createTokenizer(this.lnr)) : tokenizerFactory.createTokenizer(this.lnr);
                }
            }
            if (!hasClassHeader) {
                Tokenizer secondLine = tokenizerFactory.createTokenizer(this.lnr);
                boolean known = true;
                for (String token : secondLine) {
                    if (token == null || typemapModel.findBuilder(token) != null) continue;
                    known = false;
                    break;
                }
                if ((!hasColumnHeader || columnHeader[0].size() == secondLine.size()) && known) {
                    hasClassHeader = true;
                    classHeader = secondLine;
                } else {
                    this.second = secondLine;
                }
            } else {
                classHeader = tokenizerFactory.createTokenizer(this.lnr);
            }
            Iterator classHeaderIterator = classHeader != null ? classHeader.iterator() : null;
            this.hasClassHeader = hasClassHeader;
            this.first = null;
            if (hasColumnHeader && hasClassHeader) {
                for (l = 0; l < columnHeaderLines; ++l) {
                    this.columnCount = Math.min(columnHeader[l].size(), classHeader.size());
                }
            } else if (hasColumnHeader) {
                this.columnCount = Integer.MAX_VALUE;
                for (l = 0; l < columnHeaderLines; ++l) {
                    this.columnCount = Math.min(columnHeader[l].size(), this.columnCount);
                }
            } else if (hasClassHeader) {
                this.columnCount = classHeader.size();
            } else {
                this.first = tokenizerFactory.createTokenizer(this.lnr);
                this.columnCount = this.first.size();
            }
            if (firstLine != null) {
                int lastValidColumn = -1;
                Tokenizer firstLineTokenizer = firstLine;
                int column = -1;
                for (String token : firstLineTokenizer) {
                    ++column;
                    if (token == null) continue;
                    lastValidColumn = column;
                }
                this.columnCount = lastValidColumn + 1;
            }
            this.labels = new Object[this.getColumnCount()];
            this.classes = new Class[this.getColumnCount()];
            this.builders = new TypemapModel.Builder[this.getColumnCount()];
            if (builders != null) {
                for (int i = 0; i < builders.length; ++i) {
                    TypemapModel.Builder builder;
                    this.builders[i] = builder = builders[i];
                }
            }
            Iterator[] columnHeaderIterator = new Iterator[columnHeader.length];
            for (int c = 0; c < columnHeader.length; ++c) {
                columnHeaderIterator[c] = columnHeader[c].iterator();
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (hasColumnHeader) {
                    if (columnHeaderLines == 1) {
                        String token;
                        token = (String)columnHeaderIterator[0].next();
                        this.labels[i] = token;
                    } else {
                        String[] s = new String[columnHeaderLines];
                        for (int l3 = 0; l3 < columnHeaderLines; ++l3) {
                            String token;
                            s[l3] = token = (String)columnHeaderIterator[l3].next();
                        }
                        this.labels[i] = new MultilineHeaderModel(s);
                    }
                } else {
                    this.labels[i] = "Column " + i;
                }
                String c = hasClassHeader ? (String)classHeaderIterator.next() : className;
                try {
                    TypemapModel.Builder builder = c == null ? typemapModel.getBuilder("String") : typemapModel.getBuilder(c);
                    if (this.builders[i] == null) {
                        this.builders[i] = builder;
                    }
                    this.classes[i] = this.builders[i].getType();
                    continue;
                }
                catch (Exception e) {
                    Logging.getInstance().process((Throwable)e);
                }
            }
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
            this.columnCount = 0;
            this.labels = new String[0];
            this.classes = new Class[0];
        }
        this.row = -1;
        this.column = -1;
    }

    @Override
    public Object getColumnName(int column) {
        return this.labels[column];
    }

    @Override
    public Class getClass(int column) {
        return this.classes[column];
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return -1;
    }

    @Override
    public void nextRow() {
        if (this.first != null) {
            this.current = this.first;
            this.currentIterator = this.current.iterator();
            this.first = null;
        } else if (this.second != null) {
            this.current = this.second;
            this.currentIterator = this.current.iterator();
            this.second = null;
        } else {
            this.current = this.next;
            this.currentIterator = this.current.iterator();
        }
        ++this.row;
        this.column = -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object nextColumn() {
        ++this.column;
        this.token = this.currentIterator.next();
        Object value = null;
        if (this.token == null) return null;
        if (this.token instanceof String) {
            if (this.nullStrings.contains(this.token)) return null;
        }
        try {
            if (!(this.builders[this.column] instanceof DefaultTypemapModel.ImageBuilderFactory.ImageBuilder)) return this.builders[this.column].create(this.token);
            ((DefaultTypemapModel.ImageBuilderFactory.ImageBuilder)this.builders[this.column]).setFileLoader(this.fileLoader);
            return this.builders[this.column].create(this.token);
        }
        catch (Exception e) {
            if (this.exceptionThrown) return value;
            this.exceptionThrown = true;
            String message = "Incorrect value \"" + this.token + "\"";
            if (this.builders != null && this.builders[this.column] != null) {
                message = message + " for type " + this.builders[this.column].getName();
            }
            message = message + " at line " + this.lnr.getLineNumber() + " for column " + this.getColumnName(this.column);
            InvalidValueException t = new InvalidValueException(message, e);
            if (!Logging.getInstance().process((Throwable)t)) return null;
            throw new RuntimeException(t);
        }
    }

    @Override
    public boolean hasMoreRow() {
        try {
            if (this.getLineNumber() <= this.endLineNumber) {
                boolean c3;
                boolean c1 = this.second != null;
                boolean c2 = this.current != null;
                boolean bl = c3 = this.current != null && this.current.size() >= 0;
                if (this.second != null) {
                    return true;
                }
                if (this.current != null && this.current.size() > 0) {
                    this.next = this.tokenizerFactory.createTokenizer(this.lnr);
                    return this.next.size() >= 0;
                }
                if (this.tokenizerFactory.getEndLine() == null) {
                    this.next = this.tokenizerFactory.createTokenizer(this.lnr);
                    return this.next.size() >= 0;
                }
                return false;
            }
            return false;
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean hasMoreColumn() {
        try {
            return this.current != null && this.currentIterator.hasNext();
        }
        catch (StringIndexOutOfBoundsException e) {
            Logging.getInstance().process((Throwable)new Exception("Row:" + this.row + ", column:" + this.column, e));
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.lnr.close();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getLineNumber() {
        return this.lnr.getLineNumber();
    }

    @Override
    public boolean isHasClassHeader() {
        return this.hasClassHeader;
    }

    public void setFileLoader(FileLoader fileLoader) {
        this.fileLoader = fileLoader;
    }
}

