/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.reader;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.header.MultilineHeaderModel;
import com.macrofocus.data.reader.DataReader;
import com.macrofocus.data.reader.InvalidTypeException;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.util.ole.biff.sheet.SheetModel;

public class SheetDataReader
implements DataReader {
    private final SheetModel sheetModel;
    private Object[] labels;
    private Class[] classes;
    private String[] classesString;
    private TypemapModel.Builder[] constructors;
    private int column;
    private int row;
    private final int rowCount;

    public SheetDataReader(SheetModel sheetModel, boolean hasColumnHeader, boolean hasClassHeader, String className, int startLineNumber, int endLineNumber, int columnHeaderLines, TypemapModel typemapModel) {
        int c;
        this.sheetModel = sheetModel;
        this.row = startLineNumber;
        this.column = -1;
        this.rowCount = sheetModel.getRowCount() - startLineNumber - (hasClassHeader ? 1 : 0) - columnHeaderLines;
        this.labels = new Object[this.getColumnCount()];
        this.classes = new Class[this.getColumnCount()];
        this.classesString = new String[this.getColumnCount()];
        this.constructors = new TypemapModel.Builder[this.getColumnCount()];
        for (c = 0; c < this.getColumnCount(); ++c) {
            if (hasColumnHeader) {
                if (columnHeaderLines == 1) {
                    this.labels[c] = sheetModel.getObject(this.row, c);
                    continue;
                }
                String[] s = new String[columnHeaderLines];
                for (int l = 0; l < columnHeaderLines; ++l) {
                    s[l] = sheetModel.getObject(this.row + l, c) != null ? sheetModel.getObject(this.row + l, c).toString() : null;
                }
                this.labels[c] = new MultilineHeaderModel(s);
                continue;
            }
            this.labels[c] = "Column " + c;
        }
        this.row += columnHeaderLines;
        for (c = 0; c < this.getColumnCount(); ++c) {
            String classString = hasClassHeader ? (sheetModel.getObject(this.row, c) != null ? sheetModel.getObject(this.row, c).toString() : className) : className;
            this.classesString[c] = classString;
            try {
                Class cl;
                this.classes[c] = cl = typemapModel.getClass(classString);
                continue;
            }
            catch (Exception e) {
                Logging.getInstance().process((Throwable)new InvalidTypeException("Invalid type " + classString + " in cell " + SheetDataReader.convertNumToColString(c) + "" + (this.row + 1), e));
                this.classes[c] = String.class;
            }
        }
        ++this.row;
    }

    @Override
    public Object getColumnName(int column) {
        return this.labels[column];
    }

    @Override
    public Class getClass(int column) {
        return this.classes[column];
    }

    @Override
    public int getColumnCount() {
        return this.sheetModel.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void nextRow() {
        this.column = -1;
        ++this.row;
    }

    @Override
    public Object nextColumn() {
        ++this.column;
        String token = (String)this.sheetModel.getObject(this.row, this.column);
        Object value = null;
        if (!(token == null || token.equals("") || token.equals(" ") || token.equals("n.a.") || token.equals("N/A") || token.equals("x") || token.equals("NaN") || token.equals("---"))) {
            try {
                value = this.constructors[this.column].create(token);
                if (value == null) {
                    throw new NoSuchFieldException("Instantiation failed for " + token + " as " + this.constructors[this.column] + " at row " + this.row);
                }
            }
            catch (Exception e) {
                Logging.getInstance().process((Throwable)e);
            }
        } else {
            value = null;
        }
        return value;
    }

    private static String convertNumToColString(int col) {
        String retval = null;
        int mod = col % 26;
        int div = col / 26;
        char small = (char)(mod + 65);
        char big = (char)(div + 64);
        retval = div == 0 ? "" + small : "" + big + "" + small;
        return retval;
    }

    @Override
    public boolean hasMoreRow() {
        return this.row < this.sheetModel.getRowCount() - 1;
    }

    @Override
    public boolean hasMoreColumn() {
        return this.column < this.sheetModel.getColumnCount() - 1;
    }

    @Override
    public void close() {
    }

    @Override
    public int getLineNumber() {
        return this.row;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public boolean isHasClassHeader() {
        return true;
    }
}

