/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.reader;

import com.macrofocus.data.reader.CharMatcher;
import com.macrofocus.data.reader.StringMatcher;
import com.macrofocus.data.reader.Tokenizer;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UltimateTokenizer
implements Tokenizer {
    private static final char NEWLINE = '\n';
    private static final char SPACE = ' ';
    private final StringBuilder currentColumn = new StringBuilder();
    private CharMatcher delimeterMatcher;
    private final CharMatcher[] delimeterMatchers;
    private final CharMatcher quoteMatcher;
    private final boolean surroundingSpacesNeedQuotes;
    private final StringMatcher commentMatcher;
    private final String endLine;
    private final List<String> columns;
    private final boolean ready;

    public UltimateTokenizer(LineNumberReader reader, CharMatcher quoteMatcher, String endLine, CharMatcher ... delimeterMatchers) throws IOException {
        this.quoteMatcher = quoteMatcher;
        this.endLine = endLine;
        this.delimeterMatchers = delimeterMatchers;
        if (delimeterMatchers.length == 1) {
            this.delimeterMatcher = delimeterMatchers[0];
        }
        this.surroundingSpacesNeedQuotes = false;
        this.commentMatcher = null;
        this.columns = new ArrayList<String>();
        this.ready = this.readColumns(reader, this.columns);
    }

    private boolean readColumns(LineNumberReader reader, List<String> columns) throws IOException {
        String line;
        if (columns == null) {
            throw new NullPointerException("columns should not be null");
        }
        columns.clear();
        this.currentColumn.setLength(0);
        do {
            if ((line = reader.readLine()) == null) {
                return false;
            }
            if (!line.equals(this.endLine)) continue;
            return false;
        } while (line.length() == 0 || this.commentMatcher != null && this.commentMatcher.isMatch(line));
        line = line + '\n';
        TokenizerState state = TokenizerState.NORMAL;
        int quoteScopeStartingLine = -1;
        int potentialSpaces = 0;
        int charIndex = 0;
        while (true) {
            char c = line.charAt(charIndex);
            if (TokenizerState.NORMAL.equals((Object)state)) {
                if (this.delimeterMatcher == null) {
                    for (CharMatcher matcher : this.delimeterMatchers) {
                        if (!matcher.isMatch(c)) continue;
                        this.delimeterMatcher = matcher;
                        break;
                    }
                }
                if (this.delimeterMatcher != null && this.delimeterMatcher.isMatch(c)) {
                    if (!this.surroundingSpacesNeedQuotes) {
                        UltimateTokenizer.appendSpaces(this.currentColumn, potentialSpaces);
                    }
                    columns.add(this.currentColumn.length() > 0 ? this.currentColumn.toString() : null);
                    potentialSpaces = 0;
                    this.currentColumn.setLength(0);
                } else if (c == ' ') {
                    ++potentialSpaces;
                } else {
                    if (c == '\n') {
                        if (!this.surroundingSpacesNeedQuotes) {
                            UltimateTokenizer.appendSpaces(this.currentColumn, potentialSpaces);
                        }
                        columns.add(this.currentColumn.length() > 0 ? this.currentColumn.toString() : null);
                        return true;
                    }
                    if (this.quoteMatcher.isMatch(c) && this.currentColumn.length() == 0) {
                        state = TokenizerState.QUOTE_MODE;
                        quoteScopeStartingLine = reader.getLineNumber();
                        if (!this.surroundingSpacesNeedQuotes || this.currentColumn.length() > 0) {
                            UltimateTokenizer.appendSpaces(this.currentColumn, potentialSpaces);
                        }
                        potentialSpaces = 0;
                    } else {
                        if (!this.surroundingSpacesNeedQuotes || this.currentColumn.length() > 0) {
                            UltimateTokenizer.appendSpaces(this.currentColumn, potentialSpaces);
                        }
                        potentialSpaces = 0;
                        this.currentColumn.append(c);
                    }
                }
            } else if (c == '\n') {
                this.currentColumn.append('\n');
                charIndex = -1;
                line = reader.readLine();
                if (line == null) {
                    throw new IllegalStateException(String.format("unexpected end of file while reading quoted column beginning on line %d and ending on line %d", quoteScopeStartingLine, reader.getLineNumber()));
                }
                line = line + '\n';
            } else if (this.quoteMatcher.isMatch(c)) {
                if (this.quoteMatcher.isMatch(line.charAt(charIndex + 1))) {
                    this.currentColumn.append(c);
                    ++charIndex;
                } else {
                    state = TokenizerState.NORMAL;
                    quoteScopeStartingLine = -1;
                }
            } else {
                this.currentColumn.append(c);
            }
            ++charIndex;
        }
    }

    private static void appendSpaces(StringBuilder sb, int spaces) {
        for (int i = 0; i < spaces; ++i) {
            sb.append(' ');
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.columns.iterator();
    }

    @Override
    public int size() {
        return this.ready ? this.columns.size() : -1;
    }

    public CharMatcher[] getDelimeterMatchers() {
        CharMatcher[] charMatcherArray;
        if (this.delimeterMatcher != null) {
            CharMatcher[] charMatcherArray2 = new CharMatcher[1];
            charMatcherArray = charMatcherArray2;
            charMatcherArray2[0] = this.delimeterMatcher;
        } else {
            charMatcherArray = this.delimeterMatchers;
        }
        return charMatcherArray;
    }

    private static enum TokenizerState {
        NORMAL,
        QUOTE_MODE;

    }
}

