/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.row;

import com.macrofocus.data.row.AbstractRowModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class GenericRowModelAdapter
extends AbstractRowModel {
    private final Method[] methods;
    private final String[] names;
    private final Object object;

    public GenericRowModelAdapter(Object object, Method[] methods) {
        this.object = object;
        this.methods = methods;
        this.names = new String[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method == null) continue;
            this.names[i] = method.getName().startsWith("get") ? method.getName().substring(3) : method.getName();
        }
    }

    @Override
    public final int getColumnCount() {
        return this.methods.length;
    }

    @Override
    public final Class getMembership(int column) {
        return this.methods[column].getReturnType();
    }

    @Override
    public final Object getName(int column) {
        return this.names[column];
    }

    @Override
    public final Object getObject(int column) {
        if (column < this.methods.length) {
            Method method = this.methods[column];
            if (method != null) {
                try {
                    Object value = method.invoke(this.object, new Object[0]);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    System.err.println(method);
                    e.printStackTrace();
                    return null;
                }
                catch (ClassCastException e) {
                    System.err.println(method);
                    e.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public final boolean isAvailable(int column) {
        if (column < this.methods.length) {
            Method method = this.methods[column];
            if (method != null) {
                try {
                    return method.invoke(this.object, new Object[0]) != null;
                }
                catch (IllegalAccessException e) {
                    return false;
                }
                catch (InvocationTargetException e) {
                    return false;
                }
            }
            return false;
        }
        return false;
    }
}

