/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.row;

import com.macrofocus.data.row.AbstractRowModel;
import com.macrofocus.data.row.RowModel;

public class SimpleRowModel
extends AbstractRowModel {
    private final Object[] objects;
    private final Class[] memberships;
    private final Object[] names;
    private final boolean[] isAvailable;

    public SimpleRowModel(RowModel ... rowModels) {
        int columns = 0;
        for (RowModel rowModel : rowModels) {
            columns += rowModel.getColumnCount();
        }
        this.objects = new Object[columns];
        this.memberships = new Class[columns];
        this.names = new Object[columns];
        this.isAvailable = new boolean[columns];
        int i = 0;
        for (RowModel rowModel : rowModels) {
            for (int c = 0; c < rowModel.getColumnCount(); ++c) {
                this.objects[i] = rowModel.getObject(c);
                this.memberships[i] = rowModel.getMembership(c);
                this.names[i] = rowModel.getName(c);
                this.isAvailable[i] = rowModel.isAvailable(c);
                ++i;
            }
        }
    }

    public SimpleRowModel(Object[] objects, Class[] memberships, Object[] names) {
        this.objects = objects;
        this.memberships = memberships;
        this.names = names;
        this.isAvailable = null;
    }

    @Override
    public boolean isAvailable(int index) {
        if (this.isAvailable == null) {
            return this.objects[index] != null;
        }
        return this.isAvailable[index];
    }

    @Override
    public Object getObject(int index) {
        return this.objects[index];
    }

    @Override
    public Class getMembership(int index) {
        return this.memberships[index];
    }

    @Override
    public Object getName(int index) {
        return this.names[index];
    }

    @Override
    public int getColumnCount() {
        return this.objects.length;
    }

    public void setObject(int index, Object value) {
        this.objects[index] = value;
    }
}

