/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.sort;

import com.macrofocus.data.AbstractDataModel;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.row.RowModel;
import com.macrofocus.data.sort.RowComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;

public class SortDataModel
extends AbstractDataModel {
    private Object[] rows;
    private DataModel dataModel;

    public SortDataModel(DataModel dataModel, RowComparator comparator, boolean duplicates) {
        if (duplicates) {
            ArrayList<RowModel> list = new ArrayList<RowModel>(dataModel.getRowCount());
            for (int row = 0; row < dataModel.getRowCount(); ++row) {
                list.add(dataModel.getRowModel(row));
            }
            Collections.sort(list, comparator);
            this.rows = list.toArray();
        } else {
            TreeSet<RowModel> set = new TreeSet<RowModel>(comparator);
            for (int row = 0; row < dataModel.getRowCount(); ++row) {
                set.add(dataModel.getRowModel(row));
            }
            this.rows = set.toArray();
        }
        this.dataModel = dataModel;
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return ((RowModel)this.rows[row]).isAvailable(column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        return ((RowModel)this.rows[row]).getObject(column);
    }

    @Override
    public Object getColumnName(int column) {
        return this.dataModel.getColumnName(column);
    }

    @Override
    public Class getColumnClass(int column) {
        return this.dataModel.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this.rows.length;
    }

    @Override
    public int getColumnCount() {
        return this.dataModel.getColumnCount();
    }
}

