/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.SimpleVersionModel;
import com.macrofocus.data.format.ArrowDataFormat;
import com.macrofocus.data.format.CartoPlotDataFormat;
import com.macrofocus.data.format.CommaDelimitedDataFormat;
import com.macrofocus.data.format.ExcelDataFormat;
import com.macrofocus.data.format.FileURLDataFormat;
import com.macrofocus.data.format.GeoJSONDataFormat;
import com.macrofocus.data.format.HCILDataFormat;
import com.macrofocus.data.format.HTMLTagCloudDataFormat;
import com.macrofocus.data.format.HighDDataFormat;
import com.macrofocus.data.format.InfoScopeDataFormat;
import com.macrofocus.data.format.JSONDataFormat;
import com.macrofocus.data.format.JarDataFormat;
import com.macrofocus.data.format.LLCoordsDataFormat;
import com.macrofocus.data.format.LipperDataFormat;
import com.macrofocus.data.format.MicrosoftAccessDataFormat;
import com.macrofocus.data.format.MicrosoftProjectDataFormat;
import com.macrofocus.data.format.MicrosoftProjectDataInterchangeDataFormat;
import com.macrofocus.data.format.MicrosoftProjectExchangeDataFormat;
import com.macrofocus.data.format.NetDrawVNADataFormat;
import com.macrofocus.data.format.ODFSpreadsheetDataFormat;
import com.macrofocus.data.format.ParquetDataFormat;
import com.macrofocus.data.format.RTFTagCloudDataFormat;
import com.macrofocus.data.format.SASDataFormat;
import com.macrofocus.data.format.SPSSDataFormat;
import com.macrofocus.data.format.ShapefileDataFormat;
import com.macrofocus.data.format.TabDelimitedDataFormat;
import com.macrofocus.data.format.TableBrowserDataFormat;
import com.macrofocus.data.format.TcpdumpDataFormat;
import com.macrofocus.data.format.TextTagCloudDataFormat;
import com.macrofocus.data.format.TreeMLDataFormat;
import com.macrofocus.data.format.TreeMapDataFormat;
import com.macrofocus.data.format.TrendDisplayDataFormat;
import com.macrofocus.data.format.VisFluxDataFormat;
import com.macrofocus.data.format.ZipDataFormat;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.DirectoryDataSource;
import com.macrofocus.data.source.ExcelDataSource;
import com.macrofocus.data.source.GoogleSpreadsheetDataSource;
import com.macrofocus.data.source.JDBCDataSource;
import com.macrofocus.data.source.OSProcessesDataSource;
import com.macrofocus.data.source.TabDelimitedDataSource;
import com.macrofocus.data.source.YahooFinanceDataSource;
import com.macrofocus.data.source.YahooIndustryBrowserDataSource;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;

public class DataSourceFactory {
    private static final FileURLDataFormat tabDelimitedDataFormat = new TabDelimitedDataFormat();
    private static final FileURLDataFormat commaDelimitedDataFormat = new CommaDelimitedDataFormat();
    private static final FileURLDataFormat excelDataFormat = new ExcelDataFormat();
    private static final FileURLDataFormat odfSpreadsheetDataFormat = new ODFSpreadsheetDataFormat();
    private static final FileURLDataFormat parquetDataFormat = new ParquetDataFormat();
    private static final FileURLDataFormat arrowDataFormat = new ArrowDataFormat();
    private static final FileURLDataFormat spssDataFormat = new SPSSDataFormat();
    private static final FileURLDataFormat sasDataFormat = new SASDataFormat();
    private static final FileURLDataFormat infoScopeDataFormat = new InfoScopeDataFormat();
    private static final FileURLDataFormat treeMapDataFormat = new TreeMapDataFormat();
    private static final FileURLDataFormat llCoordsDataFormat = new LLCoordsDataFormat();
    private static final FileURLDataFormat highDDataFormat = new HighDDataFormat();
    private static final FileURLDataFormat cartoPlotDataFormat = new CartoPlotDataFormat();
    private static final FileURLDataFormat hcilTreeMapDataFormat = new HCILDataFormat();
    private static final FileURLDataFormat treeMLDataFormat = new TreeMLDataFormat();
    private static final FileURLDataFormat microsoftProjectExchangeDataFormat = new MicrosoftProjectExchangeDataFormat();
    private static final FileURLDataFormat microsoftProjectDataInterchangeDataFormat = new MicrosoftProjectDataInterchangeDataFormat();
    private static final FileURLDataFormat microsoftProjectDataFormat = new MicrosoftProjectDataFormat();
    private static final FileURLDataFormat zipDataFormat = new ZipDataFormat();
    private static final FileURLDataFormat jarDataFormat = new JarDataFormat();
    private static final FileURLDataFormat textDataFormat = new TextTagCloudDataFormat();
    private static final FileURLDataFormat rtfDataFormat = new RTFTagCloudDataFormat();
    private static final FileURLDataFormat htmlDataFormat = new HTMLTagCloudDataFormat();
    private static final FileURLDataFormat shapefileDataFormat = new ShapefileDataFormat();
    private static final FileURLDataFormat accessDataFormat = new MicrosoftAccessDataFormat();
    private static final FileURLDataFormat jsonDataFormat = new JSONDataFormat();
    private static final FileURLDataFormat geojsonDataFormat = new GeoJSONDataFormat();
    private static final FileURLDataFormat tcpdumpDataFormat = new TcpdumpDataFormat();
    private static final FileURLDataFormat lipperDataFormat = new LipperDataFormat();
    private static final FileURLDataFormat trendDisplayDataFormat = new TrendDisplayDataFormat();
    private static final FileURLDataFormat tableBrowserDataFormat = new TableBrowserDataFormat();
    private static final FileURLDataFormat visFluxDataFormat = new VisFluxDataFormat();
    private static final FileURLDataFormat netdrawVNADataFormat = new NetDrawVNADataFormat();
    private static final FileURLDataFormat[] dataFormats = new FileURLDataFormat[]{treeMapDataFormat, highDDataFormat, cartoPlotDataFormat, tabDelimitedDataFormat, commaDelimitedDataFormat, excelDataFormat, odfSpreadsheetDataFormat, parquetDataFormat, arrowDataFormat, spssDataFormat, sasDataFormat, hcilTreeMapDataFormat, treeMLDataFormat, microsoftProjectDataInterchangeDataFormat, microsoftProjectExchangeDataFormat, microsoftProjectDataFormat, zipDataFormat, jarDataFormat, textDataFormat, rtfDataFormat, htmlDataFormat, geojsonDataFormat, shapefileDataFormat, accessDataFormat, jsonDataFormat, trendDisplayDataFormat, tableBrowserDataFormat, visFluxDataFormat, infoScopeDataFormat, tcpdumpDataFormat, netdrawVNADataFormat};
    private static final FileURLDataFormat[] high_DDataFormats = new FileURLDataFormat[]{highDDataFormat, treeMapDataFormat, cartoPlotDataFormat, infoScopeDataFormat, tabDelimitedDataFormat, commaDelimitedDataFormat, excelDataFormat, odfSpreadsheetDataFormat, shapefileDataFormat, spssDataFormat, sasDataFormat, accessDataFormat, jsonDataFormat, geojsonDataFormat, tcpdumpDataFormat};
    private static final FileURLDataFormat[] cartoPlotDataFormats = new FileURLDataFormat[]{cartoPlotDataFormat, highDDataFormat, treeMapDataFormat, infoScopeDataFormat, tabDelimitedDataFormat, commaDelimitedDataFormat, excelDataFormat, odfSpreadsheetDataFormat, shapefileDataFormat, spssDataFormat, sasDataFormat, accessDataFormat, jsonDataFormat, geojsonDataFormat};
    private static final FileURLDataFormat[] trendDisplayDataFormats = new FileURLDataFormat[]{trendDisplayDataFormat, highDDataFormat, treeMapDataFormat, cartoPlotDataFormat, tabDelimitedDataFormat, infoScopeDataFormat, commaDelimitedDataFormat, excelDataFormat, odfSpreadsheetDataFormat, shapefileDataFormat, spssDataFormat, sasDataFormat, accessDataFormat, jsonDataFormat};
    private static final FileURLDataFormat[] visFluxDataFormats = new FileURLDataFormat[]{visFluxDataFormat, netdrawVNADataFormat, highDDataFormat, treeMapDataFormat, cartoPlotDataFormat, infoScopeDataFormat, tabDelimitedDataFormat, commaDelimitedDataFormat, excelDataFormat, odfSpreadsheetDataFormat, shapefileDataFormat, spssDataFormat, sasDataFormat, accessDataFormat, jsonDataFormat, geojsonDataFormat, tcpdumpDataFormat};

    public static FileURLDataFormat[] getDataFormats() {
        return dataFormats;
    }

    public static FileURLDataFormat[] getHigh_DDataFormats() {
        return high_DDataFormats;
    }

    public static FileURLDataFormat[] getCartoPlotDataFormats() {
        return cartoPlotDataFormats;
    }

    public static FileURLDataFormat[] getTrendDisplayDataFormats() {
        return trendDisplayDataFormats;
    }

    public static FileURLDataFormat[] getVisFluxDataFormats() {
        return visFluxDataFormats;
    }

    public static FileURLDataFormat getTabDelimitedDataFormat() {
        return tabDelimitedDataFormat;
    }

    public static FileURLDataFormat getCommaDelimitedDataFormat() {
        return commaDelimitedDataFormat;
    }

    public static FileURLDataFormat getTreeMapDataFormat() {
        return treeMapDataFormat;
    }

    public static FileURLDataFormat getInfoScopeDataFormat() {
        return infoScopeDataFormat;
    }

    public static FileURLDataFormat getLLCoordsDataFormat() {
        return llCoordsDataFormat;
    }

    public static FileURLDataFormat getHighDDataFormat() {
        return highDDataFormat;
    }

    public static FileURLDataFormat getCartoPlotDataFormat() {
        return cartoPlotDataFormat;
    }

    public static FileURLDataFormat getTrendDisplayDataFormat() {
        return trendDisplayDataFormat;
    }

    public static Iterable<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (FileURLDataFormat dataFormat : dataFormats) {
            types.add(dataFormat.getType());
        }
        return types;
    }

    public static AbstractFileFilter getFileFilter(String type) {
        if (type != null) {
            for (FileURLDataFormat dataFormat : dataFormats) {
                if (!dataFormat.getType().equals(type)) continue;
                return dataFormat.getFileFilter();
            }
        }
        return treeMapDataFormat.getFileFilter();
    }

    public static Iterable<AbstractFileFilter> getFileFilters() {
        ArrayList<AbstractFileFilter> fileFilters = new ArrayList<AbstractFileFilter>();
        for (FileURLDataFormat dataFormat : dataFormats) {
            fileFilters.add(dataFormat.getFileFilter());
        }
        return fileFilters;
    }

    public static DataSource getDataSource(URL url) {
        assert (url != null);
        if (url != null) {
            for (FileURLDataFormat fileURLDataFormat : dataFormats) {
                AbstractFileFilter fileFilter = fileURLDataFormat.getFileFilter();
                if (!fileFilter.accept(url)) continue;
                return fileURLDataFormat.getDataSource(url);
            }
            try {
                String contentType = null;
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.connect();
                contentType = connection.getContentType();
                DataSource dataSource = null;
                for (FileURLDataFormat dataFormat : dataFormats) {
                    AbstractFileFilter fileFilter = dataFormat.getFileFilter();
                    if (!fileFilter.acceptContentType(contentType)) continue;
                    dataSource = dataFormat.getDataSource(url);
                    break;
                }
                try {
                    connection.disconnect();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (dataSource != null) {
                    return dataSource;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        assert (false) : "Could not find format for " + url;
        return null;
    }

    public static DataSource getDataSource(URL url, FileFilter fileFilter) {
        if (url != null) {
            for (FileURLDataFormat dataFormat : dataFormats) {
                AbstractFileFilter ff = dataFormat.getFileFilter();
                if (!fileFilter.equals(ff)) continue;
                return dataFormat.getDataSource(url);
            }
            return new TabDelimitedDataSource(url);
        }
        return null;
    }

    public static DataSource getDataSource(File file) {
        try {
            if (file.isDirectory()) {
                return new DirectoryDataSource(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (FileURLDataFormat dataFormat : dataFormats) {
            AbstractFileFilter fileFilter = dataFormat.getFileFilter();
            if (!fileFilter.accept(file)) continue;
            return dataFormat.getDataSource(file);
        }
        return null;
    }

    public static DataSource getDataSource(File file, FileFilter fileFilter) {
        if (file != null) {
            for (FileURLDataFormat dataFormat : dataFormats) {
                AbstractFileFilter ff = dataFormat.getFileFilter();
                if (!fileFilter.equals(ff)) continue;
                return dataFormat.getDataSource(file);
            }
            return new TabDelimitedDataSource(file);
        }
        return null;
    }

    public static DataSource getDataSource(File file, String type) {
        if (type != null) {
            for (FileURLDataFormat dataFormat : dataFormats) {
                String t = dataFormat.getType();
                if (!type.equals(t)) continue;
                return dataFormat.getDataSource(file);
            }
            return new TabDelimitedDataSource(file);
        }
        return null;
    }

    public static DataSource getDataSource(URL url, String type) {
        if (type != null) {
            for (FileURLDataFormat dataFormat : dataFormats) {
                String t = dataFormat.getType();
                if (!type.equals(t)) continue;
                return dataFormat.getDataSource(url);
            }
            return new TabDelimitedDataSource(url);
        }
        return null;
    }

    public static DataSource getDataSource(File parent, Element root, String applicationType) throws IOException {
        if (root.getLocalName().equals(applicationType)) {
            Attribute versionAttribute = root.getAttribute("version");
            SimpleVersionModel version = versionAttribute != null ? new SimpleVersionModel(versionAttribute.getValue()) : new SimpleVersionModel(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
            Elements children = root.getChildElements();
            for (int h = 0; h < children.size(); ++h) {
                File relativeFile;
                File file;
                File file2;
                Element element = children.get(h);
                if (!element.getLocalName().equals("DataSource")) continue;
                String type = element.getAttributeValue("type");
                if ("JDBC".equals(type)) {
                    return new JDBCDataSource(element);
                }
                if ("GoogleSpreadsheet".equals(type)) {
                    return new GoogleSpreadsheetDataSource(element);
                }
                if ("Directory".equals(type)) {
                    return new DirectoryDataSource(element);
                }
                if ("YahooFinance".equals(type)) {
                    return new YahooFinanceDataSource(element);
                }
                if ("YahooIndustryBrowser".equals(type)) {
                    return new YahooIndustryBrowserDataSource(element);
                }
                if ("Excel".equals(type)) {
                    File relativeFile2;
                    File file3;
                    File file4;
                    String sheetName = element.getAttributeValue("sheet");
                    String url = element.getAttributeValue("url");
                    if (url != null) {
                        return new ExcelDataSource(new URL(url), sheetName);
                    }
                    String relativePath = element.getAttributeValue("relativePath");
                    if (relativePath != null && (file4 = new File(parent, relativePath)).exists()) {
                        return new ExcelDataSource(file4, sheetName);
                    }
                    String absolutePath = element.getAttributeValue("absolutePath");
                    if (absolutePath != null && (file3 = new File(absolutePath)).exists()) {
                        return new ExcelDataSource(file3, sheetName);
                    }
                    String path = element.getAttributeValue("path");
                    File file5 = new File(path);
                    if (!file5.exists() && (relativeFile2 = new File(parent, FileHelper.getName(path))).exists()) {
                        return new ExcelDataSource(relativeFile2, sheetName);
                    }
                    return new ExcelDataSource(file5, sheetName);
                }
                if ("OSProcesses".equals(type)) {
                    return new OSProcessesDataSource();
                }
                String url = element.getAttributeValue("url");
                if (url != null) {
                    return DataSourceFactory.getDataSource(new URL(url));
                }
                String relativePath = element.getAttributeValue("relativePath");
                if (relativePath != null && (file2 = new File(parent, relativePath)).exists()) {
                    return DataSourceFactory.getDataSource(file2);
                }
                String absolutePath = element.getAttributeValue("absolutePath");
                if (absolutePath != null && (file = new File(absolutePath)).exists()) {
                    return DataSourceFactory.getDataSource(file);
                }
                String path = element.getAttributeValue("path");
                File file6 = new File(path);
                if (!file6.exists() && (relativeFile = new File(parent, FileHelper.getName(path))).exists()) {
                    return DataSourceFactory.getDataSource(relativeFile);
                }
                return DataSourceFactory.getDataSource(file6);
            }
        }
        return null;
    }

    public static DataSource getDataSource(URL parent, Element root, String applicationtype) throws IOException {
        if (root.getLocalName().equals(applicationtype)) {
            Attribute versionAttribute = root.getAttribute("version");
            SimpleVersionModel version = versionAttribute != null ? new SimpleVersionModel(versionAttribute.getValue()) : new SimpleVersionModel(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
            Elements children = root.getChildElements();
            for (int h = 0; h < children.size(); ++h) {
                File file;
                Element element = children.get(h);
                if (!element.getLocalName().equals("DataSource")) continue;
                String type = element.getAttributeValue("type");
                if ("JDBC".equals(type)) {
                    return new JDBCDataSource(element);
                }
                if ("GoogleSpreadsheet".equals(type)) {
                    return new GoogleSpreadsheetDataSource(element);
                }
                if ("Directory".equals(type)) {
                    return new DirectoryDataSource(element);
                }
                if ("YahooFinance".equals(type)) {
                    return new YahooFinanceDataSource(element);
                }
                if ("YahooIndustryBrowser".equals(type)) {
                    return new YahooIndustryBrowserDataSource(element);
                }
                if ("Excel".equals(type)) {
                    File file2;
                    String sheetName = element.getAttributeValue("sheet");
                    String url = element.getAttributeValue("url");
                    if (url != null) {
                        return new ExcelDataSource(new URL(url), sheetName);
                    }
                    String relativePath = element.getAttributeValue("relativePath");
                    if (relativePath != null) {
                        URL file3 = new URL(parent + relativePath);
                        return new ExcelDataSource(file3, sheetName);
                    }
                    String absolutePath = element.getAttributeValue("absolutePath");
                    if (absolutePath != null && (file2 = new File(absolutePath)).exists()) {
                        return new ExcelDataSource(file2, sheetName);
                    }
                    String path = element.getAttributeValue("path");
                    File file4 = new File(path);
                    if (!file4.exists()) {
                        URL relativeFile = new URL(parent + FileHelper.getName(path));
                        return new ExcelDataSource(relativeFile, sheetName);
                    }
                    return new ExcelDataSource(file4, sheetName);
                }
                if ("OSProcesses".equals(type)) {
                    return new OSProcessesDataSource();
                }
                String url = element.getAttributeValue("url");
                if (url != null) {
                    return DataSourceFactory.getDataSource(new URL(url));
                }
                String relativePath = element.getAttributeValue("relativePath");
                if (relativePath != null) {
                    URL file5 = new URL(parent + relativePath);
                    return DataSourceFactory.getDataSource(file5);
                }
                String absolutePath = element.getAttributeValue("absolutePath");
                if (absolutePath != null && (file = new File(absolutePath)).exists()) {
                    return DataSourceFactory.getDataSource(file);
                }
                String path = element.getAttributeValue("path");
                File file6 = new File(path);
                if (!file6.exists()) {
                    URL relativeFile = new URL(parent, FileHelper.getName(path));
                    return DataSourceFactory.getDataSource(relativeFile);
                }
                return DataSourceFactory.getDataSource(file6);
            }
        }
        return null;
    }
}

