/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.data.table.ExcelXTableModel;
import com.macrofocus.data.table.SimpleTableModel;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.util.file.FileHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelDataSource
extends FileURLDataSource {
    static final String type = "Excel";
    private String sheetName;

    public ExcelDataSource(File file) {
        this(file, null);
    }

    public ExcelDataSource(URL url) {
        this(url, null);
    }

    public ExcelDataSource(File file, String sheetName) {
        super(file);
        this.sheetName = sheetName;
    }

    public ExcelDataSource(URL url, String sheetName) {
        super(url);
        this.sheetName = sheetName;
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public Element save(File file, ElementFactory factory) {
        Element dataSource = factory.newElement("DataSource");
        dataSource.addAttribute(factory.newAttribute("type", this.getType()));
        if (this.file != null) {
            dataSource.addAttribute(factory.newAttribute("path", this.file.getPath()));
            dataSource.addAttribute(factory.newAttribute("absolutePath", this.file.getAbsolutePath()));
            try {
                dataSource.addAttribute(factory.newAttribute("relativePath", FileHelper.getRelativePath(this.file.getAbsolutePath(), file.getAbsolutePath(), File.separator)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            dataSource.addAttribute(factory.newAttribute("url", this.url.toExternalForm()));
        }
        if (this.sheetName != null) {
            dataSource.addAttribute(factory.newAttribute("sheet", this.sheetName));
        }
        return dataSource;
    }

    @Override
    protected TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        return this.loadTableModel(contentPane, true);
    }

    @Override
    public MutableDataFrame<Integer, String, Object> loadDataFrame(Component contentPane) throws IOException, SQLException {
        return new DefaultDataFrame<Object>(this.loadTableModel(contentPane, false), true);
    }

    public TableModel loadTableModel(Component contentPane, boolean autoConvert) throws IOException, SQLException {
        try (BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));){
            AbstractTableModel abstractTableModel;
            Sheet sheet;
            Workbook wb = WorkbookFactory.create((InputStream)bis);
            if (this.sheetName != null && wb.getSheet(this.sheetName) != null) {
                sheet = wb.getSheet(this.sheetName);
            } else {
                ArrayList<Sheet> sheets = new ArrayList<Sheet>();
                Sheet selected = null;
                for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                    Sheet s;
                    if (wb.isSheetHidden(i) || wb.isSheetVeryHidden(i) || (s = wb.getSheetAt(i)).getLastRowNum() - s.getFirstRowNum() <= 0) continue;
                    if (s.isSelected()) {
                        selected = s;
                    }
                    sheets.add(s);
                }
                if (sheets.isEmpty()) {
                    TableModel i = null;
                    return i;
                }
                if (wb.getSheet("TreeMap Data") != null) {
                    sheet = wb.getSheet("TreeMap Data");
                } else if (sheets.size() == 1 || contentPane == null) {
                    sheet = selected != null ? selected : (Sheet)sheets.get(0);
                } else {
                    Frame frame = JOptionPane.getFrameForComponent(contentPane);
                    SheetSelector selector = new SheetSelector(frame, contentPane, "Select which worksheet to load:", "Choose worksheet", sheets.toArray(), selected);
                    selector.setVisible(true);
                    sheet = selector.getValue();
                    if (sheet != null) {
                        this.sheetName = sheet.getSheetName();
                    }
                }
            }
            if (sheet != null) {
                if (autoConvert) {
                    abstractTableModel = new SimpleTableModel((TableModel)new ExcelXTableModel(sheet), autoConvert);
                    return abstractTableModel;
                }
                abstractTableModel = new ExcelXTableModel(sheet);
                return abstractTableModel;
            }
            abstractTableModel = null;
            return abstractTableModel;
        }
    }

    private class SheetSelector
    extends JDialog {
        private JList list;
        private final WeakActionListeners actionListeners;

        private SheetSelector(Frame frame, Component locationComp, String labelText, String title, Object[] data, Sheet initialValue) {
            super(frame, title, true);
            this.actionListeners = new WeakActionListeners();
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(this.actionListeners.create(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SheetSelector.this.list.clearSelection();
                    SheetSelector.this.setVisible(false);
                }
            }, (Object)cancelButton));
            final JButton okButton = new JButton("Ok");
            okButton.setActionCommand("Ok");
            okButton.addActionListener(this.actionListeners.create(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SheetSelector.this.setVisible(false);
                }
            }, (Object)okButton));
            this.getRootPane().setDefaultButton(okButton);
            this.list = new JList(data){

                @Override
                public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                    int row;
                    if (orientation == 1 && direction < 0 && (row = this.getFirstVisibleIndex()) != -1) {
                        Rectangle r = this.getCellBounds(row, row);
                        if (r.y == visibleRect.y && row != 0) {
                            Point loc = r.getLocation();
                            --loc.y;
                            int prevIndex = this.locationToIndex(loc);
                            Rectangle prevR = this.getCellBounds(prevIndex, prevIndex);
                            if (prevR == null || prevR.y >= r.y) {
                                return 0;
                            }
                            return prevR.height;
                        }
                    }
                    return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
                }
            };
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    return super.getListCellRendererComponent((JList<?>)list, ((Sheet)value).getSheetName(), index, isSelected, cellHasFocus);
                }
            });
            this.list.setSelectionMode(0);
            this.list.setVisibleRowCount(-1);
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        okButton.doClick();
                    }
                }
            });
            JScrollPane listScroller = new JScrollPane(this.list);
            listScroller.setPreferredSize(new Dimension(250, 80));
            listScroller.setAlignmentX(0.0f);
            JPanel listPane = new JPanel();
            listPane.setLayout(new BoxLayout(listPane, 3));
            JLabel label = new JLabel(labelText);
            label.setLabelFor(this.list);
            listPane.add(label);
            listPane.add(Box.createRigidArea(new Dimension(0, 5)));
            listPane.add(listScroller);
            listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new BoxLayout(buttonPane, 2));
            buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            buttonPane.add(Box.createHorizontalGlue());
            buttonPane.add(cancelButton);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(okButton);
            Container contentPane = this.getContentPane();
            contentPane.add((Component)listPane, "Center");
            contentPane.add((Component)buttonPane, "Last");
            this.setValue(initialValue);
            this.pack();
            this.setLocationRelativeTo(ExcelDataSource.this.checkContentPane(locationComp));
        }

        private void setValue(Sheet newValue) {
            this.list.setSelectedValue(newValue, true);
        }

        public Sheet getValue() {
            return (Sheet)this.list.getSelectedValue();
        }
    }
}

