/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.reader.FileLoader;
import com.macrofocus.data.reader.FileResourceLoader;
import com.macrofocus.data.reader.URLResourceLoader;
import com.macrofocus.data.source.AbstractDataSource;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.util.file.FileHelper;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;
import nu.xom.Document;

public abstract class FileURLDataSource
extends AbstractDataSource {
    protected final File file;
    protected final URL url;

    protected FileURLDataSource(File file) {
        this.file = file;
        this.url = null;
    }

    protected FileURLDataSource(URL url) {
        this.file = null;
        this.url = url;
    }

    @Override
    public Element save(File file, ElementFactory factory) {
        Element dataSource = factory.newElement("DataSource");
        dataSource.addAttribute(factory.newAttribute("type", this.getType()));
        if (this.file != null) {
            dataSource.addAttribute(factory.newAttribute("path", this.file.getPath()));
            dataSource.addAttribute(factory.newAttribute("absolutePath", this.file.getAbsolutePath()));
            if (file != null) {
                try {
                    dataSource.addAttribute(factory.newAttribute("relativePath", FileHelper.getRelativePath(this.file.getAbsolutePath(), file.getAbsolutePath(), File.separator)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            dataSource.addAttribute(factory.newAttribute("url", this.url.toExternalForm()));
        }
        return dataSource;
    }

    protected abstract String getType();

    InputStream getInputStream() throws IOException {
        InputStream is = this.file != null ? new FileInputStream(this.file) : this.url.openStream();
        return new BufferedInputStream(is);
    }

    BufferedInputStream getInputStream(Component contentPane) throws IOException {
        InputStream inputStream = this.getInputStream();
        if (!GraphicsEnvironment.isHeadless() && !SwingUtilities.isEventDispatchThread()) {
            try {
                ProgressMonitorInputStream monitorInputStream = new ProgressMonitorInputStream(contentPane, "Reading " + this.getName(), inputStream);
                monitorInputStream.getProgressMonitor().setMillisToDecideToPopup(50);
                monitorInputStream.getProgressMonitor().setMillisToPopup(50);
                inputStream = monitorInputStream;
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
        if (this.file != null) {
            if (this.file.getName().endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            }
        } else if (this.url.getPath().endsWith(".gz")) {
            inputStream = new GZIPInputStream(inputStream);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        return bufferedInputStream;
    }

    String getName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return this.url.getPath();
    }

    FileLoader getFileLoader() {
        if (this.file != null) {
            return new FileResourceLoader(this.file.getParentFile());
        }
        return new URLResourceLoader(this.url);
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        return null;
    }
}

