/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.source.AbstractDataSource;
import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.util.MailSSLSocketFactory;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.mail.Authenticator;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.swing.table.TableModel;
import nu.xom.Document;

public class IMAPDataSource
extends AbstractDataSource {
    static final String type = "IMAP";
    private final String hostname;
    private final int port;
    private final String username;
    private final String password;
    private final String connectionSecurity;
    private Map<String, FolderInfo> map = new HashMap<String, FolderInfo>();

    public IMAPDataSource(String hostname, int port, String username, String password, String connectionSecurity) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.connectionSecurity = connectionSecurity;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        try {
            final ArrayList<Object[]> list = new ArrayList<Object[]>();
            this.getMailboxInfo(null, this.hostname, this.username, this.password);
            Set<Map.Entry<String, FolderInfo>> set = this.map.entrySet();
            for (Map.Entry<String, FolderInfo> me : set) {
                FolderInfo fi = me.getValue();
                int fn = fi.folderNmsgs;
                Long fs = fi.folderSize;
                System.out.println(me.getKey() + " : " + fn + " : " + fs);
                String[] path = me.getKey().split("\\.");
                if (path == null || path.length <= 0) continue;
                String[] folder = Arrays.copyOf(path, path.length - 1);
                String mailbox = path[path.length - 1];
                list.add(new Object[]{folder, mailbox, fn, fs});
            }
            return new AbstractTableModel(){

                @Override
                public int getRowCount() {
                    return list.size();
                }

                @Override
                public int getColumnCount() {
                    return 4;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object[] row = (Object[])list.get(rowIndex);
                    return row[columnIndex];
                }

                @Override
                public String getColumnName(int column) {
                    switch (column) {
                        case 0: {
                            return "Folder";
                        }
                        case 1: {
                            return "Mailbox";
                        }
                        case 2: {
                            return "Messages";
                        }
                        case 3: {
                            return "Size";
                        }
                    }
                    return null;
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    switch (columnIndex) {
                        case 0: {
                            return String[].class;
                        }
                        case 1: {
                            return String.class;
                        }
                        case 2: {
                            return Integer.class;
                        }
                        case 3: {
                            return Long.class;
                        }
                    }
                    return null;
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        return null;
    }

    @Override
    public Element save(File file, ElementFactory factory) {
        return null;
    }

    public String getMailboxInfo(String mail, String hostname, String username, String password) throws Exception {
        String pattern = "%";
        Store store = IMAPDataSource.connectStore(hostname, "993", username, password);
        Folder rf = store.getDefaultFolder();
        this.map.clear();
        if ((rf.getType() & 2) != 0) {
            Folder[] f = rf.list(pattern);
            for (int i = 0; i < f.length; ++i) {
                try {
                    this.dumpFolder(f[i], true, "    ");
                    continue;
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
            store.close();
        }
        ValueComparator bvc = new ValueComparator(this.map);
        TreeMap<String, FolderInfo> sorted_map = new TreeMap<String, FolderInfo>(bvc);
        sorted_map.putAll(this.map);
        Set set = sorted_map.entrySet();
        for (Map.Entry me : set) {
            FolderInfo fi = (FolderInfo)me.getValue();
            int fn = fi.folderNmsgs;
            Long fs = fi.folderSize;
            System.out.println(me.getKey() + " : " + fn + " : " + fs);
        }
        return null;
    }

    public static Store connectStore(String hostname, String port, String username, String password) throws GeneralSecurityException, MessagingException {
        MailSSLSocketFactory sf = new MailSSLSocketFactory();
        sf.setTrustAllHosts(true);
        Properties mailProps = System.getProperties();
        mailProps.put("mail.imaps.ssl.socketFactory", sf);
        mailProps.put("mail.store.protocol", "imaps");
        mailProps.put("mail.imaps.host", hostname);
        mailProps.put("mail.imaps.port", port);
        Session session = Session.getInstance((Properties)mailProps, (Authenticator)new SASLMasqueradeAuthenticator(username, password));
        session.setDebug(false);
        Store store = session.getStore();
        store.connect();
        return store;
    }

    void dumpFolder(Folder folder, boolean recurse, String tab) throws Exception {
        if (folder.getType() == 2) {
            if ((folder.getType() & 2) != 0 && recurse) {
                Folder[] f = folder.list();
                for (int i = 0; i < f.length; ++i) {
                    this.dumpFolder(f[i], recurse, tab + "    ");
                }
            }
            folder.close(false);
            return;
        }
        folder.open(1);
        Message[] messages = folder.getMessages();
        FetchProfile fp = new FetchProfile();
        fp.add(FetchProfile.Item.ENVELOPE);
        folder.fetch(messages, fp);
        System.out.println(tab + "Name:      " + folder.getName());
        System.out.println(tab + "Full Name: " + folder.getFullName());
        System.out.println(tab + "URL:       " + folder.getURLName());
        boolean verbose = true;
        if (verbose) {
            IMAPFolder f;
            String[] attrs;
            if (!folder.isSubscribed()) {
                System.out.println(tab + "Not Subscribed");
            }
            if ((folder.getType() & 1) != 0) {
                if (folder.hasNewMessages()) {
                    System.out.println(tab + "Has New Messages");
                }
                System.out.println(tab + "Total Messages:  " + folder.getMessageCount());
                System.out.println(tab + "New Messages:    " + folder.getNewMessageCount());
                System.out.println(tab + "Unread Messages: " + folder.getUnreadMessageCount());
            }
            if ((folder.getType() & 2) != 0) {
                System.out.println(tab + "Is Directory");
            }
            long folderSize = 0L;
            for (Message message : messages) {
                folderSize += (long)message.getSize();
            }
            long folderSizeMB = folderSize / 0x100000L;
            System.out.printf(tab + "Folder Size in MB: %d\n", folderSizeMB);
            FolderInfo fi = new FolderInfo(folder.getMessageCount(), folderSizeMB);
            this.map.put(folder.getFullName(), fi);
            if (folder instanceof IMAPFolder && (attrs = (f = (IMAPFolder)folder).getAttributes()) != null && attrs.length > 0) {
                System.out.println(tab + "IMAP Attributes:");
                for (int i = 0; i < attrs.length; ++i) {
                    System.out.println(tab + "    " + attrs[i]);
                }
            }
        }
        System.out.println();
        if ((folder.getType() & 2) != 0 && recurse) {
            Folder[] f = folder.list();
            for (int i = 0; i < f.length; ++i) {
                this.dumpFolder(f[i], recurse, tab + "    ");
            }
        }
        folder.close(false);
    }

    class FolderInfo {
        int folderNmsgs;
        Long folderSize;

        public FolderInfo(int i, Long l) {
            this.folderNmsgs = i;
            this.folderSize = l;
        }
    }

    class ValueComparator
    implements Comparator {
        Map base;

        public ValueComparator(Map base) {
            this.base = base;
        }

        public int compare(Object a, Object b) {
            FolderInfo fa = (FolderInfo)this.base.get(a);
            FolderInfo fb = (FolderInfo)this.base.get(b);
            Long fsa = fa.folderSize;
            Long fsb = fb.folderSize;
            if (fsa < fsb) {
                return 1;
            }
            if (fsa == fsb) {
                return 1;
            }
            return -1;
        }
    }

    private static class SASLMasqueradeAuthenticator
    extends Authenticator {
        String authcid;
        String authcpass;

        public SASLMasqueradeAuthenticator(String adminusername, String adminpassword) {
            this.authcid = adminusername;
            this.authcpass = adminpassword;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.authcid, this.authcpass);
        }
    }
}

