/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.db.DatabaseDriver;
import com.macrofocus.data.db.DatabaseDriverFactory;
import com.macrofocus.data.source.AbstractDataSource;
import com.macrofocus.data.table.RowMajorTableModel;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.util.logging.SwingLogging;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.swing.ProgressMonitor;
import javax.swing.table.TableModel;
import nu.xom.Document;

public class JDBCDataSource
extends AbstractDataSource {
    static final String type = "JDBC";
    private final String url;
    private final String username;
    private final String password;
    private final String query;
    protected final DatabaseDriver driver;
    private Connection connection;
    private ResultSetMetaData meta;

    public JDBCDataSource(DatabaseDriver driver, String url, String username, String password, String query) {
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
        this.query = query;
    }

    public JDBCDataSource(nu.xom.Element root) {
        this.url = root.getAttributeValue("url");
        this.username = root.getAttributeValue("username");
        this.password = root.getAttributeValue("password");
        this.query = root.getAttributeValue("query");
        this.driver = DatabaseDriverFactory.find(root.getAttributeValue("driver"));
    }

    @Override
    public Element save(File file, ElementFactory factory) {
        Element dataSource = factory.newElement("DataSource");
        dataSource.addAttribute(factory.newAttribute("type", this.getType()));
        dataSource.addAttribute(factory.newAttribute("url", this.url));
        dataSource.addAttribute(factory.newAttribute("username", this.username));
        dataSource.addAttribute(factory.newAttribute("password", this.password));
        dataSource.addAttribute(factory.newAttribute("query", this.query));
        dataSource.addAttribute(factory.newAttribute("driver", this.driver.toString()));
        return dataSource;
    }

    String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        return this.load(contentPane, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableModel load(Component contentPane, boolean closeConnection) throws IOException, SQLException {
        int progress = 0;
        ProgressMonitor progressMonitor = null;
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                progressMonitor = new ProgressMonitor(contentPane, "Scanning file system", "", 0, Integer.MAX_VALUE);
                progressMonitor.setMillisToDecideToPopup(50);
                progressMonitor.setMillisToPopup(50);
                progressMonitor.setMaximum(1);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
        TableModel tableModel = null;
        try {
            this.connection = this.driver.getConnection(this.url, this.username, this.password);
            PreparedStatement pst = this.createPreparedStatement(this.connection);
            ResultSet result = pst.executeQuery();
            tableModel = this.createTableModel(result);
            this.meta = result.getMetaData();
            if (closeConnection) {
                pst.close();
                this.connection.close();
            }
        }
        catch (Exception e) {
            SwingLogging.getInstance().process(contentPane, (Throwable)e);
        }
        finally {
            ++progress;
            if (progressMonitor != null) {
                progressMonitor.setProgress(progress);
            }
        }
        return tableModel;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected TableModel createTableModel(ResultSet result) throws SQLException {
        return new RowMajorTableModel(this.driver, result);
    }

    public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
        PreparedStatement pst = connection.prepareStatement(this.query);
        return pst;
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        return null;
    }

    public ResultSetMetaData getMeta() {
        return this.meta;
    }

    public DatabaseMetaData getDatabaseMetaData() throws SQLException {
        Connection connection = this.driver.getConnection(this.url, this.username, this.password);
        return connection.getMetaData();
    }
}

