/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.DataSourceFactory;
import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.source.parquet.ParquetStream;
import com.macrofocus.data.table.JSONTableModel;
import com.macrofocus.data.table.SimpleTableModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.IndexedDataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.series.Series;
import com.macrofocus.molap.series.SeriesFactory;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.List;
import javax.swing.table.TableModel;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

public class ParquetDataSource
extends FileURLDataSource {
    static final String type = "Parquet";

    public ParquetDataSource(File file) {
        super(file);
    }

    public ParquetDataSource(URL url) {
        super(url);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        TableModel tableModel = this.load(contentPane, true);
        return tableModel;
    }

    public TableModel load(Component contentPane, boolean autoConvert) throws IOException {
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        JSONTableModel dataReader = new JSONTableModel(bis);
        SimpleTableModel tableModel = new SimpleTableModel((TableModel)dataReader, autoConvert);
        bis.close();
        return tableModel;
    }

    @Override
    public MutableDataFrame<Integer, String, Object> loadDataFrame(Component contentPane) throws IOException, SQLException {
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        return this.loadDataFrameFromInputStream(bis);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MutableDataFrame<Integer, String, Object> loadDataFrameFromInputStream(InputStream bis) throws IOException, SQLException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(ParquetDataSource.readAllBytes(bis));
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)new ParquetStream("parquet", stream));){
            ParquetMetadata footer = reader.getFooter();
            MessageType schema = footer.getFileMetaData().getSchema();
            long nrows = reader.getRecordCount();
            PageReadStore store = reader.readNextRowGroup();
            if (store == null) return null;
            long rowCount = store.getRowCount();
            ColumnReadStoreImpl colReader = new ColumnReadStoreImpl(store, new GroupRecordConverter(schema).getRootConverter(), schema, footer.getFileMetaData().getCreatedBy());
            List columns = schema.getColumns();
            Series[] vectors = new Series[columns.size()];
            block33: for (int c = 0; c < columns.size(); ++c) {
                ColumnDescriptor column = (ColumnDescriptor)columns.get(c);
                PrimitiveType primitiveType = column.getPrimitiveType();
                OriginalType originalType = primitiveType.getOriginalType();
                String[] path = column.getPath();
                String name = path[path.length - 1];
                ColumnReader columnReader = colReader.getColumnReader(column);
                int count = (int)columnReader.getTotalValueCount();
                int maxDefinitionLevel = column.getMaxDefinitionLevel();
                int rep = columnReader.getCurrentRepetitionLevel();
                switch (primitiveType.getPrimitiveTypeName()) {
                    case BOOLEAN: {
                        int definitionLevel;
                        int i;
                        if (rep >= 0 && rep <= 1) {
                            Object[] a = new Boolean[count];
                            for (i = 0; i < count; ++i) {
                                definitionLevel = columnReader.getCurrentDefinitionLevel();
                                if (definitionLevel == maxDefinitionLevel) {
                                    a[i] = columnReader.getBoolean();
                                }
                                columnReader.consume();
                            }
                            vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                            continue block33;
                        }
                        if (rep <= 1) continue block33;
                        boolean[] a = new boolean[rep];
                        continue block33;
                    }
                    case INT32: {
                        int scale;
                        DecimalMetadata decimalMetadata;
                        int definitionLevel;
                        int i;
                        if (originalType == null) {
                            if (rep >= 0 && rep <= 1) {
                                Object[] a = new Integer[count];
                                for (i = 0; i < count; ++i) {
                                    definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        a[i] = columnReader.getInteger();
                                    }
                                    columnReader.consume();
                                }
                                vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                continue block33;
                            }
                            if (rep <= 1) continue block33;
                            continue block33;
                        }
                        switch (originalType) {
                            case INT_8: {
                                if (rep >= 0 && rep <= 1) {
                                    Object[] a = new Byte[count];
                                    for (i = 0; i < count; ++i) {
                                        definitionLevel = columnReader.getCurrentDefinitionLevel();
                                        if (definitionLevel == maxDefinitionLevel) {
                                            a[i] = (byte)columnReader.getInteger();
                                        }
                                        columnReader.consume();
                                    }
                                    vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                    continue block33;
                                }
                                if (rep <= 1) break;
                                continue block33;
                            }
                            case UINT_8: 
                            case INT_16: {
                                if (rep >= 0 && rep <= 1) {
                                    Object[] a = new Short[count];
                                    for (i = 0; i < count; ++i) {
                                        definitionLevel = columnReader.getCurrentDefinitionLevel();
                                        if (definitionLevel == maxDefinitionLevel) {
                                            a[i] = (short)columnReader.getInteger();
                                        }
                                        columnReader.consume();
                                    }
                                    vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                    continue block33;
                                }
                                if (rep <= 1) break;
                                continue block33;
                            }
                            case UINT_16: 
                            case INT_32: {
                                if (rep >= 0 && rep <= 1) {
                                    Object[] a = new Integer[count];
                                    for (i = 0; i < count; ++i) {
                                        definitionLevel = columnReader.getCurrentDefinitionLevel();
                                        if (definitionLevel == maxDefinitionLevel) {
                                            a[i] = columnReader.getInteger();
                                        }
                                        columnReader.consume();
                                    }
                                    vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                    continue block33;
                                }
                                if (rep <= 1) break;
                                continue block33;
                            }
                            case DECIMAL: {
                                if (rep < 0 || rep > 1) break;
                                Object[] a = new BigDecimal[count];
                                for (i = 0; i < count; ++i) {
                                    definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        int unscaledValue = columnReader.getInteger();
                                        decimalMetadata = primitiveType.getDecimalMetadata();
                                        scale = decimalMetadata.getScale();
                                        a[i] = BigDecimal.valueOf(unscaledValue, scale);
                                    }
                                    columnReader.consume();
                                }
                                vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                continue block33;
                            }
                            case DATE: {
                                if (rep < 0 || rep > 1) break;
                                Object[] a = new LocalDate[count];
                                for (i = 0; i < count; ++i) {
                                    definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        int days = columnReader.getInteger();
                                        a[i] = LocalDate.ofEpochDay(days);
                                    }
                                    columnReader.consume();
                                }
                                vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                continue block33;
                            }
                            case TIME_MILLIS: {
                                if (rep < 0 || rep > 1) break;
                                Object[] a = new LocalTime[count];
                                for (i = 0; i < count; ++i) {
                                    definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        int millis = columnReader.getInteger();
                                        a[i] = LocalTime.ofNanoOfDay(millis * 1000000);
                                    }
                                    columnReader.consume();
                                }
                                vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                            }
                        }
                        continue block33;
                    }
                    case INT64: {
                        int definitionLevel;
                        int i;
                        if (originalType == null) {
                            if (rep >= 0 && rep <= 1) {
                                Object[] a = new Long[count];
                                for (i = 0; i < count; ++i) {
                                    definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        a[i] = columnReader.getLong();
                                    }
                                    columnReader.consume();
                                    vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                }
                                continue block33;
                            }
                            if (rep <= 1) continue block33;
                            continue block33;
                        }
                        switch (originalType) {
                            case INT_64: {
                                if (rep >= 0 && rep <= 1) {
                                    Object[] a = new Long[count];
                                    for (i = 0; i < count; ++i) {
                                        definitionLevel = columnReader.getCurrentDefinitionLevel();
                                        if (definitionLevel == maxDefinitionLevel) {
                                            a[i] = columnReader.getLong();
                                        }
                                        columnReader.consume();
                                    }
                                    vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                    continue block33;
                                }
                                if (rep <= 1) break;
                                continue block33;
                            }
                            case DECIMAL: {
                                if (rep < 0 || rep > 1) break;
                                Object[] a = new BigDecimal[count];
                                for (i = 0; i < count; ++i) {
                                    definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        long unscaledValue = columnReader.getLong();
                                        DecimalMetadata decimalMetadata = primitiveType.getDecimalMetadata();
                                        int scale = decimalMetadata.getScale();
                                        a[i] = BigDecimal.valueOf(unscaledValue, scale);
                                    }
                                    columnReader.consume();
                                }
                                vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                continue block33;
                            }
                            case TIME_MICROS: {
                                if (rep < 0 || rep > 1) break;
                                Object[] a = new LocalTime[count];
                                for (i = 0; i < count; ++i) {
                                    definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        long micros = columnReader.getLong();
                                        a[i] = LocalTime.ofNanoOfDay(micros * 1000L);
                                    }
                                    columnReader.consume();
                                }
                                vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                continue block33;
                            }
                            case TIMESTAMP_MILLIS: {
                                if (rep < 0 || rep > 1) break;
                                Object[] a = new LocalDateTime[count];
                                for (i = 0; i < count; ++i) {
                                    definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        long millis = columnReader.getLong();
                                        a[i] = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
                                    }
                                    columnReader.consume();
                                }
                                vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                continue block33;
                            }
                            case TIMESTAMP_MICROS: {
                                if (rep < 0 || rep > 1) break;
                                Object[] a = new LocalDateTime[count];
                                for (i = 0; i < count; ++i) {
                                    definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        long micros = columnReader.getLong();
                                        long second = micros / 1000000L;
                                        int nano = (int)(micros % 1000000L) * 1000;
                                        a[i] = LocalDateTime.ofEpochSecond(second, nano, ZoneOffset.UTC);
                                    }
                                    columnReader.consume();
                                }
                                vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                            }
                        }
                        continue block33;
                    }
                    case INT96: {
                        int definitionLevel;
                        int i;
                        if (rep < 0 || rep > 1) continue block33;
                        Object[] a = new LocalDateTime[count];
                        for (i = 0; i < count; ++i) {
                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                            if (definitionLevel == maxDefinitionLevel) {
                                ByteBuffer buf = columnReader.getBinary().toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
                                long nanoOfDay = buf.getLong();
                                int julianDay = buf.getInt();
                                LocalDate date = LocalDate.ofEpochDay(julianDay - 2440588);
                                LocalTime time = LocalTime.ofNanoOfDay(nanoOfDay);
                                a[i] = LocalDateTime.of(date, time);
                            }
                            columnReader.consume();
                        }
                        vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                        continue block33;
                    }
                    case FLOAT: {
                        int definitionLevel;
                        int i;
                        if (rep >= 0 && rep <= 1) {
                            Object[] a = new Float[count];
                            for (i = 0; i < count; ++i) {
                                definitionLevel = columnReader.getCurrentDefinitionLevel();
                                if (definitionLevel == maxDefinitionLevel) {
                                    a[i] = Float.valueOf(columnReader.getFloat());
                                }
                                columnReader.consume();
                            }
                            vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                            continue block33;
                        }
                        if (rep <= 1) continue block33;
                        continue block33;
                    }
                    case DOUBLE: {
                        int definitionLevel;
                        int i;
                        if (rep < 0 || rep > 1) continue block33;
                        Object[] a = new Double[count];
                        for (i = 0; i < count; ++i) {
                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                            if (definitionLevel == maxDefinitionLevel) {
                                a[i] = columnReader.getDouble();
                            }
                            columnReader.consume();
                        }
                        vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                        continue block33;
                    }
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        int scale;
                        DecimalMetadata decimalMetadata;
                        int definitionLevel;
                        int i;
                        switch (originalType) {
                            case UTF8: {
                                if (rep >= 0 && rep <= 1) {
                                    Object[] a = new String[count];
                                    for (i = 0; i < count; ++i) {
                                        definitionLevel = columnReader.getCurrentDefinitionLevel();
                                        if (definitionLevel == maxDefinitionLevel) {
                                            a[i] = columnReader.getBinary().toStringUsingUTF8();
                                        }
                                        columnReader.consume();
                                    }
                                    vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                    break;
                                }
                                if (rep <= 1) break;
                                throw new UnsupportedEncodingException("Unsuported repition level " + rep);
                            }
                            case DECIMAL: {
                                if (rep < 0 || rep > 1) break;
                                Object[] a = new BigDecimal[count];
                                for (i = 0; i < count; ++i) {
                                    definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        byte[] value = columnReader.getBinary().getBytes();
                                        decimalMetadata = primitiveType.getDecimalMetadata();
                                        scale = decimalMetadata.getScale();
                                        a[i] = new BigDecimal(new BigInteger(value), scale);
                                    }
                                    columnReader.consume();
                                }
                                vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                break;
                            }
                            default: {
                                if (rep < 0 || rep > 1) break;
                                byte[][] a = new byte[count][];
                                for (i = 0; i < count; ++i) {
                                    definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        byte[] value = columnReader.getBinary().getBytes();
                                        decimalMetadata = primitiveType.getDecimalMetadata();
                                        scale = decimalMetadata.getScale();
                                        a[i] = columnReader.getBinary().getBytes();
                                    }
                                    columnReader.consume();
                                }
                                vectors[c] = SeriesFactory.create((Object)name, (Object[])a);
                                break;
                            }
                        }
                        continue block33;
                    }
                    default: {
                        System.err.println("Unsupported type " + primitiveType + ", " + originalType);
                        int r = 0;
                        while ((long)r < rowCount) {
                            columnReader.consume();
                            ++r;
                        }
                        break block2;
                    }
                }
            }
            DefaultDataFrame<Object> defaultDataFrame = new DefaultDataFrame<Object>((DataFrame)new IndexedDataFrame(vectors));
            return defaultDataFrame;
        }
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int bufLen = 4096;
        byte[] buf = new byte[4096];
        IOException exception = null;
        try {
            byte[] byArray;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                int readLen;
                while ((readLen = inputStream.read(buf, 0, 4096)) != -1) {
                    outputStream.write(buf, 0, readLen);
                }
                byArray = outputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    exception = e;
                    throw e;
                }
            }
            outputStream.close();
            return byArray;
        }
        finally {
            if (exception == null) {
                inputStream.close();
            } else {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    exception.addSuppressed(e);
                }
            }
        }
    }

    public static void main(String[] args) {
        File file = new File("/Users/luc/macrofocus/dataset/swissgrid/20190101-20190131.parquet/part-00013-tid-8754402889509081591-c57c588a-a3a3-4ee6-8b94-0d91c640d7ea-404-1-c000.snappy.parquet");
        DataSource dataSource = DataSourceFactory.getDataSource(file);
        System.err.println(dataSource);
        try {
            MutableDataFrame<Integer, String, Object> dataFrame = dataSource.loadDataFrame(null);
            dataFrame.printSchema();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }
}

