/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.reader.PerfectDataReader;
import com.macrofocus.data.reader.TokenizerFactory;
import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.table.RowMajorTableModel;
import com.macrofocus.data.table.TreeMapTableModel;
import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.util.file.CharsetToolkit;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.SQLException;
import javax.swing.table.TableModel;

public class TabDelimitedDataSource
extends FileURLDataSource {
    public static final String type = "TabDelimited";
    private final String defaultCharset;
    private final TypemapModel.Builder[] builders;

    public TabDelimitedDataSource(File file, String defaultCharset, TypemapModel.Builder ... builders) {
        super(file);
        this.defaultCharset = defaultCharset;
        this.builders = builders;
    }

    public TabDelimitedDataSource(URL url, String defaultCharset, TypemapModel.Builder ... builders) {
        super(url);
        this.defaultCharset = defaultCharset;
        this.builders = builders;
    }

    public TabDelimitedDataSource(File file) {
        this(file, "UTF-8", new TypemapModel.Builder[0]);
    }

    public TabDelimitedDataSource(URL url) {
        this(url, "UTF-8", new TypemapModel.Builder[0]);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        return this.loadTableModel(contentPane, true);
    }

    @Override
    public MutableDataFrame<Integer, String, Object> loadDataFrame(Component contentPane) throws IOException, SQLException {
        return new DefaultDataFrame<Object>(this.loadTableModel(contentPane, false), true);
    }

    public TableModel loadTableModel(Component contentPane, boolean autoConvert) throws IOException, SQLException {
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        BufferedReader reader = new CharsetToolkit(bis, Charset.forName(this.defaultCharset)).getReader();
        PerfectDataReader dataReader = new PerfectDataReader(reader, TokenizerFactory.getTabDelimitedInstance(), true, false, "String", 0, Integer.MAX_VALUE, 1, DefaultTypemapModel.getInstance(), this.builders);
        dataReader.setFileLoader(this.getFileLoader());
        RowMajorTableModel tableModel = new RowMajorTableModel(dataReader, autoConvert);
        bis.close();
        if (TreeMapTableModel.containsEmptyColumn(tableModel)) {
            return new TreeMapTableModel(tableModel);
        }
        return tableModel;
    }
}

